/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.tests;

import java.util.Iterator;
import javax.wsdl.OperationType;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.wst.wsdl.Binding;
import org.eclipse.wst.wsdl.BindingFault;
import org.eclipse.wst.wsdl.BindingInput;
import org.eclipse.wst.wsdl.BindingOperation;
import org.eclipse.wst.wsdl.BindingOutput;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.ExtensibilityElement;
import org.eclipse.wst.wsdl.ExtensibleElement;
import org.eclipse.wst.wsdl.Fault;
import org.eclipse.wst.wsdl.Import;
import org.eclipse.wst.wsdl.Input;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.Output;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.Port;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.wst.wsdl.Service;
import org.eclipse.wst.wsdl.Types;
import org.eclipse.wst.wsdl.binding.soap.SOAPAddress;
import org.eclipse.wst.wsdl.binding.soap.SOAPBinding;
import org.eclipse.wst.wsdl.binding.soap.SOAPBody;
import org.eclipse.wst.wsdl.binding.soap.SOAPOperation;
import org.eclipse.wst.wsdl.tests.WSDLTestsPlugin;
import org.eclipse.wst.wsdl.tests.util.DefinitionLoader;
import org.eclipse.wst.wsdl.tests.util.DefinitionVisitor;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.Element;

public class SemanticTest
extends DefinitionVisitor {
    private String PLUGIN_ABSOLUTE_PATH = WSDLTestsPlugin.getInstallURL();
    private boolean soapOperationVisited = false;
    private boolean soapBodyVisited = false;
    private boolean soapBindingVisited = false;
    private boolean soapAddressVisited = false;

    public SemanticTest(String name) {
        super(name);
    }

    public SemanticTest(Definition definition) {
        super(definition);
    }

    private void visitDocumentation(Element docElement) {
        if (docElement == null) {
            return;
        }
        this.println("documentation: " + docElement);
    }

    private void println(String s) {
        System.out.println(s);
    }

    protected void visitDefinition(Definition def) {
        String targetNamespace;
        this.println("Visiting definitions...");
        this.visitDocumentation(def.getDocumentationElement());
        QName qname = def.getQName();
        if (qname != null) {
            this.println("name: " + qname.getLocalPart());
        }
        if ((targetNamespace = def.getTargetNamespace()) != null) {
            this.println("targetNamespace: " + targetNamespace);
        }
        Iterator iterator = def.getNamespaces().keySet().iterator();
        String prefix = null;
        String namespace = null;
        while (iterator.hasNext()) {
            prefix = (String)iterator.next();
            namespace = def.getNamespace(prefix);
            this.println("namespace prefix: " + prefix + ", namespace URI: " + namespace);
        }
        super.visitDefinition(def);
        this.println("Leaving definitions...");
    }

    protected void visitImport(Import wsdlImport) {
        this.println("Visiting import...");
        if (this.importingSchema(wsdlImport)) {
            this.println("<import>ing XML Schema");
            this.println("namespace: " + wsdlImport.getNamespaceURI());
            this.println("schemaLocation: " + wsdlImport.getLocationURI());
            this.visitDocumentation(wsdlImport.getDocumentationElement());
        } else {
            this.println("<import>ing WSDL");
            this.visitDocumentation(wsdlImport.getDocumentationElement());
        }
        this.println("Leaving import...");
    }

    private boolean importingSchema(Import myImport) {
        return myImport.getDefinition() == null;
    }

    protected void visitTypes(Types types) {
        this.println("Visiting types...");
        Iterator iterator = types.getSchemas().iterator();
        XSDSchema schema = null;
        while (iterator.hasNext()) {
            schema = (XSDSchema)iterator.next();
            this.println("in-line schema: " + schema);
        }
        this.println("Leaving types...");
    }

    protected void visitPart(Part part) {
        this.println("Visiting part...");
    }

    protected void visitPortType(PortType portType) {
        this.println("Visiting portType...");
        this.visitDocumentation(portType.getDocumentationElement());
        QName qname = portType.getQName();
        if (qname != null) {
            this.println("name: " + qname.getLocalPart());
        }
        super.visitPortType(portType);
        this.println("Leaving portType...");
    }

    protected void visitOperation(Operation operation) {
        this.println("Visiting operation...");
        this.visitDocumentation(operation.getDocumentationElement());
        String name = operation.getName();
        if (name != null) {
            this.println("name: " + name);
        }
        OperationType opType = operation.getStyle();
        Assert.assertNotNull((String)"Failed determining Operation Type", (Object)opType);
        if (OperationType.REQUEST_RESPONSE == opType) {
            this.println("op type: in-out");
        } else if (OperationType.SOLICIT_RESPONSE == opType) {
            this.println("op typeout-in");
        } else if (OperationType.NOTIFICATION == opType) {
            this.println("op typeout-only");
        } else if (OperationType.ONE_WAY == opType) {
            this.println("op typein-only");
        }
        super.visitOperation(operation);
        this.println("Leaving operation...");
    }

    protected void visitInput(Input input) {
        this.println("Visiting input...");
        this.visitDocumentation(input.getDocumentationElement());
        String name = input.getName();
        if (name != null) {
            this.println("name: " + name);
        }
        Message message = input.getEMessage();
        Assert.assertNotNull((String)"Failed to resolve the message", (Object)message);
        this.println("Leaving input...");
    }

    protected void visitOutput(Output output) {
        this.println("Visiting output...");
        this.visitDocumentation(output.getDocumentationElement());
        String name = output.getName();
        if (name != null) {
            this.println("name: " + name);
        }
        Message message = output.getEMessage();
        Assert.assertNotNull((String)"Failed to resolve the message", (Object)message);
        this.println("Leaving output...");
    }

    protected void visitFault(Fault fault) {
        this.println("Visiting fault...");
        this.println("Leaving fault...");
    }

    protected void visitBinding(Binding binding) {
        this.println("Visiting binding...");
        this.visitDocumentation(binding.getDocumentationElement());
        QName qname = binding.getQName();
        if (qname != null) {
            this.println("name: " + qname.getLocalPart());
        }
        PortType portType = binding.getEPortType();
        Assert.assertNotNull((String)"Failed to resolve the portType", (Object)portType);
        super.visitBinding(binding);
        Assert.assertTrue((String)"<soapBody> is missing", (boolean)this.soapBodyVisited);
        Assert.assertTrue((String)"<soapBinding> is missing", (boolean)this.soapBindingVisited);
        Assert.assertTrue((String)"<soapOperation> is missing", (boolean)this.soapOperationVisited);
        this.println("Leaving binding...");
    }

    protected void visitBindingOperation(BindingOperation bindingOperation) {
        this.println("Visiting binding operation...");
        this.visitDocumentation(bindingOperation.getDocumentationElement());
        Operation operation = bindingOperation.getEOperation();
        Assert.assertNotNull((String)"Failed to resolve the operation", (Object)operation);
        if (operation != null) {
            String operationName = operation.getName();
            this.println("name: " + operationName);
        }
        super.visitBindingOperation(bindingOperation);
        this.println("Leaving binding operation...");
    }

    protected void visitBindingInput(BindingInput input) {
        this.println("Visiting binding input...");
        this.visitDocumentation(input.getDocumentationElement());
        String inputName = input.getName();
        if (inputName != null) {
            this.println("name: " + inputName);
        }
        super.visitBindingInput(input);
        this.println("Leaving binding input...");
    }

    protected void visitBindingOutput(BindingOutput output) {
        this.println("Visiting binding output...");
        this.visitDocumentation(output.getDocumentationElement());
        String outputName = output.getName();
        if (outputName != null) {
            this.println("name: " + outputName);
        }
        super.visitBindingOutput(output);
        this.println("Leaving binding output...");
    }

    protected void visitBindingFault(BindingFault fault) {
        this.println("Visiting binding fault...");
        this.visitDocumentation(fault.getDocumentationElement());
        Element faultElement = fault.getElement();
        String faultName = fault.getName();
        if (faultName != null) {
            faultElement.setAttribute("name", faultName);
        }
        super.visitBindingFault(fault);
        this.println("Leaving binding fault...");
    }

    protected void visitService(Service service) {
        this.println("Visiting service...");
        this.visitDocumentation(service.getDocumentationElement());
        QName qname = service.getQName();
        Assert.assertNotNull((String)"Validation Error: service is missing the name attribute", (Object)qname);
        if (qname != null) {
            this.println("name: " + qname.getLocalPart());
        }
        super.visitService(service);
        this.println("Leaving service...");
    }

    protected void visitPort(Port port) {
        this.println("Visiting port...");
        this.visitDocumentation(port.getDocumentationElement());
        String name = port.getName();
        Assert.assertNotNull((String)"Validation Error: port is missing the name attribute", (Object)port);
        if (name != null) {
            this.println("name: " + port.getName());
        }
        Binding binding = port.getEBinding();
        Assert.assertNotNull((String)"Failed to resolve the binding", (Object)binding);
        super.visitPort(port);
        Assert.assertTrue((String)"<soapAddress> is missing", (boolean)this.soapAddressVisited);
        this.println("Leaving port...");
    }

    protected void visitExtensibilityElement(ExtensibleElement owner, ExtensibilityElement extensibilityElement) {
        this.println("Visiting extensibility element...");
        if (extensibilityElement instanceof SOAPBody) {
            this.visitSOAPBody((SOAPBody)extensibilityElement);
        } else if (extensibilityElement instanceof SOAPBinding) {
            this.visitSOAPBinding((SOAPBinding)extensibilityElement);
        } else if (extensibilityElement instanceof SOAPAddress) {
            this.visitSOAPAddress((SOAPAddress)extensibilityElement);
        } else if (extensibilityElement instanceof SOAPOperation) {
            this.visitSOAPOperation((SOAPOperation)extensibilityElement);
        }
        this.println("Leaving extensibility element...");
    }

    private void visitSOAPOperation(SOAPOperation soapOperation) {
        this.soapOperationVisited = true;
        this.println("Visiting SOAPOperation...");
        this.println("soapAction: " + soapOperation.getSoapActionURI());
        this.println("Leaving SOAPOperation...");
    }

    private void visitSOAPBody(SOAPBody soapBody) {
        this.soapBodyVisited = true;
        this.println("Visiting SOAPBody...");
        this.println("use: " + soapBody.getUse());
        this.println("Leaving SOAPBody...");
    }

    private void visitSOAPBinding(SOAPBinding soapBinding) {
        this.soapBindingVisited = true;
        this.println("Visiting SOAPBinding...");
        this.println("style: " + soapBinding.getStyle());
        this.println("transport: " + soapBinding.getTransportURI());
        this.println("Leaving SOAPBinding...");
    }

    private void visitSOAPAddress(SOAPAddress soapAddress) {
        this.soapAddressVisited = true;
        this.println("Visiting SOAPAddress...");
        this.println("location: " + soapAddress.getLocationURI());
        this.println("Leaving SOAPAddress...");
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new SemanticTest("ModelSemanticTest"){

            protected void runTest() {
                this.testModelSemantic();
            }
        });
        return suite;
    }

    public void testModelSemantic() {
        try {
            Definition def = DefinitionLoader.load(String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + "samples/LoadStoreCompare/LoadAndPrintTest.wsdl", true);
            SemanticTest test = new SemanticTest(def);
            test.visit();
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
    }

    public static void main(String[] args) {
        TestRunner.run((Test)SemanticTest.suite());
    }
}

