/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.tests.contentmodels;

import junit.framework.TestCase;
import org.eclipse.jst.jsp.core.internal.contentmodel.JSPCMDocumentFactory;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;

public class TestFixedCMDocuments
extends TestCase {
    public TestFixedCMDocuments(String name) {
        super(name);
    }

    private void checkAttrNames(String documentKey, String elementName, String[] attrNames) {
        CMDocument document = JSPCMDocumentFactory.getCMDocument((String)documentKey);
        CMNode elementDeclaration = document.getElements().getNamedItem(elementName);
        TestFixedCMDocuments.assertEquals((String)("not an element declaration:" + elementDeclaration), (int)5, (int)elementDeclaration.getNodeType());
        TestFixedCMDocuments.assertNotNull((String)("missing element declaration:" + elementName), (Object)elementDeclaration);
        CMNamedNodeMap attributes = ((CMElementDeclaration)elementDeclaration).getAttributes();
        int i = 0;
        while (i < attrNames.length) {
            TestFixedCMDocuments.assertNotNull((String)("missing attribute declaration:" + attrNames[i]), (Object)attributes.getNamedItem(attrNames[i]));
            ++i;
        }
        TestFixedCMDocuments.assertEquals((String)"Attributes defined in content model that are not expected by the test", (int)attributes.getLength(), (int)attrNames.length);
    }

    private void checkDocument(Object documentKey) {
        CMDocument document = JSPCMDocumentFactory.getCMDocument((String)documentKey.toString());
        TestFixedCMDocuments.assertNotNull((String)("missing doc:" + documentKey.toString()), (Object)document);
        CMNamedNodeMap elements = document.getElements();
        int i = 0;
        while (i < elements.getLength()) {
            CMNode item = elements.item(i);
            this.verifyElementDeclarationHasName(item);
            ++i;
        }
    }

    public void testAttributesOnJSP11Forward() {
        this.checkAttrNames("JSP11", "jsp:forward", new String[]{"page"});
    }

    public void testAttributesOnJSP11GetProperty() {
        this.checkAttrNames("JSP11", "jsp:getProperty", new String[]{"name", "property"});
    }

    public void testAttributesOnJSP11Include() {
        this.checkAttrNames("JSP11", "jsp:include", new String[]{"page", "flush"});
    }

    public void testAttributesOnJSP11IncludeDirective() {
        this.checkAttrNames("JSP11", "jsp:directive.include", new String[]{"file"});
    }

    public void testAttributesOnJSP11PageDirective() {
        this.checkAttrNames("JSP11", "jsp:directive.page", new String[]{"language", "extends", "import", "session", "buffer", "autoFlush", "isThreadSafe", "info", "errorPage", "isErrorPage", "contentType", "pageEncoding"});
    }

    public void testAttributesOnJSP11Param() {
        this.checkAttrNames("JSP11", "jsp:param", new String[]{"name", "value"});
    }

    public void testAttributesOnJSP11Plugin() {
        this.checkAttrNames("JSP11", "jsp:plugin", new String[]{"type", "code", "codebase", "name", "archive", "align", "height", "width", "hspace", "vspace", "jreversion", "nspluginurl", "iepluginurl"});
    }

    public void testAttributesOnJSP11Root() {
        this.checkAttrNames("JSP11", "jsp:root", new String[]{"xmlns:jsp", "version"});
    }

    public void testAttributesOnJSP11SetProperty() {
        this.checkAttrNames("JSP11", "jsp:setProperty", new String[]{"name", "property", "param", "value"});
    }

    public void testAttributesOnJSP11TaglibDirective() {
        this.checkAttrNames("JSP11", "jsp:directive.taglib", new String[]{"uri", "prefix"});
    }

    public void testAttributesOnJSP11UseBean() {
        this.checkAttrNames("JSP11", "jsp:useBean", new String[]{"id", "scope", "class", "type", "beanName"});
    }

    public void testAttributesOnJSP20Attribute() {
        this.checkAttrNames("JSP20", "jsp:attribute", new String[]{"name", "trim"});
    }

    public void testAttributesOnJSP20Element() {
        this.checkAttrNames("JSP20", "jsp:element", new String[]{"name"});
    }

    public void testAttributesOnJSP20Forward() {
        this.checkAttrNames("JSP20", "jsp:forward", new String[]{"page"});
    }

    public void testAttributesOnJSP20GetProperty() {
        this.checkAttrNames("JSP20", "jsp:getProperty", new String[]{"name", "property"});
    }

    public void testAttributesOnJSP20Include() {
        this.checkAttrNames("JSP20", "jsp:include", new String[]{"page", "flush"});
    }

    public void testAttributesOnJSP20IncludeDirective() {
        this.checkAttrNames("JSP20", "jsp:directive.include", new String[]{"file"});
    }

    public void testAttributesOnJSP20Output() {
        this.checkAttrNames("JSP20", "jsp:output", new String[]{"omit-xml-declaration", "doctype-public", "doctype-root-element", "doctype-system"});
    }

    public void testAttributesOnJSP20PageDirective() {
        this.checkAttrNames("JSP20", "jsp:directive.page", new String[]{"language", "extends", "import", "session", "buffer", "autoFlush", "isThreadSafe", "info", "errorPage", "isErrorPage", "contentType", "pageEncoding", "isELIgnored"});
    }

    public void testAttributesOnJSP20Param() {
        this.checkAttrNames("JSP20", "jsp:param", new String[]{"name", "value"});
    }

    public void testAttributesOnJSP20Plugin() {
        this.checkAttrNames("JSP20", "jsp:plugin", new String[]{"type", "code", "codebase", "name", "archive", "align", "height", "width", "hspace", "vspace", "jreversion", "nspluginurl", "iepluginurl", "mayscript"});
    }

    public void testAttributesOnJSP20Root() {
        this.checkAttrNames("JSP20", "jsp:root", new String[]{"xmlns:jsp", "version"});
    }

    public void testAttributesOnJSP20SetProperty() {
        this.checkAttrNames("JSP20", "jsp:setProperty", new String[]{"name", "property", "param", "value"});
    }

    public void testAttributesOnJSP20TaglibDirective() {
        this.checkAttrNames("JSP20", "jsp:directive.taglib", new String[]{"uri", "prefix", "tagdir"});
    }

    public void testAttributesOnJSP20UseBean() {
        this.checkAttrNames("JSP20", "jsp:useBean", new String[]{"id", "scope", "class", "type", "beanName"});
    }

    public void testAttributesOnTAG20Attribute() {
        this.checkAttrNames("JSP20.TAG", "jsp:attribute", new String[]{"name", "trim"});
    }

    public void testAttributesOnTAG20AttributeDirective() {
        this.checkAttrNames("JSP20.TAG", "jsp:directive.attribute", new String[]{"name", "required", "fragment", "rtexprvalue", "type", "description"});
    }

    public void testAttributesOnTAG20DoBody() {
        this.checkAttrNames("JSP20.TAG", "jsp:doBody", new String[]{"var", "varReader", "scope"});
    }

    public void testAttributesOnTAG20Element() {
        this.checkAttrNames("JSP20.TAG", "jsp:element", new String[]{"name"});
    }

    public void testAttributesOnTAG20Forward() {
        this.checkAttrNames("JSP20.TAG", "jsp:forward", new String[]{"page"});
    }

    public void testAttributesOnTAG20GetProperty() {
        this.checkAttrNames("JSP20.TAG", "jsp:getProperty", new String[]{"name", "property"});
    }

    public void testAttributesOnTAG20Include() {
        this.checkAttrNames("JSP20.TAG", "jsp:include", new String[]{"page", "flush"});
    }

    public void testAttributesOnTAG20IncludeDirective() {
        this.checkAttrNames("JSP20.TAG", "jsp:directive.include", new String[]{"file"});
    }

    public void testAttributesOnTAG20Invoke() {
        this.checkAttrNames("JSP20.TAG", "jsp:invoke", new String[]{"fragment", "var", "varReader", "scope"});
    }

    public void testAttributesOnTAG20Output() {
        this.checkAttrNames("JSP20.TAG", "jsp:output", new String[]{"omit-xml-declaration", "doctype-public", "doctype-root-element", "doctype-system"});
    }

    public void testAttributesOnTAG20Param() {
        this.checkAttrNames("JSP20.TAG", "jsp:param", new String[]{"name", "value"});
    }

    public void testAttributesOnTAG20Plugin() {
        this.checkAttrNames("JSP20.TAG", "jsp:plugin", new String[]{"type", "code", "codebase", "name", "archive", "align", "height", "width", "hspace", "vspace", "jreversion", "nspluginurl", "iepluginurl", "mayscript"});
    }

    public void testAttributesOnTAG20Root() {
        this.checkAttrNames("JSP20.TAG", "jsp:root", new String[]{"xmlns:jsp", "version"});
    }

    public void testAttributesOnTAG20SetProperty() {
        this.checkAttrNames("JSP20.TAG", "jsp:setProperty", new String[]{"name", "property", "param", "value"});
    }

    public void testAttributesOnTAG20TagDirective() {
        this.checkAttrNames("JSP20.TAG", "jsp:directive.tag", new String[]{"display-name", "body-content", "dynamic-attributes", "small-icon", "large-icon", "description", "example", "language", "import", "pageEncoding", "isELIgnored"});
    }

    public void testAttributesOnTAG20TaglibDirective() {
        this.checkAttrNames("JSP20.TAG", "jsp:directive.taglib", new String[]{"uri", "prefix", "tagdir"});
    }

    public void testAttributesOnTAG20UseBean() {
        this.checkAttrNames("JSP20.TAG", "jsp:useBean", new String[]{"id", "scope", "class", "type", "beanName"});
    }

    public void testAttributesOnTAG20VariableDirective() {
        this.checkAttrNames("JSP20.TAG", "jsp:directive.variable", new String[]{"name-given", "name-from-attribute", "alias", "variable-class", "declare", "scope", "description"});
    }

    public void testCHTMLdocument() {
        this.checkDocument("CHTML");
    }

    public void testHTML4document() {
        this.checkDocument("HTML");
    }

    public void testJSP11document() {
        this.checkDocument("JSP11");
    }

    public void testJSP12document() {
        this.checkDocument("JSP12");
    }

    public void testJSP20document() {
        this.checkDocument("JSP20");
    }

    public void testTag20document() {
        this.checkDocument("JSP20.TAG");
    }

    private void verifyAttributeDeclaration(CMElementDeclaration elemDecl, CMNode attr) {
        TestFixedCMDocuments.assertTrue((attr.getNodeType() == 2 ? 1 : 0) != 0);
        TestFixedCMDocuments.assertNotNull((String)"no name on an attribute declaration", (Object)attr.getNodeName());
        CMAttributeDeclaration attrDecl = (CMAttributeDeclaration)attr;
        TestFixedCMDocuments.assertNotNull((String)("no attribute 'type' on an attribute declaration " + elemDecl.getNodeName() + "/" + attr.getNodeName()), (Object)attrDecl.getAttrType());
    }

    private void verifyElementDeclarationHasName(CMNode item) {
        TestFixedCMDocuments.assertTrue((item.getNodeType() == 5 ? 1 : 0) != 0);
        TestFixedCMDocuments.assertNotNull((String)"no name on an element declaration", (Object)item.getNodeName());
        CMNamedNodeMap attrs = ((CMElementDeclaration)item).getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            CMNode attr = attrs.item(i);
            this.verifyAttributeDeclaration((CMElementDeclaration)item, attr);
            ++i;
        }
    }
}

