/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.tests.dom;

import junit.framework.TestCase;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.xml.core.internal.parser.ContextRegionContainer;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AttrValueTest
extends TestCase {
    private static final String[] VALUES = new String[]{"<<Previous", "<page>", "Next>>"};

    public void testAttributeValue() {
        IDOMModel model = (IDOMModel)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor("org.eclipse.jst.jsp.core.jspsource");
        AttrValueTest.assertNotNull((Object)model);
        IStructuredDocument document = model.getStructuredDocument();
        AttrValueTest.assertNotNull((Object)document);
        document.setText((Object)this, "<button value=\"" + VALUES[0] + "\"></button><button value=\"" + VALUES[1] + "\"></button><button value=\"" + VALUES[2] + "\"></button>");
        IDOMDocument dom = model.getDocument();
        NodeList nodes = dom.getElementsByTagName("button");
        AttrValueTest.assertTrue((String)"Must be 3 button elements in the document.", (nodes.getLength() == 3 ? 1 : 0) != 0);
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            Node attr = node.getAttributes().getNamedItem("value");
            AttrValueTest.assertTrue((String)"Attribute 'value' not present.", (attr != null && attr.getNodeValue().length() > 0 ? 1 : 0) != 0);
            AttrValueTest.assertEquals((String)"Attribute values are not equal", (String)VALUES[i], (String)attr.getNodeValue());
            ++i;
        }
    }

    public void testEmbeddedTagValue() {
        IDOMModel model = (IDOMModel)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor("org.eclipse.jst.jsp.core.jspsource");
        AttrValueTest.assertNotNull((Object)model);
        IStructuredDocument document = model.getStructuredDocument();
        AttrValueTest.assertNotNull((Object)document);
        document.setText((Object)this, "<a href=\"<c:out value='test.html'></c:out>\">Test</a>");
        IDOMDocument dom = model.getDocument();
        NodeList nodes = dom.getElementsByTagName("a");
        AttrValueTest.assertTrue((String)"Must be 1 anchor element in the document.", (nodes.getLength() == 1 ? 1 : 0) != 0);
        IStructuredDocumentRegion region = document.getFirstStructuredDocumentRegion();
        ITextRegion embeddedRegion = region.getRegionAtCharacterOffset(9);
        AttrValueTest.assertTrue((String)"The attribute is not a ContextRegionContainer", (boolean)(embeddedRegion instanceof ContextRegionContainer));
        Node node = nodes.item(0);
        Node attr = node.getAttributes().getNamedItem("href");
        AttrValueTest.assertEquals((String)"Attribute values are not equal", (String)"<c:out value='test.html'></c:out>", (String)attr.getNodeValue());
    }
}

