/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.validation.sample.filesystem;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public class ValidatorMessages {
    private Map _messages = new HashMap();
    private IValidator _validator = null;
    protected static final Object DEFAULT_OBJECT = new Object();

    public ValidatorMessages(IValidator validator) {
        this._validator = validator;
    }

    public IValidator getValidator() {
        return this._validator;
    }

    public void addValidationMessage(IMessage message) {
        this.addValidationMessage(message, null);
    }

    public void addValidationMessage(IMessage message, String groupName) {
        ArrayList<IMessage> list;
        if (message == null) {
            return;
        }
        if (message.getTargetObject() == null) {
            message.setTargetObject(ValidatorMessages.getDefaultObject());
        }
        if (groupName != null) {
            message.setGroupName(groupName);
        }
        if ((list = (ArrayList<IMessage>)this._messages.get(message.getTargetObject())) == null) {
            list = new ArrayList<IMessage>();
        }
        list.add(message);
        this._messages.put(message.getTargetObject(), list);
    }

    public static Object getDefaultObject() {
        return DEFAULT_OBJECT;
    }

    public List getMessages(int messageTypes) {
        ArrayList<IMessage> messages = new ArrayList<IMessage>();
        Iterator iterator = this._messages.values().iterator();
        while (iterator.hasNext()) {
            List list = (List)iterator.next();
            Object[] listContents = list.toArray();
            int i = 0;
            while (i < listContents.length) {
                IMessage message = (IMessage)listContents[i];
                if ((messageTypes & message.getSeverity()) != 0) {
                    messages.add(message);
                }
                ++i;
            }
        }
        return messages;
    }

    public void removeAllMessages(Object object) {
        if (object == null) {
            object = ValidatorMessages.getDefaultObject();
        }
        this._messages.remove(object);
    }

    public void removeMessageSubset(Object object, String groupName) {
        List list;
        if (groupName == null) {
            this.removeAllMessages(object);
            return;
        }
        if (object == null) {
            object = ValidatorMessages.getDefaultObject();
        }
        if ((list = (List)this._messages.get(object)) == null) {
            return;
        }
        if (list.size() == 0) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IMessage msg = (IMessage)iterator.next();
            String msgGroupName = msg.getGroupName();
            if (!groupName.equals(msgGroupName)) continue;
            list.remove(msg);
        }
    }
}

