/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.core.tests;

import junit.framework.TestCase;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatRuntime;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;

public class TomcatRuntimeTestCase
extends TestCase {
    private static final String RUNTIME_TYPE_ID_32 = "org.eclipse.jst.server.tomcat.runtime.32";
    private static final String RUNTIME_TYPE_ID_40 = "org.eclipse.jst.server.tomcat.runtime.40";
    private static final String RUNTIME_TYPE_ID_41 = "org.eclipse.jst.server.tomcat.runtime.41";
    private static final String RUNTIME_TYPE_ID_50 = "org.eclipse.jst.server.tomcat.runtime.50";
    private static final String RUNTIME_TYPE_ID_55 = "org.eclipse.jst.server.tomcat.runtime.55";
    protected static IRuntime runtime;
    protected static ITomcatRuntime tomcatRuntime;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected IRuntimeWorkingCopy createRuntime(String runtimeTypeId) throws Exception {
        IRuntimeType rt = ServerCore.findRuntimeType((String)runtimeTypeId);
        IRuntimeWorkingCopy wc = rt.createRuntime("a", null);
        wc.setLocation((IPath)new Path("c://test"));
        return wc;
    }

    public void test00CreateRuntime() throws Exception {
        runtime = this.createRuntime(RUNTIME_TYPE_ID_32).save(false, null);
        TomcatRuntimeTestCase.assertTrue((!runtime.isWorkingCopy() ? 1 : 0) != 0);
    }

    protected void validateRuntime() throws Exception {
        IStatus status = runtime.validate(null);
        TomcatRuntimeTestCase.assertTrue((!status.isOK() ? 1 : 0) != 0);
    }

    protected void adaptRuntime() throws Exception {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.server.tomcat.core.internal.ITomcatRuntime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        tomcatRuntime = (ITomcatRuntime)runtime.loadAdapter((Class)clazz, null);
        TomcatRuntimeTestCase.assertNotNull((Object)tomcatRuntime);
        TomcatRuntimeTestCase.assertNotNull((Object)tomcatRuntime.getVMInstall());
        TomcatRuntimeTestCase.assertNotNull((Object)tomcatRuntime.getRuntimeClasspath(null));
    }

    protected void modifyRuntime() throws Exception {
        IRuntimeWorkingCopy wc = runtime.createWorkingCopy();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jst.server.tomcat.core.internal.ITomcatRuntimeWorkingCopy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ITomcatRuntimeWorkingCopy trwc = (ITomcatRuntimeWorkingCopy)wc.loadAdapter((Class)clazz, null);
        trwc.setVMInstall(null);
        wc.save(true, null);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.jst.server.tomcat.core.internal.ITomcatRuntime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        tomcatRuntime = (ITomcatRuntime)runtime.loadAdapter((Class)clazz2, null);
        TomcatRuntimeTestCase.assertNotNull((Object)tomcatRuntime.getVMInstall());
    }

    protected void deleteRuntime() throws Exception {
        runtime.delete();
        runtime = null;
        tomcatRuntime = null;
    }

    public void test01ValidateRuntime() throws Exception {
        this.validateRuntime();
    }

    public void test02AdaptRuntime() throws Exception {
        this.adaptRuntime();
    }

    public void test03ModifyRuntime() throws Exception {
        this.modifyRuntime();
    }

    public void test04DeleteRuntime() throws Exception {
        this.deleteRuntime();
    }

    public void test10CreateRuntime() throws Exception {
        runtime = this.createRuntime(RUNTIME_TYPE_ID_40).save(false, null);
        TomcatRuntimeTestCase.assertTrue((!runtime.isWorkingCopy() ? 1 : 0) != 0);
    }

    public void test11ValidateRuntime() throws Exception {
        this.validateRuntime();
    }

    public void test12AdaptRuntime() throws Exception {
        this.adaptRuntime();
    }

    public void test13ModifyRuntime() throws Exception {
        this.modifyRuntime();
    }

    public void test14DeleteRuntime() throws Exception {
        this.deleteRuntime();
    }

    public void test20CreateRuntime() throws Exception {
        runtime = this.createRuntime(RUNTIME_TYPE_ID_41).save(false, null);
        TomcatRuntimeTestCase.assertTrue((!runtime.isWorkingCopy() ? 1 : 0) != 0);
    }

    public void test21ValidateRuntime() throws Exception {
        this.validateRuntime();
    }

    public void test22AdaptRuntime() throws Exception {
        this.adaptRuntime();
    }

    public void test23ModifyRuntime() throws Exception {
        this.modifyRuntime();
    }

    public void test24DeleteRuntime() throws Exception {
        this.deleteRuntime();
    }

    public void test30CreateRuntime() throws Exception {
        runtime = this.createRuntime(RUNTIME_TYPE_ID_50).save(false, null);
        TomcatRuntimeTestCase.assertTrue((!runtime.isWorkingCopy() ? 1 : 0) != 0);
    }

    public void test31ValidateRuntime() throws Exception {
        this.validateRuntime();
    }

    public void test32AdaptRuntime() throws Exception {
        this.adaptRuntime();
    }

    public void test33ModifyRuntime() throws Exception {
        this.modifyRuntime();
    }

    public void test34DeleteRuntime() throws Exception {
        this.deleteRuntime();
    }

    public void test40CreateRuntime() throws Exception {
        runtime = this.createRuntime(RUNTIME_TYPE_ID_55).save(false, null);
        TomcatRuntimeTestCase.assertTrue((!runtime.isWorkingCopy() ? 1 : 0) != 0);
    }

    public void test41ValidateRuntime() throws Exception {
        this.validateRuntime();
    }

    public void test42AdaptRuntime() throws Exception {
        this.adaptRuntime();
    }

    public void test43ModifyRuntime() throws Exception {
        this.modifyRuntime();
    }

    public void test44DeleteRuntime() throws Exception {
        this.deleteRuntime();
    }
}

