/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom.validation;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.ws.jaxws.dom.runtime.DomUtil;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IServiceEndpointInterface;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebService;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebServiceProject;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.JaxWsWorkspaceResource;
import org.eclipse.jst.ws.jaxws.testutils.jmock.MockObjectTestCase;
import org.eclipse.jst.ws.jaxws.testutils.project.TestProject;
import org.eclipse.jst.ws.jaxws.testutils.project.TestProjectsUtils;
import org.eclipse.jst.ws.jaxws.utils.resources.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationTestsSetUp
extends MockObjectTestCase {
    protected static final String VALIDATION_PROBLEM_MARKER_ID = "org.eclipse.jdt.apt.core.nonreconcile.compile.problem";
    protected TestProject testProject;
    protected JaxWsWorkspaceResource target;
    protected IPackageFragment testPack;
    protected DomUtil util = DomUtil.INSTANCE;

    public void setUp() throws Exception {
        final TestProject[] fixtureProjects = this.createFixtureProjects();
        IJavaModel javaModel = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        this.target = new JaxWsWorkspaceResource(javaModel){

            public boolean approveProject(IJavaProject prj) {
                TestProject[] testProjectArray = fixtureProjects;
                int n = fixtureProjects.length;
                int n2 = 0;
                while (n2 < n) {
                    TestProject tp = testProjectArray[n2];
                    if (prj.getElementName().equals(tp.getJavaProject().getElementName())) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        };
        this.target.load(null);
        this.target.startSynchronizing();
    }

    protected TestProject[] createFixtureProjects() throws CoreException {
        this.testProject = new TestProject(TestProjectsUtils.createWeb25Project((String)("ValidationTest" + System.currentTimeMillis())));
        this.testPack = this.testProject.createPackage("test");
        this.testProject.setAptProcessingEnabled(true, false);
        this.testProject.build(10);
        return new TestProject[]{this.testProject};
    }

    public void tearDown() throws Exception {
        super.tearDown();
        try {
            this.disposeFixtureProjects();
        }
        catch (Exception exception) {}
    }

    protected void disposeFixtureProjects() throws CoreException {
        this.testProject.dispose();
    }

    protected IWebService findWs(String wsFQName) {
        IWebServiceProject wsProject = this.util.findProjectByName(this.target.getDOM(), this.testProject.getProject().getName());
        return this.util.findWsByImplName(wsProject, wsFQName);
    }

    protected IServiceEndpointInterface findSei(String seiFQName) {
        IWebServiceProject wsProject = this.util.findProjectByName(this.target.getDOM(), this.testProject.getProject().getName());
        return this.util.findSeiByImplName(wsProject, seiFQName);
    }

    protected void setContents(final ICompilationUnit cu, final String contents) throws CoreException {
        IWorkspaceRunnable setContentsRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                String newContent = "package " + ValidationTestsSetUp.this.testPack.getElementName() + ";\n" + contents;
                FileUtils.getInstance().setCompilationUnitContent(cu, newContent, false, monitor);
                cu.getResource().getProject().build(10, monitor);
            }
        };
        TestProjectsUtils.executeWorkspaceRunnable((IWorkspaceRunnable)setContentsRunnable);
    }

    protected void validateResourceMarkers(IResource resource, MarkerData ... markersExpectations) throws CoreException {
        this.validateMarkerCount(resource, markersExpectations);
        MarkerData[] markerDataArray = markersExpectations;
        int n = markersExpectations.length;
        int n2 = 0;
        while (n2 < n) {
            MarkerData mData = markerDataArray[n2];
            this.validateSingleResourceMarker(resource, mData);
            ++n2;
        }
    }

    private void validateMarkerCount(IResource resource, MarkerData ... markersExpectations) throws CoreException {
        MarkerData md;
        HashMap<String, Integer> markersCount = new HashMap<String, Integer>();
        MarkerData[] markerDataArray = markersExpectations;
        int n = markersExpectations.length;
        int n2 = 0;
        while (n2 < n) {
            md = markerDataArray[n2];
            if (markersCount.get(md.markerType) == null) {
                markersCount.put(md.markerType, 0);
            }
            markersCount.put(md.markerType, (Integer)markersCount.get(md.markerType) + 1);
            ++n2;
        }
        markerDataArray = markersExpectations;
        n = markersExpectations.length;
        n2 = 0;
        while (n2 < n) {
            md = markerDataArray[n2];
            IMarker[] markers = resource.findMarkers(md.markerType, true, 2);
            int markersFound = markers == null ? 0 : markers.length;
            ValidationTestsSetUp.assertEquals((String)MessageFormat.format("Unexpected count of markers of type {0}", md.markerType), markersCount.get(md.markerType), (Object)new Integer(markersFound));
            ++n2;
        }
    }

    private void validateSingleResourceMarker(IResource resource, MarkerData markerExpectation) throws CoreException {
        IMarker[] markers = resource.findMarkers(markerExpectation.markerType, true, 2);
        ValidationTestsSetUp.assertTrue((String)MessageFormat.format("No markers with type {0} found in resource {1}", markerExpectation.markerType, resource.getName()), (markers.length > 0 ? 1 : 0) != 0);
        boolean found = false;
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker m = iMarkerArray[n2];
            found = found || this.markerHasAttributes(m, markerExpectation.markerAttributes);
            ++n2;
        }
        ValidationTestsSetUp.assertTrue((String)("Could not find marker with attributes specified: " + markerExpectation.markerAttributes), (boolean)found);
    }

    private boolean markerHasAttributes(IMarker marker, Map<String, Object> attributes) throws CoreException {
        if (marker.getAttributes() == null || marker.getAttributes().isEmpty()) {
            return false;
        }
        for (String attributeName : attributes.keySet()) {
            Object markerAttribute = this.getMarkerAttribute(marker, attributeName);
            if (markerAttribute == null) {
                return false;
            }
            if (attributes.get(attributeName).equals(markerAttribute)) continue;
            return false;
        }
        return true;
    }

    private Object getMarkerAttribute(IMarker marker, String attributeName) {
        try {
            return marker.getAttribute(attributeName);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    protected void assertNoValidationErrors(IResource validatedResource, String markerType) throws CoreException {
        IMarker[] foundMarkers = validatedResource.findMarkers(markerType, true, 2);
        int markersCount = foundMarkers == null ? 0 : foundMarkers.length;
        ValidationTestsSetUp.assertEquals((String)"Markers unexpectedly found", (int)0, (int)markersCount);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MarkerData {
        protected final IResource resource;
        protected final Map<String, Object> markerAttributes;
        protected final String markerType;

        public MarkerData(IResource resource, String markerType, Map<String, Object> markerAttributes) {
            this.resource = resource;
            this.markerAttributes = markerAttributes;
            this.markerType = markerType;
        }
    }
}

