/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.archive.test;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.common.CommonPackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchivePackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBJarFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBModuleRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ValidateXmlCommand;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WebModuleRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.XmlValidationResult;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.SaveFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveInit;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.core.tests.bvt.AutomatedBVT;
import org.eclipse.jst.j2ee.ejb.ContainerManagedEntity;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EjbPackage;
import org.eclipse.jst.j2ee.ejb.Entity;
import org.eclipse.jst.j2ee.ejb.Session;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebapplicationPackage;

public class SimpleTests
extends TestCase {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    static /* synthetic */ Class class$0;

    public SimpleTests(String name) {
        super(name);
    }

    public boolean isEmpty(Collection adapters) {
        if (adapters.isEmpty()) {
            return true;
        }
        Iterator iter = adapters.iterator();
        while (iter.hasNext()) {
            if (iter.next() == null) continue;
            return false;
        }
        return true;
    }

    public CommonarchiveFactory getArchiveFactory() {
        return CommonarchivePackage.eINSTANCE.getCommonarchiveFactory();
    }

    public static void main(String[] args) {
        String[] className = new String[]{"com.ibm.etools.archive.test.SimpleTests", "-noloading"};
        TestRunner.main((String[])className);
    }

    public void printApplToConsole(Application appl) {
        EList modules = appl.getModules();
        int i = 0;
        while (i < modules.size()) {
            System.out.println(modules.get(i));
            ++i;
        }
    }

    public void printEJBJarToConsole(EJBJar ejbJar) {
        EList ejbs = ejbJar.getEnterpriseBeans();
        int i = 0;
        while (i < ejbs.size()) {
            System.out.println(ejbs.get(i));
            ++i;
        }
    }

    public void printWebAppToConsole(WebApp webApp) {
        EList servlets = webApp.getServlets();
        int i = 0;
        while (i < servlets.size()) {
            System.out.println(servlets.get(i));
            ++i;
        }
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.j2ee.archive.test.SimpleTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public void testContainerManagedEntityExtensionRead() throws Exception {
        CommonarchiveFactory factory = CommonarchivePackage.eINSTANCE.getCommonarchiveFactory();
        EJBJarFile jarFile = (EJBJarFile)factory.openArchive(String.valueOf(AutomatedBVT.baseDirectory) + "cmpsample.jar");
        jarFile.getDeploymentDescriptor();
    }

    public void testEJB11JarAdd() throws Exception {
        EARFile _earFile = this.getArchiveFactory().createEARFileInitialized(String.valueOf(AutomatedBVT.baseDirectory) + "testOutput/TestEAREJBAdd.ear");
        CommonarchiveFactory factory = CommonarchivePackage.eINSTANCE.getCommonarchiveFactory();
        EJBJarFile jar = (EJBJarFile)factory.openArchive(String.valueOf(AutomatedBVT.baseDirectory) + "ejb_compat_entitycmp.jar");
        jar.setURI(String.valueOf(AutomatedBVT.baseDirectory) + "ejb_compat_entitycmp.jar");
        _earFile.addCopy((ModuleFile)jar);
        _earFile.save();
    }

    public void testEJBSetAbstractSchemaName() throws Exception {
        String testSm = String.valueOf(AutomatedBVT.baseDirectory) + "TestSchema";
        CommonarchiveFactory factory = CommonarchivePackage.eINSTANCE.getCommonarchiveFactory();
        EJBJarFile jarFile = (EJBJarFile)factory.openArchive(String.valueOf(AutomatedBVT.baseDirectory) + "cmpsample.jar");
        EJBJar jar = jarFile.getDeploymentDescriptor();
        List lst = jar.getContainerManagedBeans();
        ContainerManagedEntity cmp = (ContainerManagedEntity)lst.get(0);
        cmp.setAbstractSchemaName(testSm);
        SimpleTests.assertTrue((boolean)cmp.getAbstractSchemaName().equals(testSm));
    }

    public void testIndexing() throws Exception {
        Archive anArchive = this.getArchiveFactory().openArchive(String.valueOf(AutomatedBVT.baseDirectory) + "foo.jar");
        String uri = "com/ibm/etools/archive/test/SimpleTests.java";
        EList files = anArchive.getFiles();
        org.eclipse.jst.j2ee.commonarchivecore.internal.File aFile = anArchive.getFile(uri);
        SimpleTests.assertTrue((String)"Adapter should be attached to aFile", (!this.isEmpty((Collection)aFile.eAdapters()) ? 1 : 0) != 0);
        files.remove(aFile);
        SimpleTests.assertTrue((String)"Adapter should not be attached to aFile", (boolean)this.isEmpty((Collection)aFile.eAdapters()));
        SimpleTests.assertTrue((String)"Contains should return false", (!anArchive.containsFile(uri) ? 1 : 0) != 0);
        org.eclipse.jst.j2ee.commonarchivecore.internal.File copy = anArchive.addCopy(aFile);
        SimpleTests.assertTrue((String)"Contains should return true", (boolean)anArchive.containsFile(uri));
        String renamedURI = "com/ibm/goobledygook";
        copy.setURI(renamedURI);
        SimpleTests.assertTrue((String)"Contains should return false for old uri", (!anArchive.containsFile(uri) ? 1 : 0) != 0);
        SimpleTests.assertTrue((String)"Contains should return true for new uri", (boolean)anArchive.containsFile(renamedURI));
    }

    public void testIndexingWithCollections() throws Exception {
        org.eclipse.jst.j2ee.commonarchivecore.internal.File aFile;
        Archive anArchive = this.getArchiveFactory().openArchive(String.valueOf(AutomatedBVT.baseDirectory) + "bankejbs.jar");
        EARFile earFile = this.getArchiveFactory().createEARFileInitialized(String.valueOf(AutomatedBVT.baseDirectory) + "bar.ear");
        earFile.addCopy(anArchive);
        anArchive = (Archive)earFile.getFile(String.valueOf(AutomatedBVT.baseDirectory) + "bankejbs.jar");
        SimpleTests.assertTrue((String)"Index out of sync", (!anArchive.getFiles().isEmpty() && anArchive.isIndexed() ? 1 : 0) != 0);
        EList files = anArchive.getFiles();
        int i = 0;
        while (i < files.size()) {
            org.eclipse.jst.j2ee.commonarchivecore.internal.File aFile2 = (org.eclipse.jst.j2ee.commonarchivecore.internal.File)files.get(i);
            SimpleTests.assertTrue((String)"Index out of whack; containment should be true", (boolean)anArchive.containsFile(aFile2.getURI()));
            SimpleTests.assertTrue((String)"Adapter should be attached to aFile", (!this.isEmpty((Collection)aFile2.eAdapters()) ? 1 : 0) != 0);
            ++i;
        }
        List filesToAdd = this.getArchiveFactory().openReadOnlyDirectory(String.valueOf(AutomatedBVT.baseDirectory) + "WarTestClasses").getFilesRecursive();
        List addedFiles = anArchive.addCopyFiles(filesToAdd);
        SimpleTests.assertTrue((String)"Files added incorrectly", (!filesToAdd.isEmpty() && filesToAdd.size() == addedFiles.size() ? 1 : 0) != 0);
        int i2 = 0;
        while (i2 < addedFiles.size()) {
            aFile = (org.eclipse.jst.j2ee.commonarchivecore.internal.File)addedFiles.get(i2);
            SimpleTests.assertTrue((String)"Contains should be true", (boolean)anArchive.containsFile(aFile.getURI()));
            SimpleTests.assertTrue((String)"Should be same instance", (anArchive.getFile(aFile.getURI()) == aFile ? 1 : 0) != 0);
            SimpleTests.assertTrue((String)"Adapter should be attached to aFile", (!this.isEmpty((Collection)aFile.eAdapters()) ? 1 : 0) != 0);
            ++i2;
        }
        anArchive.getFiles().removeAll((Collection)addedFiles);
        i2 = 0;
        while (i2 < addedFiles.size()) {
            aFile = (org.eclipse.jst.j2ee.commonarchivecore.internal.File)addedFiles.get(i2);
            SimpleTests.assertTrue((String)"Adapter should not be attached to aFile", (boolean)this.isEmpty((Collection)aFile.eAdapters()));
            SimpleTests.assertTrue((String)"Contains should return false", (!anArchive.containsFile(aFile.getURI()) ? 1 : 0) != 0);
            ++i2;
        }
        this.getArchiveFactory().closeOpenArchives();
    }

    public void testOpenAndExtract1() throws Exception {
        String in = String.valueOf(AutomatedBVT.baseDirectory) + "sample.ear";
        EARFile earFile = (EARFile)this.getArchiveFactory().openArchive(in);
        String out = String.valueOf(AutomatedBVT.baseDirectory) + "testOutput/SimpleTests/sample-expanded-out1.ear";
        earFile.extractTo(out, 0);
        earFile.close();
    }

    public void testOpenAndExtract2() throws Exception {
        String in = String.valueOf(AutomatedBVT.baseDirectory) + "sample.ear";
        ArchiveOptions options = new ArchiveOptions();
        options.setIsReadOnly(true);
        options.setUseJavaReflection(false);
        EARFile earFile = (EARFile)this.getArchiveFactory().openArchive(options, in);
        EList moduleRefs = earFile.getModuleRefs();
        int i = 0;
        while (i < moduleRefs.size()) {
            ModuleRef m = (ModuleRef)moduleRefs.get(i);
            m.getDeploymentDescriptor();
            ++i;
        }
        String out = "testOutput/SimpleTests/sample-expanded-out2.ear";
        earFile.extractTo(out, 2);
        earFile.close();
    }

    public void testOpenAndExtract3() throws Exception {
        String in = String.valueOf(AutomatedBVT.baseDirectory) + "sample.ear";
        EARFile earFile = (EARFile)this.getArchiveFactory().openArchive(in);
        String out = String.valueOf(AutomatedBVT.baseDirectory) + "testOutput/SimpleTests/sample-expanded-out3.ear";
        earFile.extractTo(out, 10);
        earFile.close();
    }

    public void testOpenAndRead() throws Exception {
        String in = String.valueOf(AutomatedBVT.baseDirectory) + "sample.ear";
        EARFile earFile = (EARFile)this.getArchiveFactory().openArchive(in);
        Application appl = earFile.getDeploymentDescriptor();
        this.printApplToConsole(appl);
        EList moduleRefs = earFile.getModuleRefs();
        int i = 0;
        while (i < moduleRefs.size()) {
            ModuleRef aModuleRef = (ModuleRef)moduleRefs.get(i);
            if (aModuleRef.isWeb()) {
                WebModuleRef wRef = (WebModuleRef)aModuleRef;
                this.printWebAppToConsole(wRef.getWebApp());
            } else if (aModuleRef.isEJB()) {
                EJBModuleRef eRef = (EJBModuleRef)aModuleRef;
                this.printEJBJarToConsole(eRef.getEJBJar());
            }
            ++i;
        }
    }

    public void testOpenAndSaveAsJarFile() throws Exception {
        String in = String.valueOf(AutomatedBVT.baseDirectory) + "sample.ear";
        EARFile earFile = (EARFile)this.getArchiveFactory().openArchive(in);
        String out = String.valueOf(AutomatedBVT.baseDirectory) + "testOutput/SimpleTests/sample-copy.ear";
        earFile.saveAsNoReopen(out);
    }

    public void testOpenDirectoryAndSaveAsJarFile() throws Exception {
        String in = String.valueOf(AutomatedBVT.baseDirectory) + "sample_expanded.ear";
        in = new File(in).getAbsolutePath();
        EARFile earFile = (EARFile)this.getArchiveFactory().openArchive(in);
        earFile.getDeploymentDescriptor();
        String out = "testOutput/SimpleTests/sample-jarred.ear";
        out = new File(out).getAbsolutePath();
        earFile.saveAsNoReopen(out);
    }

    public void testSafeClose() throws Exception {
        String in = String.valueOf(AutomatedBVT.baseDirectory) + "sample.ear";
        EARFile earFile = this.getArchiveFactory().openEARFile(in);
        EList modules = earFile.getDeploymentDescriptor().getModules();
        EJBJarFile ejbJarFile = null;
        int i = 0;
        while (i < modules.size()) {
            Module aModule = (Module)modules.get(i);
            if (aModule.isEjbModule()) {
                ejbJarFile = (EJBJarFile)earFile.getFile(aModule.getUri());
                break;
            }
            ++i;
        }
        SimpleTests.assertTrue((String)"EJBJarFile should not be null", (ejbJarFile != null ? 1 : 0) != 0);
        EARFile newEarFile = this.getArchiveFactory().createEARFileInitialized("testOutput/SimpleTests/safeClose1.ear");
        newEarFile.addCopy(ejbJarFile);
        SimpleTests.assertTrue((!earFile.getDependentOpenArchives().isEmpty() && !ejbJarFile.getDependentOpenArchives().isEmpty() ? 1 : 0) != 0);
        newEarFile.save();
        SimpleTests.assertTrue((earFile.getDependentOpenArchives().isEmpty() && ejbJarFile.getDependentOpenArchives().isEmpty() ? 1 : 0) != 0);
        earFile.close();
        newEarFile.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testSaveFailure() throws Exception {
        Object var7_8;
        String in = String.valueOf(AutomatedBVT.baseDirectory) + "sample.ear";
        String out = String.valueOf(AutomatedBVT.baseDirectory) + "testOutput/SimpleTests/saveFailure.ear";
        EARFile earFile = this.getArchiveFactory().openEARFile(in);
        EList modules = earFile.getDeploymentDescriptor().getModules();
        EJBJarFile ejbJarFile = null;
        int i = 0;
        while (i < modules.size()) {
            Module aModule = (Module)modules.get(i);
            if (aModule.isEjbModule()) {
                ejbJarFile = (EJBJarFile)earFile.getFile(aModule.getUri());
                break;
            }
            ++i;
        }
        SimpleTests.assertTrue((String)"EJBJarFile should not be null", (ejbJarFile != null ? 1 : 0) != 0);
        EARFile newEarFile = this.getArchiveFactory().createEARFileInitialized(out);
        newEarFile.addCopy(ejbJarFile);
        ejbJarFile.close();
        try {
            try {
                newEarFile.save();
            }
            catch (SaveFailureException saveFailureException) {
                System.out.println("Expected save failure occurred");
                var7_8 = null;
                SimpleTests.assertTrue((String)"File should not exist", (!new File(out).exists() ? 1 : 0) != 0);
                this.getArchiveFactory().closeOpenArchives();
                return;
            }
        }
        catch (Throwable throwable) {
            var7_8 = null;
            SimpleTests.assertTrue((String)"File should not exist", (!new File(out).exists() ? 1 : 0) != 0);
            this.getArchiveFactory().closeOpenArchives();
            throw throwable;
        }
        {
            var7_8 = null;
            SimpleTests.assertTrue((String)"File should not exist", (!new File(out).exists() ? 1 : 0) != 0);
        }
        this.getArchiveFactory().closeOpenArchives();
        SimpleTests.assertTrue((String)"Save should have failed", (boolean)false);
    }

    public void testXmlValidation() throws Exception {
        String in = String.valueOf(AutomatedBVT.baseDirectory) + "sample.ear";
        EARFile earFile = this.getArchiveFactory().openEARFile(in);
        Application appl = earFile.getDeploymentDescriptor();
        appl.getSecurityRoles().add((Object)CommonPackage.eINSTANCE.getCommonFactory().createSecurityRole());
        List moduleFiles = earFile.getModuleFiles();
        int i = 0;
        while (i < moduleFiles.size()) {
            ModuleFile aModuleFile = (ModuleFile)moduleFiles.get(i);
            if (aModuleFile.isWARFile()) {
                WARFile aWarFile = (WARFile)aModuleFile;
                aWarFile.getDeploymentDescriptor().getServlets().add((Object)WebapplicationPackage.eINSTANCE.getWebapplicationFactory().createServlet());
            } else if (aModuleFile.isEJBJarFile()) {
                EJBJarFile anEjbJarFile = (EJBJarFile)aModuleFile;
                anEjbJarFile.getDeploymentDescriptor().getEnterpriseBeans().add((Object)EjbPackage.eINSTANCE.getEjbFactory().createEntity());
                anEjbJarFile.getDeploymentDescriptor().getAssemblyDescriptor().getSecurityRoles().add((Object)CommonPackage.eINSTANCE.getCommonFactory().createSecurityRole());
            }
            ++i;
        }
        ValidateXmlCommand cmd = new ValidateXmlCommand((ModuleFile)earFile);
        cmd.execute();
        List errors = (List)cmd.getResult();
        SimpleTests.assertTrue((String)("Total validation errors should be 3, instead of " + errors.size()), (errors.size() == 3 ? 1 : 0) != 0);
        int i2 = 0;
        while (i2 < 3) {
            XmlValidationResult result = (XmlValidationResult)errors.get(i2);
            if (i2 == 1) {
                SimpleTests.assertTrue((String)("The ejb module should have 2 errors instead of " + result.getCaughtExceptions().size()), (result.getCaughtExceptions().size() == 2 ? 1 : 0) != 0);
            } else {
                SimpleTests.assertTrue((String)("The web module should have 1 error instead of " + result.getCaughtExceptions().size()), (result.getCaughtExceptions().size() == 1 ? 1 : 0) != 0);
            }
            ++i2;
        }
        earFile.close();
    }

    protected void setUp() throws Exception {
        super.setUp();
        ArchiveInit.init();
    }

    public void testReadEmptyTags() throws Exception {
        String uri = String.valueOf(AutomatedBVT.baseDirectory) + "CHKJ280X.jar";
        EJBJarFile jarfile = this.getArchiveFactory().openEJBJarFile(uri);
        EJBJar jar = jarfile.getDeploymentDescriptor();
        Session sess = (Session)jar.getEnterpriseBeans().get(0);
        Entity entity = (Entity)jar.getEnterpriseBeans().get(1);
        SimpleTests.assertFalse((String)"Value should be unset", (boolean)entity.isSetReentrant());
        SimpleTests.assertFalse((String)"Value should be unset", (boolean)sess.isSetSessionType());
        SimpleTests.assertFalse((String)"Value should be unset", (boolean)sess.isSetTransactionType());
    }
}

