/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.archive.test;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchivePackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ReadOnlyDirectory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.core.tests.bvt.AutomatedBVT;

public class WARFileTests
extends TestCase {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    static /* synthetic */ Class class$0;

    public WARFileTests(String name) {
        super(name);
    }

    public CommonarchiveFactory getArchiveFactory() {
        return CommonarchivePackage.eINSTANCE.getCommonarchiveFactory();
    }

    public static void main(String[] args) {
        String[] className = new String[]{"com.ibm.etools.archive.test.WARFileTests", "-noloading"};
        TestRunner.main((String[])className);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.j2ee.archive.test.WARFileTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public void testAddCopyClass() throws Exception {
        WARFile aWarFile = (WARFile)this.getArchiveFactory().openArchive(String.valueOf(AutomatedBVT.baseDirectory) + "example2.war");
        ReadOnlyDirectory sampleDirectory = this.getArchiveFactory().openReadOnlyDirectory(String.valueOf(AutomatedBVT.baseDirectory) + "WarTestClasses");
        int initialSize = aWarFile.getClasses().size();
        File aFile = sampleDirectory.getFileInSelfOrSubdirectory("com/ibm/etools/archive/test/WARFileTests.class");
        aWarFile.addCopyClass(aFile);
        WARFileTests.assertTrue((aWarFile.getClasses().size() == initialSize + 1 ? 1 : 0) != 0);
        String classURI = ArchiveUtil.concatUri((String)"WEB-INF/classes/", (String)aFile.getURI(), (char)'/');
        WARFileTests.assertTrue((boolean)aWarFile.containsFile(classURI));
        aWarFile.saveAsNoReopen(String.valueOf(AutomatedBVT.baseDirectory) + "testOutput/WarTests/addCopyClass.war");
    }

    public void testAddCopyLib() throws Exception {
        WARFile aWarFile = (WARFile)this.getArchiveFactory().openArchive(String.valueOf(AutomatedBVT.baseDirectory) + "example2.war");
        Archive lib = this.getArchiveFactory().openArchive(String.valueOf(AutomatedBVT.baseDirectory) + "foo.jar");
        int initialSize = aWarFile.getLibs().size();
        aWarFile.addCopyLib((File)lib);
        WARFileTests.assertTrue((aWarFile.getLibs().size() == initialSize + 1 ? 1 : 0) != 0);
        String libURI = ArchiveUtil.concatUri((String)"WEB-INF/lib/", (String)lib.getURI(), (char)'/');
        WARFileTests.assertTrue((boolean)aWarFile.containsFile(libURI));
        aWarFile.saveAsNoReopen("testOutput/WarTests/addCopyLib.war");
    }

    public void testListClassesAndLibs() throws Exception {
        WARFile aWarFile = (WARFile)this.getArchiveFactory().openArchive(String.valueOf(AutomatedBVT.baseDirectory) + "example2.war");
        aWarFile.getLibs();
        aWarFile.getClasses();
        aWarFile.getResources();
    }
}

