/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.generic.tests;

import java.util.List;
import junit.framework.TestCase;
import org.eclipse.jst.server.generic.core.internal.GenericServerRuntime;
import org.eclipse.jst.server.generic.servertype.definition.ServerRuntime;
import org.eclipse.jst.server.generic.tests.ServerRuntimeUtils;
import org.eclipse.jst.server.generic.tests.TestConstants;

public class GenericServerRuntimeTest
extends TestCase
implements TestConstants {
    public void testRuntimeInfoOnly() throws Exception {
        GenericServerRuntime runtime = ServerRuntimeUtils.getGenericServerRuntime("bar.runtime.id");
        GenericServerRuntimeTest.assertNotNull((Object)runtime);
        ServerRuntime runtimeDef = runtime.getServerTypeDefinition();
        GenericServerRuntimeTest.assertNotNull((Object)runtimeDef);
        ServerRuntimeUtils.verifyProperty((List)runtimeDef.getProperty(), "foo.prop.a", "a runtime property value");
        ServerRuntimeUtils.verifyNoProperty((List)runtimeDef.getProperty(), "foo.prop.b");
    }

    public void testServerAndRuntimeInfo() throws Exception {
        GenericServerRuntime runtime = ServerRuntimeUtils.getGenericServerRuntime("foo.serverdefonly.runtime.id");
        GenericServerRuntimeTest.assertNotNull((Object)runtime);
        ServerRuntime serverRuntime = runtime.getServerTypeDefinition();
        GenericServerRuntimeTest.assertNotNull((Object)serverRuntime);
        ServerRuntimeUtils.verifyProperty((List)serverRuntime.getProperty(), "foo.prop.a", "a runtime property value");
        ServerRuntimeUtils.verifyProperty((List)serverRuntime.getProperty(), "foo.prop.b", "a server property value");
    }
}

