/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.validation.test.internal.registry;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.validation.test.BVTValidationPlugin;
import org.eclipse.jst.validation.test.setup.IImportOperation;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;

public class TestSetupImport {
    private String _fileName = null;
    private IImportOperation _importOperation = null;

    public TestSetupImport(IImportOperation op, String fileName) {
        this._importOperation = op;
        this._fileName = fileName;
    }

    public File getInputFile(String dir) {
        File file = new File(dir, this.getFileName());
        if (!file.exists()) {
            Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
            if (logger.isLoggingLevel(Level.SEVERE)) {
                logger.write(Level.SEVERE, "File " + file.getAbsolutePath() + " must exist and have read access.");
            }
            return null;
        }
        return file;
    }

    public String getFileName() {
        return this._fileName;
    }

    public IImportOperation getOperation() {
        return this._importOperation;
    }

    public boolean importFile(IProgressMonitor monitor, String dir) {
        int executionMap = 0;
        boolean imported = true;
        try {
            File file = this.getInputFile(dir);
            executionMap |= 1;
            try {
                IImportOperation op = this.getOperation();
                executionMap |= 2;
                imported = op.run(monitor, file);
                executionMap |= 4;
            }
            catch (InterruptedException exc) {
                executionMap |= 8;
                imported = false;
                ValidationPlugin.getPlugin().handleException((Throwable)exc);
            }
            catch (InvocationTargetException exc) {
                executionMap |= 0x10;
                imported = false;
                ValidationPlugin.getPlugin().handleException((Throwable)exc);
                ValidationPlugin.getPlugin().handleException(exc.getTargetException());
            }
            catch (Throwable exc) {
                executionMap |= 0x20;
                imported = false;
                ValidationPlugin.getPlugin().handleException(exc);
            }
        }
        finally {
            if (!imported) {
                ValidationPlugin.getPlugin().logMessage(4, "TestSetup for " + dir + " was unsuccessful.");
            }
        }
        return imported;
    }
}

