/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.validation.test.setup;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jst.validation.test.BVTValidationPlugin;
import org.eclipse.jst.validation.test.internal.util.BVTValidationUtility;
import org.eclipse.jst.validation.test.setup.IImportOperation;
import org.eclipse.wst.validation.ValidationFramework;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;

public abstract class AImportOperation
implements IImportOperation {
    private void preRun(IProgressMonitor monitor) {
        ValidationFramework.getDefault().suspendAllValidation(true);
    }

    private void postRun(IProgressMonitor monitor) {
        ValidationFramework.getDefault().suspendAllValidation(false);
    }

    protected void deleteOldProject(IProgressMonitor monitor, String projectName) {
        IProject existingProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (existingProject.exists()) {
            try {
                existingProject.delete(true, null);
            }
            catch (CoreException exc) {
                BVTValidationPlugin.getPlugin().handleException(exc);
            }
        }
    }

    public boolean run(IProgressMonitor monitor, File file) {
        IProject project;
        boolean imported;
        block12: {
            imported = true;
            int executionMap = 0;
            project = null;
            try {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                this.preRun(monitor);
                try {
                    try {
                        String projectName = BVTValidationUtility.getProjectName(file);
                        this.deleteOldProject(monitor, projectName);
                        project = this.createNewProject(monitor, projectName, file);
                        if (project == null || !project.isAccessible()) {
                            executionMap |= 1;
                            imported = false;
                            String message = "Cannot import file because IProject is null or not accessible.";
                            monitor.subTask(message);
                            ValidationPlugin.getPlugin().logMessage(4, message);
                        } else {
                            imported = this.importFile(monitor, project, file);
                            executionMap |= 2;
                        }
                    }
                    catch (Throwable exc) {
                        executionMap |= 4;
                        imported = false;
                        ValidationPlugin.getPlugin().handleException(exc);
                        this.postRun(monitor);
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    this.postRun(monitor);
                    throw throwable;
                }
                this.postRun(monitor);
            }
            catch (Throwable throwable) {
                if (!imported) {
                    String projectName = project == null ? file.getName() : project.getName();
                    ValidationPlugin.getPlugin().logMessage(4, "AImportOperation for " + projectName + " was unsuccessful.");
                }
                throw throwable;
            }
        }
        if (!imported) {
            String projectName = project == null ? file.getName() : project.getName();
            ValidationPlugin.getPlugin().logMessage(4, "AImportOperation for " + projectName + " was unsuccessful.");
        }
        return imported;
    }

    protected abstract IProject createNewProject(IProgressMonitor var1, String var2, File var3);

    protected abstract boolean importFile(IProgressMonitor var1, IProject var2, File var3);
}

