/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.appconfig;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jst.jsf.core.jsfappconfig.AbstractJSFAppConfigLocater;
import org.eclipse.jst.jsf.core.jsfappconfig.AbstractJSFAppConfigProvider;
import org.eclipse.jst.jsf.core.jsfappconfig.IJSFAppConfigLocater;
import org.eclipse.jst.jsf.core.jsfappconfig.IJSFAppConfigProvider;
import org.eclipse.jst.jsf.core.jsfappconfig.internal.DefaultJSFAppConfigLocatorProviderStrategy;
import org.eclipse.jst.jsf.core.jsfappconfig.internal.IJSFAppConfigLocatorProvider;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanClassType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanNameType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestLocatorProvider
implements IJSFAppConfigLocatorProvider {
    public static final String MANAGED_BEAN_NAME_PREFIX = "MyManagedBean";
    public static final String MANAGED_BEAN_CLASS_PREFIX = "com.foo.MyManagedBeanClass";
    public static final int MANAGED_BEAN_COUNT = 10;
    public int managed_bean_count = 0;

    public TestLocatorProvider(int count) {
        this.managed_bean_count = count;
    }

    public TestLocatorProvider() {
        this.managed_bean_count = 10;
    }

    public List<IJSFAppConfigLocater> getLocators() {
        ArrayList<FakeLocator> ret = new ArrayList<FakeLocator>();
        ret.add(new FakeLocator());
        ret.addAll(new DefaultJSFAppConfigLocatorProviderStrategy().getLocators());
        return Collections.unmodifiableList(ret);
    }

    public void setBeanCreationCount(int count) {
        this.managed_bean_count = count;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FakeLocator
    extends AbstractJSFAppConfigLocater {
        private Set<IJSFAppConfigProvider> _providers;

        private FakeLocator() {
        }

        public Set<IJSFAppConfigProvider> getJSFAppConfigProviders() {
            if (this._providers == null) {
                this._providers = new HashSet<IJSFAppConfigProvider>();
                this._providers.add((IJSFAppConfigProvider)new FakeProvider());
            }
            return Collections.unmodifiableSet(this._providers);
        }

        public void startLocating() {
        }

        public void stopLocating() {
        }
    }

    private class FakeProvider
    extends AbstractJSFAppConfigProvider {
        private FacesConfigType _model;

        private FakeProvider() {
        }

        public FacesConfigType getFacesConfigModel() {
            if (this._model == null) {
                FacesConfigFactory fac = FacesConfigFactory.eINSTANCE;
                this._model = fac.createFacesConfigType();
                this.addFakeBeans(fac, this._model);
            }
            return this._model;
        }

        private void addFakeBeans(FacesConfigFactory fac, FacesConfigType model) {
            int i = 0;
            while (i < TestLocatorProvider.this.managed_bean_count) {
                ManagedBeanType bean = fac.createManagedBeanType();
                ManagedBeanNameType name = fac.createManagedBeanNameType();
                name.setTextContent(TestLocatorProvider.MANAGED_BEAN_NAME_PREFIX + i);
                bean.setManagedBeanName(name);
                ManagedBeanClassType klass = fac.createManagedBeanClassType();
                klass.setTextContent(TestLocatorProvider.MANAGED_BEAN_CLASS_PREFIX + i);
                bean.setManagedBeanClass(klass);
                model.getManagedBean().add((Object)bean);
                ++i;
            }
        }

        public void releaseFacesConfigModel() {
            this._model = null;
        }
    }
}

