/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.facet;

import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jst.common.project.facet.core.JavaFacet;
import org.eclipse.jst.javaee.core.Description;
import org.eclipse.jst.javaee.core.Listener;
import org.eclipse.jst.javaee.core.ParamValue;
import org.eclipse.jst.javaee.core.UrlPatternType;
import org.eclipse.jst.javaee.web.Servlet;
import org.eclipse.jst.javaee.web.ServletMapping;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.jsf.common.webxml.WebXmlUpdater;
import org.eclipse.jst.jsf.common.webxml.WebXmlUtilsForJavaEE;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class VendorSpecificWebXmlConfigurationForJavaEETest
extends TestCase {
    private static final IProjectFacetVersion WEB_MODULE_VERSION = ProjectFacetsManager.getProjectFacet((String)"jst.web").getVersion("2.5");
    private static final IProjectFacetVersion JAVA_VERSION = JavaFacet.VERSION_1_5;
    private static final String PROJECT_NAME_PREFIX = "_TEST_PROJECT_NAME_FOR_JAVA_EE";
    private static final String SERVLET_NAME = "_TEST_SERVLET_NAME";
    private static final String SERVLET_CLASS_NAME = "_TEST_SERVLET_CLASS_NAME";
    private static final String SERVLET_LOAD_ON_STARTUP = "1";
    private static final String SERVLET_URL_PATTERN = "*._TEST_SERVLET_URL_PATTERN";
    private static final String CONTEXT_PARAM_NAME = "_TEST_CONTEXT_PARAM_NAME";
    private static final String CONTEXT_PARAM_VALUE = "_TEST_CONTEXT_PARAM_VALUE";
    private static final String CONTEXT_PARAM_DESCRIPTION = "_TEST_CONTEXT_PARAM_DESCRIPTION";
    private static final String LISTENER_CLASS = "_TEST_LISTENER_CLASS";
    private IProject project;
    private WebXmlUpdater updater;

    protected void setUp() throws Exception {
        super.setUp();
        this.project = this.createProject(PROJECT_NAME_PREFIX + ((Object)((Object)this)).getClass().getName() + this.getName());
        this.updater = new WebXmlUpdater(this.project, (IProgressMonitor)new NullProgressMonitor());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        JSFTestUtil.safeDelete((IResource)this.project, (int)3, (int)500);
    }

    private IProject createProject(String projectName) throws Exception {
        WebProjectTestEnvironment testEnv = new WebProjectTestEnvironment(projectName, JAVA_VERSION, WEB_MODULE_VERSION);
        testEnv.createProject(true);
        return testEnv.getTestProject();
    }

    public void testAddServlet() throws Exception {
        this.updater.addServlet(SERVLET_NAME, SERVLET_CLASS_NAME, SERVLET_LOAD_ON_STARTUP);
        Servlet servlet = WebXmlUtilsForJavaEE.findServlet((String)SERVLET_CLASS_NAME, (WebApp)this.updater.getWebAppForJavaEE());
        VendorSpecificWebXmlConfigurationForJavaEETest.assertNotNull((Object)servlet);
        VendorSpecificWebXmlConfigurationForJavaEETest.assertEquals((String)SERVLET_NAME, (String)servlet.getServletName());
        VendorSpecificWebXmlConfigurationForJavaEETest.assertEquals((String)SERVLET_CLASS_NAME, (String)servlet.getServletClass());
        VendorSpecificWebXmlConfigurationForJavaEETest.assertEquals((String)SERVLET_LOAD_ON_STARTUP, (String)servlet.getLoadOnStartup().toString());
    }

    public void testAddContextParam() throws Exception {
        this.updater.addServlet(SERVLET_NAME, SERVLET_CLASS_NAME, SERVLET_LOAD_ON_STARTUP);
        this.updater.addContextParam(CONTEXT_PARAM_NAME, CONTEXT_PARAM_VALUE, CONTEXT_PARAM_DESCRIPTION);
        ParamValue param = WebXmlUtilsForJavaEE.findContextParam((WebApp)this.updater.getWebAppForJavaEE(), (String)CONTEXT_PARAM_NAME, (String)CONTEXT_PARAM_VALUE);
        VendorSpecificWebXmlConfigurationForJavaEETest.assertNotNull((Object)param);
        VendorSpecificWebXmlConfigurationForJavaEETest.assertEquals((String)CONTEXT_PARAM_NAME, (String)param.getParamName());
        VendorSpecificWebXmlConfigurationForJavaEETest.assertEquals((String)CONTEXT_PARAM_VALUE, (String)param.getParamValue());
        VendorSpecificWebXmlConfigurationForJavaEETest.assertEquals((String)CONTEXT_PARAM_DESCRIPTION, (String)((Description)param.getDescriptions().get(0)).getValue());
    }

    public void testGetContextParamValue() {
        VendorSpecificWebXmlConfigurationForJavaEETest.assertFalse((boolean)WebXmlUtilsForJavaEE.existsContextParam((WebApp)this.updater.getWebAppForJavaEE(), (String)CONTEXT_PARAM_NAME, (String)CONTEXT_PARAM_VALUE));
        this.updater.addContextParam(CONTEXT_PARAM_NAME, CONTEXT_PARAM_VALUE, CONTEXT_PARAM_DESCRIPTION);
        String contextParamValue = this.updater.getContextParamValue(CONTEXT_PARAM_NAME);
        VendorSpecificWebXmlConfigurationForJavaEETest.assertNotNull((Object)contextParamValue);
        VendorSpecificWebXmlConfigurationForJavaEETest.assertEquals((String)CONTEXT_PARAM_VALUE, (String)contextParamValue);
    }

    public void testGetContextParamValuesAsList() {
        VendorSpecificWebXmlConfigurationForJavaEETest.assertFalse((boolean)WebXmlUtilsForJavaEE.existsContextParam((WebApp)this.updater.getWebAppForJavaEE(), (String)CONTEXT_PARAM_NAME, (String)CONTEXT_PARAM_VALUE));
        this.updater.addContextParam(CONTEXT_PARAM_NAME, "_TEST_CONTEXT_PARAM_VALUE1;_TEST_CONTEXT_PARAM_VALUE2;_TEST_CONTEXT_PARAM_VALUE3", CONTEXT_PARAM_DESCRIPTION);
        List<String> expectedList = Arrays.asList("_TEST_CONTEXT_PARAM_VALUE1", "_TEST_CONTEXT_PARAM_VALUE2", "_TEST_CONTEXT_PARAM_VALUE3");
        List actualList = this.updater.getContextParamValuesAsList(CONTEXT_PARAM_NAME, ";");
        VendorSpecificWebXmlConfigurationForJavaEETest.assertEquals(expectedList, (Object)actualList);
    }

    public void testSetContextParamValue() {
        VendorSpecificWebXmlConfigurationForJavaEETest.assertFalse((boolean)WebXmlUtilsForJavaEE.existsContextParam((WebApp)this.updater.getWebAppForJavaEE(), (String)CONTEXT_PARAM_NAME, (String)CONTEXT_PARAM_VALUE));
        this.updater.setContextParamValue(CONTEXT_PARAM_NAME, CONTEXT_PARAM_VALUE);
        VendorSpecificWebXmlConfigurationForJavaEETest.assertEquals((String)CONTEXT_PARAM_VALUE, (String)this.updater.getContextParamValue(CONTEXT_PARAM_NAME));
        VendorSpecificWebXmlConfigurationForJavaEETest.assertFalse((boolean)this.updater.getContextParamValue(CONTEXT_PARAM_NAME).equals("_TEST_CONTEXT_PARAM_VALUEupdated"));
        this.updater.setContextParamValue(CONTEXT_PARAM_NAME, "_TEST_CONTEXT_PARAM_VALUEupdated");
        VendorSpecificWebXmlConfigurationForJavaEETest.assertEquals((String)"_TEST_CONTEXT_PARAM_VALUEupdated", (String)this.updater.getContextParamValue(CONTEXT_PARAM_NAME));
    }

    public void testAddServletMapping() throws Exception {
        this.updater.addServlet(SERVLET_NAME, SERVLET_CLASS_NAME, SERVLET_LOAD_ON_STARTUP);
        this.updater.addServletMapping(SERVLET_NAME, SERVLET_CLASS_NAME, SERVLET_URL_PATTERN);
        ServletMapping mapping = WebXmlUtilsForJavaEE.findServletMapping((WebApp)this.updater.getWebAppForJavaEE(), (String)SERVLET_NAME, (String)SERVLET_URL_PATTERN);
        VendorSpecificWebXmlConfigurationForJavaEETest.assertNotNull((Object)mapping);
        VendorSpecificWebXmlConfigurationForJavaEETest.assertEquals((String)SERVLET_NAME, (String)mapping.getServletName());
        VendorSpecificWebXmlConfigurationForJavaEETest.assertEquals((String)SERVLET_URL_PATTERN, (String)((UrlPatternType)mapping.getUrlPatterns().get(0)).getValue());
    }

    public void testAddListener() throws Exception {
        this.updater.addListener(LISTENER_CLASS);
        Listener listener = WebXmlUtilsForJavaEE.findListener((WebApp)this.updater.getWebAppForJavaEE(), (String)LISTENER_CLASS);
        VendorSpecificWebXmlConfigurationForJavaEETest.assertNotNull((Object)listener);
        VendorSpecificWebXmlConfigurationForJavaEETest.assertEquals((String)LISTENER_CLASS, (String)listener.getListenerClass());
    }
}

