/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.project.facet;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.webapplication.WebapplicationFactory;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.javaee.web.WebAppVersionType;
import org.eclipse.jst.javaee.web.WebFactory;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.jst.jsf.core.internal.project.facet.JSFUtilFactory;
import org.eclipse.jst.jsf.core.tests.project.facet.TestableJSFUtils;
import org.eclipse.jst.jsf.test.util.TestFileResource;
import org.eclipse.jst.jsf.test.util.mock.MockBundle;
import org.eclipse.jst.jsf.test.util.mock.MockDataModel;
import org.eclipse.jst.jsf.test.util.mock.MockModelProvider;
import org.eclipse.jst.jsf.test.util.mock.MockResource;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.osgi.framework.Bundle;

public abstract class TestJSFUtils
extends TestCase {
    private static final String PATTERN_SLASH_FACES_SLASH_ALL = "/faces/*";
    protected TestableJSFUtils _jsfUtils;
    protected Object _modelObject;
    private WebAppAccessor _webAppAccessor;

    protected void setUp() throws Exception {
        this._modelObject = new Object();
        this._jsfUtils = new TestableJSFUtils(new JSFUtilFactory().create(this.getVersionToTestIn(), null), (IModelProvider)new MockModelProvider(this._modelObject));
        TestJSFUtils.assertEquals((Object)this.getVersionToTestIn(), (Object)this._jsfUtils.getVersion());
        this._webAppAccessor = this.createWebAccessor();
    }

    protected void testRollbackWebApp(String version) {
        Object webApp = this._webAppAccessor.createWebApp(version);
        this._jsfUtils.rollbackWebApp(webApp);
        Object servlet = this._webAppAccessor.createServlet("Foobar", "javax.faces.webapp.FacesServlet");
        this._webAppAccessor.addServletToWebApp(webApp, servlet);
        this._jsfUtils.rollbackWebApp(webApp);
        TestJSFUtils.assertEquals((int)0, (int)this._webAppAccessor.getServlets(webApp).size());
        TestJSFUtils.assertTrue((this._webAppAccessor.getServlet(webApp, "Foobar") == null ? 1 : 0) != 0);
        this._webAppAccessor.addServletToWebApp(webApp, servlet);
        Object mapping = this._webAppAccessor.createServletMapping();
        this._webAppAccessor.setMappingData(webApp, Collections.singletonList(".xhtml"), servlet, mapping);
        this._webAppAccessor.addMappingToWebApp(webApp, mapping);
        Object contextParam = this._webAppAccessor.createContextParam("javax.faces.CONFIG_FILES", "/WEB-INF/faces-config.xml", version);
        this._webAppAccessor.setContextParam(webApp, contextParam, version);
        TestJSFUtils.assertEquals((int)1, (int)this._webAppAccessor.getServlets(webApp).size());
        TestJSFUtils.assertTrue((this._webAppAccessor.getServlet(webApp, "Foobar") == servlet ? 1 : 0) != 0);
        TestJSFUtils.assertEquals((int)1, (int)this._webAppAccessor.getServletMappings_WebApp(webApp).size());
        TestJSFUtils.assertEquals((int)1, (int)this._webAppAccessor.getContextParams(webApp, version).size());
        this._jsfUtils.rollbackWebApp(webApp);
        TestJSFUtils.assertEquals((int)0, (int)this._webAppAccessor.getServlets(webApp).size());
        TestJSFUtils.assertTrue((this._webAppAccessor.getServlet(webApp, "Foobar") == null ? 1 : 0) != 0);
        TestJSFUtils.assertEquals((int)0, (int)this._webAppAccessor.getServletMappings_WebApp(webApp).size());
        TestJSFUtils.assertEquals((int)0, (int)this._webAppAccessor.getContextParams(webApp, version).size());
        this._webAppAccessor.addServletToWebApp(webApp, servlet);
        Object servlet2 = this._webAppAccessor.createServlet("DonotRemove", "com.foo.SomeClass");
        this._webAppAccessor.addServletToWebApp(webApp, servlet2);
        this._webAppAccessor.addMappingToWebApp(webApp, mapping);
        Object mapping2 = this._webAppAccessor.createServletMapping();
        this._webAppAccessor.setMappingData(webApp, Collections.singletonList("blah"), servlet2, mapping2);
        this._webAppAccessor.addMappingToWebApp(webApp, mapping2);
        TestJSFUtils.assertEquals((int)2, (int)this._webAppAccessor.getServlets(webApp).size());
        TestJSFUtils.assertTrue((this._webAppAccessor.getServlet(webApp, "Foobar") == servlet ? 1 : 0) != 0);
        TestJSFUtils.assertTrue((this._webAppAccessor.getServlet(webApp, "DonotRemove") == servlet2 ? 1 : 0) != 0);
        TestJSFUtils.assertEquals((int)2, (int)this._webAppAccessor.getServletMappings_WebApp(webApp).size());
        this._jsfUtils.rollbackWebApp(webApp);
        TestJSFUtils.assertEquals((int)1, (int)this._webAppAccessor.getServlets(webApp).size());
        TestJSFUtils.assertSame((Object)servlet2, (Object)this._webAppAccessor.getServlet(webApp, "DonotRemove"));
        TestJSFUtils.assertEquals((int)1, (int)this._webAppAccessor.getServletMappings_WebApp(webApp).size());
    }

    protected void testUpdateWebApp_NewServlet(String version) {
        Object webApp = this._webAppAccessor.createWebApp(version);
        HashMap<String, MockDataModel.MockPropertyHolder> configProps = new HashMap<String, MockDataModel.MockPropertyHolder>();
        configProps.put("IJSFFacetInstallDataModelProperties.SERVLET_URL_PATTERNS", new MockDataModel.MockPropertyHolder((Object)new String[]{PATTERN_SLASH_FACES_SLASH_ALL}, null));
        configProps.put("IJSFFacetInstallDataModelProperties.CONFIG_PATH", new MockDataModel.MockPropertyHolder((Object)"/WEB-INF/faces-config.xml", null));
        MockDataModel config = new MockDataModel("testModel", configProps);
        this._jsfUtils.updateWebApp(webApp, (IDataModel)config);
        this.verifyServlet(webApp);
        webApp = this._webAppAccessor.createWebApp(version);
        configProps.put("IJSFFacetInstallDataModelProperties.CONFIG_PATH", new MockDataModel.MockPropertyHolder((Object)"/WEB-INF/app-config.xml", null));
        this._jsfUtils.updateWebApp(webApp, (IDataModel)config);
        this.verifyServlet(webApp);
        TestJSFUtils.assertEquals((int)1, (int)this._webAppAccessor.getContextParams(webApp, version).size());
        TestJSFUtils.assertEquals((String)"/WEB-INF/app-config.xml", (String)this._webAppAccessor.getContextParamValue(this._webAppAccessor.getContextParams(webApp, version).get(0), version));
        webApp = this._webAppAccessor.createWebApp(version);
        configProps.put("IJSFFacetInstallDataModelProperties.CONFIG_PATH", new MockDataModel.MockPropertyHolder((Object)"/WEB-INF/app-config.xml", null));
        Object param = this._webAppAccessor.createContextParam("javax.faces.CONFIG_FILES", "SomeOtherValue", version);
        this._webAppAccessor.setContextParam(webApp, param, version);
        this._jsfUtils.updateWebApp(webApp, (IDataModel)config);
        this.verifyServlet(webApp);
        TestJSFUtils.assertEquals((int)1, (int)this._webAppAccessor.getContextParams(webApp, version).size());
    }

    protected void verifyServlet(Object webApp) {
        Object defaultServlet = this._webAppAccessor.getServlet(webApp, "Faces Servlet");
        TestJSFUtils.assertNotNull((Object)defaultServlet);
        this._webAppAccessor.verifyServlet(defaultServlet, "javax.faces.webapp.FacesServlet");
        this._webAppAccessor.verifyLoadOnStartup(defaultServlet, 1);
        List mappings = this._webAppAccessor.getServletMappings_Servlet(webApp, defaultServlet);
        TestJSFUtils.assertEquals((int)1, (int)mappings.size());
        Object mapping = mappings.get(0);
        TestJSFUtils.assertNotNull(mapping);
        this._webAppAccessor.verifyMapping(mapping, "Faces Servlet", PATTERN_SLASH_FACES_SLASH_ALL);
    }

    protected void testUpdateWebApp_ExistingServlet(String version) {
        Object webApp = this._webAppAccessor.createWebApp(version);
        Object servlet = this._webAppAccessor.createServlet("Foobar", "javax.faces.webapp.FacesServlet");
        this._webAppAccessor.addServletToWebApp(webApp, servlet);
        HashMap<String, MockDataModel.MockPropertyHolder> configProps = new HashMap<String, MockDataModel.MockPropertyHolder>();
        MockDataModel config = new MockDataModel("testModel", configProps);
        this._jsfUtils.updateWebApp(webApp, (IDataModel)config);
        Object defaultServlet = this._webAppAccessor.getServlet(webApp, "Faces Servlet");
        TestJSFUtils.assertNotNull((Object)defaultServlet);
        this._webAppAccessor.verifyServlet(defaultServlet, "javax.faces.webapp.FacesServlet");
        this._webAppAccessor.verifyLoadOnStartup(defaultServlet, 1);
        Object mapping = this._webAppAccessor.createServletMapping();
        this._webAppAccessor.setMappingData(webApp, Collections.singletonList("/faces"), servlet, mapping);
        this._webAppAccessor.addMappingToWebApp(webApp, mapping);
        configProps.put("IJSFFacetInstallDataModelProperties.SERVLET_URL_PATTERNS", new MockDataModel.MockPropertyHolder((Object)new String[]{"/faces"}, null));
        this._jsfUtils.updateWebApp(webApp, (IDataModel)config);
        defaultServlet = this._webAppAccessor.getServlet(webApp, "Faces Servlet");
        this._webAppAccessor.verifyServlet(defaultServlet, "javax.faces.webapp.FacesServlet");
        this._webAppAccessor.verifyMapping(mapping, "Faces Servlet", "/faces");
        this._webAppAccessor.verifyLoadOnStartup(defaultServlet, 1);
    }

    protected void testGetFileUrlPath_NonNullCases(String version) {
        Object webApp = this._webAppAccessor.createWebApp(version);
        Object servlet = this._webAppAccessor.createServlet("JSF Servlet", "javax.faces.webapp.FacesServlet");
        this._webAppAccessor.addServletToWebApp(webApp, servlet);
        Object mapping = this._webAppAccessor.createServletMapping();
        this._webAppAccessor.setMappingData(webApp, Collections.singletonList(".faces"), servlet, mapping);
        this._webAppAccessor.addMappingToWebApp(webApp, mapping);
        IPath fileUrlPath = this._jsfUtils.getFileUrlPath(webApp, (IResource)new MockResource(1, (IPath)new Path("/WebContent/test.jsp")), (IPath)new Path("/test.jsp"));
        TestJSFUtils.assertEquals((String)"/test.faces", (String)fileUrlPath.toString());
        fileUrlPath = this._jsfUtils.getFileUrlPath(webApp, (IResource)new MockResource(1, (IPath)new Path("/WebContent/test.xhtml")), (IPath)new Path("/test.xhtml"));
        TestJSFUtils.assertEquals((String)"/test.faces", (String)fileUrlPath.toString());
        this._webAppAccessor.setUrlPattern(mapping, Collections.singletonList("/faces"));
        fileUrlPath = this._jsfUtils.getFileUrlPath(webApp, (IResource)new MockResource(1, (IPath)new Path("/WebContent/test.jsp")), (IPath)new Path("/test.jsp"));
        TestJSFUtils.assertEquals((String)"/faces/test.jsp", (String)fileUrlPath.toString());
        this._webAppAccessor.setUrlPattern(mapping, Collections.singletonList(PATTERN_SLASH_FACES_SLASH_ALL));
        fileUrlPath = this._jsfUtils.getFileUrlPath(webApp, (IResource)new MockResource(1, (IPath)new Path("/WebContent/test.jsp")), (IPath)new Path("/test.jsp"));
        TestJSFUtils.assertEquals((String)"/faces/test.jsp", (String)fileUrlPath.toString());
        this._webAppAccessor.setUrlPattern(mapping, Collections.singletonList(".jspx"));
        Object param = this._webAppAccessor.createContextParam("javax.faces.DEFAULT_SUFFIX", ".xhtml", version);
        this._webAppAccessor.setContextParam(webApp, param, version);
        fileUrlPath = this._jsfUtils.getFileUrlPath(webApp, (IResource)new MockResource(1, (IPath)new Path("/WebContent/test.xhtml")), (IPath)new Path("/test.xhtml"));
        TestJSFUtils.assertEquals((String)"/test.jspx", (String)fileUrlPath.toString());
    }

    protected void testGetFileUrlPath_NullCases(String version) {
        Path existingURL = new Path("foobar");
        this.verifyNull(existingURL, null);
        this.verifyNull(existingURL, new Object());
        Object webApp = this._webAppAccessor.createWebApp("2.4");
        this.verifyNull(existingURL, webApp);
        Object servlet = this._webAppAccessor.createServlet(null, null);
        this._webAppAccessor.addServletToWebApp(webApp, servlet);
        this.verifyNull(existingURL, webApp);
        this.doPre25SpecificOrNoop(existingURL, webApp, servlet);
        this._webAppAccessor.setServletClass(servlet, "com.wrong.Servlet");
        this.verifyNull(existingURL, webApp);
        servlet = this._webAppAccessor.createServlet("JSF Servlet", "com.AnotherWrong.Servlet");
        this._webAppAccessor.addServletToWebApp(webApp, servlet);
        TestJSFUtils.assertEquals((int)2, (int)this._webAppAccessor.getServlets(webApp).size());
        this.verifyNull(existingURL, webApp);
        this._webAppAccessor.setServletClass(servlet, "javax.faces.webapp.FacesServlet");
        this.verifyNull(existingURL, webApp, (IResource)new MockResource(1, (IPath)new Path("/somepath")));
        this.verifyNull(existingURL, webApp, (IResource)new MockResource(1, (IPath)new Path("/somepath.xhtml")));
        Object mapping = this._webAppAccessor.createServletMapping();
        this._webAppAccessor.addMappingToWebApp(webApp, mapping);
        TestJSFUtils.assertEquals((int)1, (int)this._webAppAccessor.getServletMappings_WebApp(webApp).size());
        TestJSFUtils.assertEquals((int)0, (int)this._webAppAccessor.getServletMappings_Servlet(webApp, servlet).size());
        this.verifyNull(existingURL, webApp, (IResource)new MockResource(1, (IPath)new Path("/somepath.xhtml")));
        this._webAppAccessor.setServletOnMapping(mapping, servlet);
        TestJSFUtils.assertEquals((int)1, (int)this._webAppAccessor.getServletMappings_WebApp(webApp).size());
        TestJSFUtils.assertEquals((int)1, (int)this._webAppAccessor.getServletMappings_Servlet(webApp, servlet).size());
        TestJSFUtils.assertTrue((boolean)this._webAppAccessor.getServletMappings_Servlet(webApp, servlet).contains(mapping));
        this.verifyNull(existingURL, webApp, (IResource)new MockResource(1, (IPath)new Path("/somepath.xhtml")));
    }

    protected void doPre25SpecificOrNoop(Path existingURL, Object webApp, Object servlet) {
    }

    public void testFacesConfigCreation() throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this._jsfUtils.printConfigFile_testable(os);
        TestJSFUtils.assertEquals((String)this.getExpectedDefaultConfigFile().toString("ISO-8859-1").replaceAll("\\r", ""), (String)os.toString("ISO-8859-1"));
    }

    protected TestFileResource getExpectedDefaultConfigFile() throws IOException {
        String replaceAll = this.getVersionToTestIn().toString().replaceAll("\\.", "_");
        String defaultFileName = String.format("/testfiles/facet/expected-faces-config-%s.xml", replaceAll);
        TestFileResource testFileResource = new TestFileResource();
        testFileResource.load((Bundle)new MockBundle(new File(".").getCanonicalPath()), defaultFileName);
        return testFileResource;
    }

    public void testIsJavaEE() {
        WebApp javaEEWebApp = WebFactory.eINSTANCE.createWebApp();
        TestJSFUtils.assertEquals((Object)WebAppVersionType._25_LITERAL, (Object)javaEEWebApp.getVersion());
        TestJSFUtils.assertTrue((boolean)this._jsfUtils.isJavaEE(javaEEWebApp));
        javaEEWebApp.setVersion(WebAppVersionType._30_LITERAL);
        TestJSFUtils.assertTrue((boolean)this._jsfUtils.isJavaEE(javaEEWebApp));
        org.eclipse.jst.j2ee.webapplication.WebApp J2EEWebApp = WebapplicationFactory.eINSTANCE.createWebApp();
        TestJSFUtils.assertFalse((boolean)this._jsfUtils.isJavaEE(J2EEWebApp));
    }

    public void testGetModelProvider() {
        IModelProvider modelProvider = this._jsfUtils.getModelProvider();
        TestJSFUtils.assertNotNull((Object)modelProvider);
        TestJSFUtils.assertEquals((Object)this._modelObject, (Object)modelProvider.getModelObject());
        this._jsfUtils = new TestableJSFUtils(new JSFUtilFactory().create(JSFVersion.V2_0, null), (IModelProvider)new MockModelProvider(null));
        TestJSFUtils.assertNull((Object)this._jsfUtils.getModelProvider());
    }

    public void testGetDisplayName() {
        HashMap propsMap = new HashMap();
        MockDataModel model = new MockDataModel("TestID", propsMap);
        TestJSFUtils.assertEquals((String)"Faces Servlet", (String)this._jsfUtils.getDisplayName_testable((IDataModel)model));
        model.setProperty("IJSFFacetInstallDataModelProperties.SERVLET_NAME", (Object)"");
        TestJSFUtils.assertEquals((String)"Faces Servlet", (String)this._jsfUtils.getDisplayName_testable((IDataModel)model));
        model.setProperty("IJSFFacetInstallDataModelProperties.SERVLET_NAME", (Object)"");
        TestJSFUtils.assertEquals((String)"Faces Servlet", (String)this._jsfUtils.getDisplayName_testable((IDataModel)model));
        model.setProperty("IJSFFacetInstallDataModelProperties.SERVLET_NAME", (Object)"foobar");
        TestJSFUtils.assertEquals((String)"foobar", (String)this._jsfUtils.getDisplayName_testable((IDataModel)model));
    }

    public void testGetServletClassName() {
        HashMap propsMap = new HashMap();
        MockDataModel model = new MockDataModel("TestID", propsMap);
        TestJSFUtils.assertEquals((String)"javax.faces.webapp.FacesServlet", (String)this._jsfUtils.getServletClassname_testable((IDataModel)model));
        model.setProperty("IJSFFacetInstallDataModelProperties.SERVLET_CLASSNAME", (Object)"");
        TestJSFUtils.assertEquals((String)"javax.faces.webapp.FacesServlet", (String)this._jsfUtils.getServletClassname_testable((IDataModel)model));
        model.setProperty("IJSFFacetInstallDataModelProperties.SERVLET_CLASSNAME", (Object)"");
        TestJSFUtils.assertEquals((String)"javax.faces.webapp.FacesServlet", (String)this._jsfUtils.getServletClassname_testable((IDataModel)model));
        model.setProperty("IJSFFacetInstallDataModelProperties.SERVLET_CLASSNAME", (Object)"foobar");
        TestJSFUtils.assertEquals((String)"foobar", (String)this._jsfUtils.getServletClassname_testable((IDataModel)model));
    }

    public void testGetServletMappings() {
        HashMap propsMap = new HashMap();
        MockDataModel model = new MockDataModel("TestID", propsMap);
        model.setProperty("IJSFFacetInstallDataModelProperties.SERVLET_URL_PATTERNS", (Object)new String[0]);
        TestJSFUtils.assertTrue((boolean)this._jsfUtils.getServletMappings_testable((IDataModel)model).isEmpty());
        String[] values1 = new String[]{"foo"};
        String[] valuesMany = new String[]{"foo", "bar", "foobar"};
        model.setProperty("IJSFFacetInstallDataModelProperties.SERVLET_URL_PATTERNS", (Object)values1);
        TestJSFUtils.assertEquals(Arrays.asList(values1), this._jsfUtils.getServletMappings_testable((IDataModel)model));
        model.setProperty("IJSFFacetInstallDataModelProperties.SERVLET_URL_PATTERNS", (Object)valuesMany);
        TestJSFUtils.assertEquals(Arrays.asList(valuesMany), this._jsfUtils.getServletMappings_testable((IDataModel)model));
    }

    public void testIsJSFPage() {
        TestJSFUtils.assertTrue((boolean)this._jsfUtils.isJSFPage_testable(null));
    }

    public void testIsValidKnownExtension() {
        TestJSFUtils.assertTrue((boolean)this._jsfUtils.isValidKnownExtension_testable("jsp"));
        TestJSFUtils.assertTrue((boolean)this._jsfUtils.isValidKnownExtension_testable("jspx"));
        TestJSFUtils.assertTrue((boolean)this._jsfUtils.isValidKnownExtension_testable("jsf"));
        TestJSFUtils.assertTrue((boolean)this._jsfUtils.isValidKnownExtension_testable("xhtml"));
        TestJSFUtils.assertFalse((boolean)this._jsfUtils.isValidKnownExtension_testable("html"));
        TestJSFUtils.assertFalse((boolean)this._jsfUtils.isValidKnownExtension_testable("dtd"));
        TestJSFUtils.assertFalse((boolean)this._jsfUtils.isValidKnownExtension_testable("jspf"));
        TestJSFUtils.assertFalse((boolean)this._jsfUtils.isValidKnownExtension_testable("php"));
        TestJSFUtils.assertFalse((boolean)this._jsfUtils.isValidKnownExtension_testable(""));
        TestJSFUtils.assertFalse((boolean)this._jsfUtils.isValidKnownExtension_testable(null));
    }

    protected final void verifyNull(Path existingURL, Object webApp, IResource res) {
        TestJSFUtils.assertNull((Object)this._jsfUtils.getFileUrlPath(webApp, res, null));
        TestJSFUtils.assertNull((Object)this._jsfUtils.getFileUrlPath(webApp, res, (IPath)existingURL));
    }

    protected final void verifyNull(Path existingURL, Object webApp) {
        this.verifyNull(existingURL, webApp, null);
    }

    protected abstract JSFVersion getVersionToTestIn();

    protected abstract WebAppAccessor createWebAccessor();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class WebAppAccessor {
        protected abstract Object createWebApp(String var1);

        protected abstract String getContextParamValue(Object var1, String var2);

        protected abstract List getContextParams(Object var1, String var2);

        protected abstract void verifyMapping(Object var1, String var2, String var3);

        protected abstract Object createServlet(String var1, String var2);

        protected abstract Object createServletMapping();

        protected abstract void setServletClass(Object var1, String var2);

        protected abstract List getServlets(Object var1);

        protected abstract void addMappingToWebApp(Object var1, Object var2);

        protected abstract void addServletToWebApp(Object var1, Object var2);

        protected abstract List getServletMappings_WebApp(Object var1);

        protected abstract List getServletMappings_Servlet(Object var1, Object var2);

        protected abstract void setMappingData(Object var1, List<String> var2, Object var3, Object var4);

        protected abstract void setUrlPattern(Object var1, List<String> var2);

        protected abstract Object createContextParam(String var1, String var2, String var3);

        protected abstract void setContextParam(Object var1, Object var2, String var3);

        protected abstract Object getServlet(Object var1, String var2);

        protected abstract void verifyServlet(Object var1, String var2);

        protected abstract void verifyLoadOnStartup(Object var1, Integer var2);

        protected abstract void setServletOnMapping(Object var1, Object var2);
    }
}

