/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.resource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jst.jsf.common.internal.resource.ClasspathEntryLifecycleListener;
import org.eclipse.jst.jsf.common.internal.resource.EventResult;
import org.eclipse.jst.jsf.common.internal.resource.IClasspathLifecycleListener;
import org.eclipse.jst.jsf.common.internal.resource.ILifecycleListener;
import org.eclipse.jst.jsf.core.tests.resource.AbstractTestListener;
import org.eclipse.jst.jsf.test.util.mock.java.MockJDTWorkspaceContext;
import org.junit.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClasspathTestListener
extends AbstractTestListener<IClasspathLifecycleListener.ClasspathLifecycleEvent>
implements IClasspathLifecycleListener {
    private final List<EventData> _events = new ArrayList<EventData>();
    private final MockJDTWorkspaceContext _jdtContext;

    public ClasspathTestListener(MockJDTWorkspaceContext jdtContext) {
        this._jdtContext = jdtContext;
    }

    public ClasspathTestListener(MockJDTWorkspaceContext jdtContext, ClasspathEntryLifecycleListener listener) {
        this(jdtContext);
        listener.addListener((ILifecycleListener)this);
    }

    public void fireAndExpect(ElementChangedEvent fire, List<EventData> expectedData) {
        this.fireEvent(fire);
        Assert.assertEquals((long)expectedData.size(), (long)this._events.size());
        for (EventData data : expectedData) {
            data.assertContainedIn(this._events);
        }
    }

    public void fireAndExpect(ElementChangedEvent fire, IJavaElement javaElement, IClasspathLifecycleListener.ClasspathLifecycleEvent.Type type) {
        this.fireAndExpect(fire, Collections.singletonList(new EventData(javaElement, type)));
    }

    public void fireAndExpectNull(ElementChangedEvent fire) {
        this.fireEvent(fire);
        Assert.assertTrue((boolean)this._events.isEmpty());
    }

    protected void fireEvent(ElementChangedEvent event) {
        this._events.clear();
        this._jdtContext.fireElementChangedEvent(event);
    }

    @Override
    public EventResult acceptEvent(IClasspathLifecycleListener.ClasspathLifecycleEvent event) {
        this._events.add(new EventData(event));
        return EventResult.getDefaultEventResult();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EventData {
        private final IJavaElement _affectedElement;
        private final IClasspathLifecycleListener.ClasspathLifecycleEvent.Type _type;

        public EventData(IJavaElement affectedElement, IClasspathLifecycleListener.ClasspathLifecycleEvent.Type type) {
            this._affectedElement = affectedElement;
            this._type = type;
        }

        public EventData(IClasspathLifecycleListener.ClasspathLifecycleEvent event) {
            this(event.getAffectedElement(), event.getType());
        }

        public void assertContainedIn(List<EventData> events) {
            for (EventData event : events) {
                if (!this.isEqual(event)) continue;
                return;
            }
            junit.framework.Assert.fail((String)("Event not found in list: " + this.toString()));
        }

        public boolean isEqual(EventData eventData) {
            return this._affectedElement.equals(eventData._affectedElement) && this._type == eventData._type;
        }

        public String toString() {
            return String.format("Classpath Entry: %s", this._affectedElement.toString());
        }
    }
}

