/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.resource;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jst.jsf.common.internal.resource.EventResult;
import org.eclipse.jst.jsf.common.internal.resource.IResourceLifecycleListener;
import org.eclipse.jst.jsf.common.internal.resource.ResourceLifecycleEvent;
import org.eclipse.jst.jsf.core.tests.resource.TestLifecycleListener;

class MockListener
implements IResourceLifecycleListener {
    private List<ResourceLifecycleEvent> _acceptedEvents = new ArrayList<ResourceLifecycleEvent>();

    MockListener() {
    }

    public EventResult acceptEvent(ResourceLifecycleEvent event) {
        this._acceptedEvents.add(event);
        return new EventResult();
    }

    public void assertAcceptedResourceInaccessible(IResource res, ResourceLifecycleEvent.ReasonType reason) {
        this.assertAcceptedEvent(res, ResourceLifecycleEvent.EventType.RESOURCE_INACCESSIBLE, reason);
    }

    public void assertNoAcceptedResourceInaccessible(IResource res, ResourceLifecycleEvent.ReasonType reason) {
        this.assertNoAcceptedEvent(res, ResourceLifecycleEvent.EventType.RESOURCE_INACCESSIBLE, reason);
    }

    public void assertNoAcceptedEvent(IResource res, ResourceLifecycleEvent.EventType eventType, ResourceLifecycleEvent.ReasonType reason) {
        for (ResourceLifecycleEvent event : this._acceptedEvents) {
            if (event.getEventType() != eventType || !event.getAffectedResource().equals((Object)res) || reason != event.getReasonType()) continue;
            TestLifecycleListener.fail((String)("Expected not to find RESOURCE_INACCESSIBLE event for resource: " + res.toString()));
        }
    }

    public void assertAcceptedEvent(IResource res, ResourceLifecycleEvent.EventType eventType, ResourceLifecycleEvent.ReasonType reason) {
        for (ResourceLifecycleEvent event : this._acceptedEvents) {
            if (event.getEventType() != eventType || event.getReasonType() != reason || !event.getAffectedResource().equals((Object)res)) continue;
            if (reason == event.getReasonType()) {
                return;
            }
            System.out.printf("Expected event found with different result: %s instead of %s", event.getReasonType().toString(), reason.toString());
        }
        TestLifecycleListener.fail((String)("Expected to find" + eventType + " event, reason " + reason + " for resource: " + res.toString()));
    }
}

