/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.resource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.jst.jsf.common.internal.resource.EventResult;
import org.eclipse.jst.jsf.common.internal.resource.ILifecycleListener;
import org.eclipse.jst.jsf.common.internal.resource.IResourceLifecycleListener;
import org.eclipse.jst.jsf.common.internal.resource.LifecycleListener;
import org.eclipse.jst.jsf.common.internal.resource.ResourceLifecycleEvent;
import org.eclipse.jst.jsf.core.tests.resource.AbstractTestListener;
import org.eclipse.jst.jsf.test.util.mock.MockWorkspaceContext;
import org.junit.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MyTestListener
extends AbstractTestListener<ResourceLifecycleEvent>
implements IResourceLifecycleListener {
    private final List<EventData> _events = new ArrayList<EventData>();
    private final MockWorkspaceContext _wsContext;

    public MyTestListener(MockWorkspaceContext wsContext) {
        this._wsContext = wsContext;
    }

    public MyTestListener(MockWorkspaceContext wsContext, LifecycleListener listener) {
        listener.addListener((ILifecycleListener)this);
        this._wsContext = wsContext;
    }

    @Override
    public EventResult acceptEvent(ResourceLifecycleEvent event) {
        this._events.add(new EventData(event));
        return EventResult.getDefaultEventResult();
    }

    public void fireAndExpect(IResourceChangeEvent fire, List<EventData> expectedData) {
        this.fireEvent(fire);
        Assert.assertEquals((long)expectedData.size(), (long)this._events.size());
        for (EventData data : expectedData) {
            data.assertContainedIn(this._events);
        }
    }

    public void fireAndExpect(IResourceChangeEvent fire, IResource expectedResource, ResourceLifecycleEvent.EventType eventType, ResourceLifecycleEvent.ReasonType reasonType) {
        this.fireAndExpect(fire, Collections.singletonList(new EventData(expectedResource, eventType, reasonType)));
    }

    public void fireAndExpectNull(IResourceChangeEvent fire) {
        this.fireEvent(fire);
        Assert.assertTrue((boolean)this._events.isEmpty());
    }

    protected void fireEvent(IResourceChangeEvent event) {
        this._events.clear();
        this._wsContext.fireWorkspaceEvent(event);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EventData {
        private final IResource _expectedResource;
        private final ResourceLifecycleEvent.EventType _eventType;
        private final ResourceLifecycleEvent.ReasonType _reasonType;

        public EventData(IResource expectedResource, ResourceLifecycleEvent.EventType eventType, ResourceLifecycleEvent.ReasonType reasonType) {
            this._expectedResource = expectedResource;
            this._eventType = eventType;
            this._reasonType = reasonType;
        }

        public EventData(ResourceLifecycleEvent event) {
            this(event.getAffectedResource(), event.getEventType(), event.getReasonType());
        }

        public final IResource getExpectedResource() {
            return this._expectedResource;
        }

        public final ResourceLifecycleEvent.EventType getEventType() {
            return this._eventType;
        }

        public final ResourceLifecycleEvent.ReasonType getReasonType() {
            return this._reasonType;
        }

        public void assertContainedIn(List<EventData> events) {
            for (EventData event : events) {
                if (!this.isEqual(event)) continue;
                return;
            }
            junit.framework.Assert.fail((String)("Event not found in list: " + this.toString()));
        }

        public boolean isEqual(EventData eventData) {
            return this._expectedResource.equals((Object)eventData.getExpectedResource()) && this._eventType == eventData.getEventType() && this._reasonType == eventData.getReasonType();
        }

        public String toString() {
            return String.format("Resource: %s, Event Type: %s, ReasonType: %s", this._expectedResource, this._eventType, this._reasonType);
        }
    }
}

