/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.util;

import java.util.zip.ZipFile;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.common.project.facet.core.JavaFacet;
import org.eclipse.jst.jsf.core.internal.tld.CMUtil;
import org.eclipse.jst.jsf.core.tests.TestsPlugin;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.CMDocumentFactoryTLD;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDDocument;
import org.eclipse.jst.jsp.core.taglib.ITaglibRecord;
import org.eclipse.jst.jsp.core.taglib.TaglibIndex;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.osgi.framework.Bundle;

public class TestCMUtil
extends TestCase {
    private WebProjectTestEnvironment _webProject;
    private IProject _project;

    protected void setUp() throws Exception {
        super.setUp();
        JSFTestUtil.setValidationEnabled((boolean)false);
        JSFTestUtil.setInternetProxyPreferences((boolean)true, (String)"www-proxy.uk.oracle.com", (String)"80");
        ZipFile zipFile = JSFTestUtil.createZipFile((Bundle)TestsPlugin.getDefault().getBundle(), (String)"/testfiles/testzips/TLDTests.zip");
        this._webProject = new WebProjectTestEnvironment((TestCase)this, JavaFacet.VERSION_1_5, ProjectFacetsManager.getProjectFacet((String)"jst.web").getVersion("2.4"));
        this._webProject.createFromZip(zipFile, true);
        TestCMUtil.assertNotNull((Object)this._webProject);
        this._project = this._webProject.getTestProject();
        TestCMUtil.assertNotNull((Object)this._project);
        TestCMUtil.assertTrue((boolean)this._project.isAccessible());
    }

    public void testGetURIFromDoc() {
        ITaglibRecord[] iTaglibRecordArray = TaglibIndex.getAvailableTaglibRecords((IPath)this._project.getFullPath());
        int n = iTaglibRecordArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITaglibRecord tldRec = iTaglibRecordArray[n2];
            if (tldRec.getDescriptor().getShortName().equals("tags")) {
                TestCMUtil.assertEquals((String)"/WEB-INF/tags", (String)CMUtil.getURIFromTaglibRecord((ITaglibRecord)tldRec, (IProject)this._project));
            } else if (tldRec.getDescriptor().getShortName().equals("moreTags")) {
                TestCMUtil.assertEquals((String)"/WEB-INF/tags/moreTags", (String)CMUtil.getURIFromTaglibRecord((ITaglibRecord)tldRec, (IProject)this._project));
            } else if (tldRec.getDescriptor().getShortName().equals("mysample")) {
                TestCMUtil.assertEquals((String)"/WEB-INF/SampleTagLib.tld", (String)CMUtil.getURIFromTaglibRecord((ITaglibRecord)tldRec, (IProject)this._project));
            } else if (tldRec.getDescriptor().getShortName().equals("XXXXmysample")) {
                TestCMUtil.assertEquals((String)"/WEB-INF/tlds/XXXXSampleTagLib.tld", (String)CMUtil.getURIFromTaglibRecord((ITaglibRecord)tldRec, (IProject)this._project));
            } else if (tldRec.getDescriptor().getShortName().equals("uri-supplied")) {
                TestCMUtil.assertEquals((String)"uri-supplied", (String)CMUtil.getURIFromTaglibRecord((ITaglibRecord)tldRec, (IProject)this._project));
            }
            ++n2;
        }
    }

    public void testGetURIFromTaglibRecord() {
        CMDocumentFactoryTLD factory = new CMDocumentFactoryTLD();
        ITaglibRecord[] iTaglibRecordArray = TaglibIndex.getAvailableTaglibRecords((IPath)this._project.getFullPath());
        int n = iTaglibRecordArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITaglibRecord tldRec = iTaglibRecordArray[n2];
            TLDDocument tldDoc = (TLDDocument)factory.createCMDocument(tldRec);
            if (tldRec.getDescriptor().getShortName().equals("tags")) {
                TestCMUtil.assertEquals((String)"/WEB-INF/tags", (String)CMUtil.getURIFromDoc((TLDDocument)tldDoc, (IProject)this._project));
            } else if (tldRec.getDescriptor().getShortName().equals("moreTags")) {
                TestCMUtil.assertEquals((String)"/WEB-INF/tags/moreTags", (String)CMUtil.getURIFromDoc((TLDDocument)tldDoc, (IProject)this._project));
            } else if (tldRec.getDescriptor().getShortName().equals("mysample")) {
                TestCMUtil.assertEquals((String)"/WEB-INF/SampleTagLib.tld", (String)CMUtil.getURIFromDoc((TLDDocument)tldDoc, (IProject)this._project));
            } else if (tldRec.getDescriptor().getShortName().equals("XXXXmysample")) {
                TestCMUtil.assertEquals((String)"/WEB-INF/tlds/XXXXSampleTagLib.tld", (String)CMUtil.getURIFromDoc((TLDDocument)tldDoc, (IProject)this._project));
            } else if (tldRec.getDescriptor().getShortName().equals("uri-supplied")) {
                TestCMUtil.assertEquals((String)"uri-supplied", (String)CMUtil.getURIFromDoc((TLDDocument)tldDoc, (IProject)this._project));
            }
            ++n2;
        }
    }

    public void testIsTagDirDocument() {
        CMDocumentFactoryTLD factory = new CMDocumentFactoryTLD();
        ITaglibRecord[] iTaglibRecordArray = TaglibIndex.getAvailableTaglibRecords((IPath)this._project.getFullPath());
        int n = iTaglibRecordArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITaglibRecord tldRec = iTaglibRecordArray[n2];
            TLDDocument tldDoc = (TLDDocument)factory.createCMDocument(tldRec);
            if (tldRec.getDescriptor().getShortName().equals("tags")) {
                TestCMUtil.assertTrue((boolean)CMUtil.isTagDirDocument((TLDDocument)tldDoc, (IProject)this._project));
            } else if (tldRec.getDescriptor().getShortName().equals("moreTags")) {
                TestCMUtil.assertTrue((boolean)CMUtil.isTagDirDocument((TLDDocument)tldDoc, (IProject)this._project));
            } else if (tldRec.getDescriptor().getShortName().equals("mysample")) {
                TestCMUtil.assertFalse((boolean)CMUtil.isTagDirDocument((TLDDocument)tldDoc, (IProject)this._project));
            } else if (tldRec.getDescriptor().getShortName().equals("XXXXmysample")) {
                TestCMUtil.assertFalse((boolean)CMUtil.isTagDirDocument((TLDDocument)tldDoc, (IProject)this._project));
            } else if (tldRec.getDescriptor().getShortName().equals("uri-supplied")) {
                TestCMUtil.assertFalse((boolean)CMUtil.isTagDirDocument((TLDDocument)tldDoc, (IProject)this._project));
            }
            ++n2;
        }
    }
}

