/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.tests;

import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IPublishListener;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerEvent;
import org.eclipse.wst.server.core.ServerPort;

public class ServerEventTestCase
extends TestCase {
    private static ServerEvent serverEvent;
    private static ServerEvent moduleEvent;
    private static int SAMPLE_KIND;
    private static IServer SAMPLE_SERVER;
    private static IModule[] SAMPLE_MODULE_TREE;
    private static int SAMPLE_STATE;
    private static int SAMPLE_PUBLISHING_STATE;
    private static boolean SAMPLE_RESTART_STATE;

    static {
        SAMPLE_KIND = 1;
        SAMPLE_SERVER = ServerEventTestCase.createSampleServer();
        SAMPLE_MODULE_TREE = new IModule[1];
        SAMPLE_STATE = 1;
        SAMPLE_PUBLISHING_STATE = 2;
        SAMPLE_RESTART_STATE = true;
    }

    public static IServer createSampleServer() {
        return new IServer(){

            public int getServerState() {
                return 0;
            }

            public String getMode() {
                return null;
            }

            public int getServerPublishState() {
                return 0;
            }

            public int getModulePublishState(IModule[] module) {
                return 0;
            }

            public void addServerListener(IServerListener listener) {
            }

            public void addServerListener(IServerListener listener, int eventMask) {
            }

            public void removeServerListener(IServerListener listener) {
            }

            public IStatus canPublish() {
                return null;
            }

            public IStatus publish(int kind, IProgressMonitor monitor) {
                return null;
            }

            public IStatus canStart(String launchMode) {
                return null;
            }

            public void start(String launchMode, IProgressMonitor monitor) throws CoreException {
            }

            public void start(String launchMode, IServer.IOperationListener listener) {
            }

            public void synchronousStart(String launchMode, IProgressMonitor monitor) throws CoreException {
            }

            public IStatus canRestart(String mode) {
                return null;
            }

            public boolean getServerRestartState() {
                return false;
            }

            public void restart(String mode, IProgressMonitor monitor) {
            }

            public void restart(String mode, IServer.IOperationListener listener) {
            }

            public void synchronousRestart(String launchMode, IProgressMonitor monitor) throws CoreException {
            }

            public IStatus canStop() {
                return null;
            }

            public void stop(boolean force) {
            }

            public void stop(boolean force, IServer.IOperationListener listener) {
            }

            public void synchronousStop(boolean force) {
            }

            public IStatus canControlModule(IModule[] module, IProgressMonitor monitor) {
                return null;
            }

            public boolean getModuleRestartState(IModule[] module) {
                return false;
            }

            public int getModuleState(IModule[] module) {
                return 0;
            }

            public String getName() {
                return null;
            }

            public String getId() {
                return null;
            }

            public void delete() throws CoreException {
            }

            public boolean isReadOnly() {
                return false;
            }

            public boolean isWorkingCopy() {
                return false;
            }

            public Object loadAdapter(Class c, IProgressMonitor monitor) {
                return null;
            }

            public String getHost() {
                return null;
            }

            public IRuntime getRuntime() {
                return null;
            }

            public IServerType getServerType() {
                return null;
            }

            public IFolder getServerConfiguration() {
                return null;
            }

            public IServerWorkingCopy createWorkingCopy() {
                return null;
            }

            public IModule[] getModules() {
                return null;
            }

            public IStatus canModifyModules(IModule[] add, IModule[] remove, IProgressMonitor monitor) {
                return null;
            }

            public IModule[] getChildModules(IModule[] module, IProgressMonitor monitor) {
                return null;
            }

            public IModule[] getRootModules(IModule module, IProgressMonitor monitor) throws CoreException {
                return null;
            }

            public ServerPort[] getServerPorts(IProgressMonitor monitor) {
                return null;
            }

            public Object getAdapter(Class adapter) {
                return null;
            }

            public void startModule(IModule[] module, IServer.IOperationListener listener) {
            }

            public void stopModule(IModule[] module, IServer.IOperationListener listener) {
            }

            public void restartModule(IModule[] module, IServer.IOperationListener listener) {
            }

            public void addPublishListener(IPublishListener listener) {
            }

            public void removePublishListener(IPublishListener listener) {
            }

            public boolean shouldPublish() {
                return false;
            }

            public boolean shouldRestart() {
                return false;
            }

            public ILaunchConfiguration getLaunchConfiguration(boolean create, IProgressMonitor monitor) throws CoreException {
                return null;
            }

            public ILaunch getLaunch() {
                return null;
            }

            public int getStartTimeout() {
                return 0;
            }

            public int getStopTimeout() {
                return 0;
            }

            public void publish(int kind, List<IModule[]> modules, IAdaptable info, IServer.IOperationListener listener) {
            }

            public boolean contains(ISchedulingRule rule) {
                return false;
            }

            public boolean isConflicting(ISchedulingRule rule) {
                return false;
            }

            public int getAttribute(String attributeName, int defaultValue) {
                return 0;
            }

            public boolean getAttribute(String attributeName, boolean defaultValue) {
                return false;
            }

            public String getAttribute(String attributeName, String defaultValue) {
                return null;
            }

            public List<String> getAttribute(String attributeName, List<String> defaultValue) {
                return null;
            }

            public Map getAttribute(String attributeName, Map defaultValue) {
                return null;
            }

            public IStatus canRestartModule(IModule[] module, IProgressMonitor monitor) {
                return null;
            }

            public IStatus canPublishModule(IModule[] module, IProgressMonitor monitor) {
                return null;
            }
        };
    }

    protected ServerEvent getSampleServerEvent() {
        if (serverEvent == null) {
            serverEvent = new ServerEvent(SAMPLE_KIND, SAMPLE_SERVER, SAMPLE_STATE, SAMPLE_PUBLISHING_STATE, SAMPLE_RESTART_STATE);
        }
        return serverEvent;
    }

    protected ServerEvent getSampleModuleEvent() {
        if (moduleEvent == null) {
            moduleEvent = new ServerEvent(SAMPLE_KIND, SAMPLE_SERVER, SAMPLE_MODULE_TREE, SAMPLE_STATE, SAMPLE_PUBLISHING_STATE, SAMPLE_RESTART_STATE);
        }
        return moduleEvent;
    }

    public void testServerGetKind() {
        ServerEventTestCase.assertTrue(((this.getSampleServerEvent().getKind() & (0x10 | SAMPLE_KIND)) != 0 ? 1 : 0) != 0);
    }

    public void testServerGetPublishingState() {
        ServerEventTestCase.assertEquals((int)SAMPLE_PUBLISHING_STATE, (int)this.getSampleServerEvent().getPublishState());
    }

    public void testServerGetRestartState() {
        ServerEventTestCase.assertEquals((boolean)SAMPLE_RESTART_STATE, (boolean)this.getSampleServerEvent().getRestartState());
    }

    public void testServerGetServer() {
        ServerEventTestCase.assertEquals((Object)SAMPLE_SERVER, (Object)this.getSampleServerEvent().getServer());
    }

    public void testServerGetState() {
        ServerEventTestCase.assertEquals((int)SAMPLE_STATE, (int)this.getSampleServerEvent().getState());
    }

    public void testModuleGetKind() {
        ServerEventTestCase.assertTrue(((this.getSampleModuleEvent().getKind() & (0x20 | SAMPLE_KIND)) != 0 ? 1 : 0) != 0);
    }

    public void testModuleGetModuleTree() {
        try {
            ServerEventTestCase.assertEquals((Object)SAMPLE_MODULE_TREE, (Object)this.getSampleModuleEvent().getModule());
        }
        catch (Exception exception) {}
    }

    public void testModuleGetPublishingState() {
        ServerEventTestCase.assertEquals((int)SAMPLE_PUBLISHING_STATE, (int)this.getSampleModuleEvent().getPublishState());
    }

    public void testModuleGetRestartState() {
        ServerEventTestCase.assertEquals((boolean)SAMPLE_RESTART_STATE, (boolean)this.getSampleModuleEvent().getRestartState());
    }

    public void testModuleGetServer() {
        ServerEventTestCase.assertEquals((Object)SAMPLE_SERVER, (Object)this.getSampleModuleEvent().getServer());
    }

    public void testModuleGetState() {
        ServerEventTestCase.assertEquals((int)SAMPLE_STATE, (int)this.getSampleModuleEvent().getState());
    }
}

