/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.tests;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.ant.core.AntRunner;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.jem.tests.JavaTestsPlugin;
import org.osgi.framework.Bundle;

public class JavaProjectUtil {
    static int cfSuffix = 0;

    public static IProject getProject(String projectName) throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        return project.exists() ? project : null;
    }

    public static IProject createProject(IWorkspace workspace, IPath projectPath, IProgressMonitor pm) throws CoreException {
        IProjectDescription newDescription = null;
        File projectFile = new File(projectPath.toFile(), ".project");
        if (!projectFile.exists()) {
            throw new CoreException((IStatus)new Status(4, JavaTestsPlugin.getPlugin().getBundle().getSymbolicName(), 0, "Project file not in project directory. Couldn't create project \"" + projectPath.toString() + "\"", null));
        }
        Path projectFilePath = new Path(projectFile.getPath());
        newDescription = workspace.loadProjectDescription((IPath)projectFilePath);
        final IProject project = workspace.getRoot().getProject(newDescription.getName());
        final IProjectDescription description = newDescription;
        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                project.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                project.open((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            }
        }, (ISchedulingRule)project, 0, pm);
        return project;
    }

    public static IProject createEmptyJavaProject(IWorkspace workspace, IPath projectPath, IProgressMonitor pm) throws CoreException {
        projectPath = workspace.getRoot().getFullPath().append(projectPath);
        File projectFile = new File(projectPath.toFile(), ".project");
        if (projectFile.exists()) {
            return JavaProjectUtil.createProject(workspace, projectPath, pm);
        }
        final IProject project = workspace.getRoot().getProject(projectPath.lastSegment());
        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                project.create((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                project.open((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                IProjectDescription description = project.getDescription();
                String[] natureids = description.getNatureIds();
                int i = 0;
                while (i < natureids.length) {
                    if (natureids[i].equals("org.eclipse.jdt.core.javanature")) {
                        return;
                    }
                    ++i;
                }
                String[] newNatureids = new String[natureids.length + 1];
                newNatureids[0] = "org.eclipse.jdt.core.javanature";
                System.arraycopy(natureids, 0, newNatureids, 1, natureids.length);
                description.setNatureIds(newNatureids);
                project.setDescription(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                IFolder sf = project.getFolder("src");
                sf.create(true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                IFolder bf = project.getFolder("bin");
                bf.create(true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                IFile cp = project.getFile(".classpath");
                try {
                    cp.create(this.getClass().getResource(".classpath").openStream(), true, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }, (ISchedulingRule)workspace.getRoot(), 0, pm);
        return project;
    }

    public static void deleteProject(IProject project) throws CoreException {
        if (project != null) {
            project.delete(true, false, null);
        }
    }

    public static boolean setAutoBuild(boolean autoBuild) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (autoBuild != workspace.isAutoBuilding()) {
            IWorkspaceDescription description = workspace.getDescription();
            description.setAutoBuilding(true);
            workspace.setDescription(description);
            return !autoBuild;
        }
        return autoBuild;
    }

    public static IProject[] importProjects(final String[] projectNames, final String[] zipFiles) throws CoreException {
        final IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IProject[] result = new IProject[projectNames.length];
        workspace.run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IPath rootLocation = workspace.getRoot().getLocation();
                try {
                    String antFile = FileLocator.toFileURL((URL)JavaTestsPlugin.getPlugin().getBundle().getEntry("testdata/unzip.xml")).getFile();
                    int i = 0;
                    while (i < zipFiles.length) {
                        IProject p = JavaProjectUtil.getProject(projectNames[i]);
                        if (p != null) {
                            p.delete(true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                        }
                        AntRunner ant = new AntRunner();
                        ant.setBuildFileLocation(antFile);
                        ant.setArguments(new String[]{"-Dzipfrom=" + zipFiles[i], "-Dzipto=" + rootLocation.toString()});
                        ant.run((IProgressMonitor)new SubProgressMonitor(monitor, 50));
                        ++i;
                    }
                    i = 0;
                    while (i < zipFiles.length) {
                        result[i] = JavaProjectUtil.createProject(workspace, rootLocation.append(projectNames[i]), (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                        ++i;
                    }
                }
                catch (MalformedURLException malformedURLException) {
                }
                catch (IOException iOException) {}
            }
        }, (ISchedulingRule)workspace.getRoot(), 0, null);
        return result;
    }

    public static void addBundleJarToPath(Bundle bundle, String pathToJar, IJavaProject project, IProgressMonitor pm) throws CoreException {
        Path actualPath = new Path(ProxyPlugin.getPlugin().localizeFromBundleAndFragments(bundle, pathToJar));
        if (actualPath.isEmpty()) {
            return;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.run(new IWorkspaceRunnable((IPath)actualPath, project){
            private final /* synthetic */ IPath val$actualPath;
            private final /* synthetic */ IJavaProject val$project;
            {
                this.val$actualPath = iPath;
                this.val$project = iJavaProject;
            }

            public void run(IProgressMonitor monitor) throws CoreException {
                if (this.val$actualPath.toFile().isFile()) {
                    IClasspathEntry[] raw = this.val$project.getRawClasspath();
                    IClasspathEntry[] newRaw = new IClasspathEntry[raw.length + 1];
                    newRaw[raw.length] = JavaCore.newLibraryEntry((IPath)this.val$actualPath, null, null);
                    System.arraycopy(raw, 0, newRaw, 0, raw.length);
                    this.val$project.setRawClasspath(newRaw, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                } else {
                    IFolder cf = this.val$project.getProject().getFolder("linkbin" + ++cfSuffix);
                    cf.createLink(this.val$actualPath, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                    IClasspathEntry[] raw = this.val$project.getRawClasspath();
                    IClasspathEntry[] newRaw = new IClasspathEntry[raw.length + 1];
                    newRaw[raw.length] = JavaCore.newLibraryEntry((IPath)cf.getFullPath(), null, null);
                    System.arraycopy(raw, 0, newRaw, 0, raw.length);
                    this.val$project.setRawClasspath(newRaw, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                }
            }
        }, (ISchedulingRule)workspace.getRoot(), 0, pm);
    }

    public static void waitForAutoBuild() throws CoreException {
        IJobManager jobManager = Job.getJobManager();
        if (jobManager.find(ResourcesPlugin.FAMILY_AUTO_BUILD).length > 0) {
            while (true) {
                try {
                    jobManager.join(ResourcesPlugin.FAMILY_AUTO_BUILD, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

