/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.tests.modelListeners;

import java.util.Collections;
import java.util.List;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jem.internal.adapters.jdom.JavaJDOMAdapterFactory;
import org.eclipse.jem.internal.adapters.jdom.JavaReflectionSynchronizer;
import org.eclipse.jem.tests.modelListeners.IListenerTester;

public class TestJavaJDOMAdapterFactory
extends JavaJDOMAdapterFactory
implements IListenerTester {
    int callIndex = -1;
    AssertionFailedError exception;
    protected int[] callTypes;
    protected Object[] callArgs;
    public static final int FLUSH_ALL = 0;
    public static final int FLUSH_ALL_NO_NOTIFICATION = 1;
    public static final int FLUSH_PACKAGE = 2;
    public static final int FLUSH_PACKAGE_NO_NOTIFICATION = 3;
    public static final int FLUSH_REFLECTION = 4;
    public static final int FLUSH_REFLECTION_NO_NOTIFICATION = 5;
    public static final int FLUSH_REFLECTION_PLUS_INNER_NO_NOTIFICATION = 6;
    public static final int NOTIFY_CONTENT_CHANGED = 7;
    public static final int DISASSOCIATE_SOURCE_NOTIFY = 8;
    public static final int DISASSOCIATE_SOURCE = 9;
    public static final int DISASSOCIATE_SOURCE_PLUS_INNER_NOTIFY = 10;
    public static final int DISASSOCIATE_SOURCE_PLUS_INNER = 11;
    private static final String[] callTypeNames = new String[]{"FLUSH_ALL", "FLUSH_ALL_NO_NOTIFICATION", "FLUSH_PACKAGE", "FLUSH_PACKAGE_NO_NOTIFICATION", "FLUSH_REFLECTION", "FLUSH_REFLECTION_NO_NOTIFICATION", "FLUSH_REFLECTION_PLUS_INNER_NO_NOTIFICATION", "NOTIFY_CONTENT_CHANGED", "DISASSOCIATE_SOURCE_NOTIFY", "DISASSOCIATE_SOURCE", "DISASSOCIATE_SOURCE_PLUS_INNER_NOTIFY", "DISASSOCIATE_SOURCE_PLUS_INNER"};

    public void setTestCases(int[] callTypes, Object[] callArgs) {
        this.callTypes = callTypes;
        this.callArgs = callArgs;
    }

    public void isException() throws AssertionFailedError {
        if (this.exception != null) {
            throw this.exception;
        }
    }

    public void isComplete() throws AssertionFailedError {
        Assert.assertEquals((String)"Did not complete all notifcations. ", (int)this.callTypes.length, (int)(this.callIndex + 1));
    }

    protected boolean testCallType(int callType) {
        if (this.exception != null) {
            return false;
        }
        try {
            if (++this.callIndex >= this.callTypes.length) {
                Assert.fail((String)("An extra notification of type " + callTypeNames[callType] + " received."));
            }
            if (this.callTypes[this.callIndex] != callType) {
                Assert.assertEquals((String)callTypeNames[this.callTypes[this.callIndex]], (String)callTypeNames[callType]);
            }
        }
        catch (AssertionFailedError e) {
            this.exception = e;
            return false;
        }
        return true;
    }

    public void flushAll() {
        this.testCallType(0);
    }

    public List flushAllNoNotification() {
        this.testCallType(1);
        return Collections.EMPTY_LIST;
    }

    public void flushPackage(String packageName, boolean noFlushIfSourceFound) {
        if (this.testCallType(2)) {
            try {
                Assert.assertEquals((String)((String)((Object[])this.callArgs[this.callIndex])[0]), (String)packageName);
                Assert.assertEquals((boolean)((Boolean)((Object[])this.callArgs[this.callIndex])[1]), (boolean)noFlushIfSourceFound);
            }
            catch (AssertionFailedError e) {
                this.exception = e;
            }
        }
    }

    public List flushPackageNoNotification(String packageName, boolean noFlushIfSourceFound) {
        if (this.testCallType(3)) {
            try {
                Assert.assertEquals((String)((String)((Object[])this.callArgs[this.callIndex])[0]), (String)packageName);
                Assert.assertEquals((boolean)((Boolean)((Object[])this.callArgs[this.callIndex])[1]), (boolean)noFlushIfSourceFound);
            }
            catch (AssertionFailedError e) {
                this.exception = e;
            }
        }
        return Collections.EMPTY_LIST;
    }

    public void flushReflection(String source) {
        if (this.testCallType(4)) {
            try {
                Assert.assertEquals((String)((String)this.callArgs[this.callIndex]), (String)source);
            }
            catch (AssertionFailedError e) {
                this.exception = e;
            }
        }
    }

    public Notification flushReflectionNoNotification(String source) {
        if (this.testCallType(5)) {
            try {
                Assert.assertEquals((String)((String)this.callArgs[this.callIndex]), (String)source);
            }
            catch (AssertionFailedError e) {
                this.exception = e;
            }
        }
        return null;
    }

    public Notification flushReflectionPlusInnerNoNotification(String source) {
        if (this.testCallType(6)) {
            try {
                Assert.assertEquals((String)((String)this.callArgs[this.callIndex]), (String)source);
            }
            catch (AssertionFailedError e) {
                this.exception = e;
            }
        }
        return null;
    }

    public void notifyContentChanged(ICompilationUnit targetCU) {
        if (this.testCallType(7)) {
            try {
                Assert.assertEquals((String)((String)this.callArgs[this.callIndex]), (String)targetCU.getElementName());
            }
            catch (AssertionFailedError e) {
                this.exception = e;
            }
        }
    }

    public Notification disAssociateSource(String source, boolean doNotify) {
        if (this.testCallType(8)) {
            try {
                Assert.assertEquals((String)((String)((Object[])this.callArgs[this.callIndex])[0]), (String)source);
                Assert.assertEquals((boolean)((Boolean)((Object[])this.callArgs[this.callIndex])[1]), (boolean)doNotify);
            }
            catch (AssertionFailedError e) {
                this.exception = e;
            }
        }
        return null;
    }

    public Notification disAssociateSource(String source) {
        if (this.testCallType(9)) {
            try {
                Assert.assertEquals((String)((String)this.callArgs[this.callIndex]), (String)source);
            }
            catch (AssertionFailedError e) {
                this.exception = e;
            }
        }
        return null;
    }

    public Notification disAssociateSourcePlusInner(String source, boolean doNotify) {
        if (this.testCallType(10)) {
            try {
                Assert.assertEquals((String)((String)((Object[])this.callArgs[this.callIndex])[0]), (String)source);
                Assert.assertEquals((boolean)((Boolean)((Object[])this.callArgs[this.callIndex])[1]), (boolean)doNotify);
            }
            catch (AssertionFailedError e) {
                this.exception = e;
            }
        }
        return null;
    }

    public void disAssociateSourcePlusInner(String source) {
        if (this.testCallType(11)) {
            try {
                Assert.assertEquals((String)((String)this.callArgs[this.callIndex]), (String)source);
            }
            catch (AssertionFailedError e) {
                this.exception = e;
            }
        }
    }

    public JavaReflectionSynchronizer getSynchronizer() {
        return this.synchronizer;
    }
}

