/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.tests.proxy;

import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.ICallback;

public class TestCallbackStream
implements ICallback {
    Object tester;
    private boolean testStopped;
    private String badMsg;
    private IOException exp;
    private boolean testSuccesful;

    public TestCallbackStream(Object o) {
        this.tester = o;
    }

    public void testComplete() throws IOException {
        if (this.badMsg != null) {
            TestCase.fail((String)this.badMsg);
        }
        if (this.exp != null) {
            throw this.exp;
        }
        TestCase.assertTrue((boolean)this.testSuccesful);
    }

    public Object calledBack(int msgID, Object parm) {
        this.badMsg = "Failed Callback Test. Shouldn't have gotton to object parm";
        this.stopTest();
        return null;
    }

    public Object calledBack(int msgID, IBeanProxy parm) {
        this.badMsg = "Failed Callback Test. Shouldn't have gotton to parm";
        this.stopTest();
        return null;
    }

    public Object calledBack(int msgID, Object[] parms) {
        this.badMsg = "Failed Callback Test. Shouldn't have gotton to multi-parms";
        this.stopTest();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calledBackStream(int msgID, InputStream in) {
        Object object = this.tester;
        synchronized (object) {
            if (this.testStopped) {
                return;
            }
        }
        int i = 0;
        while (i < 30000) {
            try {
                int next = in.read();
                if (next == -1) {
                    this.badMsg = "Failed Callback Stream test. Stream ended too soon. On counter=" + String.valueOf(i);
                    this.stopTest();
                    return;
                }
                if ((byte)next != (byte)i) {
                    this.badMsg = "Failed Callback Stream test. Did not get correct next byte at:" + i;
                    this.stopTest();
                    return;
                }
            }
            catch (IOException e) {
                this.exp = e;
                this.stopTest();
                return;
            }
            ++i;
        }
        try {
            if (in.read() != -1) {
                this.badMsg = "Failed Callback Stream test. Too much data sent.";
                this.stopTest();
                return;
            }
        }
        catch (IOException e) {
            this.exp = e;
        }
        this.testSuccesful = true;
        this.stopTest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopTest() {
        Object object = this.tester;
        synchronized (object) {
            this.testStopped = true;
            this.tester.notify();
        }
    }
}

