/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.tests.tagcreator;

import org.eclipse.core.resources.IFile;
import org.eclipse.jst.jsf.common.dom.TagIdentifier;
import org.eclipse.jst.jsf.core.internal.ITagRegistryFactoryProvider;
import org.eclipse.jst.jsf.core.internal.tld.IJSFConstants;
import org.eclipse.jst.jsf.core.tests.util.JSFCoreUtilHelper;
import org.eclipse.jst.pagedesigner.itemcreation.CreationData;
import org.eclipse.jst.pagedesigner.itemcreation.ITagCreator;
import org.eclipse.jst.pagedesigner.itemcreation.ITagDropOverrider;
import org.eclipse.jst.pagedesigner.itemcreation.customizer.CustomizationDataImpl;
import org.eclipse.jst.pagedesigner.itemcreation.customizer.ICustomizationData;
import org.eclipse.jst.pagedesigner.tests.PageDesignerTestsPlugin;
import org.eclipse.jst.pagedesigner.tests.tagcreator.BaseUserCustomizedTagCreatorTestCase;
import org.eclipse.wst.xml.core.internal.document.ElementImpl;
import org.w3c.dom.Element;

public class TestOverrideableCreationData
extends BaseUserCustomizedTagCreatorTestCase {
    private final String OVERRIDDEN_TAGNAME = "fooTag";
    private final String OVERRIDDEN_TAGURI = "http://com.foo.bar/fooey";
    private final String OVERRIDDEN_DEFAULT_PREFIX = "fooey";
    private boolean DO_TAGNAME_OVERRIDE = true;
    private boolean DO_TAGURI_OVERRIDE = true;
    private boolean DO_DEFAULT_PREFIX_OVERRIDE = true;

    public void testOverriddenCreationData() throws Exception {
        Verification v = new Verification("fooTag", "http://com.foo.bar/fooey", "fooey", "fooTag", "fooey");
        this.reset();
        this.doCreateTestOverridden(IJSFConstants.TAG_IDENTIFIER_COMMANDBUTTON, "jsp", "jsp", 358, false, this.getCustomizationData(), v);
        this.doCreateTestOverridden(IJSFConstants.TAG_IDENTIFIER_COMMANDBUTTON, "jspx", "jspx", 495, false, this.getCustomizationData(), v);
        JSFCoreUtilHelper.injectTestTagRegistryFactoryProvider((ITagRegistryFactoryProvider)JSFCoreUtilHelper.createSimpleRegistryFactory());
        this.doCreateTestOverridden(IJSFConstants.TAG_IDENTIFIER_COMMANDBUTTON, "xhtml", "xhtml", 350, false, this.getCustomizationData(), v);
        JSFCoreUtilHelper.injectTestTagRegistryFactoryProvider(null);
    }

    public void testNullTagNameOverride() throws Exception {
        this.reset();
        this.DO_TAGNAME_OVERRIDE = false;
        Verification v = new Verification(IJSFConstants.TAG_IDENTIFIER_COMMANDBUTTON.getTagName(), "http://com.foo.bar/fooey", "fooey", IJSFConstants.TAG_IDENTIFIER_COMMANDBUTTON.getTagName(), "fooey");
        this.doCreateTestOverridden(IJSFConstants.TAG_IDENTIFIER_COMMANDBUTTON, "jsp", "jsp", 358, false, this.getCustomizationData(), v);
    }

    public void testNullTagUriOverride() throws Exception {
        this.reset();
        this.DO_TAGURI_OVERRIDE = false;
        Verification v = new Verification("fooTag", IJSFConstants.TAG_IDENTIFIER_COMMANDBUTTON.getUri(), "fooey", "fooTag", "h");
        this.doCreateTestOverridden(IJSFConstants.TAG_IDENTIFIER_COMMANDBUTTON, "jspx", "jspx", 495, false, this.getCustomizationData(), v);
    }

    public void testNullDefaultPrefixOverride() throws Exception {
        this.reset();
        this.DO_DEFAULT_PREFIX_OVERRIDE = false;
        Verification v = new Verification("fooTag", "http://com.foo.bar/fooey", "h", "fooTag", "h");
        JSFCoreUtilHelper.injectTestTagRegistryFactoryProvider((ITagRegistryFactoryProvider)JSFCoreUtilHelper.createSimpleRegistryFactory());
        this.doCreateTestOverridden(IJSFConstants.TAG_IDENTIFIER_COMMANDBUTTON, "xhtml", "xhtml", 350, false, this.getCustomizationData(), v);
        JSFCoreUtilHelper.injectTestTagRegistryFactoryProvider(null);
    }

    private void reset() {
        this.DO_TAGNAME_OVERRIDE = true;
        this.DO_TAGURI_OVERRIDE = true;
        this.DO_DEFAULT_PREFIX_OVERRIDE = true;
    }

    private void doCreateTestOverridden(TagIdentifier tagId, String inExt, String outExt, int offset, boolean forceResultTagEmpty, ICustomizationData customizationData, Verification v) throws Exception {
        String uri = tagId.getUri();
        String tagName = tagId.getTagName();
        IFile file = (IFile)this._webProjectTestEnv.loadResourceInWebRoot(PageDesignerTestsPlugin.getDefault().getBundle(), "/testdata/tagcreator/tagCreator." + inExt + ".data", "/tagCreator_" + tagName + "." + inExt);
        this.setTagIdentifier(tagId);
        ITagCreator tagCreator = this.getTagCreator(this.getTagIdentifier());
        CreationData creationData = this.getCreationData(uri, tagName, this._defaultPrefix, file, offset, customizationData);
        Element element = tagCreator.createTag(creationData);
        if (forceResultTagEmpty && element instanceof ElementImpl) {
            this.forceTagEmpty((ElementImpl)element);
        }
        v.verify(creationData, element);
    }

    protected ICustomizationData getCustomizationData() {
        CustomizationDataImpl data = new CustomizationDataImpl(this.getTagIdentifier()){

            public Object getAdapter(Class adapter) {
                if (ITagDropOverrider.class == adapter) {
                    return TestOverrideableCreationData.this.getCustomizationAdapter();
                }
                return super.getAdapter(adapter);
            }
        };
        data.addAttribute("attr1", "value1");
        return data;
    }

    private ITagDropOverrider getCustomizationAdapter() {
        return new ITagDropOverrider(){

            public String getTagNameOverride() {
                if (TestOverrideableCreationData.this.DO_TAGNAME_OVERRIDE) {
                    return "fooTag";
                }
                return null;
            }

            public String getUriOverride() {
                if (TestOverrideableCreationData.this.DO_TAGURI_OVERRIDE) {
                    return "http://com.foo.bar/fooey";
                }
                return null;
            }

            public String getDefaultPrefixOverride() {
                if (TestOverrideableCreationData.this.DO_DEFAULT_PREFIX_OVERRIDE) {
                    return "fooey";
                }
                return null;
            }
        };
    }

    private class Verification {
        private String _expectedTagName;
        private String _expectedTagUri;
        private String _expectedDefaultPrefix;
        private String _expectedElementLocalName;
        private String _expectedElementPrefix;

        public Verification(String expectedTagName, String expectedTagUri, String expectedDefaultPrefix, String expectedElementLocalName, String expectedElementPrefix) {
            this._expectedTagName = expectedTagName;
            this._expectedTagUri = expectedTagUri;
            this._expectedDefaultPrefix = expectedDefaultPrefix;
            this._expectedElementLocalName = expectedElementLocalName;
            this._expectedElementPrefix = expectedElementPrefix;
        }

        public void verify(CreationData creationData, Element element) throws Exception {
            TestOverrideableCreationData.assertEquals((String)this._expectedTagName, (String)creationData.getTagName());
            TestOverrideableCreationData.assertEquals((String)this._expectedTagUri, (String)creationData.getUri());
            TestOverrideableCreationData.assertEquals((String)this._expectedDefaultPrefix, (String)creationData.getDefaultPrefix());
            TestOverrideableCreationData.assertEquals((String)this._expectedElementLocalName, (String)element.getLocalName());
            TestOverrideableCreationData.assertEquals((String)this._expectedElementPrefix, (String)element.getPrefix());
        }
    }
}

