/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.metadata.tests.taglibprocessing;

import org.eclipse.jst.jsf.common.internal.types.CompositeType;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.jst.jsf.metadata.tests.util.SingleJSPTestCase;
import org.eclipse.jst.jsf.metadataprocessors.features.IPossibleValues;
import org.eclipse.jst.jsf.metadataprocessors.features.IValidELValues;
import org.eclipse.jst.jsf.metadataprocessors.features.IValidValues;
import org.eclipse.jst.jsf.metadataprocessors.features.IValidationMessage;

public class ActionTypeTests
extends SingleJSPTestCase {
    private final String tagName = "commandButton";
    private final String attrName = "action";

    public ActionTypeTests() {
        super("/testfiles/jsps/actionTypeTest.jsp.data/", "/actionTypeTest.jsp", JSFVersion.V1_1, "/testfiles/web/faces-config_1_1.xml.data");
    }

    public void testGetPossibleValues() {
        IPossibleValues pv = (IPossibleValues)this.getProcessor(IPossibleValues.class, "http://java.sun.com/jsf/html", "commandButton", "action");
        ActionTypeTests.assertNotNull((Object)pv);
        ActionTypeTests.assertEquals((int)2, (int)pv.getPossibleValues().size());
        this.assertPossibleValues(pv.getPossibleValues(), new String[]{"gotoWelcome", "gotoSomeplaceElse"});
    }

    public void testIsValidValue() {
        IValidValues vv = (IValidValues)this.getProcessor(IValidValues.class, "http://java.sun.com/jsf/html", "commandButton", "action");
        ActionTypeTests.assertNotNull((Object)vv);
        ActionTypeTests.assertTrue((boolean)vv.isValidValue("gotoWelcome"));
        ActionTypeTests.assertTrue((boolean)vv.isValidValue("gotoSomeplaceElse"));
        ActionTypeTests.assertFalse((boolean)vv.isValidValue("gotoSomeplace"));
        ActionTypeTests.assertEquals((int)1, (int)vv.getValidationMessages().size());
        IValidationMessage msg = (IValidationMessage)vv.getValidationMessages().get(0);
        ActionTypeTests.assertEquals((int)2, (int)msg.getSeverity());
        ActionTypeTests.assertEquals((String)"The action value does not match a navigation case outcome.", (String)msg.getMessage());
        vv.getValidationMessages().clear();
        ActionTypeTests.assertFalse((boolean)vv.isValidValue(""));
        msg = (IValidationMessage)vv.getValidationMessages().get(0);
        ActionTypeTests.assertEquals((int)2, (int)msg.getSeverity());
        ActionTypeTests.assertEquals((String)"The action attribute must be a non-zero length String or a method binding matching a navigation case outcome.", (String)msg.getMessage());
    }

    public void testGetExpectedRuntimeType() {
        IValidELValues vv = (IValidELValues)this.getProcessor(IValidELValues.class, "http://java.sun.com/jsf/html", "commandButton", "action");
        ActionTypeTests.assertNotNull((Object)vv);
        try {
            ActionTypeTests.assertNotNull((Object)vv.getExpectedRuntimeType());
            ActionTypeTests.assertTrue((boolean)(vv.getExpectedRuntimeType() instanceof CompositeType));
        }
        catch (Exception exception) {}
    }
}

