/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.tests.encoding.jsp;

import java.io.IOException;
import java.io.Reader;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.eclipse.jst.jsp.core.internal.contenttype.HeadParserToken;
import org.eclipse.jst.jsp.core.internal.contenttype.JSPHeadTokenizer;
import org.eclipse.jst.jsp.tests.encoding.JSPEncodingTestsPlugin;
import org.eclipse.wst.sse.core.utils.StringUtils;

public class JSPHeadTokenizerTester
extends TestCase {
    private boolean DEBUG = false;
    private String fCharset;
    private String fContentType;
    private String fContentTypeValue;
    private final String fileDir = "jsp/";
    private final String fileHome = "testfiles/";
    private final String fileLocation = "testfiles/jsp/";
    private String fPageEncodingValue = null;
    private String fXMLDecEncodingName;
    private String fLanguage;

    private void doTestFile(String filename, String expectedName) throws Exception {
        this.doTestFile(filename, expectedName, null, null);
    }

    private void doTestFile(String filename, String expectedName, String finalTokenType, String expectedContentType) throws Exception {
        JSPHeadTokenizer tokenizer = null;
        Reader fileReader = null;
        try {
            if (this.DEBUG) {
                System.out.println();
                System.out.println("       " + filename);
                System.out.println();
            }
            fileReader = JSPEncodingTestsPlugin.getTestReader(filename);
            tokenizer = new JSPHeadTokenizer(fileReader);
        }
        catch (IOException iOException) {
            System.out.println("Error opening file \"" + filename + "\"");
        }
        HeadParserToken token = this.parseHeader(tokenizer);
        String resultValue = this.getAppropriateEncoding();
        fileReader.close();
        if (finalTokenType != null) {
            JSPHeadTokenizerTester.assertTrue((String)("did not end as expected. found:  " + token.getType()), (boolean)finalTokenType.equals(token.getType()));
        }
        if (expectedName == null) {
            JSPHeadTokenizerTester.assertTrue((String)("expected no encoding, but found: " + resultValue), (resultValue == null ? 1 : 0) != 0);
        } else {
            JSPHeadTokenizerTester.assertTrue((String)("expected " + expectedName + " but found " + resultValue), (boolean)expectedName.equals(resultValue));
        }
        String foundContentType = this.getContentType();
        if (expectedContentType == null) {
            JSPHeadTokenizerTester.assertTrue((String)("expected no contentType, but found: " + foundContentType), (foundContentType == null ? 1 : 0) != 0);
        } else {
            JSPHeadTokenizerTester.assertTrue((String)("expected " + expectedContentType + " but found " + foundContentType), (boolean)expectedContentType.equals(foundContentType));
        }
    }

    public void testNormalNonDefault() throws Exception {
        String filename = "testfiles/jsp/NormalNonDefault.jsp";
        this.doTestFile(filename, "ISO-8859-8");
    }

    private String getAppropriateEncoding() {
        String result = null;
        if (this.fXMLDecEncodingName != null) {
            result = this.fXMLDecEncodingName;
        } else if (this.fPageEncodingValue != null) {
            result = this.fPageEncodingValue;
        } else if (this.fCharset != null) {
            result = this.fCharset;
        }
        return result;
    }

    private String getContentType() {
        return this.fContentType;
    }

    private boolean isLegalString(String tokenType) {
        boolean result = false;
        if (tokenType != null) {
            result = tokenType.equals("strval") || tokenType.equals("UnDelimitedStringValue") || tokenType.equals("InvalidTerminatedStringValue") || tokenType.equals("InvalidTermintatedUnDelimitedStringValue");
        }
        return result;
    }

    private void parseContentTypeValue(String contentType) {
        String cleanContentTypeValue = StringUtils.stripNonLetterDigits((String)contentType);
        StringTokenizer tokenizer = new StringTokenizer(cleanContentTypeValue, ";");
        int tLen = tokenizer.countTokens();
        if (tLen == 0) {
            return;
        }
        String[] tokens = new String[tLen];
        int j = 0;
        while (tokenizer.hasMoreTokens()) {
            tokens[j] = tokenizer.nextToken();
            ++j;
        }
        int firstParameter = 0;
        if (tokens[0].indexOf(61) == -1) {
            this.fContentType = tokens[0].trim();
            firstParameter = 1;
        }
        Pattern equalPattern = Pattern.compile("\\s*=\\s*");
        int i = firstParameter;
        while (i < tokens.length) {
            String[] pair = equalPattern.split(tokens[i]);
            if (pair.length >= 2 && pair[0].trim().equals("charset")) {
                this.fCharset = pair[1].trim();
            }
            ++i;
        }
    }

    private HeadParserToken parseHeader(JSPHeadTokenizer tokenizer) throws Exception {
        this.fPageEncodingValue = null;
        this.fCharset = null;
        this.fContentType = null;
        HeadParserToken token = null;
        HeadParserToken finalToken = null;
        do {
            HeadParserToken valueToken;
            String valueTokenType;
            String tokenType;
            if (this.canHandleAsUnicodeStream(tokenType = (token = tokenizer.getNextToken()).getType())) continue;
            if (tokenType == "XMLDelEncoding") {
                if (!tokenizer.hasMoreTokens() || !this.isLegalString(valueTokenType = (valueToken = tokenizer.getNextToken()).getType())) continue;
                this.fXMLDecEncodingName = valueToken.getText();
                continue;
            }
            if (tokenType == "PageEncoding") {
                if (!tokenizer.hasMoreTokens() || !this.isLegalString(valueTokenType = (valueToken = tokenizer.getNextToken()).getType())) continue;
                this.fPageEncodingValue = valueToken.getText();
                continue;
            }
            if (tokenType == "PageContentType") {
                if (!tokenizer.hasMoreTokens() || !this.isLegalString(valueTokenType = (valueToken = tokenizer.getNextToken()).getType())) continue;
                this.fContentTypeValue = valueToken.getText();
                continue;
            }
            if (tokenType != "PageLanguage" || !tokenizer.hasMoreTokens() || !this.isLegalString(valueTokenType = (valueToken = tokenizer.getNextToken()).getType())) continue;
            this.fLanguage = valueToken.getText();
        } while (tokenizer.hasMoreTokens());
        if (this.fContentTypeValue != null) {
            this.parseContentTypeValue(this.fContentTypeValue);
        }
        finalToken = token;
        return finalToken;
    }

    private boolean canHandleAsUnicodeStream(String tokenType) {
        boolean canHandleAsUnicode = false;
        if (tokenType == "UTF83ByteBOM") {
            canHandleAsUnicode = true;
            this.fCharset = "UTF-8";
        } else if (tokenType == "UTF16BE" || tokenType == "UTF16LE") {
            canHandleAsUnicode = true;
            this.fCharset = "UTF-16";
        }
        return canHandleAsUnicode;
    }

    public void testBestCase() throws Exception {
        String filename = "testfiles/jsp/nomalDirectiveCase.jsp";
        this.doTestFile(filename, "ISO-8859-2", null, "text/html");
    }

    public void testMinimalPageDirective() throws Exception {
        String filename = "testfiles/jsp/minimalPageDirective.jsp";
        this.doTestFile(filename, null, null, "text/html");
    }

    public void testIllFormed() throws Exception {
        String filename = "testfiles/jsp/testIllFormed.jsp";
        this.doTestFile(filename, null);
    }

    public void testIllFormed2() throws Exception {
        String filename = "testfiles/jsp/testIllFormed2.jsp";
        this.doTestFile(filename, "UTF-8");
    }

    public void testIllformedNormalNonDefault() throws Exception {
        String filename = "testfiles/jsp/IllformedNormalNonDefault.jsp";
        this.doTestFile(filename, "ISO-8859-8", null, "text/html");
    }

    public void testEmptyFile() throws Exception {
        String filename = "testfiles/jsp/EmptyFile.jsp";
        this.doTestFile(filename, null);
    }

    public void testNomalDirectiveCaseUsingXMLSyntax() throws Exception {
        String filename = "testfiles/jsp/nomalDirectiveCaseUsingXMLSyntax.jsp";
        this.doTestFile(filename, "ISO-8859-2", null, "text/html");
    }

    public void testNoPageDirective() throws Exception {
        String filename = "testfiles/jsp/testNoPageDirective.jsp";
        this.doTestFile(filename, null);
    }

    public void testNormalPageDirectiveWithXMLDecl() throws Exception {
        String filename = "testfiles/jsp/nomalDirectiveCasewithXMLDecl.jsp";
        this.doTestFile(filename, "ISO-8859-1", null, "text/html");
    }

    public void testNoPageDirectiveAtFirst() throws Exception {
        String filename = "testfiles/jsp/testNoPageDirectiveAtFirst.jsp";
        this.doTestFile(filename, "ISO-8859-2", null, "text/html");
    }

    public void testNoPageDirectiveInLargeFile() throws Exception {
        String filename = "testfiles/jsp/testNoPageDirectiveInLargeFile.jsp";
        this.doTestFile(filename, null, "MAX_CHARS_REACHED", null);
    }

    public void testNormalCaseWithNeither() throws Exception {
        String filename = "testfiles/jsp/nomalDirectiveCaseNoEncoding.jsp";
        this.doTestFile(filename, null);
    }

    public void testNormalCharset() throws Exception {
        String filename = "testfiles/jsp/nomalDirectiveCaseUsingCharset.jsp";
        this.doTestFile(filename, "ISO-8859-3", null, "text/html");
    }

    public void testUTF16le() throws Exception {
        String filename = "testfiles/jsp/utf16le.jsp";
        this.doTestFile(filename, "UTF-16LE", null, "text/html");
    }

    public void testUTF16be() throws Exception {
        String filename = "testfiles/jsp/utf16be.jsp";
        this.doTestFile(filename, "UTF-16BE", null, "text/html");
    }

    public void testUTF16BOM() throws Exception {
    }

    public void testUTF16leXmlStyle() throws Exception {
        String filename = "testfiles/jsp/utf16le_xmlStyle.jsp";
        this.doTestFile(filename, "UTF-16LE", null, null);
    }

    public String getLanguage() {
        return this.fLanguage;
    }
}

