package oracle.adfdemo.view.faces;

import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.event.ActionEvent;
import oracle.adf.view.faces.component.core.output.CoreOutputText;

public class ReorderTest
{
  public void setPanel(UIComponent panel)
  {
    _panel = panel;
  }

  public UIComponent getPanel()
  {
    return _panel;
  }

  public void add(ActionEvent event)
  {
    List children = _panel.getChildren();
    CoreOutputText output = new CoreOutputText();
    output.setValue("Item " + (children.size() + 1));
    children.add(0, output);
  }

  public void remove(ActionEvent event)
  {
    List children = _panel.getChildren();
    children.remove(children.size() - 1);
  }

  public void removeFirst(ActionEvent event)
  {
    List children = _panel.getChildren();
    children.remove(0);
  }

  public void rotate(ActionEvent event)
  {
    List children = _panel.getChildren();
    Object o = children.get(0);
    children.remove(0);
    children.add(o);
  }

  public void removeSeparator(ActionEvent event)
  {
    _panel.getFacets().remove("separator");
  }

  public void setSeparator(ActionEvent event)
  {
    CoreOutputText output = new CoreOutputText();
    output.setValue("New Separator");
    _panel.getFacets().put("separator", output);
  }
  
  private UIComponent _panel;
}