/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.context.orm;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.eclipselink.core.tests.internal.context.orm.EclipseLinkOrmContextModelTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class EclipseLinkOrmTransientMappingTests
extends EclipseLinkOrmContextModelTestCase {
    public EclipseLinkOrmTransientMappingTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestEntityWithTransientMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Transient"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Transient").append(CR);
            }
        });
    }

    public void testCreateTransientMapping() throws Exception {
        this.createTestEntityWithTransientMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute persistentAttribute = ormPersistentType.getAttributeNamed("id");
        EclipseLinkOrmTransientMappingTests.assertTrue((boolean)persistentAttribute.isVirtual());
        EclipseLinkOrmTransientMappingTests.assertEquals((String)"transient", (String)persistentAttribute.getMappingKey());
        ormPersistentType.addSpecifiedAttribute("transient", "id");
        persistentAttribute = ormPersistentType.getAttributeNamed("id");
        EclipseLinkOrmTransientMappingTests.assertFalse((boolean)persistentAttribute.isVirtual());
        EclipseLinkOrmTransientMappingTests.assertEquals((String)"transient", (String)persistentAttribute.getMappingKey());
        EclipseLinkOrmTransientMappingTests.assertEquals((String)"transient", (String)persistentAttribute.getSpecifiedMapping().getKey());
    }
}

