/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.eclipselink.core.resource.java.EclipseLinkCustomizerAnnotation;
import org.eclipse.jpt.eclipselink.core.tests.internal.resource.java.EclipseLinkJavaResourceModelTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class CustomizerAnnotationTests
extends EclipseLinkJavaResourceModelTestCase {
    public CustomizerAnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestCustomizer() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.annotations.Customizer"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Customizer");
            }
        });
    }

    private ICompilationUnit createTestCustomizerWithValue() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.annotations.Customizer"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Customizer(Foo.class)");
            }
        });
    }

    public void testCustomizerAnnotation() throws Exception {
        ICompilationUnit cu = this.createTestCustomizer();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        CustomizerAnnotationTests.assertNotNull((Object)typeResource.getAnnotation("org.eclipse.persistence.annotations.Customizer"));
        typeResource.removeAnnotation("org.eclipse.persistence.annotations.Customizer");
        CustomizerAnnotationTests.assertNull((Object)typeResource.getAnnotation("org.eclipse.persistence.annotations.Customizer"));
        typeResource.addAnnotation("org.eclipse.persistence.annotations.Customizer");
        CustomizerAnnotationTests.assertNotNull((Object)typeResource.getAnnotation("org.eclipse.persistence.annotations.Customizer"));
    }

    public void testGetConverterClass() throws Exception {
        ICompilationUnit cu = this.createTestCustomizerWithValue();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        EclipseLinkCustomizerAnnotation converter = (EclipseLinkCustomizerAnnotation)typeResource.getAnnotation("org.eclipse.persistence.annotations.Customizer");
        CustomizerAnnotationTests.assertEquals((String)"Foo", (String)converter.getValue());
    }

    public void testSetConverterClass() throws Exception {
        ICompilationUnit cu = this.createTestCustomizerWithValue();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        EclipseLinkCustomizerAnnotation converter = (EclipseLinkCustomizerAnnotation)typeResource.getAnnotation("org.eclipse.persistence.annotations.Customizer");
        CustomizerAnnotationTests.assertEquals((String)"Foo", (String)converter.getValue());
        converter.setValue("Bar");
        CustomizerAnnotationTests.assertEquals((String)"Bar", (String)converter.getValue());
        this.assertSourceContains("@Customizer(Bar.class)", cu);
    }

    public void testSetConverterClassNull() throws Exception {
        ICompilationUnit cu = this.createTestCustomizerWithValue();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        EclipseLinkCustomizerAnnotation converter = (EclipseLinkCustomizerAnnotation)typeResource.getAnnotation("org.eclipse.persistence.annotations.Customizer");
        CustomizerAnnotationTests.assertEquals((String)"Foo", (String)converter.getValue());
        converter.setValue(null);
        CustomizerAnnotationTests.assertNull((Object)converter.getValue());
        this.assertSourceContains("@Customizer", cu);
        this.assertSourceDoesNotContain("Foo.class", cu);
    }
}

