/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink2_0.core.tests.internal.context.orm;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.MappingKeys;
import org.eclipse.jpt.core.context.BasicMapping;
import org.eclipse.jpt.core.context.CollectionMapping;
import org.eclipse.jpt.core.context.Column;
import org.eclipse.jpt.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.core.context.EmbeddedMapping;
import org.eclipse.jpt.core.context.FetchType;
import org.eclipse.jpt.core.context.IdMapping;
import org.eclipse.jpt.core.context.ManyToManyMapping;
import org.eclipse.jpt.core.context.ManyToOneMapping;
import org.eclipse.jpt.core.context.OneToManyMapping;
import org.eclipse.jpt.core.context.TransientMapping;
import org.eclipse.jpt.core.context.VersionMapping;
import org.eclipse.jpt.core.context.java.JavaAttributeOverride;
import org.eclipse.jpt.core.context.java.JavaBasicMapping;
import org.eclipse.jpt.core.context.java.JavaColumn;
import org.eclipse.jpt.core.context.orm.OrmAttributeOverride;
import org.eclipse.jpt.core.context.orm.OrmAttributeOverrideContainer;
import org.eclipse.jpt.core.context.orm.OrmColumn;
import org.eclipse.jpt.core.context.orm.OrmEntity;
import org.eclipse.jpt.core.context.orm.OrmOneToManyMapping;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.jpa2.context.ElementCollectionMapping2_0;
import org.eclipse.jpt.core.jpa2.context.OrderColumn2_0;
import org.eclipse.jpt.core.jpa2.context.Orderable2_0;
import org.eclipse.jpt.core.jpa2.context.java.JavaElementCollectionMapping2_0;
import org.eclipse.jpt.core.jpa2.context.orm.OrmElementCollectionMapping2_0;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlAttributeOverride;
import org.eclipse.jpt.core.resource.orm.XmlElementCollection;
import org.eclipse.jpt.core.resource.orm.XmlEntity;
import org.eclipse.jpt.core.resource.orm.XmlOneToMany;
import org.eclipse.jpt.core.resource.orm.v2_0.XmlElementCollection_2_0;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.eclipselink2_0.core.tests.internal.context.orm.EclipseLink2_0OrmContextModelTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class EclipseLink2_0OrmElementCollectionMappingTests
extends EclipseLink2_0OrmContextModelTestCase {
    private static final String ATTRIBUTE_OVERRIDE_NAME = "city";
    private static final String ATTRIBUTE_OVERRIDE_COLUMN_NAME = "E_CITY";

    public EclipseLink2_0OrmElementCollectionMappingTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestEntityWithElementCollectionMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ElementCollection", "javax.persistence.FetchType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ElementCollection(targetClass=String.class, fetch=FetchType.EAGER)");
                sb.append(CR);
                sb.append("    private java.util.Collection<Address> address;").append(CR);
                sb.append(CR);
                sb.append("    @Id");
            }
        });
    }

    private void createTestTargetEmbeddableAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    private State state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private ICompilationUnit createTestEntityWithEmbeddableElementCollectionMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ElementCollection", "javax.persistence.FetchType", "javax.persistence.AttributeOverride", "javax.persistence.Column"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ElementCollection");
                sb.append(CR);
                sb.append("    @AttributeOverride(name=\"city\", column=@Column(name=\"E_CITY\"))");
                sb.append("    private java.util.Collection<Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id");
            }
        });
    }

    private ICompilationUnit createTestEntityWithNonGenericElementCollectionMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ElementCollection", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ElementCollection").append(CR);
                sb.append("    private java.util.Collection addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithGenericBasicElementCollectionMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ElementCollection", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ElementCollection").append(CR);
                sb.append("    private java.util.Collection<String> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithValidMapElementCollectionMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ElementCollection", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ElementCollection").append(CR);
                sb.append("    private java.util.Map<String, Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private void createTestEmbeddableState() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("State").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String name;").append(CR);
                sb.append(CR);
                sb.append("    private String abbr;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "State.java", sourceWriter);
    }

    private ICompilationUnit createTestEntityWithValidNonGenericMapElementCollectionMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ElementCollection", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ElementCollection").append(CR);
                sb.append("    private java.util.Map addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private void createSelfReferentialElementCollection() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.ElementCollection");
                sb.append(";");
                sb.append(CR).append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("Foo").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @ElementCollection").append(CR);
                sb.append("    private java.util.List<Foo> elementCollection;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Foo.java", sourceWriter);
    }

    public void testUpdateName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("elementCollection", "oneToOneMapping");
        OrmElementCollectionMapping2_0 ormElementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        XmlElementCollection elementCollection = (XmlElementCollection)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getElementCollections().get(0);
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"oneToOneMapping", (String)ormElementCollectionMapping.getName());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"oneToOneMapping", (String)elementCollection.getName());
        elementCollection.setName("newName");
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"newName", (String)ormElementCollectionMapping.getName());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"newName", (String)elementCollection.getName());
        elementCollection.setName(null);
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)ormElementCollectionMapping.getName());
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)elementCollection.getName());
    }

    public void testModifyName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("elementCollection", "oneToOneMapping");
        OrmElementCollectionMapping2_0 ormElementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        XmlElementCollection elementCollection = (XmlElementCollection)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getElementCollections().get(0);
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"oneToOneMapping", (String)ormElementCollectionMapping.getName());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"oneToOneMapping", (String)elementCollection.getName());
        ormElementCollectionMapping.setName("newName");
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"newName", (String)ormElementCollectionMapping.getName());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"newName", (String)elementCollection.getName());
        ormElementCollectionMapping.setName(null);
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)ormElementCollectionMapping.getName());
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)elementCollection.getName());
    }

    public void testMappingNoUnderylingJavaAttribute() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("embeddable", "test.Address");
        ormPersistentType.addSpecifiedAttribute("elementCollection", "foo");
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((int)3, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        OrmElementCollectionMapping2_0 ormElementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"foo", (String)ormElementCollectionMapping.getName());
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)ormElementCollectionMapping.getSpecifiedFetch());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((Object)FetchType.LAZY, (Object)ormElementCollectionMapping.getFetch());
    }

    public void testVirtualMappingMetadataCompleteFalse() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("embeddable", "test.Address");
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((int)3, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        OrmElementCollectionMapping2_0 ormElementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"address", (String)ormElementCollectionMapping.getName());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((Object)FetchType.EAGER, (Object)ormElementCollectionMapping.getSpecifiedFetch());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"java.lang.String", (String)ormElementCollectionMapping.getSpecifiedTargetClass());
        ormPersistentAttribute.makeSpecified();
        ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        ormElementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"address", (String)ormElementCollectionMapping.getName());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals(null, (Object)ormElementCollectionMapping.getSpecifiedFetch());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((Object)FetchType.LAZY, (Object)ormElementCollectionMapping.getDefaultFetch());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals(null, (String)ormElementCollectionMapping.getSpecifiedTargetClass());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"test.Address", (String)ormElementCollectionMapping.getDefaultTargetClass());
    }

    public void testVirtualMappingMetadataCompleteTrue() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("embeddable", "test.Address");
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((int)3, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("address");
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY, (String)ormPersistentAttribute.getMappingKey());
        ormPersistentAttribute.makeSpecified("elementCollection");
        ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        OrmElementCollectionMapping2_0 ormElementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"address", (String)ormElementCollectionMapping.getName());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((Object)FetchType.LAZY, (Object)ormElementCollectionMapping.getFetch());
    }

    public void testSpecifiedMapping() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("embeddable", "test.Address");
        ormPersistentType.addSpecifiedAttribute("elementCollection", "address");
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((int)2, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        OrmElementCollectionMapping2_0 ormElementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"address", (String)ormElementCollectionMapping.getName());
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)ormElementCollectionMapping.getSpecifiedFetch());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((Object)FetchType.LAZY, (Object)ormElementCollectionMapping.getFetch());
    }

    public void testMorphToIdMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("elementCollection", "oneToOne");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        EclipseLink2_0OrmElementCollectionMappingTests.assertFalse((boolean)elementCollectionMapping.isDefault());
        elementCollectionMapping.setSpecifiedFetch(FetchType.EAGER);
        EclipseLink2_0OrmElementCollectionMappingTests.assertFalse((boolean)elementCollectionMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("id");
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        EclipseLink2_0OrmElementCollectionMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof IdMapping));
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"oneToOne", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testMorphToVersionMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("elementCollection", "oneToOne");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        EclipseLink2_0OrmElementCollectionMappingTests.assertFalse((boolean)elementCollectionMapping.isDefault());
        elementCollectionMapping.setSpecifiedFetch(FetchType.EAGER);
        EclipseLink2_0OrmElementCollectionMappingTests.assertFalse((boolean)elementCollectionMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("version");
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        EclipseLink2_0OrmElementCollectionMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof VersionMapping));
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"oneToOne", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testMorphToTransientMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("elementCollection", "oneToOne");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        EclipseLink2_0OrmElementCollectionMappingTests.assertFalse((boolean)elementCollectionMapping.isDefault());
        elementCollectionMapping.setSpecifiedFetch(FetchType.EAGER);
        EclipseLink2_0OrmElementCollectionMappingTests.assertFalse((boolean)elementCollectionMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("transient");
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        EclipseLink2_0OrmElementCollectionMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof TransientMapping));
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"oneToOne", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testMorphToEmbeddedMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("elementCollection", "oneToOne");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        EclipseLink2_0OrmElementCollectionMappingTests.assertFalse((boolean)elementCollectionMapping.isDefault());
        elementCollectionMapping.setSpecifiedFetch(FetchType.EAGER);
        EclipseLink2_0OrmElementCollectionMappingTests.assertFalse((boolean)elementCollectionMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("embedded");
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        EclipseLink2_0OrmElementCollectionMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof EmbeddedMapping));
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"oneToOne", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testMorphToEmbeddedIdMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("elementCollection", "oneToOne");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        EclipseLink2_0OrmElementCollectionMappingTests.assertFalse((boolean)elementCollectionMapping.isDefault());
        elementCollectionMapping.setSpecifiedFetch(FetchType.EAGER);
        EclipseLink2_0OrmElementCollectionMappingTests.assertFalse((boolean)elementCollectionMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("embeddedId");
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        EclipseLink2_0OrmElementCollectionMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof EmbeddedIdMapping));
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"oneToOne", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testMorphToManyToManyMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("elementCollection", "oneToOne");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        EclipseLink2_0OrmElementCollectionMappingTests.assertFalse((boolean)elementCollectionMapping.isDefault());
        elementCollectionMapping.setSpecifiedFetch(FetchType.EAGER);
        EclipseLink2_0OrmElementCollectionMappingTests.assertFalse((boolean)elementCollectionMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("manyToMany");
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        EclipseLink2_0OrmElementCollectionMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof ManyToManyMapping));
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"oneToOne", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testMorphToOneToManyMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("elementCollection", "oneToOne");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        EclipseLink2_0OrmElementCollectionMappingTests.assertFalse((boolean)elementCollectionMapping.isDefault());
        elementCollectionMapping.setSpecifiedFetch(FetchType.EAGER);
        EclipseLink2_0OrmElementCollectionMappingTests.assertFalse((boolean)elementCollectionMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("oneToMany");
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        EclipseLink2_0OrmElementCollectionMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof OneToManyMapping));
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"oneToOne", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testMorphToManyToOneMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("elementCollection", "oneToOne");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        EclipseLink2_0OrmElementCollectionMappingTests.assertFalse((boolean)elementCollectionMapping.isDefault());
        elementCollectionMapping.setSpecifiedFetch(FetchType.EAGER);
        EclipseLink2_0OrmElementCollectionMappingTests.assertFalse((boolean)elementCollectionMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("manyToOne");
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        EclipseLink2_0OrmElementCollectionMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof ManyToOneMapping));
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"oneToOne", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testMorphToBasicMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("elementCollection", "oneToOne");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        EclipseLink2_0OrmElementCollectionMappingTests.assertFalse((boolean)elementCollectionMapping.isDefault());
        elementCollectionMapping.setSpecifiedFetch(FetchType.EAGER);
        EclipseLink2_0OrmElementCollectionMappingTests.assertFalse((boolean)elementCollectionMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("basic");
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        EclipseLink2_0OrmElementCollectionMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof BasicMapping));
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"oneToOne", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testUpdateSpecifiedFetch() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("elementCollection", "oneToOneMapping");
        OrmElementCollectionMapping2_0 ormElementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        XmlElementCollection elementCollection = (XmlElementCollection)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getElementCollections().get(0);
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)ormElementCollectionMapping.getSpecifiedFetch());
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)elementCollection.getFetch());
        elementCollection.setFetch(org.eclipse.jpt.core.resource.orm.FetchType.EAGER);
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((Object)FetchType.EAGER, (Object)ormElementCollectionMapping.getSpecifiedFetch());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.FetchType.EAGER, (Object)elementCollection.getFetch());
        elementCollection.setFetch(org.eclipse.jpt.core.resource.orm.FetchType.LAZY);
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((Object)FetchType.LAZY, (Object)ormElementCollectionMapping.getSpecifiedFetch());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.FetchType.LAZY, (Object)elementCollection.getFetch());
        elementCollection.setFetch(null);
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)ormElementCollectionMapping.getSpecifiedFetch());
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)elementCollection.getFetch());
    }

    public void testModifySpecifiedFetch() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("elementCollection", "oneToOneMapping");
        OrmElementCollectionMapping2_0 ormElementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        XmlElementCollection elementCollection = (XmlElementCollection)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getElementCollections().get(0);
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)ormElementCollectionMapping.getSpecifiedFetch());
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)elementCollection.getFetch());
        ormElementCollectionMapping.setSpecifiedFetch(FetchType.EAGER);
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.FetchType.EAGER, (Object)elementCollection.getFetch());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((Object)FetchType.EAGER, (Object)ormElementCollectionMapping.getSpecifiedFetch());
        ormElementCollectionMapping.setSpecifiedFetch(FetchType.LAZY);
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.FetchType.LAZY, (Object)elementCollection.getFetch());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((Object)FetchType.LAZY, (Object)ormElementCollectionMapping.getSpecifiedFetch());
        ormElementCollectionMapping.setSpecifiedFetch(null);
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)elementCollection.getFetch());
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)ormElementCollectionMapping.getSpecifiedFetch());
    }

    public void testUpdateSpecifiedTargetClass() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("elementCollection", "elementCollectionMapping");
        OrmElementCollectionMapping2_0 ormElementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        XmlElementCollection_2_0 elementCollection = (XmlElementCollection_2_0)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getElementCollections().get(0);
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)ormElementCollectionMapping.getSpecifiedTargetClass());
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)elementCollection.getTargetClass());
        elementCollection.setTargetClass("newTargetClass");
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"newTargetClass", (String)ormElementCollectionMapping.getSpecifiedTargetClass());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"newTargetClass", (String)elementCollection.getTargetClass());
        elementCollection.setTargetClass(null);
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)ormElementCollectionMapping.getSpecifiedTargetClass());
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)elementCollection.getTargetClass());
    }

    public void testModifySpecifiedTargetClass() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("elementCollection", "elementCollectionMapping");
        OrmElementCollectionMapping2_0 ormElementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        XmlElementCollection_2_0 elementCollection = (XmlElementCollection_2_0)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getElementCollections().get(0);
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)ormElementCollectionMapping.getSpecifiedTargetClass());
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)elementCollection.getTargetClass());
        ormElementCollectionMapping.setSpecifiedTargetClass("newTargetClass");
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"newTargetClass", (String)ormElementCollectionMapping.getSpecifiedTargetClass());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"newTargetClass", (String)elementCollection.getTargetClass());
        ormElementCollectionMapping.setSpecifiedTargetClass(null);
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)ormElementCollectionMapping.getSpecifiedTargetClass());
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)elementCollection.getTargetClass());
    }

    public void testGetValueTypeEmbeddable() throws Exception {
        this.createTestEntityWithEmbeddableElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("embeddable", "test.Address");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("elementCollection", "addresses");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((Object)CollectionMapping.Type.EMBEDDABLE_TYPE, (Object)elementCollectionMapping.getValueType());
    }

    public void testGetValueTypeEntity() throws Exception {
        this.createTestEntityWithEmbeddableElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("elementCollection", "addresses");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((Object)CollectionMapping.Type.BASIC_TYPE, (Object)elementCollectionMapping.getValueType());
    }

    public void testGetValueTypeNone() throws Exception {
        this.createTestEntityWithNonGenericElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("embeddable", "test.Address");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("elementCollection", "addresses");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((Object)CollectionMapping.Type.NO_TYPE, (Object)elementCollectionMapping.getValueType());
        elementCollectionMapping.setSpecifiedTargetClass("test.Address");
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((Object)CollectionMapping.Type.EMBEDDABLE_TYPE, (Object)elementCollectionMapping.getValueType());
    }

    public void testGetValueTypeBasic() throws Exception {
        this.createTestEntityWithGenericBasicElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("elementCollection", "addresses");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((Object)CollectionMapping.Type.BASIC_TYPE, (Object)elementCollectionMapping.getValueType());
    }

    public void testUpdateMapKey() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToMany", "oneToManyMapping");
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        XmlOneToMany oneToMany = (XmlOneToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)ormOneToManyMapping.getSpecifiedMapKey());
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)oneToMany.getMapKey());
        oneToMany.setMapKey(OrmFactory.eINSTANCE.createMapKey());
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)ormOneToManyMapping.getSpecifiedMapKey());
        EclipseLink2_0OrmElementCollectionMappingTests.assertNotNull((Object)oneToMany.getMapKey());
        oneToMany.getMapKey().setName("myMapKey");
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"myMapKey", (String)ormOneToManyMapping.getSpecifiedMapKey());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"myMapKey", (String)oneToMany.getMapKey().getName());
        oneToMany.getMapKey().setName(null);
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)ormOneToManyMapping.getSpecifiedMapKey());
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)oneToMany.getMapKey().getName());
        oneToMany.getMapKey().setName("myMapKey");
        oneToMany.setMapKey(null);
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)ormOneToManyMapping.getSpecifiedMapKey());
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)oneToMany.getMapKey());
    }

    public void testUpdateVirtualMapKey() throws Exception {
        this.createTestEntityWithValidMapElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("embeddable", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        OrmElementCollectionMapping2_0 ormElementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentType.getAttributeNamed("addresses").getMapping();
        JavaElementCollectionMapping2_0 javaElementCollectionMapping = (JavaElementCollectionMapping2_0)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)ormElementCollectionMapping.getSpecifiedMapKey());
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)ormElementCollectionMapping.getMapKey());
        EclipseLink2_0OrmElementCollectionMappingTests.assertFalse((boolean)ormElementCollectionMapping.isPkMapKey());
        EclipseLink2_0OrmElementCollectionMappingTests.assertFalse((boolean)ormElementCollectionMapping.isCustomMapKey());
        EclipseLink2_0OrmElementCollectionMappingTests.assertTrue((boolean)ormElementCollectionMapping.isNoMapKey());
        javaElementCollectionMapping.setPkMapKey(true);
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals(null, (String)ormElementCollectionMapping.getMapKey());
        EclipseLink2_0OrmElementCollectionMappingTests.assertTrue((boolean)ormElementCollectionMapping.isPkMapKey());
        EclipseLink2_0OrmElementCollectionMappingTests.assertFalse((boolean)ormElementCollectionMapping.isCustomMapKey());
        EclipseLink2_0OrmElementCollectionMappingTests.assertFalse((boolean)ormElementCollectionMapping.isNoMapKey());
        javaElementCollectionMapping.setCustomMapKey(true);
        javaElementCollectionMapping.setSpecifiedMapKey(ATTRIBUTE_OVERRIDE_NAME);
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)ormElementCollectionMapping.getSpecifiedMapKey());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)ormElementCollectionMapping.getMapKey());
        EclipseLink2_0OrmElementCollectionMappingTests.assertFalse((boolean)ormElementCollectionMapping.isPkMapKey());
        EclipseLink2_0OrmElementCollectionMappingTests.assertTrue((boolean)ormElementCollectionMapping.isCustomMapKey());
        EclipseLink2_0OrmElementCollectionMappingTests.assertFalse((boolean)ormElementCollectionMapping.isNoMapKey());
    }

    public void testModifyMapKey() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToMany", "oneToManyMapping");
        OrmOneToManyMapping ormOneToManyMapping = (OrmOneToManyMapping)ormPersistentAttribute.getMapping();
        XmlOneToMany oneToMany = (XmlOneToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToManys().get(0);
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)ormOneToManyMapping.getSpecifiedMapKey());
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)oneToMany.getMapKey());
        ormOneToManyMapping.setSpecifiedMapKey("myMapKey");
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"myMapKey", (String)ormOneToManyMapping.getSpecifiedMapKey());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"myMapKey", (String)oneToMany.getMapKey().getName());
        ormOneToManyMapping.setSpecifiedMapKey(null);
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)ormOneToManyMapping.getSpecifiedMapKey());
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)oneToMany.getMapKey());
    }

    public void testCandidateMapKeyNames() throws Exception {
        this.createTestEntityWithValidMapElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("embeddable", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        OrmElementCollectionMapping2_0 ormElementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentType.getAttributeNamed("addresses").getMapping();
        Iterator mapKeyNames = ormElementCollectionMapping.candidateMapKeyNames();
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"state.name", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"state.abbr", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmElementCollectionMappingTests.assertFalse((boolean)mapKeyNames.hasNext());
    }

    public void testCandidateMapKeyNames2() throws Exception {
        this.createTestEntityWithValidNonGenericMapElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("embeddable", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        OrmElementCollectionMapping2_0 ormElementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentType.getAttributeNamed("addresses").getMapping();
        JavaElementCollectionMapping2_0 javaElementCollectionMapping = (JavaElementCollectionMapping2_0)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        Iterator mapKeyNames = ormElementCollectionMapping.candidateMapKeyNames();
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((boolean)false, (boolean)mapKeyNames.hasNext());
        javaElementCollectionMapping.setSpecifiedTargetClass("test.Address");
        mapKeyNames = ormElementCollectionMapping.candidateMapKeyNames();
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"state.name", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"state.abbr", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmElementCollectionMappingTests.assertFalse((boolean)mapKeyNames.hasNext());
        ormElementCollectionMapping.getPersistentAttribute().makeSpecified();
        ormElementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentType.getAttributeNamed("addresses").getMapping();
        mapKeyNames = ormElementCollectionMapping.candidateMapKeyNames();
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((boolean)false, (boolean)mapKeyNames.hasNext());
        ormElementCollectionMapping.setSpecifiedTargetClass("test.Address");
        mapKeyNames = ormElementCollectionMapping.candidateMapKeyNames();
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"state.name", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"state.abbr", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        EclipseLink2_0OrmElementCollectionMappingTests.assertFalse((boolean)mapKeyNames.hasNext());
        ormElementCollectionMapping.setSpecifiedTargetClass("String");
        mapKeyNames = ormElementCollectionMapping.candidateMapKeyNames();
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((boolean)false, (boolean)mapKeyNames.hasNext());
    }

    public void testUpdateMapKeyClass() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("elementCollection", "oneToManyMapping");
        OrmElementCollectionMapping2_0 ormElementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        XmlElementCollection elementCollection = (XmlElementCollection)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getElementCollections().get(0);
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)ormElementCollectionMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)elementCollection.getMapKeyClass());
        elementCollection.setMapKeyClass(OrmFactory.eINSTANCE.createXmlClassReference());
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)ormElementCollectionMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0OrmElementCollectionMappingTests.assertNotNull((Object)elementCollection.getMapKeyClass());
        elementCollection.getMapKeyClass().setClassName("String");
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"String", (String)ormElementCollectionMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"String", (String)elementCollection.getMapKeyClass().getClassName());
        elementCollection.getMapKeyClass().setClassName(null);
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)ormElementCollectionMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)elementCollection.getMapKeyClass().getClassName());
        elementCollection.getMapKeyClass().setClassName("String");
        elementCollection.setMapKeyClass(null);
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)ormElementCollectionMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)elementCollection.getMapKeyClass());
    }

    public void testUpdateVirtualMapKeyClass() throws Exception {
        this.createTestEntityWithValidMapElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        OrmElementCollectionMapping2_0 ormElementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentType.getAttributeNamed("addresses").getMapping();
        JavaElementCollectionMapping2_0 javaElementCollectionMapping = (JavaElementCollectionMapping2_0)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"java.lang.String", (String)ormElementCollectionMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"java.lang.String", (String)ormElementCollectionMapping.getMapKeyClass());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"java.lang.String", (String)ormElementCollectionMapping.getDefaultMapKeyClass());
        javaElementCollectionMapping.setSpecifiedMapKeyClass("Integer");
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"java.lang.Integer", (String)ormElementCollectionMapping.getMapKeyClass());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"java.lang.Integer", (String)ormElementCollectionMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"java.lang.String", (String)ormElementCollectionMapping.getDefaultMapKeyClass());
    }

    public void testModifyMapKeyClass() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("elementCollection", "oneToManyMapping");
        OrmElementCollectionMapping2_0 ormElementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        XmlElementCollection elementCollection = (XmlElementCollection)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getElementCollections().get(0);
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)ormElementCollectionMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)elementCollection.getMapKeyClass());
        ormElementCollectionMapping.setSpecifiedMapKeyClass("String");
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"String", (String)ormElementCollectionMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"String", (String)elementCollection.getMapKeyClass().getClassName());
        ormElementCollectionMapping.setSpecifiedMapKeyClass(null);
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)ormElementCollectionMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)elementCollection.getMapKeyClass());
    }

    public void testOrderColumnDefaults() throws Exception {
        this.createTestEntityWithGenericBasicElementCollectionMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("elementCollection", "addresses");
        OrmElementCollectionMapping2_0 elementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        Orderable2_0 orderable = (Orderable2_0)elementCollectionMapping.getOrderable();
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((boolean)false, (boolean)orderable.isOrderColumnOrdering());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((boolean)true, (boolean)orderable.isNoOrdering());
        orderable.setOrderColumnOrdering(true);
        OrderColumn2_0 orderColumn = orderable.getOrderColumn();
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((boolean)true, (boolean)orderable.isOrderColumnOrdering());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals(null, (String)orderColumn.getSpecifiedName());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"addresses_ORDER", (String)orderColumn.getDefaultName());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"AnnotationTestType_addresses", (String)orderColumn.getTable());
        orderColumn.setSpecifiedName("FOO");
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"FOO", (String)orderColumn.getSpecifiedName());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"addresses_ORDER", (String)orderColumn.getDefaultName());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"AnnotationTestType_addresses", (String)orderColumn.getTable());
    }

    public void testVirtualOrderColumn() throws Exception {
        this.createTestEntityWithGenericBasicElementCollectionMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("elementCollection", "addresses");
        OrmElementCollectionMapping2_0 elementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        Orderable2_0 orderable = (Orderable2_0)elementCollectionMapping.getOrderable();
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((boolean)false, (boolean)orderable.isOrderColumnOrdering());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((boolean)true, (boolean)orderable.isNoOrdering());
        JavaElementCollectionMapping2_0 javaElementCollectionMapping = (JavaElementCollectionMapping2_0)ormPersistentAttribute.getJavaPersistentAttribute().getMapping();
        ((Orderable2_0)javaElementCollectionMapping.getOrderable()).setOrderColumnOrdering(true);
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((boolean)false, (boolean)orderable.isOrderColumnOrdering());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((boolean)true, (boolean)orderable.isNoOrdering());
        ormPersistentAttribute.makeVirtual();
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("addresses");
        elementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        orderable = (Orderable2_0)elementCollectionMapping.getOrderable();
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((boolean)true, (boolean)orderable.isOrderColumnOrdering());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((boolean)false, (boolean)orderable.isNoOrdering());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"AnnotationTestType_addresses", (String)orderable.getOrderColumn().getTable());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"addresses_ORDER", (String)orderable.getOrderColumn().getName());
        ((Orderable2_0)javaElementCollectionMapping.getOrderable()).getOrderColumn().setSpecifiedName("FOO");
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"AnnotationTestType_addresses", (String)orderable.getOrderColumn().getTable());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"FOO", (String)orderable.getOrderColumn().getName());
    }

    public void testVirtualValueColumnDefaults() throws Exception {
        this.createTestEntityWithGenericBasicElementCollectionMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute addressesPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        OrmElementCollectionMapping2_0 addressesVirtualMapping = (OrmElementCollectionMapping2_0)addressesPersistentAttribute.getMapping();
        OrmColumn ormColumn = addressesVirtualMapping.getValueColumn();
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"addresses", (String)ormColumn.getSpecifiedName());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"AnnotationTestType_addresses", (String)ormColumn.getSpecifiedTable());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals(null, (String)ormColumn.getColumnDefinition());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getSpecifiedInsertable());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getSpecifiedUpdatable());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getSpecifiedNullable());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormColumn.getSpecifiedUnique());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((int)255, (int)ormColumn.getSpecifiedLength());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((int)0, (int)ormColumn.getSpecifiedPrecision());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((int)0, (int)ormColumn.getSpecifiedScale());
        JavaElementCollectionMapping2_0 javaElementCollectionMapping = (JavaElementCollectionMapping2_0)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        javaElementCollectionMapping.getValueColumn().setSpecifiedName("FOO");
        javaElementCollectionMapping.getValueColumn().setSpecifiedTable("FOO_TABLE");
        javaElementCollectionMapping.getValueColumn().setColumnDefinition("COLUMN_DEFINITION");
        javaElementCollectionMapping.getValueColumn().setSpecifiedInsertable(Boolean.FALSE);
        javaElementCollectionMapping.getValueColumn().setSpecifiedUpdatable(Boolean.FALSE);
        javaElementCollectionMapping.getValueColumn().setSpecifiedNullable(Boolean.FALSE);
        javaElementCollectionMapping.getValueColumn().setSpecifiedUnique(Boolean.TRUE);
        javaElementCollectionMapping.getValueColumn().setSpecifiedLength(Integer.valueOf(45));
        javaElementCollectionMapping.getValueColumn().setSpecifiedPrecision(Integer.valueOf(46));
        javaElementCollectionMapping.getValueColumn().setSpecifiedScale(Integer.valueOf(47));
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"FOO", (String)ormColumn.getSpecifiedName());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"FOO_TABLE", (String)ormColumn.getSpecifiedTable());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"COLUMN_DEFINITION", (String)ormColumn.getColumnDefinition());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormColumn.getSpecifiedInsertable());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormColumn.getSpecifiedUpdatable());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormColumn.getSpecifiedNullable());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getSpecifiedUnique());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((Object)45, (Object)ormColumn.getSpecifiedLength());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((Object)46, (Object)ormColumn.getSpecifiedPrecision());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((Object)47, (Object)ormColumn.getSpecifiedScale());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        addressesPersistentAttribute = ormPersistentType.getAttributeNamed("addresses");
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY, (String)addressesPersistentAttribute.getMappingKey());
    }

    public void testNullColumnDefaults() throws Exception {
        this.createTestEntityWithGenericBasicElementCollectionMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute addressesPersistentAttribute = ormPersistentType.addSpecifiedAttribute("elementCollection", "addresses");
        OrmElementCollectionMapping2_0 addressesVirtualMapping = (OrmElementCollectionMapping2_0)addressesPersistentAttribute.getMapping();
        OrmColumn ormColumn = addressesVirtualMapping.getValueColumn();
        JavaElementCollectionMapping2_0 javaElementCollectionMapping = (JavaElementCollectionMapping2_0)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        javaElementCollectionMapping.getValueColumn().setSpecifiedName("FOO");
        javaElementCollectionMapping.getValueColumn().setSpecifiedTable("FOO_TABLE");
        javaElementCollectionMapping.getValueColumn().setColumnDefinition("COLUMN_DEFINITION");
        javaElementCollectionMapping.getValueColumn().setSpecifiedInsertable(Boolean.FALSE);
        javaElementCollectionMapping.getValueColumn().setSpecifiedUpdatable(Boolean.FALSE);
        javaElementCollectionMapping.getValueColumn().setSpecifiedNullable(Boolean.FALSE);
        javaElementCollectionMapping.getValueColumn().setSpecifiedUnique(Boolean.TRUE);
        javaElementCollectionMapping.getValueColumn().setSpecifiedLength(Integer.valueOf(45));
        javaElementCollectionMapping.getValueColumn().setSpecifiedPrecision(Integer.valueOf(46));
        javaElementCollectionMapping.getValueColumn().setSpecifiedScale(Integer.valueOf(47));
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"addresses", (String)ormColumn.getDefaultName());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"AnnotationTestType_addresses", (String)ormColumn.getDefaultTable());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultInsertable());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultUpdatable());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultNullable());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((boolean)false, (boolean)ormColumn.isDefaultUnique());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((int)255, (int)ormColumn.getDefaultLength());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((int)0, (int)ormColumn.getDefaultPrecision());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((int)0, (int)ormColumn.getDefaultScale());
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)ormColumn.getSpecifiedName());
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)ormColumn.getSpecifiedTable());
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)ormColumn.getColumnDefinition());
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)ormColumn.getSpecifiedInsertable());
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)ormColumn.getSpecifiedUpdatable());
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)ormColumn.getSpecifiedNullable());
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)ormColumn.getSpecifiedUnique());
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)ormColumn.getSpecifiedLength());
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)ormColumn.getSpecifiedPrecision());
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)ormColumn.getSpecifiedScale());
    }

    public void testVirtualValueColumnTable() throws Exception {
        this.createTestEntityWithGenericBasicElementCollectionMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute addressesPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        OrmElementCollectionMapping2_0 addressesVirtualMapping = (OrmElementCollectionMapping2_0)addressesPersistentAttribute.getMapping();
        OrmColumn ormColumn = addressesVirtualMapping.getValueColumn();
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"AnnotationTestType_addresses", (String)ormColumn.getSpecifiedTable());
        ((OrmEntity)ormPersistentType.getMapping()).getTable().setSpecifiedName("ORM_TABLE");
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"AnnotationTestType_addresses", (String)ormColumn.getSpecifiedTable());
        JavaElementCollectionMapping2_0 javaElementCollectionMapping = (JavaElementCollectionMapping2_0)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        javaElementCollectionMapping.getCollectionTable().setSpecifiedName("JAVA_COLLECTION_TABLE");
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"JAVA_COLLECTION_TABLE", (String)ormColumn.getSpecifiedTable());
        javaElementCollectionMapping.getValueColumn().setSpecifiedTable("JAVA_TABLE");
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"JAVA_TABLE", (String)ormColumn.getSpecifiedTable());
        addressesPersistentAttribute = ormPersistentType.addSpecifiedAttribute("elementCollection", "addresses");
        addressesVirtualMapping = (OrmElementCollectionMapping2_0)addressesPersistentAttribute.getMapping();
        ormColumn = addressesVirtualMapping.getValueColumn();
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)ormColumn.getSpecifiedTable());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"AnnotationTestType_addresses", (String)ormColumn.getDefaultTable());
    }

    public void testMoveSpecifiedAttributeOverride() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("elementCollection", "elementCollectionMapping");
        OrmElementCollectionMapping2_0 ormElementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        OrmAttributeOverrideContainer attributeOverrideContainer = ormElementCollectionMapping.getValueAttributeOverrideContainer();
        XmlElementCollection_2_0 elementCollectionResource = (XmlElementCollection_2_0)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getElementCollections().get(0);
        elementCollectionResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        elementCollectionResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        elementCollectionResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        ((XmlAttributeOverride)elementCollectionResource.getAttributeOverrides().get(0)).setName("FOO");
        ((XmlAttributeOverride)elementCollectionResource.getAttributeOverrides().get(1)).setName("BAR");
        ((XmlAttributeOverride)elementCollectionResource.getAttributeOverrides().get(2)).setName("BAZ");
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((int)3, (int)elementCollectionResource.getAttributeOverrides().size());
        attributeOverrideContainer.moveSpecifiedAttributeOverride(2, 0);
        ListIterator attributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"BAR", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"FOO", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"BAR", (String)((XmlAttributeOverride)elementCollectionResource.getAttributeOverrides().get(0)).getName());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"BAZ", (String)((XmlAttributeOverride)elementCollectionResource.getAttributeOverrides().get(1)).getName());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"FOO", (String)((XmlAttributeOverride)elementCollectionResource.getAttributeOverrides().get(2)).getName());
        attributeOverrideContainer.moveSpecifiedAttributeOverride(0, 1);
        attributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"BAR", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"FOO", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"BAZ", (String)((XmlAttributeOverride)elementCollectionResource.getAttributeOverrides().get(0)).getName());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"BAR", (String)((XmlAttributeOverride)elementCollectionResource.getAttributeOverrides().get(1)).getName());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"FOO", (String)((XmlAttributeOverride)elementCollectionResource.getAttributeOverrides().get(2)).getName());
    }

    public void testUpdateAttributeOverrides() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("elementCollection", "elementCollectionMapping");
        OrmElementCollectionMapping2_0 ormElementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        OrmAttributeOverrideContainer attributeOverrideContainer = ormElementCollectionMapping.getValueAttributeOverrideContainer();
        XmlElementCollection_2_0 elementCollectionResource = (XmlElementCollection_2_0)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getElementCollections().get(0);
        elementCollectionResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        elementCollectionResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        elementCollectionResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        ((XmlAttributeOverride)elementCollectionResource.getAttributeOverrides().get(0)).setName("FOO");
        ((XmlAttributeOverride)elementCollectionResource.getAttributeOverrides().get(1)).setName("BAR");
        ((XmlAttributeOverride)elementCollectionResource.getAttributeOverrides().get(2)).setName("BAZ");
        ListIterator attributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"FOO", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"BAR", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        EclipseLink2_0OrmElementCollectionMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        elementCollectionResource.getAttributeOverrides().move(2, 0);
        attributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"BAR", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"FOO", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        EclipseLink2_0OrmElementCollectionMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        elementCollectionResource.getAttributeOverrides().move(0, 1);
        attributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"BAR", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"FOO", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        EclipseLink2_0OrmElementCollectionMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        elementCollectionResource.getAttributeOverrides().remove(1);
        attributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"FOO", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        EclipseLink2_0OrmElementCollectionMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        elementCollectionResource.getAttributeOverrides().remove(1);
        attributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        EclipseLink2_0OrmElementCollectionMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        elementCollectionResource.getAttributeOverrides().remove(0);
        EclipseLink2_0OrmElementCollectionMappingTests.assertFalse((boolean)attributeOverrideContainer.specifiedAttributeOverrides().hasNext());
    }

    public void testElementCollectionMappingNoUnderylingJavaAttribute() throws Exception {
        this.createTestEntityWithEmbeddableElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("embeddable", "test.Address");
        ormPersistentType.addSpecifiedAttribute("elementCollection", "foo");
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((int)3, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        OrmElementCollectionMapping2_0 ormElementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        OrmAttributeOverrideContainer attributeOverrideContainer = ormElementCollectionMapping.getValueAttributeOverrideContainer();
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"foo", (String)ormElementCollectionMapping.getName());
        EclipseLink2_0OrmElementCollectionMappingTests.assertFalse((boolean)attributeOverrideContainer.specifiedAttributeOverrides().hasNext());
        EclipseLink2_0OrmElementCollectionMappingTests.assertFalse((boolean)attributeOverrideContainer.virtualAttributeOverrides().hasNext());
    }

    public void testVirtualAttributeOverrides() throws Exception {
        this.createTestEntityWithEmbeddableElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("embeddable", "test.Address");
        OrmPersistentType persistentType3 = this.getEntityMappings().addPersistentType("embeddable", "test.State");
        OrmPersistentAttribute ormPersistentAttribute = persistentType.getAttributeNamed("addresses");
        OrmElementCollectionMapping2_0 elementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        OrmAttributeOverrideContainer attributeOverrideContainer = elementCollectionMapping.getValueAttributeOverrideContainer();
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((int)4, (int)attributeOverrideContainer.attributeOverridesSize());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((int)0, (int)attributeOverrideContainer.virtualAttributeOverridesSize());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((int)4, (int)attributeOverrideContainer.specifiedAttributeOverridesSize());
        ListIterator specifiedAttributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        OrmAttributeOverride attributeOverride = (OrmAttributeOverride)specifiedAttributeOverrides.next();
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)attributeOverride.getName());
        attributeOverride = (OrmAttributeOverride)specifiedAttributeOverrides.next();
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"zip", (String)attributeOverride.getName());
        attributeOverride = (OrmAttributeOverride)specifiedAttributeOverrides.next();
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"state.name", (String)attributeOverride.getName());
        attributeOverride = (OrmAttributeOverride)specifiedAttributeOverrides.next();
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"state.abbr", (String)attributeOverride.getName());
        JavaElementCollectionMapping2_0 javaElementCollectionMapping = (JavaElementCollectionMapping2_0)ormPersistentAttribute.getJavaPersistentAttribute().getMapping();
        JavaColumn javaAttributeOverrideColumn = ((JavaAttributeOverride)javaElementCollectionMapping.getValueAttributeOverrideContainer().specifiedAttributeOverrides().next()).getColumn();
        javaAttributeOverrideColumn.setSpecifiedName("FOO_COLUMN");
        javaAttributeOverrideColumn.setSpecifiedTable("FOO_TABLE");
        javaAttributeOverrideColumn.setColumnDefinition("COLUMN_DEF");
        javaAttributeOverrideColumn.setSpecifiedInsertable(Boolean.FALSE);
        javaAttributeOverrideColumn.setSpecifiedUpdatable(Boolean.FALSE);
        javaAttributeOverrideColumn.setSpecifiedUnique(Boolean.TRUE);
        javaAttributeOverrideColumn.setSpecifiedNullable(Boolean.FALSE);
        javaAttributeOverrideColumn.setSpecifiedLength(Integer.valueOf(5));
        javaAttributeOverrideColumn.setSpecifiedPrecision(Integer.valueOf(6));
        javaAttributeOverrideColumn.setSpecifiedScale(Integer.valueOf(7));
        JavaBasicMapping javaBasicMapping = (JavaBasicMapping)persistentType3.getJavaPersistentType().getAttributeNamed("name").getMapping();
        javaBasicMapping.getColumn().setSpecifiedName("MY_STATE_COLUMN");
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((int)4, (int)attributeOverrideContainer.attributeOverridesSize());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((int)0, (int)attributeOverrideContainer.virtualAttributeOverridesSize());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((int)4, (int)attributeOverrideContainer.specifiedAttributeOverridesSize());
        specifiedAttributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        attributeOverride = (OrmAttributeOverride)specifiedAttributeOverrides.next();
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)attributeOverride.getName());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"FOO_COLUMN", (String)attributeOverride.getColumn().getSpecifiedName());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"FOO_TABLE", (String)attributeOverride.getColumn().getSpecifiedTable());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"COLUMN_DEF", (String)attributeOverride.getColumn().getColumnDefinition());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((boolean)false, (boolean)attributeOverride.getColumn().isInsertable());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((boolean)false, (boolean)attributeOverride.getColumn().isUpdatable());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((boolean)true, (boolean)attributeOverride.getColumn().isUnique());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((boolean)false, (boolean)attributeOverride.getColumn().isNullable());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((int)5, (int)attributeOverride.getColumn().getLength());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((int)6, (int)attributeOverride.getColumn().getPrecision());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((int)7, (int)attributeOverride.getColumn().getScale());
        attributeOverride = (OrmAttributeOverride)specifiedAttributeOverrides.next();
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"zip", (String)attributeOverride.getName());
        attributeOverride = (OrmAttributeOverride)specifiedAttributeOverrides.next();
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"state.name", (String)attributeOverride.getName());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"MY_STATE_COLUMN", (String)attributeOverride.getColumn().getSpecifiedName());
        attributeOverride = (OrmAttributeOverride)specifiedAttributeOverrides.next();
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"state.abbr", (String)attributeOverride.getName());
        persistentType.getAttributeNamed("addresses").makeSpecified();
        elementCollectionMapping = (OrmElementCollectionMapping2_0)persistentType.getAttributeNamed("addresses").getMapping();
        attributeOverrideContainer = elementCollectionMapping.getValueAttributeOverrideContainer();
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((int)4, (int)attributeOverrideContainer.attributeOverridesSize());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((int)4, (int)attributeOverrideContainer.virtualAttributeOverridesSize());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((int)0, (int)attributeOverrideContainer.specifiedAttributeOverridesSize());
        ListIterator virtualAttributeOverrides = attributeOverrideContainer.virtualAttributeOverrides();
        attributeOverride = (OrmAttributeOverride)virtualAttributeOverrides.next();
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)attributeOverride.getName());
        attributeOverride = (OrmAttributeOverride)virtualAttributeOverrides.next();
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"state.name", (String)attributeOverride.getName());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"MY_STATE_COLUMN", (String)attributeOverride.getColumn().getName());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"AnnotationTestType_addresses", (String)attributeOverride.getColumn().getTable());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals(null, (String)attributeOverride.getColumn().getColumnDefinition());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((boolean)true, (boolean)attributeOverride.getColumn().isInsertable());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((boolean)true, (boolean)attributeOverride.getColumn().isUpdatable());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((boolean)false, (boolean)attributeOverride.getColumn().isUnique());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((boolean)true, (boolean)attributeOverride.getColumn().isNullable());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((int)255, (int)attributeOverride.getColumn().getLength());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((int)0, (int)attributeOverride.getColumn().getPrecision());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((int)0, (int)attributeOverride.getColumn().getScale());
        attributeOverride = (OrmAttributeOverride)virtualAttributeOverrides.next();
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"state.abbr", (String)attributeOverride.getName());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"AnnotationTestType_addresses", (String)attributeOverride.getColumn().getDefaultTable());
        attributeOverride = (OrmAttributeOverride)virtualAttributeOverrides.next();
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"zip", (String)attributeOverride.getName());
        ((OrmAttributeOverride)attributeOverrideContainer.virtualAttributeOverrides().next()).setVirtual(false);
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((int)4, (int)attributeOverrideContainer.attributeOverridesSize());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((int)1, (int)attributeOverrideContainer.specifiedAttributeOverridesSize());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((int)3, (int)attributeOverrideContainer.virtualAttributeOverridesSize());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)((OrmAttributeOverride)attributeOverrideContainer.specifiedAttributeOverrides().next()).getName());
        virtualAttributeOverrides = attributeOverrideContainer.virtualAttributeOverrides();
        attributeOverride = (OrmAttributeOverride)virtualAttributeOverrides.next();
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"state.name", (String)attributeOverride.getName());
        attributeOverride = (OrmAttributeOverride)virtualAttributeOverrides.next();
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"state.abbr", (String)attributeOverride.getName());
        attributeOverride = (OrmAttributeOverride)virtualAttributeOverrides.next();
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"zip", (String)attributeOverride.getName());
    }

    public void testVirtualMapKeyColumnDefaults() throws Exception {
        this.createTestEntityWithValidMapElementCollectionMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute addressesPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        OrmElementCollectionMapping2_0 addressesVirtualMapping = (OrmElementCollectionMapping2_0)addressesPersistentAttribute.getMapping();
        Column ormColumn = addressesVirtualMapping.getMapKeyColumn();
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"addresses_KEY", (String)ormColumn.getSpecifiedName());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"AnnotationTestType_addresses", (String)ormColumn.getSpecifiedTable());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals(null, (String)ormColumn.getColumnDefinition());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getSpecifiedInsertable());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getSpecifiedUpdatable());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getSpecifiedNullable());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormColumn.getSpecifiedUnique());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((int)255, (int)ormColumn.getSpecifiedLength());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((int)0, (int)ormColumn.getSpecifiedPrecision());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((int)0, (int)ormColumn.getSpecifiedScale());
        JavaElementCollectionMapping2_0 javaElementCollectionMapping = (JavaElementCollectionMapping2_0)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        javaElementCollectionMapping.getMapKeyColumn().setSpecifiedName("FOO");
        javaElementCollectionMapping.getMapKeyColumn().setSpecifiedTable("FOO_TABLE");
        javaElementCollectionMapping.getMapKeyColumn().setColumnDefinition("COLUMN_DEFINITION");
        javaElementCollectionMapping.getMapKeyColumn().setSpecifiedInsertable(Boolean.FALSE);
        javaElementCollectionMapping.getMapKeyColumn().setSpecifiedUpdatable(Boolean.FALSE);
        javaElementCollectionMapping.getMapKeyColumn().setSpecifiedNullable(Boolean.FALSE);
        javaElementCollectionMapping.getMapKeyColumn().setSpecifiedUnique(Boolean.TRUE);
        javaElementCollectionMapping.getMapKeyColumn().setSpecifiedLength(Integer.valueOf(45));
        javaElementCollectionMapping.getMapKeyColumn().setSpecifiedPrecision(Integer.valueOf(46));
        javaElementCollectionMapping.getMapKeyColumn().setSpecifiedScale(Integer.valueOf(47));
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"FOO", (String)ormColumn.getSpecifiedName());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"FOO_TABLE", (String)ormColumn.getSpecifiedTable());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"COLUMN_DEFINITION", (String)ormColumn.getColumnDefinition());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormColumn.getSpecifiedInsertable());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormColumn.getSpecifiedUpdatable());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormColumn.getSpecifiedNullable());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getSpecifiedUnique());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((Object)45, (Object)ormColumn.getSpecifiedLength());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((Object)46, (Object)ormColumn.getSpecifiedPrecision());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((Object)47, (Object)ormColumn.getSpecifiedScale());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        addressesPersistentAttribute = ormPersistentType.getAttributeNamed("addresses");
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY, (String)addressesPersistentAttribute.getMappingKey());
    }

    public void testNullMapKeyColumnDefaults() throws Exception {
        this.createTestEntityWithValidMapElementCollectionMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute addressesPersistentAttribute = ormPersistentType.addSpecifiedAttribute("elementCollection", "addresses");
        OrmElementCollectionMapping2_0 addressesVirtualMapping = (OrmElementCollectionMapping2_0)addressesPersistentAttribute.getMapping();
        Column ormColumn = addressesVirtualMapping.getMapKeyColumn();
        JavaElementCollectionMapping2_0 javaElementCollectionMapping = (JavaElementCollectionMapping2_0)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        javaElementCollectionMapping.getMapKeyColumn().setSpecifiedName("FOO");
        javaElementCollectionMapping.getMapKeyColumn().setSpecifiedTable("FOO_TABLE");
        javaElementCollectionMapping.getMapKeyColumn().setColumnDefinition("COLUMN_DEFINITION");
        javaElementCollectionMapping.getMapKeyColumn().setSpecifiedInsertable(Boolean.FALSE);
        javaElementCollectionMapping.getMapKeyColumn().setSpecifiedUpdatable(Boolean.FALSE);
        javaElementCollectionMapping.getMapKeyColumn().setSpecifiedNullable(Boolean.FALSE);
        javaElementCollectionMapping.getMapKeyColumn().setSpecifiedUnique(Boolean.TRUE);
        javaElementCollectionMapping.getMapKeyColumn().setSpecifiedLength(Integer.valueOf(45));
        javaElementCollectionMapping.getMapKeyColumn().setSpecifiedPrecision(Integer.valueOf(46));
        javaElementCollectionMapping.getMapKeyColumn().setSpecifiedScale(Integer.valueOf(47));
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"addresses_KEY", (String)ormColumn.getDefaultName());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"AnnotationTestType_addresses", (String)ormColumn.getDefaultTable());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultInsertable());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultUpdatable());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultNullable());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((boolean)false, (boolean)ormColumn.isDefaultUnique());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((int)255, (int)ormColumn.getDefaultLength());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((int)0, (int)ormColumn.getDefaultPrecision());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((int)0, (int)ormColumn.getDefaultScale());
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)ormColumn.getSpecifiedName());
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)ormColumn.getSpecifiedTable());
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)ormColumn.getColumnDefinition());
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)ormColumn.getSpecifiedInsertable());
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)ormColumn.getSpecifiedUpdatable());
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)ormColumn.getSpecifiedNullable());
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)ormColumn.getSpecifiedUnique());
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)ormColumn.getSpecifiedLength());
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)ormColumn.getSpecifiedPrecision());
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)ormColumn.getSpecifiedScale());
    }

    public void testVirtualMapKeyColumnTable() throws Exception {
        this.createTestEntityWithValidMapElementCollectionMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute addressesPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        OrmElementCollectionMapping2_0 addressesVirtualMapping = (OrmElementCollectionMapping2_0)addressesPersistentAttribute.getMapping();
        Column ormColumn = addressesVirtualMapping.getMapKeyColumn();
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"AnnotationTestType_addresses", (String)ormColumn.getSpecifiedTable());
        ((OrmEntity)ormPersistentType.getMapping()).getTable().setSpecifiedName("ORM_TABLE");
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"AnnotationTestType_addresses", (String)ormColumn.getSpecifiedTable());
        JavaElementCollectionMapping2_0 javaElementCollectionMapping = (JavaElementCollectionMapping2_0)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        javaElementCollectionMapping.getCollectionTable().setSpecifiedName("JAVA_COLLECTION_TABLE");
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"JAVA_COLLECTION_TABLE", (String)ormColumn.getSpecifiedTable());
        javaElementCollectionMapping.getMapKeyColumn().setSpecifiedTable("JAVA_TABLE");
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"JAVA_TABLE", (String)ormColumn.getSpecifiedTable());
        addressesPersistentAttribute = ormPersistentType.addSpecifiedAttribute("elementCollection", "addresses");
        addressesVirtualMapping = (OrmElementCollectionMapping2_0)addressesPersistentAttribute.getMapping();
        ormColumn = addressesVirtualMapping.getMapKeyColumn();
        EclipseLink2_0OrmElementCollectionMappingTests.assertNull((Object)ormColumn.getSpecifiedTable());
        EclipseLink2_0OrmElementCollectionMappingTests.assertEquals((String)"AnnotationTestType_addresses", (String)ormColumn.getDefaultTable());
    }

    public void testSelfReferentialElementCollectionMapping() throws Exception {
        this.createSelfReferentialElementCollection();
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("embeddable", "test.Foo");
        OrmElementCollectionMapping2_0 mapping = (OrmElementCollectionMapping2_0)persistentType.getAttributeNamed("elementCollection").getMapping();
        EclipseLink2_0OrmElementCollectionMappingTests.assertFalse((boolean)mapping.allOverrideableAttributeMappingNames().hasNext());
    }
}

