/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.AssociationOverride;
import org.eclipse.jpt.core.context.AssociationOverrideContainer;
import org.eclipse.jpt.core.context.JoinColumn;
import org.eclipse.jpt.core.context.JoinColumnJoiningStrategy;
import org.eclipse.jpt.core.context.java.JavaAssociationOverride;
import org.eclipse.jpt.core.context.java.JavaAssociationOverrideContainer;
import org.eclipse.jpt.core.context.java.JavaEntity;
import org.eclipse.jpt.core.context.java.JavaJoinColumn;
import org.eclipse.jpt.core.context.java.JavaJoinColumnInAssociationOverrideJoiningStrategy;
import org.eclipse.jpt.core.resource.java.AssociationOverrideAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class JavaAssociationOverrideTests
extends ContextModelTestCase {
    private static final String ASSOCIATION_OVERRIDE_NAME = "MY_ASSOCIATION_OVERRIDE_NAME";

    private ICompilationUnit createTestMappedSuperclass() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.MappedSuperclass", "javax.persistence.OneToOne", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@MappedSuperclass");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToOne");
                sb.append(CR);
                sb.append("    private AnnotationTestTypeChild address;").append(CR);
                sb.append(CR);
                sb.append("    @Id");
            }
        });
    }

    private ICompilationUnit createTestEntityWithAssociationOverride() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.AssociationOverride"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@AssociationOverride(name=\"MY_ASSOCIATION_OVERRIDE_NAME\")");
            }
        });
    }

    private void createTestSubType() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("AnnotationTestTypeChild").append(" ");
                sb.append("extends AnnotationTestType ");
                sb.append("{}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "AnnotationTestTypeChild.java", sourceWriter);
    }

    public JavaAssociationOverrideTests(String name) {
        super(name);
    }

    public void testUpdateName() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        AssociationOverrideContainer overrideContainer = entity.getAssociationOverrideContainer();
        AssociationOverride javaAssociationOverride = (AssociationOverride)overrideContainer.virtualAssociationOverrides().next();
        javaAssociationOverride = javaAssociationOverride.setVirtual(false);
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestTypeChild");
        AssociationOverrideAnnotation associationOverrideResource = (AssociationOverrideAnnotation)typeResource.getAnnotation("javax.persistence.AssociationOverride");
        JavaAssociationOverrideTests.assertEquals((String)"address", (String)javaAssociationOverride.getName());
        JavaAssociationOverrideTests.assertEquals((String)"address", (String)associationOverrideResource.getName());
        JavaAssociationOverrideTests.assertTrue((boolean)overrideContainer.associationOverrides().hasNext());
        associationOverrideResource.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        JavaAssociationOverrideTests.assertEquals((String)"FOO", (String)javaAssociationOverride.getName());
        JavaAssociationOverrideTests.assertEquals((String)"FOO", (String)associationOverrideResource.getName());
        associationOverrideResource.setName(null);
        this.getJpaProject().synchronizeContextModel();
        JavaAssociationOverrideTests.assertEquals((int)0, (int)overrideContainer.specifiedAssociationOverridesSize());
        JavaAssociationOverrideTests.assertNull((Object)associationOverrideResource.getName());
        associationOverrideResource.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        JavaAssociationOverrideTests.assertEquals((int)1, (int)overrideContainer.specifiedAssociationOverridesSize());
        javaAssociationOverride = (AssociationOverride)overrideContainer.specifiedAssociationOverrides().next();
        JavaAssociationOverrideTests.assertEquals((String)"FOO", (String)javaAssociationOverride.getName());
        JavaAssociationOverrideTests.assertEquals((String)"FOO", (String)associationOverrideResource.getName());
        typeResource.removeAnnotation(0, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        this.getJpaProject().synchronizeContextModel();
        JavaAssociationOverrideTests.assertFalse((boolean)overrideContainer.specifiedAssociationOverrides().hasNext());
        JavaAssociationOverrideTests.assertFalse((boolean)typeResource.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides").hasNext());
    }

    public void testModifyName() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        AssociationOverrideContainer overrideContainer = entity.getAssociationOverrideContainer();
        AssociationOverride javaAssociationOverride = (AssociationOverride)overrideContainer.virtualAssociationOverrides().next();
        javaAssociationOverride = javaAssociationOverride.setVirtual(false);
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestTypeChild");
        AssociationOverrideAnnotation associationOverrideResource = (AssociationOverrideAnnotation)typeResource.getAnnotation("javax.persistence.AssociationOverride");
        JavaAssociationOverrideTests.assertEquals((String)"address", (String)javaAssociationOverride.getName());
        JavaAssociationOverrideTests.assertEquals((String)"address", (String)associationOverrideResource.getName());
        JavaAssociationOverrideTests.assertTrue((boolean)overrideContainer.associationOverrides().hasNext());
        javaAssociationOverride.setName("foo");
        JavaAssociationOverrideTests.assertEquals((String)"foo", (String)javaAssociationOverride.getName());
        JavaAssociationOverrideTests.assertEquals((String)"foo", (String)associationOverrideResource.getName());
        javaAssociationOverride.setName(null);
        JavaAssociationOverrideTests.assertNull((Object)javaAssociationOverride.getName());
        associationOverrideResource = (AssociationOverrideAnnotation)typeResource.getAnnotation("javax.persistence.AssociationOverride");
        JavaAssociationOverrideTests.assertNull((Object)associationOverrideResource.getName());
    }

    public void testAddSpecifiedJoinColumn() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        JavaAssociationOverrideContainer overrideContainer = entity.getAssociationOverrideContainer();
        JavaAssociationOverride javaAssociationOverride = (JavaAssociationOverride)overrideContainer.virtualAssociationOverrides().next();
        javaAssociationOverride = javaAssociationOverride.setVirtual(false);
        JavaJoinColumnInAssociationOverrideJoiningStrategy joiningStrategy = javaAssociationOverride.getRelationshipReference().getJoinColumnJoiningStrategy();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestTypeChild");
        AssociationOverrideAnnotation associationOverrideResource = (AssociationOverrideAnnotation)typeResource.getAnnotation("javax.persistence.AssociationOverride");
        JavaJoinColumn joinColumn = joiningStrategy.addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("FOO");
        JavaAssociationOverrideTests.assertEquals((String)"FOO", (String)associationOverrideResource.joinColumnAt(0).getName());
        JavaJoinColumn joinColumn2 = joiningStrategy.addSpecifiedJoinColumn(0);
        joinColumn2.setSpecifiedName("BAR");
        JavaAssociationOverrideTests.assertEquals((String)"BAR", (String)associationOverrideResource.joinColumnAt(0).getName());
        JavaAssociationOverrideTests.assertEquals((String)"FOO", (String)associationOverrideResource.joinColumnAt(1).getName());
        JavaJoinColumn joinColumn3 = joiningStrategy.addSpecifiedJoinColumn(1);
        joinColumn3.setSpecifiedName("BAZ");
        JavaAssociationOverrideTests.assertEquals((String)"BAR", (String)associationOverrideResource.joinColumnAt(0).getName());
        JavaAssociationOverrideTests.assertEquals((String)"BAZ", (String)associationOverrideResource.joinColumnAt(1).getName());
        JavaAssociationOverrideTests.assertEquals((String)"FOO", (String)associationOverrideResource.joinColumnAt(2).getName());
        ListIterator joinColumns = joiningStrategy.specifiedJoinColumns();
        JavaAssociationOverrideTests.assertEquals((Object)joinColumn2, joinColumns.next());
        JavaAssociationOverrideTests.assertEquals((Object)joinColumn3, joinColumns.next());
        JavaAssociationOverrideTests.assertEquals((Object)joinColumn, joinColumns.next());
        joinColumns = joiningStrategy.specifiedJoinColumns();
        JavaAssociationOverrideTests.assertEquals((String)"BAR", (String)((JavaJoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertEquals((String)"BAZ", (String)((JavaJoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertEquals((String)"FOO", (String)((JavaJoinColumn)joinColumns.next()).getName());
    }

    public void testRemoveSpecifiedJoinColumn() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        AssociationOverrideContainer overrideContainer = entity.getAssociationOverrideContainer();
        AssociationOverride javaAssociationOverride = (AssociationOverride)overrideContainer.virtualAssociationOverrides().next();
        javaAssociationOverride = javaAssociationOverride.setVirtual(false);
        JoinColumnJoiningStrategy joiningStrategy = javaAssociationOverride.getRelationshipReference().getJoinColumnJoiningStrategy();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestTypeChild");
        AssociationOverrideAnnotation associationOverrideResource = (AssociationOverrideAnnotation)typeResource.getAnnotation("javax.persistence.AssociationOverride");
        JavaAssociationOverrideTests.assertEquals((int)1, (int)associationOverrideResource.joinColumnsSize());
        joiningStrategy.addSpecifiedJoinColumn(0).setSpecifiedName("FOO");
        joiningStrategy.addSpecifiedJoinColumn(1).setSpecifiedName("BAR");
        joiningStrategy.addSpecifiedJoinColumn(2).setSpecifiedName("BAZ");
        JavaAssociationOverrideTests.assertEquals((int)4, (int)associationOverrideResource.joinColumnsSize());
        joiningStrategy.removeSpecifiedJoinColumn(0);
        JavaAssociationOverrideTests.assertEquals((int)3, (int)associationOverrideResource.joinColumnsSize());
        JavaAssociationOverrideTests.assertEquals((String)"BAR", (String)associationOverrideResource.joinColumnAt(0).getName());
        JavaAssociationOverrideTests.assertEquals((String)"BAZ", (String)associationOverrideResource.joinColumnAt(1).getName());
        joiningStrategy.removeSpecifiedJoinColumn(0);
        JavaAssociationOverrideTests.assertEquals((int)2, (int)associationOverrideResource.joinColumnsSize());
        JavaAssociationOverrideTests.assertEquals((String)"BAZ", (String)associationOverrideResource.joinColumnAt(0).getName());
        joiningStrategy.removeSpecifiedJoinColumn(0);
        JavaAssociationOverrideTests.assertEquals((int)1, (int)associationOverrideResource.joinColumnsSize());
        joiningStrategy.removeSpecifiedJoinColumn(0);
        JavaAssociationOverrideTests.assertEquals((int)0, (int)associationOverrideResource.joinColumnsSize());
    }

    public void testMoveSpecifiedJoinColumn() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        JavaAssociationOverrideContainer overrideContainer = entity.getAssociationOverrideContainer();
        JavaAssociationOverride javaAssociationOverride = (JavaAssociationOverride)overrideContainer.virtualAssociationOverrides().next();
        javaAssociationOverride = javaAssociationOverride.setVirtual(false);
        JavaJoinColumnInAssociationOverrideJoiningStrategy joiningStrategy = javaAssociationOverride.getRelationshipReference().getJoinColumnJoiningStrategy();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestTypeChild");
        AssociationOverrideAnnotation associationOverrideResource = (AssociationOverrideAnnotation)typeResource.getAnnotation("javax.persistence.AssociationOverride");
        joiningStrategy.addSpecifiedJoinColumn(0).setSpecifiedName("FOO");
        joiningStrategy.addSpecifiedJoinColumn(1).setSpecifiedName("BAR");
        joiningStrategy.addSpecifiedJoinColumn(2).setSpecifiedName("BAZ");
        JavaAssociationOverrideTests.assertEquals((int)4, (int)associationOverrideResource.joinColumnsSize());
        joiningStrategy.moveSpecifiedJoinColumn(2, 0);
        ListIterator joinColumns = joiningStrategy.specifiedJoinColumns();
        JavaAssociationOverrideTests.assertEquals((String)"BAR", (String)((JavaJoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertEquals((String)"BAZ", (String)((JavaJoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertEquals((String)"FOO", (String)((JavaJoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertEquals((String)"BAR", (String)associationOverrideResource.joinColumnAt(0).getName());
        JavaAssociationOverrideTests.assertEquals((String)"BAZ", (String)associationOverrideResource.joinColumnAt(1).getName());
        JavaAssociationOverrideTests.assertEquals((String)"FOO", (String)associationOverrideResource.joinColumnAt(2).getName());
        joiningStrategy.moveSpecifiedJoinColumn(0, 1);
        joinColumns = joiningStrategy.specifiedJoinColumns();
        JavaAssociationOverrideTests.assertEquals((String)"BAZ", (String)((JavaJoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertEquals((String)"BAR", (String)((JavaJoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertEquals((String)"FOO", (String)((JavaJoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertEquals((String)"BAZ", (String)associationOverrideResource.joinColumnAt(0).getName());
        JavaAssociationOverrideTests.assertEquals((String)"BAR", (String)associationOverrideResource.joinColumnAt(1).getName());
        JavaAssociationOverrideTests.assertEquals((String)"FOO", (String)associationOverrideResource.joinColumnAt(2).getName());
    }

    public void testUpdateJoinColumns() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        JavaAssociationOverrideContainer overrideContainer = entity.getAssociationOverrideContainer();
        JavaAssociationOverride javaAssociationOverride = (JavaAssociationOverride)overrideContainer.virtualAssociationOverrides().next();
        javaAssociationOverride = javaAssociationOverride.setVirtual(false);
        JavaJoinColumnInAssociationOverrideJoiningStrategy joiningStrategy = javaAssociationOverride.getRelationshipReference().getJoinColumnJoiningStrategy();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestTypeChild");
        AssociationOverrideAnnotation associationOverrideResource = (AssociationOverrideAnnotation)typeResource.getAnnotation("javax.persistence.AssociationOverride");
        ListIterator joinColumns = joiningStrategy.specifiedJoinColumns();
        JoinColumn joinColumn = (JoinColumn)joinColumns.next();
        JavaAssociationOverrideTests.assertEquals((String)"address_id", (String)joinColumn.getSpecifiedName());
        JavaAssociationOverrideTests.assertEquals((String)"id", (String)joinColumn.getSpecifiedReferencedColumnName());
        associationOverrideResource.addJoinColumn(0);
        associationOverrideResource.addJoinColumn(1);
        associationOverrideResource.addJoinColumn(2);
        associationOverrideResource.joinColumnAt(0).setName("FOO");
        associationOverrideResource.joinColumnAt(1).setName("BAR");
        associationOverrideResource.joinColumnAt(2).setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        joinColumns = joiningStrategy.specifiedJoinColumns();
        JavaAssociationOverrideTests.assertEquals((String)"FOO", (String)((JavaJoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertEquals((String)"BAR", (String)((JavaJoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertEquals((String)"BAZ", (String)((JavaJoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertEquals((String)"address_id", (String)((JavaJoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertFalse((boolean)joinColumns.hasNext());
        associationOverrideResource.moveJoinColumn(2, 0);
        this.getJpaProject().synchronizeContextModel();
        joinColumns = joiningStrategy.specifiedJoinColumns();
        JavaAssociationOverrideTests.assertEquals((String)"BAR", (String)((JavaJoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertEquals((String)"BAZ", (String)((JavaJoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertEquals((String)"FOO", (String)((JavaJoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertEquals((String)"address_id", (String)((JavaJoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertFalse((boolean)joinColumns.hasNext());
        associationOverrideResource.moveJoinColumn(0, 1);
        this.getJpaProject().synchronizeContextModel();
        joinColumns = joiningStrategy.specifiedJoinColumns();
        JavaAssociationOverrideTests.assertEquals((String)"BAZ", (String)((JavaJoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertEquals((String)"BAR", (String)((JavaJoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertEquals((String)"FOO", (String)((JavaJoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertEquals((String)"address_id", (String)((JavaJoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertFalse((boolean)joinColumns.hasNext());
        associationOverrideResource.removeJoinColumn(1);
        this.getJpaProject().synchronizeContextModel();
        joinColumns = joiningStrategy.specifiedJoinColumns();
        JavaAssociationOverrideTests.assertEquals((String)"BAZ", (String)((JavaJoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertEquals((String)"FOO", (String)((JavaJoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertEquals((String)"address_id", (String)((JavaJoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertFalse((boolean)joinColumns.hasNext());
        associationOverrideResource.removeJoinColumn(1);
        this.getJpaProject().synchronizeContextModel();
        joinColumns = joiningStrategy.specifiedJoinColumns();
        JavaAssociationOverrideTests.assertEquals((String)"BAZ", (String)((JavaJoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertEquals((String)"address_id", (String)((JavaJoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertFalse((boolean)joinColumns.hasNext());
        associationOverrideResource.removeJoinColumn(0);
        this.getJpaProject().synchronizeContextModel();
        joinColumns = joiningStrategy.specifiedJoinColumns();
        JavaAssociationOverrideTests.assertEquals((String)"address_id", (String)((JavaJoinColumn)joinColumns.next()).getName());
        associationOverrideResource.removeJoinColumn(0);
        this.getJpaProject().synchronizeContextModel();
        JavaAssociationOverrideTests.assertFalse((boolean)joiningStrategy.specifiedJoinColumns().hasNext());
    }

    public void testGetName() throws Exception {
        this.createTestEntityWithAssociationOverride();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        AssociationOverride specifiedAssociationOverride = (AssociationOverride)overrideContainer.specifiedAssociationOverrides().next();
        JavaAssociationOverrideTests.assertEquals((String)ASSOCIATION_OVERRIDE_NAME, (String)specifiedAssociationOverride.getName());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        AssociationOverrideAnnotation associationOverrideResource = (AssociationOverrideAnnotation)typeResource.getAnnotation("javax.persistence.AssociationOverride");
        associationOverrideResource.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        specifiedAssociationOverride = (AssociationOverride)overrideContainer.specifiedAssociationOverrides().next();
        JavaAssociationOverrideTests.assertEquals((String)"FOO", (String)specifiedAssociationOverride.getName());
    }

    public void testSetName() throws Exception {
        this.createTestEntityWithAssociationOverride();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        AssociationOverride specifiedAssociationOverride = (AssociationOverride)overrideContainer.specifiedAssociationOverrides().next();
        JavaAssociationOverrideTests.assertEquals((String)ASSOCIATION_OVERRIDE_NAME, (String)specifiedAssociationOverride.getName());
        specifiedAssociationOverride.setName("FOO");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        AssociationOverrideAnnotation associationOverrideResource = (AssociationOverrideAnnotation)typeResource.getAnnotation("javax.persistence.AssociationOverride");
        JavaAssociationOverrideTests.assertEquals((String)"FOO", (String)associationOverrideResource.getName());
    }

    public void testDefaultName() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        AssociationOverrideContainer overrideContainer = entity.getAssociationOverrideContainer();
        JavaAssociationOverrideTests.assertEquals((String)"AnnotationTestTypeChild", (String)entity.getName());
        JavaAssociationOverrideTests.assertEquals((int)1, (int)overrideContainer.virtualAssociationOverridesSize());
        AssociationOverride associationOverride = (AssociationOverride)overrideContainer.virtualAssociationOverrides().next();
        JavaAssociationOverrideTests.assertEquals((String)"address", (String)associationOverride.getName());
    }

    public void testIsVirtual() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        AssociationOverrideContainer overrideContainer = entity.getAssociationOverrideContainer();
        JavaAssociationOverrideTests.assertEquals((String)"AnnotationTestTypeChild", (String)entity.getName());
        JavaAssociationOverrideTests.assertEquals((int)1, (int)overrideContainer.virtualAssociationOverridesSize());
        AssociationOverride associationOverride = (AssociationOverride)overrideContainer.virtualAssociationOverrides().next();
        JavaAssociationOverrideTests.assertTrue((boolean)associationOverride.isVirtual());
    }
}

