/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.MappingKeys;
import org.eclipse.jpt.core.context.AttributeMapping;
import org.eclipse.jpt.core.context.BasicMapping;
import org.eclipse.jpt.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.core.context.EmbeddedMapping;
import org.eclipse.jpt.core.context.IdMapping;
import org.eclipse.jpt.core.context.JoinColumn;
import org.eclipse.jpt.core.context.JoinColumnJoiningStrategy;
import org.eclipse.jpt.core.context.ManyToManyMapping;
import org.eclipse.jpt.core.context.ManyToOneMapping;
import org.eclipse.jpt.core.context.MappedByJoiningStrategy;
import org.eclipse.jpt.core.context.OneToManyMapping;
import org.eclipse.jpt.core.context.OneToOneMapping;
import org.eclipse.jpt.core.context.OneToOneRelationshipReference;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.PrimaryKeyJoinColumn;
import org.eclipse.jpt.core.context.PrimaryKeyJoinColumnJoiningStrategy;
import org.eclipse.jpt.core.context.TransientMapping;
import org.eclipse.jpt.core.context.VersionMapping;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.java.JavaPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.context.java.JavaTypeMapping;
import org.eclipse.jpt.core.context.persistence.ClassRef;
import org.eclipse.jpt.core.resource.java.FetchType;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.JoinColumnAnnotation;
import org.eclipse.jpt.core.resource.java.OneToOneAnnotation;
import org.eclipse.jpt.core.resource.java.PrimaryKeyJoinColumnAnnotation;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class JavaOneToOneMappingTests
extends ContextModelTestCase {
    private void createTestTargetEntityAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    @Embedded").append(CR);
                sb.append("    private State state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestEmbeddableState() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("State").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String foo;").append(CR);
                sb.append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "State.java", sourceWriter);
    }

    private ICompilationUnit createTestEntityWithOneToOneMapping() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToOne").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithValidOneToOneMapping() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToOne").append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithCollectionOneToOneMapping() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne", "javax.persistence.Id", "java.util.Collection"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToOne").append(CR);
                sb.append("    private Collection address;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithGenericizedCollectionOneToOneMapping() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne", "javax.persistence.Id", "java.util.Collection"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToOne").append(CR);
                sb.append("    private Collection<Address> address;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    public JavaOneToOneMappingTests(String name) {
        super(name);
    }

    public void testMorphToBasicMapping() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JoinColumnJoiningStrategy joinColumns = oneToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy();
        joinColumns.addSpecifiedJoinColumn(0);
        JavaOneToOneMappingTests.assertFalse((boolean)oneToOneMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("basic");
        JavaOneToOneMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof BasicMapping));
        JavaOneToOneMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaOneToOneMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OneToOne"));
        JavaOneToOneMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Basic"));
        JavaOneToOneMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.JoinColumn"));
    }

    public void testMorphToDefault() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JoinColumnJoiningStrategy joinColumns = oneToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy();
        joinColumns.addSpecifiedJoinColumn(0);
        JavaOneToOneMappingTests.assertFalse((boolean)oneToOneMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey(MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY);
        JavaOneToOneMappingTests.assertNull((Object)persistentAttribute.getSpecifiedMapping());
        JavaOneToOneMappingTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaOneToOneMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OneToOne"));
        JavaOneToOneMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.JoinColumn"));
    }

    public void testMorphToVersionMapping() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JoinColumnJoiningStrategy joinColumns = oneToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy();
        joinColumns.addSpecifiedJoinColumn(0);
        JavaOneToOneMappingTests.assertFalse((boolean)oneToOneMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("version");
        JavaOneToOneMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof VersionMapping));
        JavaOneToOneMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaOneToOneMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OneToOne"));
        JavaOneToOneMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Version"));
        JavaOneToOneMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.JoinColumn"));
    }

    public void testMorphToIdMapping() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JoinColumnJoiningStrategy joinColumns = oneToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy();
        joinColumns.addSpecifiedJoinColumn(0);
        JavaOneToOneMappingTests.assertFalse((boolean)oneToOneMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("id");
        JavaOneToOneMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof IdMapping));
        JavaOneToOneMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaOneToOneMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OneToOne"));
        JavaOneToOneMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Id"));
        JavaOneToOneMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.JoinColumn"));
    }

    public void testMorphToEmbeddedMapping() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JoinColumnJoiningStrategy joinColumns = oneToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy();
        joinColumns.addSpecifiedJoinColumn(0);
        JavaOneToOneMappingTests.assertFalse((boolean)oneToOneMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("embedded");
        JavaOneToOneMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedMapping));
        JavaOneToOneMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaOneToOneMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OneToOne"));
        JavaOneToOneMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Embedded"));
        JavaOneToOneMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.JoinColumn"));
    }

    public void testMorphToEmbeddedIdMapping() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JoinColumnJoiningStrategy joinColumns = oneToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy();
        joinColumns.addSpecifiedJoinColumn(0);
        JavaOneToOneMappingTests.assertFalse((boolean)oneToOneMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("embeddedId");
        JavaOneToOneMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedIdMapping));
        JavaOneToOneMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaOneToOneMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OneToOne"));
        JavaOneToOneMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.EmbeddedId"));
        JavaOneToOneMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.JoinColumn"));
    }

    public void testMorphToTransientMapping() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JoinColumnJoiningStrategy joinColumns = oneToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy();
        joinColumns.addSpecifiedJoinColumn(0);
        JavaOneToOneMappingTests.assertFalse((boolean)oneToOneMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("transient");
        JavaOneToOneMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof TransientMapping));
        JavaOneToOneMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaOneToOneMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OneToOne"));
        JavaOneToOneMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Transient"));
        JavaOneToOneMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.JoinColumn"));
    }

    public void testMorphToManyToOneMapping() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JoinColumnJoiningStrategy joinColumns = oneToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy();
        joinColumns.addSpecifiedJoinColumn(0);
        JavaOneToOneMappingTests.assertFalse((boolean)oneToOneMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("manyToOne");
        JavaOneToOneMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToOneMapping));
        JavaOneToOneMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaOneToOneMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OneToOne"));
        JavaOneToOneMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.ManyToOne"));
        JavaOneToOneMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.JoinColumn"));
    }

    public void testMorphToOneToManyMapping() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JoinColumnJoiningStrategy joinColumns = oneToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy();
        joinColumns.addSpecifiedJoinColumn(0);
        JavaOneToOneMappingTests.assertFalse((boolean)oneToOneMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("oneToMany");
        JavaOneToOneMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof OneToManyMapping));
        JavaOneToOneMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaOneToOneMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OneToOne"));
        JavaOneToOneMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.OneToMany"));
        JavaOneToOneMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.JoinColumn"));
    }

    public void testMorphToManyToManyMapping() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JoinColumnJoiningStrategy joinColumns = oneToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy();
        joinColumns.addSpecifiedJoinColumn(0);
        JavaOneToOneMappingTests.assertFalse((boolean)oneToOneMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("manyToMany");
        JavaOneToOneMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToManyMapping));
        JavaOneToOneMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaOneToOneMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OneToOne"));
        JavaOneToOneMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.ManyToMany"));
        JavaOneToOneMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.JoinColumn"));
    }

    public void testUpdateSpecifiedTargetEntity() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)attributeResource.getAnnotation("javax.persistence.OneToOne");
        JavaOneToOneMappingTests.assertNull((Object)oneToOneMapping.getSpecifiedTargetEntity());
        JavaOneToOneMappingTests.assertNull((Object)oneToOne.getTargetEntity());
        oneToOne.setTargetEntity("newTargetEntity");
        JavaOneToOneMappingTests.assertEquals((String)"newTargetEntity", (String)oneToOneMapping.getSpecifiedTargetEntity());
        JavaOneToOneMappingTests.assertEquals((String)"newTargetEntity", (String)oneToOne.getTargetEntity());
        oneToOne.setTargetEntity(null);
        JavaOneToOneMappingTests.assertNull((Object)oneToOneMapping.getSpecifiedTargetEntity());
        JavaOneToOneMappingTests.assertNull((Object)oneToOne.getTargetEntity());
    }

    public void testModifySpecifiedTargetEntity() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)attributeResource.getAnnotation("javax.persistence.OneToOne");
        JavaOneToOneMappingTests.assertNull((Object)oneToOneMapping.getSpecifiedTargetEntity());
        JavaOneToOneMappingTests.assertNull((Object)oneToOne.getTargetEntity());
        oneToOneMapping.setSpecifiedTargetEntity("newTargetEntity");
        JavaOneToOneMappingTests.assertEquals((String)"newTargetEntity", (String)oneToOneMapping.getSpecifiedTargetEntity());
        JavaOneToOneMappingTests.assertEquals((String)"newTargetEntity", (String)oneToOne.getTargetEntity());
        oneToOneMapping.setSpecifiedTargetEntity(null);
        JavaOneToOneMappingTests.assertNull((Object)oneToOneMapping.getSpecifiedTargetEntity());
        JavaOneToOneMappingTests.assertNull((Object)oneToOne.getTargetEntity());
    }

    public void testUpdateMappedBy() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        MappedByJoiningStrategy mappedBy = oneToOneMapping.getRelationshipReference().getMappedByJoiningStrategy();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)attributeResource.getAnnotation("javax.persistence.OneToOne");
        JavaOneToOneMappingTests.assertNull((Object)mappedBy.getMappedByAttribute());
        JavaOneToOneMappingTests.assertNull((Object)oneToOne.getMappedBy());
        oneToOne.setMappedBy("newMappedBy");
        this.getJpaProject().synchronizeContextModel();
        JavaOneToOneMappingTests.assertEquals((String)"newMappedBy", (String)mappedBy.getMappedByAttribute());
        JavaOneToOneMappingTests.assertEquals((String)"newMappedBy", (String)oneToOne.getMappedBy());
        oneToOne.setMappedBy(null);
        this.getJpaProject().synchronizeContextModel();
        JavaOneToOneMappingTests.assertNull((Object)mappedBy.getMappedByAttribute());
        JavaOneToOneMappingTests.assertNull((Object)oneToOne.getMappedBy());
    }

    public void testModifyMappedBy() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        MappedByJoiningStrategy mappedBy = oneToOneMapping.getRelationshipReference().getMappedByJoiningStrategy();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)attributeResource.getAnnotation("javax.persistence.OneToOne");
        JavaOneToOneMappingTests.assertNull((Object)mappedBy.getMappedByAttribute());
        JavaOneToOneMappingTests.assertNull((Object)oneToOne.getMappedBy());
        mappedBy.setMappedByAttribute("newTargetEntity");
        JavaOneToOneMappingTests.assertEquals((String)"newTargetEntity", (String)mappedBy.getMappedByAttribute());
        JavaOneToOneMappingTests.assertEquals((String)"newTargetEntity", (String)oneToOne.getMappedBy());
        mappedBy.setMappedByAttribute(null);
        JavaOneToOneMappingTests.assertNull((Object)mappedBy.getMappedByAttribute());
        JavaOneToOneMappingTests.assertNull((Object)oneToOne.getMappedBy());
    }

    public void testUpdateSpecifiedOptional() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)attributeResource.getAnnotation("javax.persistence.OneToOne");
        JavaOneToOneMappingTests.assertNull((Object)oneToOneMapping.getSpecifiedOptional());
        JavaOneToOneMappingTests.assertNull((Object)oneToOne.getOptional());
        oneToOne.setOptional(Boolean.TRUE);
        this.getJpaProject().synchronizeContextModel();
        JavaOneToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)oneToOneMapping.getSpecifiedOptional());
        JavaOneToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)oneToOne.getOptional());
        oneToOne.setOptional(Boolean.FALSE);
        this.getJpaProject().synchronizeContextModel();
        JavaOneToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)oneToOneMapping.getSpecifiedOptional());
        JavaOneToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)oneToOne.getOptional());
        oneToOne.setOptional(null);
        this.getJpaProject().synchronizeContextModel();
        JavaOneToOneMappingTests.assertNull((Object)oneToOneMapping.getSpecifiedOptional());
        JavaOneToOneMappingTests.assertNull((Object)oneToOne.getOptional());
    }

    public void testModifySpecifiedOptional() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)attributeResource.getAnnotation("javax.persistence.OneToOne");
        JavaOneToOneMappingTests.assertNull((Object)oneToOneMapping.getSpecifiedOptional());
        JavaOneToOneMappingTests.assertNull((Object)oneToOne.getOptional());
        oneToOneMapping.setSpecifiedOptional(Boolean.TRUE);
        JavaOneToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)oneToOneMapping.getSpecifiedOptional());
        JavaOneToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)oneToOne.getOptional());
        oneToOneMapping.setSpecifiedOptional(Boolean.FALSE);
        JavaOneToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)oneToOneMapping.getSpecifiedOptional());
        JavaOneToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)oneToOne.getOptional());
        oneToOneMapping.setSpecifiedOptional(null);
        JavaOneToOneMappingTests.assertNull((Object)oneToOneMapping.getSpecifiedOptional());
        JavaOneToOneMappingTests.assertNull((Object)oneToOne.getOptional());
    }

    public void testUpdateSpecifiedFetch() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)attributeResource.getAnnotation("javax.persistence.OneToOne");
        JavaOneToOneMappingTests.assertNull((Object)oneToOneMapping.getSpecifiedFetch());
        JavaOneToOneMappingTests.assertNull((Object)oneToOne.getFetch());
        oneToOne.setFetch(FetchType.EAGER);
        this.getJpaProject().synchronizeContextModel();
        JavaOneToOneMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.FetchType.EAGER, (Object)oneToOneMapping.getSpecifiedFetch());
        JavaOneToOneMappingTests.assertEquals((Object)FetchType.EAGER, (Object)oneToOne.getFetch());
        oneToOne.setFetch(FetchType.LAZY);
        this.getJpaProject().synchronizeContextModel();
        JavaOneToOneMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.FetchType.LAZY, (Object)oneToOneMapping.getSpecifiedFetch());
        JavaOneToOneMappingTests.assertEquals((Object)FetchType.LAZY, (Object)oneToOne.getFetch());
        oneToOne.setFetch(null);
        this.getJpaProject().synchronizeContextModel();
        JavaOneToOneMappingTests.assertNull((Object)oneToOneMapping.getSpecifiedFetch());
        JavaOneToOneMappingTests.assertNull((Object)oneToOne.getFetch());
    }

    public void testModifySpecifiedFetch() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        OneToOneAnnotation oneToOne = (OneToOneAnnotation)attributeResource.getAnnotation("javax.persistence.OneToOne");
        JavaOneToOneMappingTests.assertNull((Object)oneToOneMapping.getSpecifiedFetch());
        JavaOneToOneMappingTests.assertNull((Object)oneToOne.getFetch());
        oneToOneMapping.setSpecifiedFetch(org.eclipse.jpt.core.context.FetchType.EAGER);
        JavaOneToOneMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.FetchType.EAGER, (Object)oneToOneMapping.getSpecifiedFetch());
        JavaOneToOneMappingTests.assertEquals((Object)FetchType.EAGER, (Object)oneToOne.getFetch());
        oneToOneMapping.setSpecifiedFetch(org.eclipse.jpt.core.context.FetchType.LAZY);
        JavaOneToOneMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.FetchType.LAZY, (Object)oneToOneMapping.getSpecifiedFetch());
        JavaOneToOneMappingTests.assertEquals((Object)FetchType.LAZY, (Object)oneToOne.getFetch());
        oneToOneMapping.setSpecifiedFetch(null);
        JavaOneToOneMappingTests.assertNull((Object)oneToOneMapping.getSpecifiedFetch());
        JavaOneToOneMappingTests.assertNull((Object)oneToOne.getFetch());
    }

    public void testSpecifiedJoinColumns() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JoinColumnJoiningStrategy joinColumns = oneToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy();
        ListIterator specifiedJoinColumns = joinColumns.specifiedJoinColumns();
        JavaOneToOneMappingTests.assertFalse((boolean)specifiedJoinColumns.hasNext());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JoinColumnAnnotation joinColumn = (JoinColumnAnnotation)attributeResource.addAnnotation(0, "javax.persistence.JoinColumn", "javax.persistence.JoinColumns");
        joinColumn.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        specifiedJoinColumns = joinColumns.specifiedJoinColumns();
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumn)specifiedJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)specifiedJoinColumns.hasNext());
        joinColumn = (JoinColumnAnnotation)attributeResource.addAnnotation(0, "javax.persistence.JoinColumn", "javax.persistence.JoinColumns");
        joinColumn.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        specifiedJoinColumns = joinColumns.specifiedJoinColumns();
        JavaOneToOneMappingTests.assertEquals((String)"BAR", (String)((JoinColumn)specifiedJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumn)specifiedJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)specifiedJoinColumns.hasNext());
        joinColumn = (JoinColumnAnnotation)attributeResource.addAnnotation(0, "javax.persistence.JoinColumn", "javax.persistence.JoinColumns");
        joinColumn.setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        specifiedJoinColumns = joinColumns.specifiedJoinColumns();
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((JoinColumn)specifiedJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"BAR", (String)((JoinColumn)specifiedJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumn)specifiedJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)specifiedJoinColumns.hasNext());
        attributeResource.moveAnnotation(1, 0, "javax.persistence.JoinColumns");
        this.getJpaProject().synchronizeContextModel();
        specifiedJoinColumns = joinColumns.specifiedJoinColumns();
        JavaOneToOneMappingTests.assertEquals((String)"BAR", (String)((JoinColumn)specifiedJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((JoinColumn)specifiedJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumn)specifiedJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)specifiedJoinColumns.hasNext());
        attributeResource.removeAnnotation(0, "javax.persistence.JoinColumn", "javax.persistence.JoinColumns");
        this.getJpaProject().synchronizeContextModel();
        specifiedJoinColumns = joinColumns.specifiedJoinColumns();
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((JoinColumn)specifiedJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumn)specifiedJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)specifiedJoinColumns.hasNext());
        attributeResource.removeAnnotation(0, "javax.persistence.JoinColumn", "javax.persistence.JoinColumns");
        this.getJpaProject().synchronizeContextModel();
        specifiedJoinColumns = joinColumns.specifiedJoinColumns();
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumn)specifiedJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)specifiedJoinColumns.hasNext());
        attributeResource.removeAnnotation(0, "javax.persistence.JoinColumn", "javax.persistence.JoinColumns");
        this.getJpaProject().synchronizeContextModel();
        specifiedJoinColumns = joinColumns.specifiedJoinColumns();
        JavaOneToOneMappingTests.assertFalse((boolean)specifiedJoinColumns.hasNext());
    }

    public void testGetDefaultJoin() {
    }

    public void testSpecifiedJoinColumnsSize() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JoinColumnJoiningStrategy joinColumns = oneToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy();
        JavaOneToOneMappingTests.assertEquals((int)0, (int)joinColumns.specifiedJoinColumnsSize());
        joinColumns.addSpecifiedJoinColumn(0);
        JavaOneToOneMappingTests.assertEquals((int)1, (int)joinColumns.specifiedJoinColumnsSize());
        joinColumns.removeSpecifiedJoinColumn(0);
        JavaOneToOneMappingTests.assertEquals((int)0, (int)joinColumns.specifiedJoinColumnsSize());
    }

    public void testJoinColumnsSize() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JoinColumnJoiningStrategy joinColumns = oneToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy();
        JavaOneToOneMappingTests.assertEquals((int)1, (int)joinColumns.joinColumnsSize());
        joinColumns.addSpecifiedJoinColumn(0);
        JavaOneToOneMappingTests.assertEquals((int)1, (int)joinColumns.joinColumnsSize());
        joinColumns.addSpecifiedJoinColumn(0);
        JavaOneToOneMappingTests.assertEquals((int)2, (int)joinColumns.joinColumnsSize());
        joinColumns.removeSpecifiedJoinColumn(0);
        joinColumns.removeSpecifiedJoinColumn(0);
        JavaOneToOneMappingTests.assertEquals((int)1, (int)joinColumns.joinColumnsSize());
        oneToOneMapping.getRelationshipReference().getMappedByJoiningStrategy().setMappedByAttribute("foo");
        JavaOneToOneMappingTests.assertEquals((int)0, (int)joinColumns.joinColumnsSize());
    }

    public void testAddSpecifiedJoinColumn() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JoinColumnJoiningStrategy joinColumns = oneToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy();
        joinColumns.addSpecifiedJoinColumn(0).setSpecifiedName("FOO");
        joinColumns.addSpecifiedJoinColumn(0).setSpecifiedName("BAR");
        joinColumns.addSpecifiedJoinColumn(0).setSpecifiedName("BAZ");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        Iterator joinColumnsIterator = attributeResource.annotations("javax.persistence.JoinColumn", "javax.persistence.JoinColumns");
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((JoinColumnAnnotation)joinColumnsIterator.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"BAR", (String)((JoinColumnAnnotation)joinColumnsIterator.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumnAnnotation)joinColumnsIterator.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)joinColumnsIterator.hasNext());
    }

    public void testAddSpecifiedJoinColumn2() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JoinColumnJoiningStrategy joinColumns = oneToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy();
        joinColumns.addSpecifiedJoinColumn(0).setSpecifiedName("FOO");
        joinColumns.addSpecifiedJoinColumn(1).setSpecifiedName("BAR");
        joinColumns.addSpecifiedJoinColumn(2).setSpecifiedName("BAZ");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        Iterator joinColumnsIterator = attributeResource.annotations("javax.persistence.JoinColumn", "javax.persistence.JoinColumns");
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumnAnnotation)joinColumnsIterator.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"BAR", (String)((JoinColumnAnnotation)joinColumnsIterator.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((JoinColumnAnnotation)joinColumnsIterator.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)joinColumnsIterator.hasNext());
    }

    public void testRemoveSpecifiedJoinColumn() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JoinColumnJoiningStrategy joinColumns = oneToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy();
        joinColumns.addSpecifiedJoinColumn(0).setSpecifiedName("FOO");
        joinColumns.addSpecifiedJoinColumn(1).setSpecifiedName("BAR");
        joinColumns.addSpecifiedJoinColumn(2).setSpecifiedName("BAZ");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaOneToOneMappingTests.assertEquals((int)3, (int)CollectionTools.size((Iterator)attributeResource.annotations("javax.persistence.JoinColumn", "javax.persistence.JoinColumns")));
        joinColumns.removeSpecifiedJoinColumn(1);
        Iterator joinColumnResources = attributeResource.annotations("javax.persistence.JoinColumn", "javax.persistence.JoinColumns");
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumnAnnotation)joinColumnResources.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((JoinColumnAnnotation)joinColumnResources.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)joinColumnResources.hasNext());
        ListIterator joinColumnsIterator = joinColumns.specifiedJoinColumns();
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)joinColumnsIterator.hasNext());
        joinColumns.removeSpecifiedJoinColumn(1);
        joinColumnResources = attributeResource.annotations("javax.persistence.JoinColumn", "javax.persistence.JoinColumns");
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumnAnnotation)joinColumnResources.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)joinColumnResources.hasNext());
        joinColumnsIterator = joinColumns.specifiedJoinColumns();
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)joinColumnsIterator.hasNext());
        joinColumns.removeSpecifiedJoinColumn(0);
        joinColumnResources = attributeResource.annotations("javax.persistence.JoinColumn", "javax.persistence.JoinColumns");
        JavaOneToOneMappingTests.assertFalse((boolean)joinColumnResources.hasNext());
        joinColumnsIterator = joinColumns.specifiedJoinColumns();
        JavaOneToOneMappingTests.assertFalse((boolean)joinColumnsIterator.hasNext());
        JavaOneToOneMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.JoinColumns"));
    }

    public void testMoveSpecifiedJoinColumn() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JoinColumnJoiningStrategy joinColumns = oneToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy();
        joinColumns.addSpecifiedJoinColumn(0).setSpecifiedName("FOO");
        joinColumns.addSpecifiedJoinColumn(1).setSpecifiedName("BAR");
        joinColumns.addSpecifiedJoinColumn(2).setSpecifiedName("BAZ");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType").persistableAttributes().next();
        Iterator javaJoinColumns = attributeResource.annotations("javax.persistence.JoinColumn", "javax.persistence.JoinColumns");
        JavaOneToOneMappingTests.assertEquals((int)3, (int)CollectionTools.size((Iterator)javaJoinColumns));
        joinColumns.moveSpecifiedJoinColumn(2, 0);
        ListIterator primaryKeyJoinColumns = joinColumns.specifiedJoinColumns();
        JavaOneToOneMappingTests.assertEquals((String)"BAR", (String)((JoinColumn)primaryKeyJoinColumns.next()).getSpecifiedName());
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((JoinColumn)primaryKeyJoinColumns.next()).getSpecifiedName());
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumn)primaryKeyJoinColumns.next()).getSpecifiedName());
        javaJoinColumns = attributeResource.annotations("javax.persistence.JoinColumn", "javax.persistence.JoinColumns");
        JavaOneToOneMappingTests.assertEquals((String)"BAR", (String)((JoinColumnAnnotation)javaJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((JoinColumnAnnotation)javaJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumnAnnotation)javaJoinColumns.next()).getName());
        joinColumns.moveSpecifiedJoinColumn(0, 1);
        primaryKeyJoinColumns = joinColumns.specifiedJoinColumns();
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((JoinColumn)primaryKeyJoinColumns.next()).getSpecifiedName());
        JavaOneToOneMappingTests.assertEquals((String)"BAR", (String)((JoinColumn)primaryKeyJoinColumns.next()).getSpecifiedName());
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumn)primaryKeyJoinColumns.next()).getSpecifiedName());
        javaJoinColumns = attributeResource.annotations("javax.persistence.JoinColumn", "javax.persistence.JoinColumns");
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((JoinColumnAnnotation)javaJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"BAR", (String)((JoinColumnAnnotation)javaJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumnAnnotation)javaJoinColumns.next()).getName());
    }

    public void testUpdateSpecifiedJoinColumns() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JoinColumnJoiningStrategy joinColumns = oneToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy();
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType").persistableAttributes().next();
        ((JoinColumnAnnotation)attributeResource.addAnnotation(0, "javax.persistence.JoinColumn", "javax.persistence.JoinColumns")).setName("FOO");
        ((JoinColumnAnnotation)attributeResource.addAnnotation(1, "javax.persistence.JoinColumn", "javax.persistence.JoinColumns")).setName("BAR");
        ((JoinColumnAnnotation)attributeResource.addAnnotation(2, "javax.persistence.JoinColumn", "javax.persistence.JoinColumns")).setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        ListIterator joinColumnsIterator = joinColumns.specifiedJoinColumns();
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"BAR", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)joinColumnsIterator.hasNext());
        attributeResource.moveAnnotation(2, 0, "javax.persistence.JoinColumns");
        this.getJpaProject().synchronizeContextModel();
        joinColumnsIterator = joinColumns.specifiedJoinColumns();
        JavaOneToOneMappingTests.assertEquals((String)"BAR", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)joinColumnsIterator.hasNext());
        attributeResource.moveAnnotation(0, 1, "javax.persistence.JoinColumns");
        this.getJpaProject().synchronizeContextModel();
        joinColumnsIterator = joinColumns.specifiedJoinColumns();
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"BAR", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)joinColumnsIterator.hasNext());
        attributeResource.removeAnnotation(1, "javax.persistence.JoinColumn", "javax.persistence.JoinColumns");
        this.getJpaProject().synchronizeContextModel();
        joinColumnsIterator = joinColumns.specifiedJoinColumns();
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)joinColumnsIterator.hasNext());
        attributeResource.removeAnnotation(1, "javax.persistence.JoinColumn", "javax.persistence.JoinColumns");
        this.getJpaProject().synchronizeContextModel();
        joinColumnsIterator = joinColumns.specifiedJoinColumns();
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)joinColumnsIterator.hasNext());
        attributeResource.removeAnnotation(0, "javax.persistence.JoinColumn", "javax.persistence.JoinColumns");
        this.getJpaProject().synchronizeContextModel();
        joinColumnsIterator = joinColumns.specifiedJoinColumns();
        JavaOneToOneMappingTests.assertFalse((boolean)joinColumnsIterator.hasNext());
    }

    public void testJoinColumnIsVirtual() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JoinColumnJoiningStrategy joinColumns = oneToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy();
        JavaOneToOneMappingTests.assertTrue((boolean)joinColumns.getDefaultJoinColumn().isVirtual());
        joinColumns.addSpecifiedJoinColumn(0);
        JoinColumn specifiedJoinColumn = (JoinColumn)joinColumns.specifiedJoinColumns().next();
        JavaOneToOneMappingTests.assertFalse((boolean)specifiedJoinColumn.isVirtual());
        JavaOneToOneMappingTests.assertNull((Object)joinColumns.getDefaultJoinColumn());
    }

    public void testCandidateMappedByAttributeNames() throws Exception {
        this.createTestEntityWithValidOneToOneMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        Iterator attributeNames = oneToOneMapping.getRelationshipReference().getMappedByJoiningStrategy().candidateMappedByAttributeNames();
        JavaOneToOneMappingTests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        JavaOneToOneMappingTests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        JavaOneToOneMappingTests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        JavaOneToOneMappingTests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        JavaOneToOneMappingTests.assertFalse((boolean)attributeNames.hasNext());
        oneToOneMapping.setSpecifiedTargetEntity("foo");
        attributeNames = oneToOneMapping.getRelationshipReference().getMappedByJoiningStrategy().candidateMappedByAttributeNames();
        JavaOneToOneMappingTests.assertFalse((boolean)attributeNames.hasNext());
        oneToOneMapping.setSpecifiedTargetEntity(null);
        attributeNames = oneToOneMapping.getRelationshipReference().getMappedByJoiningStrategy().candidateMappedByAttributeNames();
        JavaOneToOneMappingTests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        JavaOneToOneMappingTests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        JavaOneToOneMappingTests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        JavaOneToOneMappingTests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        JavaOneToOneMappingTests.assertFalse((boolean)attributeNames.hasNext());
        AttributeMapping stateFooMapping = oneToOneMapping.getResolvedTargetEntity().resolveAttributeMapping("state.foo");
        JavaOneToOneMappingTests.assertNull((Object)stateFooMapping);
    }

    public void testDefaultTargetEntity() throws Exception {
        this.createTestEntityWithValidOneToOneMapping();
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JavaOneToOneMappingTests.assertEquals((String)"test.Address", (String)oneToOneMapping.getDefaultTargetEntity());
        this.addXmlClassRef("test.Address");
        JavaOneToOneMappingTests.assertEquals((String)"test.Address", (String)oneToOneMapping.getDefaultTargetEntity());
        oneToOneMapping.setSpecifiedTargetEntity("foo");
        JavaOneToOneMappingTests.assertEquals((String)"test.Address", (String)oneToOneMapping.getDefaultTargetEntity());
        ListIterator classRefs = this.getPersistenceUnit().specifiedClassRefs();
        classRefs.next();
        ClassRef addressClassRef = (ClassRef)classRefs.next();
        JavaPersistentType addressPersistentType = addressClassRef.getJavaPersistentType();
        addressPersistentType.setMappingKey(MappingKeys.NULL_TYPE_MAPPING_KEY);
        JavaOneToOneMappingTests.assertEquals((String)"test.Address", (String)oneToOneMapping.getDefaultTargetEntity());
    }

    public void testDefaultTargetEntityCollectionType() throws Exception {
        this.createTestEntityWithCollectionOneToOneMapping();
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JavaOneToOneMappingTests.assertNull((Object)oneToOneMapping.getDefaultTargetEntity());
    }

    public void testDefaultTargetEntityGenericizedCollectionType() throws Exception {
        this.createTestEntityWithGenericizedCollectionOneToOneMapping();
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JavaOneToOneMappingTests.assertNull((Object)oneToOneMapping.getDefaultTargetEntity());
    }

    public void testTargetEntity() throws Exception {
        this.createTestEntityWithValidOneToOneMapping();
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JavaOneToOneMappingTests.assertEquals((String)"test.Address", (String)oneToOneMapping.getTargetEntity());
        oneToOneMapping.setSpecifiedTargetEntity("foo");
        JavaOneToOneMappingTests.assertEquals((String)"foo", (String)oneToOneMapping.getTargetEntity());
        oneToOneMapping.setSpecifiedTargetEntity(null);
        JavaOneToOneMappingTests.assertEquals((String)"test.Address", (String)oneToOneMapping.getTargetEntity());
    }

    public void testResolvedTargetEntity() throws Exception {
        this.createTestEntityWithValidOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JavaOneToOneMappingTests.assertNull((Object)oneToOneMapping.getResolvedTargetEntity());
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.Address");
        ListIterator classRefs = this.getPersistenceUnit().specifiedClassRefs();
        classRefs.next();
        ClassRef addressClassRef = (ClassRef)classRefs.next();
        JavaTypeMapping addressTypeMapping = addressClassRef.getJavaPersistentType().getMapping();
        JavaOneToOneMappingTests.assertEquals((Object)addressTypeMapping, (Object)oneToOneMapping.getResolvedTargetEntity());
        oneToOneMapping.setSpecifiedTargetEntity("foo");
        JavaOneToOneMappingTests.assertNull((Object)oneToOneMapping.getResolvedTargetEntity());
        oneToOneMapping.setSpecifiedTargetEntity("test.Address");
        JavaOneToOneMappingTests.assertEquals((Object)addressTypeMapping, (Object)oneToOneMapping.getResolvedTargetEntity());
        oneToOneMapping.setSpecifiedTargetEntity(null);
        JavaOneToOneMappingTests.assertEquals((Object)addressTypeMapping, (Object)oneToOneMapping.getResolvedTargetEntity());
    }

    public void testPrimaryKeyJoinColumns() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        PrimaryKeyJoinColumnJoiningStrategy strategy = oneToOneMapping.getRelationshipReference().getPrimaryKeyJoinColumnJoiningStrategy();
        ListIterator primaryKeyJoinColumns = strategy.primaryKeyJoinColumns();
        JavaOneToOneMappingTests.assertFalse((boolean)primaryKeyJoinColumns.hasNext());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        PrimaryKeyJoinColumnAnnotation joinColumn = (PrimaryKeyJoinColumnAnnotation)attributeResource.addAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        joinColumn.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        primaryKeyJoinColumns = strategy.primaryKeyJoinColumns();
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((JavaPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)primaryKeyJoinColumns.hasNext());
        joinColumn = (PrimaryKeyJoinColumnAnnotation)attributeResource.addAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        joinColumn.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        primaryKeyJoinColumns = strategy.primaryKeyJoinColumns();
        JavaOneToOneMappingTests.assertEquals((String)"BAR", (String)((JavaPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((JavaPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)primaryKeyJoinColumns.hasNext());
        joinColumn = (PrimaryKeyJoinColumnAnnotation)attributeResource.addAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        joinColumn.setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        primaryKeyJoinColumns = strategy.primaryKeyJoinColumns();
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((JavaPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"BAR", (String)((JavaPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((JavaPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)primaryKeyJoinColumns.hasNext());
        attributeResource.moveAnnotation(1, 0, "javax.persistence.PrimaryKeyJoinColumns");
        this.getJpaProject().synchronizeContextModel();
        primaryKeyJoinColumns = strategy.primaryKeyJoinColumns();
        JavaOneToOneMappingTests.assertEquals((String)"BAR", (String)((JavaPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((JavaPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((JavaPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)primaryKeyJoinColumns.hasNext());
        attributeResource.removeAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        this.getJpaProject().synchronizeContextModel();
        primaryKeyJoinColumns = strategy.primaryKeyJoinColumns();
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((JavaPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((JavaPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)primaryKeyJoinColumns.hasNext());
        attributeResource.removeAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        this.getJpaProject().synchronizeContextModel();
        primaryKeyJoinColumns = strategy.primaryKeyJoinColumns();
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((JavaPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)primaryKeyJoinColumns.hasNext());
        attributeResource.removeAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        this.getJpaProject().synchronizeContextModel();
        primaryKeyJoinColumns = strategy.primaryKeyJoinColumns();
        JavaOneToOneMappingTests.assertFalse((boolean)primaryKeyJoinColumns.hasNext());
    }

    public void testPrimaryKeyJoinColumnsSize() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        PrimaryKeyJoinColumnJoiningStrategy strategy = oneToOneMapping.getRelationshipReference().getPrimaryKeyJoinColumnJoiningStrategy();
        JavaOneToOneMappingTests.assertEquals((int)0, (int)strategy.primaryKeyJoinColumnsSize());
        strategy.addPrimaryKeyJoinColumn(0);
        JavaOneToOneMappingTests.assertEquals((int)1, (int)strategy.primaryKeyJoinColumnsSize());
        strategy.removePrimaryKeyJoinColumn(0);
        JavaOneToOneMappingTests.assertEquals((int)0, (int)strategy.primaryKeyJoinColumnsSize());
    }

    public void testAddPrimaryKeyJoinColumn() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        PrimaryKeyJoinColumnJoiningStrategy strategy = oneToOneMapping.getRelationshipReference().getPrimaryKeyJoinColumnJoiningStrategy();
        strategy.addPrimaryKeyJoinColumn(0).setSpecifiedName("FOO");
        strategy.addPrimaryKeyJoinColumn(0).setSpecifiedName("BAR");
        strategy.addPrimaryKeyJoinColumn(0).setSpecifiedName("BAZ");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        Iterator joinColumns = attributeResource.annotations("javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumnAnnotation)joinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"BAR", (String)((PrimaryKeyJoinColumnAnnotation)joinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumnAnnotation)joinColumns.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)joinColumns.hasNext());
    }

    public void testAddPrimaryKeyJoinColumn2() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        PrimaryKeyJoinColumnJoiningStrategy strategy = oneToOneMapping.getRelationshipReference().getPrimaryKeyJoinColumnJoiningStrategy();
        strategy.addPrimaryKeyJoinColumn(0).setSpecifiedName("FOO");
        strategy.addPrimaryKeyJoinColumn(1).setSpecifiedName("BAR");
        strategy.addPrimaryKeyJoinColumn(2).setSpecifiedName("BAZ");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        Iterator joinColumns = attributeResource.annotations("javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumnAnnotation)joinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"BAR", (String)((PrimaryKeyJoinColumnAnnotation)joinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumnAnnotation)joinColumns.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)joinColumns.hasNext());
    }

    public void testRemovePrimaryKeyJoinColumn() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        PrimaryKeyJoinColumnJoiningStrategy strategy = oneToOneMapping.getRelationshipReference().getPrimaryKeyJoinColumnJoiningStrategy();
        strategy.addPrimaryKeyJoinColumn(0).setSpecifiedName("FOO");
        strategy.addPrimaryKeyJoinColumn(1).setSpecifiedName("BAR");
        strategy.addPrimaryKeyJoinColumn(2).setSpecifiedName("BAZ");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaOneToOneMappingTests.assertEquals((int)3, (int)CollectionTools.size((Iterator)attributeResource.annotations("javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns")));
        strategy.removePrimaryKeyJoinColumn(1);
        Iterator joinColumnResources = attributeResource.annotations("javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumnAnnotation)joinColumnResources.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumnAnnotation)joinColumnResources.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)joinColumnResources.hasNext());
        ListIterator joinColumns = strategy.primaryKeyJoinColumns();
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumn)joinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumn)joinColumns.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)joinColumns.hasNext());
        strategy.removePrimaryKeyJoinColumn(1);
        joinColumnResources = attributeResource.annotations("javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumnAnnotation)joinColumnResources.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)joinColumnResources.hasNext());
        joinColumns = strategy.primaryKeyJoinColumns();
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumn)joinColumns.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)joinColumns.hasNext());
        strategy.removePrimaryKeyJoinColumn(0);
        joinColumnResources = attributeResource.annotations("javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        JavaOneToOneMappingTests.assertFalse((boolean)joinColumnResources.hasNext());
        joinColumns = strategy.primaryKeyJoinColumns();
        JavaOneToOneMappingTests.assertFalse((boolean)joinColumns.hasNext());
        JavaOneToOneMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.PrimaryKeyJoinColumns"));
    }

    public void testMovePrimaryKeyJoinColumn() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        PrimaryKeyJoinColumnJoiningStrategy strategy = oneToOneMapping.getRelationshipReference().getPrimaryKeyJoinColumnJoiningStrategy();
        strategy.addPrimaryKeyJoinColumn(0).setSpecifiedName("FOO");
        strategy.addPrimaryKeyJoinColumn(1).setSpecifiedName("BAR");
        strategy.addPrimaryKeyJoinColumn(2).setSpecifiedName("BAZ");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType").persistableAttributes().next();
        Iterator javaJoinColumns = attributeResource.annotations("javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        JavaOneToOneMappingTests.assertEquals((int)3, (int)CollectionTools.size((Iterator)javaJoinColumns));
        strategy.movePrimaryKeyJoinColumn(2, 0);
        ListIterator primaryKeyJoinColumns = strategy.primaryKeyJoinColumns();
        JavaOneToOneMappingTests.assertEquals((String)"BAR", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getSpecifiedName());
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getSpecifiedName());
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getSpecifiedName());
        javaJoinColumns = attributeResource.annotations("javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        JavaOneToOneMappingTests.assertEquals((String)"BAR", (String)((PrimaryKeyJoinColumnAnnotation)javaJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumnAnnotation)javaJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumnAnnotation)javaJoinColumns.next()).getName());
        strategy.movePrimaryKeyJoinColumn(0, 1);
        primaryKeyJoinColumns = strategy.primaryKeyJoinColumns();
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getSpecifiedName());
        JavaOneToOneMappingTests.assertEquals((String)"BAR", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getSpecifiedName());
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getSpecifiedName());
        javaJoinColumns = attributeResource.annotations("javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumnAnnotation)javaJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"BAR", (String)((PrimaryKeyJoinColumnAnnotation)javaJoinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumnAnnotation)javaJoinColumns.next()).getName());
    }

    public void testUpdatePrimaryKeyJoinColumns() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType").persistableAttributes().next();
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        PrimaryKeyJoinColumnJoiningStrategy strategy = oneToOneMapping.getRelationshipReference().getPrimaryKeyJoinColumnJoiningStrategy();
        ((PrimaryKeyJoinColumnAnnotation)attributeResource.addAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns")).setName("FOO");
        ((PrimaryKeyJoinColumnAnnotation)attributeResource.addAnnotation(1, "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns")).setName("BAR");
        ((PrimaryKeyJoinColumnAnnotation)attributeResource.addAnnotation(2, "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns")).setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        ListIterator joinColumns = strategy.primaryKeyJoinColumns();
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumn)joinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"BAR", (String)((PrimaryKeyJoinColumn)joinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumn)joinColumns.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)joinColumns.hasNext());
        attributeResource.moveAnnotation(2, 0, "javax.persistence.PrimaryKeyJoinColumns");
        this.getJpaProject().synchronizeContextModel();
        joinColumns = strategy.primaryKeyJoinColumns();
        JavaOneToOneMappingTests.assertEquals((String)"BAR", (String)((PrimaryKeyJoinColumn)joinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumn)joinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumn)joinColumns.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)joinColumns.hasNext());
        attributeResource.moveAnnotation(0, 1, "javax.persistence.PrimaryKeyJoinColumns");
        this.getJpaProject().synchronizeContextModel();
        joinColumns = strategy.primaryKeyJoinColumns();
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumn)joinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"BAR", (String)((PrimaryKeyJoinColumn)joinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumn)joinColumns.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)joinColumns.hasNext());
        attributeResource.removeAnnotation(1, "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        this.getJpaProject().synchronizeContextModel();
        joinColumns = strategy.primaryKeyJoinColumns();
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumn)joinColumns.next()).getName());
        JavaOneToOneMappingTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumn)joinColumns.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)joinColumns.hasNext());
        attributeResource.removeAnnotation(1, "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        this.getJpaProject().synchronizeContextModel();
        joinColumns = strategy.primaryKeyJoinColumns();
        JavaOneToOneMappingTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumn)joinColumns.next()).getName());
        JavaOneToOneMappingTests.assertFalse((boolean)joinColumns.hasNext());
        attributeResource.removeAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        this.getJpaProject().synchronizeContextModel();
        joinColumns = strategy.primaryKeyJoinColumns();
        JavaOneToOneMappingTests.assertFalse((boolean)joinColumns.hasNext());
    }

    public void testModifyPredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentAttribute resourceAttribute = (JavaResourcePersistentAttribute)this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType").persistableAttributes().next();
        OneToOneAnnotation annotation = (OneToOneAnnotation)resourceAttribute.getAnnotation("javax.persistence.OneToOne");
        PersistentAttribute contextAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToOneMapping mapping = (OneToOneMapping)contextAttribute.getMapping();
        OneToOneRelationshipReference relationshipReference = mapping.getRelationshipReference();
        JavaOneToOneMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        JavaOneToOneMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.PrimaryKeyJoinColumn"));
        JavaOneToOneMappingTests.assertNull((Object)annotation.getMappedBy());
        JavaOneToOneMappingTests.assertTrue((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        JavaOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesPrimaryKeyJoinColumnJoiningStrategy());
        JavaOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
        relationshipReference.setPrimaryKeyJoinColumnJoiningStrategy();
        JavaOneToOneMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        JavaOneToOneMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.PrimaryKeyJoinColumn"));
        JavaOneToOneMappingTests.assertNull((Object)annotation.getMappedBy());
        JavaOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        JavaOneToOneMappingTests.assertTrue((boolean)relationshipReference.usesPrimaryKeyJoinColumnJoiningStrategy());
        JavaOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
        relationshipReference.setMappedByJoiningStrategy();
        JavaOneToOneMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        JavaOneToOneMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.PrimaryKeyJoinColumn"));
        JavaOneToOneMappingTests.assertNotNull((Object)annotation.getMappedBy());
        JavaOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        JavaOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesPrimaryKeyJoinColumnJoiningStrategy());
        JavaOneToOneMappingTests.assertTrue((boolean)relationshipReference.usesMappedByJoiningStrategy());
        relationshipReference.setJoinColumnJoiningStrategy();
        JavaOneToOneMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        JavaOneToOneMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.PrimaryKeyJoinColumn"));
        JavaOneToOneMappingTests.assertNull((Object)annotation.getMappedBy());
        JavaOneToOneMappingTests.assertTrue((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        JavaOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesPrimaryKeyJoinColumnJoiningStrategy());
        JavaOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
    }

    public void testUpdatePredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentAttribute resourceAttribute = (JavaResourcePersistentAttribute)this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType").persistableAttributes().next();
        OneToOneAnnotation annotation = (OneToOneAnnotation)resourceAttribute.getAnnotation("javax.persistence.OneToOne");
        PersistentAttribute contextAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToOneMapping mapping = (OneToOneMapping)contextAttribute.getMapping();
        OneToOneRelationshipReference relationshipReference = mapping.getRelationshipReference();
        JavaOneToOneMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        JavaOneToOneMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.PrimaryKeyJoinColumn"));
        JavaOneToOneMappingTests.assertNull((Object)annotation.getMappedBy());
        JavaOneToOneMappingTests.assertTrue((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        JavaOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesPrimaryKeyJoinColumnJoiningStrategy());
        JavaOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
        resourceAttribute.addAnnotation("javax.persistence.PrimaryKeyJoinColumn");
        this.getJpaProject().synchronizeContextModel();
        JavaOneToOneMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        JavaOneToOneMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.PrimaryKeyJoinColumn"));
        JavaOneToOneMappingTests.assertNull((Object)annotation.getMappedBy());
        JavaOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        JavaOneToOneMappingTests.assertTrue((boolean)relationshipReference.usesPrimaryKeyJoinColumnJoiningStrategy());
        JavaOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
        annotation.setMappedBy("foo");
        this.getJpaProject().synchronizeContextModel();
        JavaOneToOneMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        JavaOneToOneMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.PrimaryKeyJoinColumn"));
        JavaOneToOneMappingTests.assertNotNull((Object)annotation.getMappedBy());
        JavaOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        JavaOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesPrimaryKeyJoinColumnJoiningStrategy());
        JavaOneToOneMappingTests.assertTrue((boolean)relationshipReference.usesMappedByJoiningStrategy());
        resourceAttribute.addAnnotation("javax.persistence.JoinColumn");
        this.getJpaProject().synchronizeContextModel();
        JavaOneToOneMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        JavaOneToOneMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.PrimaryKeyJoinColumn"));
        JavaOneToOneMappingTests.assertNotNull((Object)annotation.getMappedBy());
        JavaOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        JavaOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesPrimaryKeyJoinColumnJoiningStrategy());
        JavaOneToOneMappingTests.assertTrue((boolean)relationshipReference.usesMappedByJoiningStrategy());
        resourceAttribute.removeAnnotation("javax.persistence.PrimaryKeyJoinColumn");
        this.getJpaProject().synchronizeContextModel();
        JavaOneToOneMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        JavaOneToOneMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.PrimaryKeyJoinColumn"));
        JavaOneToOneMappingTests.assertNotNull((Object)annotation.getMappedBy());
        JavaOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        JavaOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesPrimaryKeyJoinColumnJoiningStrategy());
        JavaOneToOneMappingTests.assertTrue((boolean)relationshipReference.usesMappedByJoiningStrategy());
        annotation.setMappedBy(null);
        this.getJpaProject().synchronizeContextModel();
        JavaOneToOneMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        JavaOneToOneMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.PrimaryKeyJoinColumn"));
        JavaOneToOneMappingTests.assertNull((Object)annotation.getMappedBy());
        JavaOneToOneMappingTests.assertTrue((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        JavaOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesPrimaryKeyJoinColumnJoiningStrategy());
        JavaOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
        resourceAttribute.removeAnnotation("javax.persistence.JoinColumn");
        this.getJpaProject().synchronizeContextModel();
        JavaOneToOneMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        JavaOneToOneMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.PrimaryKeyJoinColumn"));
        JavaOneToOneMappingTests.assertNull((Object)annotation.getMappedBy());
        JavaOneToOneMappingTests.assertTrue((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        JavaOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesPrimaryKeyJoinColumnJoiningStrategy());
        JavaOneToOneMappingTests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
    }
}

