/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.core.internal;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.jst.server.tomcat.core.internal.FileUtil;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatConfiguration;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatConfigurationWorkingCopy;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatWebModule;
import org.eclipse.jst.server.tomcat.core.internal.Messages;
import org.eclipse.jst.server.tomcat.core.internal.ProgressUtil;
import org.eclipse.jst.server.tomcat.core.internal.TomcatServer;
import org.eclipse.jst.server.tomcat.core.internal.TomcatVersionHelper;
import org.eclipse.jst.server.tomcat.core.internal.Trace;
import org.eclipse.jst.server.tomcat.core.internal.WebModule;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.ServerPort;

public abstract class TomcatConfiguration
implements ITomcatConfiguration,
ITomcatConfigurationWorkingCopy {
    public static final String NAME_PROPERTY = "name";
    public static final String PORT_PROPERTY = "port";
    public static final String MODIFY_PORT_PROPERTY = "modifyPort";
    public static final String ADD_MAPPING_PROPERTY = "addMapping";
    public static final String REMOVE_MAPPING_PROPERTY = "removeMapping";
    public static final String MODIFY_MAPPING_PROPERTY = "modifyMapping";
    public static final String MODIFY_WEB_MODULE_PROPERTY = "modifyWebModule";
    public static final String ADD_WEB_MODULE_PROPERTY = "addWebModule";
    public static final String REMOVE_WEB_MODULE_PROPERTY = "removeWebModule";
    protected IFolder configPath;
    private transient List propertyListeners;

    public TomcatConfiguration(IFolder path) {
        this.configPath = path;
    }

    protected IFolder getFolder() {
        return this.configPath;
    }

    protected IStatus backupAndPublish(IPath tomcatDir, boolean doBackup, IProgressMonitor monitor) {
        MultiStatus ms = new MultiStatus("org.eclipse.jst.server.tomcat.core", 0, Messages.publishConfigurationTask, null);
        if (Trace.isTraceEnabled()) {
            Trace.trace((byte)4, "Backup and publish");
        }
        monitor = ProgressUtil.getMonitorFor(monitor);
        try {
            IPath backup = null;
            if (doBackup && !(backup = tomcatDir.append("backup")).toFile().exists()) {
                backup.toFile().mkdir();
            }
            this.backupFolder(this.getFolder(), tomcatDir.append("conf"), backup, ms, monitor);
        }
        catch (Exception e) {
            Trace.trace((byte)2, "backupAndPublish() error", e);
            Status s = new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorPublishConfiguration, (Object[])new String[]{e.getLocalizedMessage()}), (Throwable)e);
            ms.add((IStatus)s);
        }
        monitor.done();
        return ms;
    }

    protected void backupFolder(IFolder folder, IPath confDir, IPath backup, MultiStatus ms, IProgressMonitor monitor) throws CoreException {
        IResource[] children = folder.members();
        if (children == null) {
            return;
        }
        int size = children.length;
        monitor.beginTask(Messages.publishConfigurationTask, size * 100);
        int i = 0;
        while (i < size) {
            if (children[i] instanceof IFile) {
                try {
                    IFile file = (IFile)children[i];
                    String name = file.getName();
                    monitor.subTask(NLS.bind((String)Messages.publisherPublishTask, (Object[])new String[]{name}));
                    if (Trace.isTraceEnabled()) {
                        Trace.trace((byte)3, "Publishing " + name);
                    }
                    boolean copy = true;
                    if (backup != null && !backup.append(name).toFile().exists()) {
                        IStatus status = FileUtil.copyFile(confDir.append(name).toOSString(), backup + File.separator + name);
                        ms.add(status);
                        if (!status.isOK()) {
                            copy = false;
                        }
                    }
                    if (copy) {
                        InputStream fis;
                        String destPath = confDir.append(name).toOSString();
                        String destContents = null;
                        String srcContents = null;
                        File dest = new File(destPath);
                        if (dest.exists() && (destContents = TomcatVersionHelper.getFileContents(fis = new FileInputStream(destPath))) != null) {
                            fis = file.getContents();
                            srcContents = TomcatVersionHelper.getFileContents(fis);
                        }
                        if (destContents == null || srcContents == null || !srcContents.equals(destContents)) {
                            InputStream in = file.getContents();
                            ms.add(FileUtil.copyFile(in, destPath));
                        }
                    }
                }
                catch (Exception e) {
                    Trace.trace((byte)2, "backupAndPublish() error", e);
                    ms.add((IStatus)new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorPublishConfiguration, (Object[])new String[]{e.getLocalizedMessage()}), (Throwable)e));
                }
            }
            monitor.worked(100);
            ++i;
        }
    }

    protected void backupPath(IPath path, IPath confDir, IPath backup, MultiStatus ms, IProgressMonitor monitor) {
        File[] files = path.toFile().listFiles();
        if (files == null) {
            return;
        }
        int size = files.length;
        monitor.beginTask(Messages.publishConfigurationTask, size * 100);
        int i = 0;
        while (i < size) {
            try {
                File file = files[i];
                String name = file.getName();
                monitor.subTask(NLS.bind((String)Messages.publisherPublishTask, (Object[])new String[]{name}));
                if (Trace.isTraceEnabled()) {
                    Trace.trace((byte)3, "Publishing " + name);
                }
                boolean copy = true;
                if (backup != null && !backup.append(name).toFile().exists()) {
                    IStatus status = FileUtil.copyFile(confDir.append(name).toOSString(), backup + File.separator + name);
                    ms.add(status);
                    if (!status.isOK()) {
                        copy = false;
                    }
                }
                if (copy) {
                    ms.add(FileUtil.copyFile(file.getAbsolutePath(), confDir.append(name).toOSString()));
                }
            }
            catch (Exception e) {
                Trace.trace((byte)2, "backupAndPublish() error", e);
                ms.add((IStatus)new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorPublishConfiguration, (Object[])new String[]{e.getLocalizedMessage()}), (Throwable)e));
            }
            monitor.worked(100);
            ++i;
        }
    }

    protected IStatus publishContextConfig(IPath baseDir, IPath deployDir, IProgressMonitor monitor) {
        return Status.OK_STATUS;
    }

    protected IStatus updateContextsToServeDirectly(IPath baseDir, String loader, IProgressMonitor monitor) {
        return Status.OK_STATUS;
    }

    protected IStatus cleanupServer(IPath confDir, IPath installDir, boolean removeKeptContextFiles, IProgressMonitor monitor) {
        return Status.OK_STATUS;
    }

    public abstract IStatus localizeConfiguration(IPath var1, IPath var2, TomcatServer var3, IProgressMonitor var4);

    public abstract ServerPort getMainPort();

    public String getDocBasePrefix() {
        return "";
    }

    protected String getWebModuleURL(IModule webModule) {
        WebModule module = this.getWebModule(webModule);
        if (module != null) {
            return module.getPath();
        }
        IWebModule webModule2 = (IWebModule)webModule.loadAdapter(IWebModule.class, null);
        return "/" + webModule2.getContextRoot();
    }

    public WebModule getWebModule(IModule module) {
        if (module == null) {
            return null;
        }
        String memento = module.getId();
        List modules = this.getWebModules();
        int size = modules.size();
        int i = 0;
        while (i < size) {
            WebModule webModule = (WebModule)modules.get(i);
            if (memento.equals(webModule.getMemento())) {
                return webModule;
            }
            ++i;
        }
        return null;
    }

    protected abstract void save(IFolder var1, IProgressMonitor var2) throws CoreException;

    protected void firePropertyChangeEvent(String propertyName, Object oldValue, Object newValue) {
        if (this.propertyListeners == null) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        try {
            Iterator iterator = this.propertyListeners.iterator();
            while (iterator.hasNext()) {
                try {
                    PropertyChangeListener listener = (PropertyChangeListener)iterator.next();
                    listener.propertyChange(event);
                }
                catch (Exception e) {
                    Trace.trace((byte)2, "Error firing property change event", e);
                }
            }
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Error in property event", e);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyListeners == null) {
            this.propertyListeners = new ArrayList();
        }
        this.propertyListeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyListeners != null) {
            this.propertyListeners.remove(listener);
        }
    }

    public void importFromPath(IPath path, boolean isTestEnv, IProgressMonitor monitor) throws CoreException {
        this.load(path, monitor);
    }

    protected abstract void load(IPath var1, IProgressMonitor var2) throws CoreException;

    protected abstract void load(IFolder var1, IProgressMonitor var2) throws CoreException;

    public abstract void addWebModule(int var1, ITomcatWebModule var2);

    public abstract void removeWebModule(int var1);

    public abstract IPath getServerWorkDirectory(IPath var1);

    public abstract IPath getContextWorkDirectory(IPath var1, ITomcatWebModule var2);

    public String toString() {
        return "TomcatConfiguration[" + this.getFolder() + "]";
    }
}

