/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.application.internal.operations;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jst.j2ee.application.internal.operations.J2EEUtilityJarImportAssistantOperation;
import org.eclipse.jst.j2ee.application.internal.operations.J2EEUtilityJarImportDataModelProvider;
import org.eclipse.jst.j2ee.internal.earcreation.EARCreationResourceHandler;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public class CreateProjectWithExtractedJarOperation
extends J2EEUtilityJarImportAssistantOperation {
    private String newProjectName;
    private String projectRoot;

    public CreateProjectWithExtractedJarOperation(File utilityJar, String overridingProjectRoot) {
        super(NLS.bind((String)EARCreationResourceHandler.CreateProjectWithExtractedJarOperation_Create_project_with_extracted_conte_, (Object)utilityJar.getName()), utilityJar);
        this.newProjectName = this.getUtilityJarProjectName(utilityJar);
        this.projectRoot = this.findUniqueLocation(overridingProjectRoot, this.newProjectName);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        MultiStatus status = new MultiStatus("org.eclipse.jst.j2ee", 0, NLS.bind((String)EARCreationResourceHandler.CreateProjectWithExtractedJarOperation_Create_project_with_extracted_conte_, (Object)this.getUtilityJar().getName()), null);
        try {
            IProject existingProject;
            IDataModel importModel = DataModelFactory.createDataModel((IDataModelProvider)new J2EEUtilityJarImportDataModelProvider());
            importModel.setProperty("IJ2EEArtifactImportDataModelProperties.FILE_NAME", (Object)this.getUtilityJar().getAbsolutePath());
            if (this.projectRoot != null && this.projectRoot.length() > 0) {
                importModel.setBooleanProperty("IProjectCreationPropertiesNew.USE_DEFAULT_LOCATION", false);
                importModel.setProperty("IProjectCreationPropertiesNew.USER_DEFINED_LOCATION", (Object)this.projectRoot);
            }
            if (this.isOverwriteIfNecessary() && (existingProject = this.getWorkspaceRoot().getProject(this.newProjectName)).exists()) {
                existingProject.delete(true, true, monitor);
            }
            importModel.setProperty("IJ2EEComponentImportDataModelProperties.PROJECT_NAME", (Object)this.newProjectName);
            importModel.setProperty("J2EEUtilityJarImportDataModel.EAR_PROJECT_NAME", (Object)this.getAssociatedEARProjectName());
            status.add(importModel.getDefaultOperation().execute((IProgressMonitor)new SubProgressMonitor(monitor, 1), info));
            IProject associatedEARProject = this.getWorkspaceRoot().getProject(this.getAssociatedEARProjectName());
            IProject utilityJarProject = this.getWorkspaceRoot().getProject(this.newProjectName);
            this.linkArchiveToEAR(associatedEARProject, this.getUtilityJar().getName(), utilityJarProject, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        catch (InvocationTargetException e) {
            status.add(J2EEPlugin.createErrorStatus(0, e.getMessage(), e));
            J2EEPlugin.logError(0, e.getMessage(), e);
        }
        catch (InterruptedException e) {
            status.add(J2EEPlugin.createErrorStatus(0, e.getMessage(), e));
            J2EEPlugin.logError(0, e.getMessage(), e);
        }
        catch (CoreException e) {
            status.add(J2EEPlugin.createErrorStatus(0, e.getMessage(), e));
            J2EEPlugin.logError(0, e.getMessage(), e);
        }
        return status;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return Status.CANCEL_STATUS;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return Status.CANCEL_STATUS;
    }

    public void setNewProjectName(String newProjectName) {
        this.newProjectName = newProjectName;
    }
}

