/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.project.facet.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.common.project.facet.core.internal.FacetCorePlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.ActionConfig;
import org.eclipse.wst.common.project.facet.core.util.EventListenerRegistry;
import org.eclipse.wst.common.project.facet.core.util.IEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaFacetInstallConfig
extends ActionConfig {
    private static final String PROD_PROP_OUTPUT_FOLDER = "defaultJavaOutputFolder";
    private static final String PROD_PROP_OUTPUT_FOLDER_LEGACY = "outputFolder";
    private static final String DEFAULT_OUTPUT_FOLDER = "build/classes";
    private boolean caseSensitiveFs = EFS.getLocalFileSystem().isCaseSensitive();
    private EventListenerRegistry<ChangeEvent.Type, ChangeEvent> listeners = new EventListenerRegistry(ChangeEvent.Type.class);
    private List<IPath> sourceFolders = new CopyOnWriteArrayList<IPath>();
    private List<IPath> sourceFoldersReadOnly = Collections.unmodifiableList(this.sourceFolders);
    private IPath defaultOutputFolder = null;

    public JavaFacetInstallConfig() {
        String sourceFolder = FacetCorePlugin.getJavaSrcFolder();
        this.sourceFolders.add((IPath)new Path(sourceFolder));
        String outputFolder = JavaFacetInstallConfig.getProductProperty(PROD_PROP_OUTPUT_FOLDER);
        if (outputFolder == null) {
            outputFolder = JavaFacetInstallConfig.getProductProperty(PROD_PROP_OUTPUT_FOLDER_LEGACY);
        }
        if (outputFolder == null) {
            outputFolder = DEFAULT_OUTPUT_FOLDER;
        }
        this.defaultOutputFolder = new Path(outputFolder);
    }

    public Set<IFile> getValidateEditFiles() {
        Set files = super.getValidateEditFiles();
        IProject project = this.getFacetedProjectWorkingCopy().getProject();
        if (project != null) {
            files.add(project.getFile(".project"));
            files.add(project.getFile(".classpath"));
            files.add(project.getFile(".settings/org.eclipse.jdt.core.prefs"));
            files.add(project.getFile(".settings/org.eclipse.jst.common.project.facet.core.prefs"));
        }
        return files;
    }

    public IStatus validate() {
        IStatus status = Status.OK_STATUS;
        ArrayList<IPath> localFolderList = new ArrayList<IPath>(this.sourceFolders);
        while (!localFolderList.isEmpty()) {
            IPath folder = (IPath)localFolderList.remove(0);
            status = this.validateSourceFolder(localFolderList, folder);
            if (!status.isOK()) break;
        }
        return status;
    }

    public IStatus validateSourceFolder(String candidateSourceFolder) {
        if (candidateSourceFolder == null) {
            throw new IllegalArgumentException();
        }
        return this.validateSourceFolder(this.sourceFolders, (IPath)new Path(candidateSourceFolder.trim()));
    }

    private IStatus validateSourceFolder(List<IPath> existingSourceFolders, IPath sourceFolder) {
        IStatus status = Status.OK_STATUS;
        if (sourceFolder.segmentCount() == 0) {
            status = new Status(4, "org.eclipse.jst.common.project.facet.core", Resources.mustSpecifySourceFolderMessage);
        } else {
            String pjname = this.getFacetedProjectWorkingCopy().getProjectName();
            String fullPath = "/" + pjname + "/" + sourceFolder;
            status = ResourcesPlugin.getWorkspace().validatePath(fullPath, 2);
            if (status.isOK()) {
                for (IPath existingSourceFolder : existingSourceFolders) {
                    status = this.validateSourceFolder(existingSourceFolder, sourceFolder);
                    if (!status.isOK()) break;
                }
            }
        }
        return status;
    }

    private IStatus validateSourceFolder(IPath existingPath, IPath newPath) {
        int newPathLen;
        int existingPathLen = existingPath.segmentCount();
        int minPathLen = Math.min(existingPathLen, newPathLen = newPath.segmentCount());
        if (minPathLen == 0) {
            return Status.OK_STATUS;
        }
        int i = 0;
        while (i < minPathLen) {
            if (!this.comparePathSegments(existingPath.segment(i), newPath.segment(i))) {
                return Status.OK_STATUS;
            }
            ++i;
        }
        String message = existingPathLen == newPathLen ? NLS.bind((String)Resources.nonUniqueSourceFolderMessage, (Object)newPath) : (existingPathLen > newPathLen ? NLS.bind((String)Resources.cannotNestSourceFoldersMessage, (Object)newPath, (Object)existingPath) : NLS.bind((String)Resources.cannotNestSourceFoldersMessage, (Object)existingPath, (Object)newPath));
        return new Status(4, "org.eclipse.jst.common.project.facet.core", message);
    }

    private boolean comparePathSegments(String a, String b) {
        return this.caseSensitiveFs && a.equals(b) || !this.caseSensitiveFs && a.equalsIgnoreCase(b);
    }

    public List<IPath> getSourceFolders() {
        return this.sourceFoldersReadOnly;
    }

    public void setSourceFolders(List<IPath> paths) {
        if (!this.sourceFolders.equals(paths)) {
            this.sourceFolders.clear();
            this.sourceFolders.addAll(paths);
            ChangeEvent event = new ChangeEvent(ChangeEvent.Type.SOURCE_FOLDERS_CHANGED, this);
            this.listeners.notifyListeners((Enum)ChangeEvent.Type.SOURCE_FOLDERS_CHANGED, (Object)event);
        }
    }

    public void setSourceFolder(IPath path) {
        List<Object> newSourceFolders = path == null ? Collections.emptyList() : Collections.singletonList(path);
        this.setSourceFolders(newSourceFolders);
    }

    public void addSourceFolder(IPath path) {
        if (path == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<IPath> newSourceFolders = new ArrayList<IPath>(this.getSourceFolders());
        newSourceFolders.add(path);
        this.setSourceFolders(newSourceFolders);
    }

    public void removeSourceFolder(IPath path) {
        ArrayList<IPath> newSourceFolders = new ArrayList<IPath>(this.getSourceFolders());
        newSourceFolders.remove(path);
        this.setSourceFolders(newSourceFolders);
    }

    public IPath getDefaultOutputFolder() {
        return this.defaultOutputFolder;
    }

    public void setDefaultOutputFolder(IPath defaultOutputFolder) {
        if (!JavaFacetInstallConfig.equal(this.defaultOutputFolder, defaultOutputFolder)) {
            this.defaultOutputFolder = defaultOutputFolder;
            ChangeEvent event = new ChangeEvent(ChangeEvent.Type.DEFAULT_OUTPUT_FOLDER_CHANGED, this);
            this.listeners.notifyListeners((Enum)ChangeEvent.Type.DEFAULT_OUTPUT_FOLDER_CHANGED, (Object)event);
        }
    }

    public void addListener(IEventListener<ChangeEvent> listener, ChangeEvent.Type ... types) {
        this.listeners.addListener(listener, (Enum[])types);
    }

    public void removeListener(IEventListener<ChangeEvent> listener) {
        this.listeners.removeListener(listener);
    }

    private static boolean equal(Object obj1, Object obj2) {
        if (obj1 == null || obj2 == null) {
            return false;
        }
        return obj1.equals(obj2);
    }

    private static String getProductProperty(String propName) {
        String value = null;
        if (Platform.getProduct() != null) {
            value = Platform.getProduct().getProperty(propName);
        }
        return value;
    }

    public static class ChangeEvent {
        private final Type type;
        private final JavaFacetInstallConfig installConfig;

        ChangeEvent(Type type, JavaFacetInstallConfig installConfig) {
            this.type = type;
            this.installConfig = installConfig;
        }

        public final Type getType() {
            return this.type;
        }

        public final JavaFacetInstallConfig getJavaFacetInstallConfig() {
            return this.installConfig;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Type {
            SOURCE_FOLDERS_CHANGED,
            DEFAULT_OUTPUT_FOLDER_CHANGED;

        }
    }

    private static final class Resources
    extends NLS {
        public static String nonUniqueSourceFolderMessage;
        public static String cannotNestSourceFoldersMessage;
        public static String mustSpecifySourceFolderMessage;

        static {
            Resources.initializeMessages((String)JavaFacetInstallConfig.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

