/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.testutils.files;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.jst.ws.jaxws.testutils.files.Unzipper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestFileUtils {
    private TestFileUtils() {
    }

    public static TestFileUtils getInstance() {
        return new TestFileUtils();
    }

    public boolean copyFiles(File dest, File src) throws IOException {
        if (src.isDirectory()) {
            dest.mkdirs();
            String[] list = src.list();
            int i = 0;
            while (i < list.length) {
                String dest1 = String.valueOf(dest.getAbsolutePath()) + "\\" + list[i];
                String src1 = String.valueOf(src.getAbsolutePath()) + "\\" + list[i];
                this.copyFiles(new File(dest1), new File(src1));
                ++i;
            }
        } else {
            return this.copy(dest, src);
        }
        return false;
    }

    public boolean copy(File target, File source) throws IOException {
        if (!source.isFile()) {
            return false;
        }
        FileChannel sourceChannel = new FileInputStream(source).getChannel();
        FileChannel targetChannel = new FileInputStream(target).getChannel();
        sourceChannel.transferTo(0L, sourceChannel.size(), targetChannel);
        sourceChannel.close();
        targetChannel.close();
        return true;
    }

    public File copyResourceToDir(File destDir, InputStream srcStream, String resourceName) throws IOException {
        File destFile = new File(destDir.getAbsolutePath(), resourceName);
        this.copyFile(srcStream, new FileOutputStream(destFile));
        return destFile;
    }

    public File copyResourceToDir(File destDir, String srcRelativePath, String srcFileName, Class<?> resourceClass) throws IOException {
        File destFile = new File(destDir.getAbsolutePath(), srcFileName);
        this.copyFile(this.createInputStreamForResource(srcRelativePath, srcFileName, resourceClass), new FileOutputStream(destFile));
        return destFile;
    }

    private InputStream createInputStreamForResource(String srcRelativePath, String srcFileName, Class<?> resourceClass) {
        return resourceClass.getResourceAsStream(String.valueOf(this.createResourcePath(srcRelativePath)) + srcFileName);
    }

    private String createResourcePath(String srcRelativePath) {
        return srcRelativePath == null ? "" : String.valueOf(srcRelativePath) + "/";
    }

    public void copyFile(InputStream in, OutputStream out) throws IOException {
        if (in == null || out == null) {
            throw new IllegalArgumentException("Stream not initialized");
        }
        try {
            int len;
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        finally {
            in.close();
            out.close();
        }
    }

    public boolean deleteFolderAndContents(String folderPath) throws IOException {
        File path = new File(folderPath);
        return this.deleteFolderAndContents(path);
    }

    public boolean deleteFolderAndContents(File tempDir) {
        boolean status = true;
        if (tempDir != null) {
            File[] files = tempDir.listFiles();
            if (files != null) {
                int i = 0;
                while (i < files.length) {
                    status = files[i].isDirectory() ? this.deleteFolderAndContents(files[i]) && status : files[i].delete() && status;
                    ++i;
                }
            }
            status = tempDir.delete() && status;
        } else {
            status = false;
        }
        return status;
    }

    public boolean unzipArchiveToDir(InputStream istr, String srcFileName, File destDir) throws IOException {
        if (!destDir.exists()) {
            throw new IOException("Directory does not exist");
        }
        if (!destDir.canWrite()) {
            throw new IOException("Could not write to directory");
        }
        File sourceFile = new File(destDir, srcFileName);
        FileOutputStream fos = new FileOutputStream(sourceFile);
        BufferedOutputStream bufOutStream = new BufferedOutputStream(fos);
        try {
            Unzipper.INSTANCE.copyInputStream(istr, bufOutStream);
        }
        finally {
            bufOutStream.close();
            fos.close();
        }
        if (!sourceFile.exists()) {
            throw new FileNotFoundException("Archive could not be found");
        }
        Unzipper.INSTANCE.unzip(sourceFile, destDir, false);
        return true;
    }

    public String readURLResource(URL url) throws IOException {
        String readInf = null;
        InputStream in = url.openStream();
        try {
            int inRead = in.read();
            readInf = "";
            while (inRead != -1) {
                readInf = String.valueOf(readInf) + String.valueOf((char)inRead);
                inRead = in.read();
            }
        }
        finally {
            in.close();
        }
        return readInf;
    }

    public boolean replaceContentsInFile(File file, String find, String replacement) throws IOException {
        if (!file.exists()) {
            return false;
        }
        String fileContents = this.readFileContents(file);
        fileContents = fileContents.replaceAll(find, replacement);
        file.delete();
        file.createNewFile();
        this.writeContentsToFile(file, fileContents);
        return true;
    }

    public void writeContentsToFile(File file, String fileContents) throws IOException, FileNotFoundException {
        PrintWriter pout = new PrintWriter(file);
        try {
            pout.println(fileContents);
            pout.flush();
        }
        finally {
            pout.close();
        }
    }

    public String readFileContents(File file) throws IOException {
        String readInf = null;
        FileInputStream in = new FileInputStream(file);
        try {
            int inRead = ((InputStream)in).read();
            readInf = "";
            while (inRead != -1) {
                readInf = String.valueOf(readInf) + String.valueOf((char)inRead);
                inRead = ((InputStream)in).read();
            }
        }
        finally {
            ((InputStream)in).close();
        }
        return readInf;
    }

    public InputStream getResourceInputStream(String archiveName, String projectSourceFolder, Class relativeResourceBaseClass) {
        return relativeResourceBaseClass.getResourceAsStream(String.valueOf(projectSourceFolder) + "/" + archiveName);
    }

    public void unzipTestProjects(InputStream archiveStream, String archiveName, File destDir) throws IOException {
        if (archiveStream == null) {
            throw new IOException("The archive resource stream is not initialized! archive: " + archiveName + " - dir: " + destDir);
        }
        try {
            this.unzipArchiveToDir(archiveStream, archiveName, destDir);
        }
        finally {
            archiveStream.close();
        }
    }

    public static void addZippedContent(File zipFileLocation, File outFolder) throws IOException {
        FileInputStream fis = new FileInputStream(zipFileLocation);
        TestFileUtils.addZippedContent(fis, outFolder);
    }

    public static void addZippedContent(InputStream is, File outFolder) throws IOException {
        ZipInputStream zis = new ZipInputStream(is);
        ZipEntry entry = null;
        while ((entry = zis.getNextEntry()) != null) {
            File outFile = new File(outFolder, entry.getName());
            if (entry.isDirectory()) {
                outFile.mkdirs();
            } else {
                int read;
                FileOutputStream out = new FileOutputStream(outFile);
                byte[] buff = new byte[2048];
                while ((read = zis.read(buff)) > 0) {
                    ((OutputStream)out).write(buff, 0, read);
                }
                ((OutputStream)out).close();
            }
            zis.closeEntry();
        }
        zis.close();
    }

    public static void deleteDirectory(File dir) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("Not a directory" + dir.getName());
        }
        String[] stringArray = dir.list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            File f = new File(String.valueOf(dir.getAbsolutePath()) + File.separator + s);
            if (f.isDirectory()) {
                TestFileUtils.deleteDirectory(f);
            } else {
                f.delete();
            }
            ++n2;
        }
        dir.delete();
    }

    public static File createTempDirectory(String dirName) {
        File tempDir = new File(System.getProperty("java.io.tmpdir"), dirName);
        if (tempDir.exists()) {
            TestFileUtils.deleteDirectory(tempDir);
        }
        if (!tempDir.mkdir()) {
            throw new IllegalStateException("Temp direcory " + tempDir.getAbsolutePath() + " could not be created");
        }
        return tempDir;
    }

    public static File copyToTempLocation(Class<?> classContext, String filePath) throws IOException {
        InputStream is = classContext.getResourceAsStream(filePath);
        File dir = new File(System.getProperty("java.io.tmpdir"));
        File tempFile = new File(dir, String.valueOf(System.currentTimeMillis()) + ".java");
        tempFile.deleteOnExit();
        FileOutputStream fos = new FileOutputStream(tempFile);
        try {
            byte[] buff = new byte[1024];
            int cnt = 0;
            while ((cnt = is.read(buff)) > -1) {
                fos.write(buff, 0, cnt);
            }
        }
        finally {
            is.close();
            fos.close();
        }
        return tempFile;
    }

    public static void setFileContent(File file, String content) throws IOException {
        FileWriter fw = new FileWriter(file);
        try {
            fw.write(content);
        }
        finally {
            fw.close();
        }
    }
}

