/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.internal.model.tests;

import java.util.List;
import java.util.Map;
import org.eclipse.wst.xsl.core.internal.model.StylesheetBuilder;
import org.eclipse.wst.xsl.core.model.Function;
import org.eclipse.wst.xsl.core.model.Stylesheet;
import org.eclipse.wst.xsl.core.model.XSLAttribute;
import org.eclipse.wst.xsl.internal.model.tests.AbstractModelTest;

public class TestStylesheet
extends AbstractModelTest {
    StylesheetBuilder builder = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.builder = StylesheetBuilder.getInstance();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.builder.release();
    }

    public void testLoadModel() {
        Stylesheet model = this.builder.getStylesheet(this.getFile("style1.xsl"), false);
        TestStylesheet.assertNotNull((String)"Model failed to load, returned NULL", (Object)model);
    }

    public void testgetLocalTemplatesTemplates() {
        Stylesheet model = this.builder.getStylesheet(this.getFile("style1.xsl"), false);
        TestStylesheet.assertNotNull((String)"Model failed to load, returned NULL", (Object)model);
        List templatesList = model.getTemplates();
        TestStylesheet.assertEquals((String)"Wrong number of templates returned.", (int)2, (int)templatesList.size());
    }

    public void testGetIncludes() {
        Stylesheet stylesheet = this.builder.getStylesheet(this.getFile("style1.xsl"), false);
        TestStylesheet.assertNotNull((String)"Model failed to load, returned NULL", (Object)stylesheet);
        List includeList = stylesheet.getIncludes();
        TestStylesheet.assertEquals((String)"Wrong number of includes returned.", (int)1, (int)includeList.size());
    }

    public void testGetImports() {
        Stylesheet stylesheet = this.builder.getStylesheet(this.getFile("style1.xsl"), false);
        TestStylesheet.assertNotNull((String)"Model failed to load, returned NULL", (Object)stylesheet);
        List includeList = stylesheet.getImports();
        TestStylesheet.assertEquals((String)"Wrong number of includes returned.", (int)1, (int)includeList.size());
    }

    public void testGetGlobalVariables() {
        Stylesheet stylesheet = this.builder.getStylesheet(this.getFile("globalVariablesTest.xsl"), false);
        TestStylesheet.assertNotNull((String)"Model failed to load, returned NULL", (Object)stylesheet);
        List globalVariablesList = stylesheet.getGlobalVariables();
        TestStylesheet.assertEquals((String)"Wrong number of global variables returned.", (int)3, (int)globalVariablesList.size());
    }

    public void testGetLineNumber() {
        Stylesheet stylesheet = this.builder.getStylesheet(this.getFile("globalVariablesTest.xsl"), false);
        TestStylesheet.assertNotNull((String)"Model failed to load, returned NULL", (Object)stylesheet);
        TestStylesheet.assertEquals((String)"Incorrect line number.", (int)12, (int)stylesheet.getLineNumber());
    }

    public void testGetColumnNumber() {
        Stylesheet stylesheet = this.builder.getStylesheet(this.getFile("globalVariablesTest.xsl"), false);
        TestStylesheet.assertNotNull((String)"Model failed to load, returned NULL", (Object)stylesheet);
        TestStylesheet.assertEquals((String)"Incorrect column number.", (int)0, (int)stylesheet.getColumnNumber());
    }

    public void testGetVersion() {
        Stylesheet stylesheet = this.builder.getStylesheet(this.getFile("globalVariablesTest.xsl"), false);
        TestStylesheet.assertNotNull((String)"Model failed to load, returned NULL", (Object)stylesheet);
        TestStylesheet.assertEquals((String)"Wrong version number returned.", (String)"1.0", (String)stylesheet.getVersion());
    }

    public void testXSLT2GetVersion() {
        Stylesheet stylesheet = this.builder.getStylesheet(this.getFile("XSLT20Test.xsl"), false);
        TestStylesheet.assertNotNull((String)"Model failed to load, returned NULL", (Object)stylesheet);
        TestStylesheet.assertEquals((String)"Wrong version number returned.", (String)"2.0", (String)stylesheet.getVersion());
    }

    public void testGetAttributes() {
        Stylesheet stylesheet = this.builder.getStylesheet(this.getFile("globalVariablesTest.xsl"), false);
        TestStylesheet.assertNotNull((String)"Model failed to load, returned NULL", (Object)stylesheet);
        Map attributeList = stylesheet.getAttributes();
        TestStylesheet.assertEquals((String)"Incorrect number of attributes", (int)4, (int)attributeList.size());
        XSLAttribute attribute = stylesheet.getAttribute("exclude-result-prefixes");
        TestStylesheet.assertEquals((String)"Wrong attribute returned:", (String)"exclude-result-prefixes", (String)attribute.getName());
    }

    public void testGetFunction() {
        Stylesheet stylesheet = this.builder.getStylesheet(this.getFile("XSLT20FunctionTest.xsl"), false);
        TestStylesheet.assertNotNull((String)"Model failed to load, returned NULL", (Object)stylesheet);
        List functionList = stylesheet.getFunctions();
        TestStylesheet.assertEquals((String)"Wrong number of global variables returned.", (int)2, (int)functionList.size());
    }

    public void testGetFunctionFunc1() {
        Stylesheet stylesheet = this.builder.getStylesheet(this.getFile("XSLT20FunctionTest.xsl"), false);
        TestStylesheet.assertNotNull((String)"Model failed to load, returned NULL", (Object)stylesheet);
        List functionList = stylesheet.getFunctions();
        for (Function function : functionList) {
            if (!function.getName().equals("func1")) continue;
            return;
        }
        TestStylesheet.fail((String)"Did not find XSL func func1");
    }
}

