/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.project.facet.ui.internal;

import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.common.project.facet.core.JavaFacetInstallConfig;
import org.eclipse.jst.common.project.facet.ui.internal.FacetedProjectFrameworkJavaExtUiPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.wst.common.project.facet.core.util.IEventListener;
import org.eclipse.wst.common.project.facet.core.util.internal.ObjectReference;
import org.eclipse.wst.common.project.facet.ui.AbstractFacetWizardPage;
import org.eclipse.wst.common.project.facet.ui.internal.util.GridLayoutUtil;

public final class JavaFacetInstallPage
extends AbstractFacetWizardPage {
    private static final String WIZARD_PAGE_NAME = "java.facet.install.page";
    private static final String IMG_KEY_SOURCE_FOLDER = "source.folder";
    private JavaFacetInstallConfig installConfig = null;
    private ImageRegistry imageRegistry = null;
    private Text defaultOutputFolderTextField = null;
    private TreeViewer sourceFoldersTreeViewer = null;
    private Tree sourceFoldersTree = null;
    private Button addButton = null;
    private Button editButton = null;
    private Button removeButton = null;

    public JavaFacetInstallPage() {
        super(WIZARD_PAGE_NAME);
        this.setTitle(Resources.pageTitle);
        this.setDescription(Resources.pageDescription);
        this.setImageDescriptor(FacetedProjectFrameworkJavaExtUiPlugin.getImageDescriptor("images/java-wizban.png"));
        this.imageRegistry = new ImageRegistry();
        this.imageRegistry.put(IMG_KEY_SOURCE_FOLDER, FacetedProjectFrameworkJavaExtUiPlugin.getImageDescriptor("images/source-folder.gif"));
    }

    public JavaFacetInstallConfig getConfig() {
        return this.installConfig;
    }

    public void setConfig(Object config) {
        this.installConfig = (JavaFacetInstallConfig)config;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)GridLayoutUtil.gdfill());
        composite.setLayout((Layout)GridLayoutUtil.gl((int)2));
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                JavaFacetInstallPage.this.handleDisposeEvent();
            }
        });
        Label sourceFoldersLabel = new Label(composite, 0);
        sourceFoldersLabel.setLayoutData((Object)GridLayoutUtil.gdhspan((GridData)GridLayoutUtil.gd(), (int)2));
        sourceFoldersLabel.setText(Resources.sourceFoldersLabel);
        this.sourceFoldersTreeViewer = new TreeViewer(composite, 2048);
        this.sourceFoldersTree = this.sourceFoldersTreeViewer.getTree();
        this.sourceFoldersTree.setLayoutData((Object)GridLayoutUtil.gdfill());
        this.sourceFoldersTree.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent event) {
                if (event.childID == -1) {
                    event.result = Resources.sourceFoldersAccessibilityLabel;
                }
            }
        });
        this.sourceFoldersTreeViewer.setContentProvider((IContentProvider)new SourceFoldersContentProvider());
        this.sourceFoldersTreeViewer.setLabelProvider((IBaseLabelProvider)new SourceFoldersLabelProvider());
        this.sourceFoldersTreeViewer.setInput(new Object());
        this.sourceFoldersTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                JavaFacetInstallPage.this.updateButtonEnablement();
            }
        });
        this.installConfig.addListener((IEventListener)new IEventListener<JavaFacetInstallConfig.ChangeEvent>(){

            public void handleEvent(JavaFacetInstallConfig.ChangeEvent event) {
                JavaFacetInstallPage.this.sourceFoldersTreeViewer.refresh();
            }
        }, new JavaFacetInstallConfig.ChangeEvent.Type[]{JavaFacetInstallConfig.ChangeEvent.Type.SOURCE_FOLDERS_CHANGED});
        Composite buttons = new Composite(composite, 0);
        buttons.setLayoutData((Object)GridLayoutUtil.gdvalign((GridData)GridLayoutUtil.gd(), (int)128));
        buttons.setLayout((Layout)GridLayoutUtil.glmargins((GridLayout)GridLayoutUtil.gl((int)1), (int)0, (int)0));
        this.addButton = new Button(buttons, 8);
        this.addButton.setText(Resources.addFolderButton);
        GridDataFactory.defaultsFor((Control)this.addButton).applyTo((Control)this.addButton);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JavaFacetInstallPage.this.handleAddButtonPressed();
            }
        });
        this.editButton = new Button(buttons, 8);
        this.editButton.setText(Resources.editButton);
        GridDataFactory.defaultsFor((Control)this.editButton).applyTo((Control)this.editButton);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JavaFacetInstallPage.this.handleEditButtonPressed();
            }
        });
        this.removeButton = new Button(buttons, 8);
        this.removeButton.setText(Resources.removeButton);
        GridDataFactory.defaultsFor((Control)this.removeButton).applyTo((Control)this.removeButton);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JavaFacetInstallPage.this.handleRemoveButtonPressed();
            }
        });
        this.updateButtonEnablement();
        Label defaultOutputFolderLabel = new Label(composite, 0);
        defaultOutputFolderLabel.setLayoutData((Object)GridLayoutUtil.gdhspan((GridData)GridLayoutUtil.gd(), (int)2));
        defaultOutputFolderLabel.setText(Resources.defaultOutputFolderLabel);
        this.defaultOutputFolderTextField = new Text(composite, 2048);
        this.defaultOutputFolderTextField.setLayoutData((Object)GridLayoutUtil.gdhspan((GridData)GridLayoutUtil.gdhfill(), (int)2));
        this.bindUiToModel();
        this.setControl((Control)composite);
    }

    private void bindUiToModel() {
        this.bindDefaultOutputFolder();
    }

    private void bindDefaultOutputFolder() {
        final JavaFacetInstallConfig installConfig = this.installConfig;
        final Text defaultOutputFolderTextField = this.defaultOutputFolderTextField;
        final ObjectReference updating = new ObjectReference((Object)false);
        this.defaultOutputFolderTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (((Boolean)updating.get()).booleanValue()) {
                    return;
                }
                updating.set((Object)true);
                try {
                    String newValue = defaultOutputFolderTextField.getText();
                    installConfig.setDefaultOutputFolder((IPath)new Path(newValue));
                }
                finally {
                    updating.set((Object)false);
                }
            }
        });
        IEventListener<JavaFacetInstallConfig.ChangeEvent> modelEventListener = new IEventListener<JavaFacetInstallConfig.ChangeEvent>(){

            public void handleEvent(JavaFacetInstallConfig.ChangeEvent event) {
                if (((Boolean)updating.get()).booleanValue()) {
                    return;
                }
                updating.set((Object)true);
                try {
                    String newValue = JavaFacetInstallPage.this.convertToString(installConfig.getDefaultOutputFolder());
                    defaultOutputFolderTextField.setText(newValue);
                }
                finally {
                    updating.set((Object)false);
                }
            }
        };
        this.installConfig.addListener((IEventListener)modelEventListener, new JavaFacetInstallConfig.ChangeEvent.Type[]{JavaFacetInstallConfig.ChangeEvent.Type.DEFAULT_OUTPUT_FOLDER_CHANGED});
        modelEventListener.handleEvent(null);
    }

    private ImageRegistry getImageRegistry() {
        return this.imageRegistry;
    }

    private IPath getSelectedSourceFolder() {
        IStructuredSelection sel = (IStructuredSelection)this.sourceFoldersTreeViewer.getSelection();
        return (IPath)sel.getFirstElement();
    }

    private String convertToString(IPath path) {
        return path == null ? "" : path.toOSString();
    }

    private void updateButtonEnablement() {
        boolean haveSelection = !this.sourceFoldersTreeViewer.getSelection().isEmpty();
        this.editButton.setEnabled(haveSelection);
        this.removeButton.setEnabled(haveSelection);
    }

    private void handleAddButtonPressed() {
        InputDialog dialog = new InputDialog(this.addButton.getShell(), Resources.addSourceFolderDialogTitle, Resources.addSourceFolderDialogMessage, null, this.createSourceFolderInputValidator());
        if (dialog.open() == 0) {
            String path = dialog.getValue();
            this.installConfig.addSourceFolder((IPath)new Path(path));
        }
    }

    private void handleEditButtonPressed() {
        IPath selectedSourceFolder = this.getSelectedSourceFolder();
        InputDialog dialog = new InputDialog(this.addButton.getShell(), Resources.editSourceFolderDialogTitle, Resources.editSourceFolderDialogMessage, selectedSourceFolder.toOSString(), this.createSourceFolderInputValidator());
        if (dialog.open() == 0) {
            Path newSourceFolder = new Path(dialog.getValue());
            ArrayList<Path> sourceFolders = new ArrayList<Path>(this.installConfig.getSourceFolders());
            int position = sourceFolders.indexOf(selectedSourceFolder);
            sourceFolders.set(position, newSourceFolder);
            this.installConfig.setSourceFolders(sourceFolders);
        }
    }

    private void handleRemoveButtonPressed() {
        IPath selectedSourceFolder = this.getSelectedSourceFolder();
        this.installConfig.removeSourceFolder(selectedSourceFolder);
    }

    private void handleDisposeEvent() {
        this.imageRegistry.dispose();
    }

    private IInputValidator createSourceFolderInputValidator() {
        IInputValidator validator = new IInputValidator(){

            public String isValid(String newText) {
                IStatus status = JavaFacetInstallPage.this.getConfig().validateSourceFolder(newText);
                if (!status.isOK()) {
                    return status.getMessage();
                }
                return null;
            }
        };
        return validator;
    }

    private static final class Resources
    extends NLS {
        public static String pageTitle;
        public static String pageDescription;
        public static String defaultOutputFolderLabel;
        public static String sourceFoldersLabel;
        public static String sourceFoldersAccessibilityLabel;
        public static String addFolderButton;
        public static String editButton;
        public static String removeButton;
        public static String addSourceFolderDialogTitle;
        public static String addSourceFolderDialogMessage;
        public static String editSourceFolderDialogTitle;
        public static String editSourceFolderDialogMessage;

        static {
            Resources.initializeMessages((String)JavaFacetInstallPage.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }

    private final class SourceFoldersContentProvider
    implements ITreeContentProvider {
        private SourceFoldersContentProvider() {
        }

        public Object[] getElements(Object element) {
            return JavaFacetInstallPage.this.getConfig().getSourceFolders().toArray();
        }

        public Object[] getChildren(Object parent) {
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldObject, Object newObject) {
        }
    }

    private final class SourceFoldersLabelProvider
    implements ILabelProvider {
        private SourceFoldersLabelProvider() {
        }

        public String getText(Object element) {
            return ((IPath)element).toOSString();
        }

        public Image getImage(Object element) {
            return JavaFacetInstallPage.this.getImageRegistry().get(JavaFacetInstallPage.IMG_KEY_SOURCE_FOLDER);
        }

        public boolean isLabelProperty(Object obj, String s) {
            return false;
        }

        public void dispose() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

