/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.tests.resources;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import junit.framework.Assert;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.jst.jsf.common.internal.resource.ContentTypeResolver;
import org.eclipse.jst.jsf.common.internal.resource.DefaultJarLocator;
import org.eclipse.jst.jsf.common.internal.resource.IJarLocator;
import org.eclipse.jst.jsf.common.internal.resource.JavaCoreMediator;
import org.eclipse.jst.jsf.designtime.internal.resources.IJSFResourceFragment;
import org.eclipse.jst.jsf.designtime.internal.resources.JarBasedJSFResourceLocator;
import org.eclipse.jst.jsf.test.util.junit4.NoPluginEnvironment;
import org.eclipse.jst.jsf.test.util.mock.MockContentTypeManager;
import org.eclipse.jst.jsf.test.util.mock.MockFile;
import org.eclipse.jst.jsf.test.util.mock.MockProject;
import org.eclipse.jst.jsf.test.util.mock.MockWorkspaceContext;
import org.eclipse.jst.jsf.test.util.mock.java.MockJDTWorkspaceContext;
import org.eclipse.jst.jsf.test.util.mock.java.MockJavaCoreMediator;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NoPluginEnvironment.class})
public class TestJarBasedJSFResourceLocator {
    private IJarLocator _jarProvider;
    private JarBasedJSFResourceLocator _locator;
    private MockJDTWorkspaceContext _jdtContext;
    private MockWorkspaceContext _wsContext;
    private MockProject _project;
    private MockFile _jarIFile;

    @Before
    public void setUp() {
        this._wsContext = new MockWorkspaceContext();
        this._project = this._wsContext.createProject("TestProject");
        File jarFile = new File("./testdata/jsfResources.jar");
        Assert.assertTrue((boolean)jarFile.exists());
        this._jdtContext = new MockJDTWorkspaceContext(this._wsContext);
        this._jdtContext.createCPELibraryInProject(this._project, (IPath)new Path("/WebContent/WEB-INF/lib/jsfResources.jar"), jarFile);
        this._jarProvider = new DefaultJarLocator((JavaCoreMediator)new MockJavaCoreMediator(this._jdtContext));
        this._locator = new JarBasedJSFResourceLocator(Collections.EMPTY_LIST, new CopyOnWriteArrayList(), this._jarProvider, new ContentTypeResolver((IContentTypeManager)new MockContentTypeManager()));
    }

    @Test
    public void testLocate() {
        this._locator.start((IProject)this._project);
        List foundResources = (List)this._locator.locate((Object)this._project);
        Assert.assertEquals((int)2, (int)foundResources.size());
        HashSet<String> foundResourceIds = new HashSet<String>();
        for (IJSFResourceFragment res : foundResources) {
            foundResourceIds.add(res.getId().toString());
        }
        Assert.assertTrue((boolean)foundResourceIds.contains("mylib"));
        Assert.assertTrue((boolean)foundResourceIds.contains("mylib/tag1.xhtml"));
    }
}

