/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.test;

import org.eclipse.gef.commands.Command;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationCaseType;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationRuleType;
import org.eclipse.jst.jsf.facesconfig.emf.ToViewIdType;
import org.eclipse.jst.jsf.facesconfig.ui.FacesConfigEditor;
import org.eclipse.jst.jsf.facesconfig.ui.page.IntroductionPage;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.command.AddConnectionCommand;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.command.AddNodeCommand;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.command.DeleteConnectionCommand;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.command.DeleteNodeCommand;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.command.ReconnectConnectionCommand;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.Pageflow;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowFactory;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowLink;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowNode;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowPage;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.synchronization.TransformUtil;
import org.eclipse.jst.jsf.facesconfig.ui.test.FacesConfigEditorTest;
import org.eclipse.ui.actions.ActionFactory;

public class PageflowEditorTest
extends FacesConfigEditorTest {
    private static final String LIST_JSP = "/list.jsp";
    private static final String INDEX_JSP = "/index.jsp";
    private static final String INDEX1_JSP = "/index1.jsp";

    protected void setUp() throws Exception {
        super.setUp();
        this.editor.setActiveEditorPage("org.eclipse.jst.jsf.facesconfig.ui.pageflow.PageflowEditor");
    }

    public void testAddElements() {
        this.editor.setActiveEditorPage("org.eclipse.jst.jsf.facesconfig.ui.pageflow.PageflowEditor");
        Pageflow pageflow = this.getPageflow();
        PageflowPage source = this.createPage(INDEX_JSP);
        PageflowEditorTest.assertTrue((boolean)pageflow.getNodes().contains((Object)source));
        PageflowPage target = this.createPage(LIST_JSP);
        PageflowEditorTest.assertTrue((boolean)pageflow.getNodes().contains((Object)target));
        PageflowLink link = this.createLink(source, target);
        PageflowEditorTest.assertTrue((boolean)pageflow.getLinks().contains((Object)link));
        FacesConfigType facesConfig = this.getFacesConfig();
        NavigationRuleType rule = (NavigationRuleType)facesConfig.getNavigationRule().get(0);
        NavigationCaseType caseType = (NavigationCaseType)rule.getNavigationCase().get(0);
        PageflowEditorTest.assertTrue((boolean)rule.getFromViewId().getTextContent().equals(INDEX_JSP));
        PageflowEditorTest.assertTrue((boolean)caseType.getToViewId().getTextContent().equals(LIST_JSP));
    }

    private PageflowLink createLink(PageflowPage source, PageflowPage target) {
        AddConnectionCommand connectionCommand = new AddConnectionCommand();
        connectionCommand.setSource((PageflowNode)source);
        connectionCommand.setTarget((PageflowNode)target);
        PageflowLink link = PageflowFactory.eINSTANCE.createPFLink();
        connectionCommand.setPFLink(link);
        this.editor.getDelegatingCommandStack().execute((Command)connectionCommand);
        return link;
    }

    private PageflowPage createPage(String sourcePath) {
        PageflowPage source = PageflowFactory.eINSTANCE.createPFPage();
        source.setPath(sourcePath);
        AddNodeCommand command = new AddNodeCommand();
        command.setParent(this.getPageflow());
        command.setChild((PageflowNode)source);
        this.editor.getDelegatingCommandStack().execute((Command)command);
        return source;
    }

    private FacesConfigType getFacesConfig() {
        return this.editor.getFacesConfig();
    }

    public void testDeleteNode() {
        this.testAddElements();
        Pageflow pageflow = this.getPageflow();
        DeleteNodeCommand command = new DeleteNodeCommand(pageflow);
        command.setParent(pageflow);
        PageflowPage page = TransformUtil.findPage((String)INDEX_JSP, (Pageflow)pageflow);
        command.setChild((PageflowNode)page);
        command.execute();
        PageflowEditorTest.assertTrue((!pageflow.getNodes().contains((Object)page) ? 1 : 0) != 0);
        PageflowEditorTest.assertTrue((pageflow.getLinks().size() == 0 ? 1 : 0) != 0);
        PageflowEditorTest.assertTrue((this.getFacesConfig().getNavigationRule().size() == 0 ? 1 : 0) != 0);
    }

    public void testDeleteLink() {
        this.testAddElements();
        Pageflow pageflow = this.getPageflow();
        DeleteConnectionCommand command = new DeleteConnectionCommand();
        PageflowPage page = TransformUtil.findPage((String)INDEX_JSP, (Pageflow)pageflow);
        PageflowLink link = (PageflowLink)page.getOutlinks().get(0);
        command.setSource(link.getSource());
        command.setTarget(link.getTarget());
        command.setPFLink(link);
        command.execute();
        PageflowEditorTest.assertTrue((boolean)link.getFCElements().isEmpty());
        PageflowEditorTest.assertTrue((link.eAdapters().size() == 0 ? 1 : 0) != 0);
        PageflowEditorTest.assertTrue((!pageflow.getLinks().contains((Object)link) ? 1 : 0) != 0);
        PageflowEditorTest.assertTrue((pageflow.getLinks().size() == 0 ? 1 : 0) != 0);
        PageflowEditorTest.assertTrue((this.getFacesConfig().getNavigationRule().size() == 0 ? 1 : 0) != 0);
    }

    public void testAddNavigationCase() {
        this.testAddElements();
        NavigationRuleType rule = (NavigationRuleType)this.getFacesConfig().getNavigationRule().get(0);
        rule.getNavigationCase().remove(0);
        PageflowEditorTest.assertTrue((this.getPageflow().getLinks().size() == 0 ? 1 : 0) != 0);
    }

    public void testSetPFProperty() {
        this.testAddElements();
        PageflowPage page = TransformUtil.findPage((String)INDEX_JSP, (Pageflow)this.getPageflow());
        page.setPath(INDEX1_JSP);
        NavigationRuleType rule = (NavigationRuleType)this.getFacesConfig().getNavigationRule().get(0);
        PageflowEditorTest.assertTrue((this.getFacesConfig().getNavigationRule().size() == 1 ? 1 : 0) != 0);
        PageflowEditorTest.assertTrue((boolean)rule.getFromViewId().getTextContent().equals(INDEX1_JSP));
    }

    public void testSetFCProperty() {
        this.testAddElements();
        NavigationRuleType rule = (NavigationRuleType)this.getFacesConfig().getNavigationRule().get(0);
        rule.getFromViewId().setTextContent(INDEX1_JSP);
        PageflowEditorTest.assertTrue((this.getPageflow().getLinks().size() == 1 ? 1 : 0) != 0);
        PageflowEditorTest.assertTrue((boolean)((PageflowPage)((PageflowLink)this.getPageflow().getLinks().get(0)).getSource()).getPath().equals(INDEX1_JSP));
    }

    private Pageflow getPageflow() {
        return this.editor.getPageflowPage().getPageflow();
    }

    public void testChangeLinkTarget() {
        this.testAddElements();
        ReconnectConnectionCommand command = new ReconnectConnectionCommand();
        PageflowPage page = this.createPage(INDEX1_JSP);
        command.setSource((PageflowNode)page);
        PageflowLink link = (PageflowLink)this.getPageflow().getLinks().get(0);
        command.setPFLink(link);
        command.execute();
        NavigationRuleType rule = (NavigationRuleType)this.getFacesConfig().getNavigationRule().get(0);
        Object element1 = link.getSource().getFCElements().getData().get(0);
        Object element2 = link.getTarget().getFCElements().getData().get(0);
        PageflowEditorTest.assertTrue((link.getSource().getFCElements().getData().size() == 1 ? 1 : 0) != 0);
        PageflowEditorTest.assertTrue((link.getTarget().getFCElements().getData().size() == 1 ? 1 : 0) != 0);
        PageflowEditorTest.assertTrue((element1 == rule.getFromViewId() ? 1 : 0) != 0);
        PageflowEditorTest.assertTrue((((ToViewIdType)element2).eContainer().eContainer() == rule ? 1 : 0) != 0);
        PageflowEditorTest.assertTrue((this.getFacesConfig().getNavigationRule().size() == 1 ? 1 : 0) != 0);
        PageflowEditorTest.assertTrue((boolean)rule.getFromViewId().getTextContent().equals(INDEX1_JSP));
    }

    public void testUndo() {
        this.testAddElements();
        Pageflow pageflow = this.getPageflow();
        DeleteConnectionCommand command = new DeleteConnectionCommand();
        PageflowPage page = TransformUtil.findPage((String)INDEX_JSP, (Pageflow)pageflow);
        PageflowLink link = (PageflowLink)page.getOutlinks().get(0);
        command.setPFLink(link);
        this.editor.setActiveEditorPage("org.eclipse.jst.jsf.facesconfig.ui.pageflow.PageflowEditor");
        this.editor.getDelegatingCommandStack().execute((Command)command);
        PageflowEditorTest.assertTrue((this.getFacesConfig().getNavigationRule().size() == 0 ? 1 : 0) != 0);
        PageflowEditorTest.assertTrue((this.getPageflow().getLinks().size() == 0 ? 1 : 0) != 0);
        this.editor.getDelegatingCommandStack().undo();
        PageflowEditorTest.assertTrue((this.getFacesConfig().getNavigationRule().size() == 1 ? 1 : 0) != 0);
        PageflowEditorTest.assertTrue((this.getPageflow().getLinks().size() == 1 ? 1 : 0) != 0);
    }

    public void testRedo() {
        this.testUndo();
        this.editor.getDelegatingCommandStack().redo();
        PageflowEditorTest.assertTrue((this.getFacesConfig().getNavigationRule().size() == 0 ? 1 : 0) != 0);
        PageflowEditorTest.assertTrue((this.getPageflow().getLinks().size() == 0 ? 1 : 0) != 0);
    }

    public void testEditorSwitch() throws Exception {
        this.editor.setFocus();
        this.editor.setActivePage(IntroductionPage.class.getName());
        PageflowEditorTest.assertTrue((this.editor.getActionBarContributor().getActionBars().getGlobalActionHandler(ActionFactory.UNDO.getId()) == null ? 1 : 0) != 0);
        PageflowEditorTest.assertTrue((this.editor.getActionBarContributor().getActionBars().getGlobalActionHandler(ActionFactory.REDO.getId()) == null ? 1 : 0) != 0);
        this.testAddElements();
        this.editor.setActivePage("org.eclipse.jst.jsf.facesconfig.ui.pageflow.PageflowEditor");
        PageflowEditorTest.assertTrue((boolean)this.editor.getActionBarContributor().getActionBars().getGlobalActionHandler(ActionFactory.UNDO.getId()).isEnabled());
        this.editor.setActivePage(IntroductionPage.class.getName());
        PageflowEditorTest.assertTrue((this.editor.getActionBarContributor().getActionBars().getGlobalActionHandler(ActionFactory.UNDO.getId()) == null ? 1 : 0) != 0);
        PageflowEditorTest.assertTrue((this.editor.getActionBarContributor().getActionBars().getGlobalActionHandler(ActionFactory.REDO.getId()) == null ? 1 : 0) != 0);
        FacesConfigEditor anotherEditor = (FacesConfigEditor)this.openWithEditor("WebContent/WEB-INF/faces-config1.xml");
        anotherEditor.setFocus();
        PageflowEditorTest.assertTrue((anotherEditor.getActionBarContributor().getActionBars().getGlobalActionHandler(ActionFactory.UNDO.getId()) == null ? 1 : 0) != 0);
        PageflowEditorTest.assertTrue((anotherEditor.getActionBarContributor().getActionBars().getGlobalActionHandler(ActionFactory.REDO.getId()) == null ? 1 : 0) != 0);
        this.editor.setFocus();
        this.editor.setActiveEditorPage("org.eclipse.jst.jsf.facesconfig.ui.pageflow.PageflowEditor");
        PageflowEditorTest.assertTrue((boolean)this.editor.getActionBarContributor().getActionBars().getGlobalActionHandler(ActionFactory.UNDO.getId()).isEnabled());
    }
}

