/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.servlet.ui.internal.wizard;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.war.ui.util.WebFiltersGroupItemProvider;
import org.eclipse.jst.j2ee.internal.web.operations.FilterMappingItem;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.j2ee.project.WebUtilities;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.jee.ui.internal.navigator.web.GroupFiltersItemProvider;
import org.eclipse.jst.jee.ui.internal.navigator.web.WebAppProvider;
import org.eclipse.jst.servlet.ui.internal.wizard.IWebWizardConstants;
import org.eclipse.jst.servlet.ui.internal.wizard.MultiSelectFilteredFilterFileSelectionDialog;
import org.eclipse.jst.servlet.ui.internal.wizard.NewWebClassWizardPage;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class NewFilterClassWizardPage
extends NewWebClassWizardPage {
    private static final String[] FILTEREXTENSIONS = new String[]{"java"};

    public NewFilterClassWizardPage(IDataModel model, String pageName, String pageDesc, String pageTitle, String moduleType) {
        super(model, pageName, pageDesc, pageTitle, moduleType);
    }

    protected String getUseExistingCheckboxText() {
        return IWebWizardConstants.USE_EXISTING_FILTER_CLASS;
    }

    protected String getUseExistingProperty() {
        return "NewServletClassDataModel.USE_EXISTING_CLASS";
    }

    protected IProject getExtendedSelectedProject(Object selection) {
        if (selection instanceof WebFiltersGroupItemProvider) {
            org.eclipse.jst.j2ee.webapplication.WebApp webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)((WebFiltersGroupItemProvider)selection).getParent();
            return ProjectUtilities.getProject((EObject)webApp);
        }
        if (selection instanceof WebAppProvider) {
            return ((WebAppProvider)selection).getProject();
        }
        if (selection instanceof GroupFiltersItemProvider) {
            WebApp webApp = (WebApp)((GroupFiltersItemProvider)selection).getJavaEEObject();
            return ProjectUtilities.getProject((Object)webApp);
        }
        return super.getExtendedSelectedProject(selection);
    }

    protected void handleClassButtonSelected() {
        this.getControl().setCursor(new Cursor((Device)this.getShell().getDisplay(), 1));
        IProject project = (IProject)this.model.getProperty("NewJavaClassDataModel.PROJECT");
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        MultiSelectFilteredFilterFileSelectionDialog ms = new MultiSelectFilteredFilterFileSelectionDialog(this.getShell(), IWebWizardConstants.NEW_FILTER_WIZARD_WINDOW_TITLE, IWebWizardConstants.CHOOSE_FILTER_CLASS, FILTEREXTENSIONS, false, project);
        IContainer root = component.getRootFolder().getUnderlyingFolder();
        ms.setInput(root);
        ms.open();
        if (ms.getReturnCode() == 0) {
            String qualifiedClassName = "";
            IType type = (IType)ms.getFirstResult();
            if (type != null) {
                qualifiedClassName = type.getFullyQualifiedName();
            }
            this.existingClassText.setText(qualifiedClassName);
        }
        this.getControl().setCursor(null);
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite composite = super.createTopLevelComposite(parent);
        Object obj = this.getSelectedObject();
        if (this.isFilter(obj)) {
            this.checkExistingButton(true);
            this.existingClassText.setText(this.getFilterClass(obj));
        } else if (this.isServlet(obj)) {
            String servletName = this.getServletName(obj);
            this.classText.setText(String.valueOf(this.makeFirstCharUppercase(servletName)) + "Filter");
            if (servletName != null) {
                ArrayList<FilterMappingItem> mappings = new ArrayList<FilterMappingItem>();
                mappings.add(new FilterMappingItem(1, servletName));
                this.model.setProperty("NewFilterClassDataModel.FILTER_MAPPINGS", mappings);
            }
        } else if (this.isWebFolder(obj)) {
            IFolder folder = (IFolder)obj;
            String webFolderName = this.makeFirstCharUppercase(folder.getName());
            this.classText.setText(String.valueOf(webFolderName) + "Filter");
            String webFolderPath = this.getWebResourcePath((IResource)folder);
            ArrayList<FilterMappingItem> mappings = new ArrayList<FilterMappingItem>();
            mappings.add(new FilterMappingItem(0, String.valueOf(webFolderPath) + "/*"));
            this.model.setProperty("NewFilterClassDataModel.FILTER_MAPPINGS", mappings);
        } else if (WebUtilities.isWebResource((Object)obj)) {
            IFile file = (IFile)obj;
            String webResourceName = this.makeFirstCharUppercase(this.getFileNameWithouFileExtension(file));
            this.classText.setText(String.valueOf(webResourceName) + "Filter");
            String webResourcePath = this.getWebResourcePath((IResource)file);
            ArrayList<FilterMappingItem> mappings = new ArrayList<FilterMappingItem>();
            mappings.add(new FilterMappingItem(0, webResourcePath));
            this.model.setProperty("NewFilterClassDataModel.FILTER_MAPPINGS", mappings);
        }
        return composite;
    }

    protected boolean isProjectValid(IProject project) {
        boolean result = super.isProjectValid(project);
        if (!result) {
            return false;
        }
        IProjectFacetVersion facetVersion = JavaEEProjectUtilities.getProjectFacetVersion((IProject)project, (String)"jst.web");
        if (facetVersion == null) {
            return false;
        }
        int version = J2EEVersionUtil.convertVersionStringToInt((String)facetVersion.getVersionString());
        return version > 22;
    }
}

