/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.rhino.tests;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.DebugSession;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.DisconnectedException;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.Request;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.Response;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.TimeoutException;
import org.eclipse.wst.jsdt.debug.rhino.tests.RequestTest;
import org.eclipse.wst.jsdt.debug.rhino.tests.Util;

public class BreakpointRequestTests
extends RequestTest {
    public void testInvalidBreakpoint() throws Exception {
        Request request = new Request("breakpoint");
        request.getArguments().put("breakpointId", new Integer("9999"));
        this.debugSession.sendRequest(request);
        Response response = this.debugSession.receiveResponse(request.getSequence(), 30000);
        BreakpointRequestTests.assertFalse((boolean)response.isSuccess());
    }

    public void testBreakpointsWithNoBreakpoints() throws Exception {
        Request request = new Request("breakpoints");
        this.debugSession.sendRequest(request);
        Response response = this.debugSession.receiveResponse(request.getSequence(), 30000);
        BreakpointRequestTests.assertTrue((boolean)response.isSuccess());
        Collection breakpoints = (Collection)response.getBody().get("breakpoints");
        BreakpointRequestTests.assertNotNull((Object)breakpoints);
        BreakpointRequestTests.assertTrue((boolean)breakpoints.isEmpty());
    }

    public void testClearInvalidBreakpoint() throws Exception {
        Request request = new Request("clearbreakpoint");
        request.getArguments().put("breakpointId", new Integer("9999"));
        this.debugSession.sendRequest(request);
        Response response = this.debugSession.receiveResponse(request.getSequence(), 30000);
        BreakpointRequestTests.assertFalse((boolean)response.isSuccess());
    }

    public void testBreakpoints() throws Exception {
        this.eventHandler.addSubhandler(new RequestTest.SetBreakpointsHandler(this));
        Request request = new Request("breakpoints");
        this.debugSession.sendRequest(request);
        Response response = this.debugSession.receiveResponse(request.getSequence(), 30000);
        BreakpointRequestTests.assertTrue((boolean)response.isSuccess());
        Collection breakpoints = (Collection)response.getBody().get("breakpoints");
        BreakpointRequestTests.assertNotNull((Object)breakpoints);
        BreakpointRequestTests.assertTrue((boolean)breakpoints.isEmpty());
        String script = Util.getTestSource("scripts", "script1.js");
        BreakpointRequestTests.assertNotNull((String)"The test source for [script1.js] must exist", (Object)script);
        this.evalScript(script, 1);
        request = new Request("breakpoints");
        this.debugSession.sendRequest(request);
        response = this.debugSession.receiveResponse(request.getSequence(), 30000);
        BreakpointRequestTests.assertTrue((boolean)response.isSuccess());
        breakpoints = (Collection)response.getBody().get("breakpoints");
        BreakpointRequestTests.assertNotNull((Object)breakpoints);
        BreakpointRequestTests.assertEquals((int)7, (int)breakpoints.size());
        Iterator iterator = breakpoints.iterator();
        while (iterator.hasNext()) {
            Number breakpointId = (Number)iterator.next();
            request = new Request("breakpoint");
            request.getArguments().put("breakpointId", breakpointId);
            this.debugSession.sendRequest(request);
            response = this.debugSession.receiveResponse(request.getSequence(), 30000);
            BreakpointRequestTests.assertTrue((boolean)response.isSuccess());
            Map breakpoint = (Map)response.getBody().get("breakpoint");
            BreakpointRequestTests.assertEquals((int)breakpointId.intValue(), (int)Util.numberAsInt(breakpoint.get("breakpointId")));
            BreakpointRequestTests.assertTrue((boolean)breakpoint.containsKey("scriptId"));
            this.deleteBreakpoint(this.debugSession, breakpointId);
        }
    }

    public void testGetSetClearBreakpoint() throws Exception {
        this.eventHandler.addSubhandler(new RequestTest.SetBreakpointsHandler(this));
        this.eventHandler.addSubhandler(new RequestTest.ClearBreakpointsHandler(this));
        Request request = new Request("breakpoints");
        this.debugSession.sendRequest(request);
        Response response = this.debugSession.receiveResponse(request.getSequence(), 30000);
        BreakpointRequestTests.assertTrue((boolean)response.isSuccess());
        Collection breakpoints = (Collection)response.getBody().get("breakpoints");
        BreakpointRequestTests.assertNotNull((Object)breakpoints);
        BreakpointRequestTests.assertTrue((boolean)breakpoints.isEmpty());
        String script = Util.getTestSource("scripts", "script1.js");
        BreakpointRequestTests.assertNotNull((String)"The test source for [script1.js] must exist", (Object)script);
        this.evalScript(script, 6);
        request = new Request("breakpoints");
        this.debugSession.sendRequest(request);
        response = this.debugSession.receiveResponse(request.getSequence(), 30000);
        BreakpointRequestTests.assertTrue((boolean)response.isSuccess());
        breakpoints = (Collection)response.getBody().get("breakpoints");
        BreakpointRequestTests.assertNotNull((Object)breakpoints);
        BreakpointRequestTests.assertEquals((int)2, (int)breakpoints.size());
        Iterator iterator = breakpoints.iterator();
        while (iterator.hasNext()) {
            Number breakpointId = (Number)iterator.next();
            request = new Request("breakpoint");
            request.getArguments().put("breakpointId", breakpointId);
            this.debugSession.sendRequest(request);
            response = this.debugSession.receiveResponse(request.getSequence(), 30000);
            BreakpointRequestTests.assertTrue((boolean)response.isSuccess());
            Map breakpoint = (Map)response.getBody().get("breakpoint");
            BreakpointRequestTests.assertEquals((int)breakpointId.intValue(), (int)Util.numberAsInt(breakpoint.get("breakpointId")));
            BreakpointRequestTests.assertTrue((boolean)breakpoint.containsKey("scriptId"));
            this.deleteBreakpoint(this.debugSession, breakpointId);
        }
    }

    void deleteBreakpoint(DebugSession session, Number breakpointid) {
        Request request = new Request("clearbreakpoint");
        request.getArguments().put("breakpointId", breakpointid);
        try {
            this.debugSession.sendRequest(request);
            Response response = this.debugSession.receiveResponse(request.getSequence(), 30000);
            BreakpointRequestTests.assertTrue((boolean)response.isSuccess());
        }
        catch (DisconnectedException e) {
            e.printStackTrace();
        }
        catch (TimeoutException e) {
            e.printStackTrace();
        }
    }
}

