/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath.ui.internal.views.tests;

import java.lang.reflect.InvocationTargetException;
import javax.xml.xpath.XPathExpressionException;
import junit.framework.TestCase;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.wst.xml.core.internal.document.DOMModelImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.xpath.core.util.XPathCoreHelper;
import org.eclipse.wst.xml.xpath.ui.internal.hander.tests.StubXPathProcessorHandler;
import org.eclipse.wst.xml.xpath.ui.internal.views.XPathComputer;
import org.eclipse.wst.xml.xpath.ui.internal.views.XPathView;
import org.osgi.service.prefs.Preferences;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class TestXPathComputer
extends TestCase {
    Preferences prefs = null;
    StubXPathProcessorHandler handler = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.prefs = XPathCoreHelper.getPreferences();
        this.prefs.putBoolean("XPATH1.0", false);
        this.prefs.putBoolean("XPATH2.0", false);
        this.prefs.flush();
        this.handler = new StubXPathProcessorHandler();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.prefs = null;
        this.handler = null;
    }

    public Document createSimpleDocument() throws Exception {
        DOMModelImpl domImpl = new DOMModelImpl();
        domImpl.setId("dummy");
        IDOMDocument document = domImpl.getDocument();
        document.appendChild(document.createElement("test"));
        Element rootelem = document.getDocumentElement();
        Element elem1 = document.createElement("testNode1");
        Element elem2 = document.createElement("testNode1");
        rootelem.appendChild(elem1);
        rootelem.appendChild(elem2);
        return document;
    }

    public void testComputeNodeXpath10() throws Exception {
        this.handler.toggleState("xpath10");
        NodeList nl = this.computeXPathInView("string(count(//*)) < '04'", this.createSimpleDocument());
        TestXPathComputer.assertEquals((int)1, (int)nl.getLength());
        TestXPathComputer.assertEquals((String)"true", (String)((Text)nl.item(0)).getTextContent());
    }

    public void testComputeNodeXpath2() throws Exception {
        this.handler.toggleState("xpath2");
        NodeList nl = this.computeXPathInView("'2' > '04'", this.createSimpleDocument());
        TestXPathComputer.assertEquals((int)1, (int)nl.getLength());
        TestXPathComputer.assertEquals((String)"true", (String)((Text)nl.item(0)).getTextContent());
    }

    private NodeList computeXPathInView(String xpathExpression, Node node) throws Exception, XPathExpressionException {
        MockXPathView myMockView = new MockXPathView();
        XPathComputer pathComputer = new XPathComputer((XPathView)myMockView);
        pathComputer.setSelectedNode(node);
        pathComputer.setText(xpathExpression);
        pathComputer.compute();
        NodeList nl = myMockView.getLastList();
        return nl;
    }

    public void testToggleStateXpath2() throws Exception {
        this.handler.toggleState("xpath2");
    }

    private final class MockXPathView
    extends XPathView {
        private NodeList lastList = null;

        private MockXPathView() {
        }

        public NodeList getLastList() {
            return this.lastList;
        }

        protected void xpathRecomputed(NodeList nodeList) {
            this.lastList = nodeList;
        }

        public IWorkbenchPartSite getSite() {
            return new IWorkbenchPartSite(){

                public boolean hasService(Class api) {
                    return IWorkbenchSiteProgressService.class.equals((Object)api);
                }

                public Object getService(Class api) {
                    if (IWorkbenchSiteProgressService.class.equals((Object)api)) {
                        return new IWorkbenchSiteProgressService(){

                            public int getLongOperationTime() {
                                return 0;
                            }

                            public void registerIconForFamily(ImageDescriptor icon, Object family) {
                            }

                            public void runInUI(IRunnableContext context, IRunnableWithProgress runnable, ISchedulingRule rule) throws InvocationTargetException, InterruptedException {
                                runnable.run((IProgressMonitor)new NullProgressMonitor());
                            }

                            public Image getIconFor(Job job) {
                                return null;
                            }

                            public void busyCursorWhile(IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
                            }

                            public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
                                runnable.run((IProgressMonitor)new NullProgressMonitor());
                            }

                            public void showInDialog(Shell shell, Job job) {
                            }

                            public void schedule(Job job, long delay, boolean useHalfBusyCursor) {
                                this.schedule(job, delay);
                            }

                            public void schedule(Job job, long delay) {
                                job.schedule(delay);
                                try {
                                    job.join();
                                }
                                catch (InterruptedException interruptedException) {}
                            }

                            public void schedule(Job job) {
                                job.schedule();
                            }

                            public void showBusyForFamily(Object family) {
                            }

                            public void warnOfContentChange() {
                            }

                            public void incrementBusy() {
                            }

                            public void decrementBusy() {
                            }
                        };
                    }
                    return null;
                }

                public Object getAdapter(Class adapter) {
                    return null;
                }

                public void setSelectionProvider(ISelectionProvider provider) {
                }

                public IWorkbenchWindow getWorkbenchWindow() {
                    return null;
                }

                public Shell getShell() {
                    return null;
                }

                public ISelectionProvider getSelectionProvider() {
                    return null;
                }

                public IWorkbenchPage getPage() {
                    return null;
                }

                public void registerContextMenu(String menuId, MenuManager menuManager, ISelectionProvider selectionProvider) {
                }

                public void registerContextMenu(MenuManager menuManager, ISelectionProvider selectionProvider) {
                }

                public String getRegisteredName() {
                    return null;
                }

                public String getPluginId() {
                    return null;
                }

                public IWorkbenchPart getPart() {
                    return null;
                }

                public IKeyBindingService getKeyBindingService() {
                    return null;
                }

                public String getId() {
                    return null;
                }
            };
        }
    }
}

