/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.function;

import java.util.ArrayList;
import java.util.Collection;
import java.util.ListIterator;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.SeqType;
import org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSInteger;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSString;

public class FnCodepointsToString
extends Function {
    private static Collection _expected_args = null;
    public static final int MIN_LEGAL_CODEPOINT = 1;
    public static final int MAX_LEGAL_CODEPOINT = 0x10FFFF;

    public FnCodepointsToString() {
        super(new QName("codepoints-to-string"), 1);
    }

    public ResultSequence evaluate(Collection args) throws DynamicError {
        return FnCodepointsToString.codepoints_to_string(args);
    }

    public static ResultSequence codepoints_to_string(Collection args) throws DynamicError {
        Collection cargs = Function.convert_arguments(args, FnCodepointsToString.expected_args());
        ResultSequence rs = ResultSequenceFactory.create_new();
        ResultSequence arg1 = (ResultSequence)cargs.iterator().next();
        if (arg1.empty()) {
            rs.add(new XSString(""));
            return rs;
        }
        int[] codePointArray = new int[arg1.size()];
        int codePointIndex = 0;
        ListIterator i = arg1.iterator();
        while (i.hasNext()) {
            XSInteger code = (XSInteger)i.next();
            int codepoint = code.int_value().intValue();
            if (codepoint < 1 || codepoint > 0x10FFFF) {
                throw DynamicError.unsupported_codepoint("U+" + Integer.toString(codepoint, 16).toUpperCase());
            }
            codePointArray[codePointIndex] = codepoint;
            ++codePointIndex;
        }
        try {
            String str = new String(codePointArray, 0, codePointArray.length);
            rs.add(new XSString(str));
        }
        catch (IllegalArgumentException iae) {
            throw DynamicError.unsupported_codepoint(iae.getMessage());
        }
        return rs;
    }

    public static synchronized Collection expected_args() {
        if (_expected_args == null) {
            _expected_args = new ArrayList();
            _expected_args.add(new SeqType(new XSInteger(), 1));
        }
        return _expected_args;
    }
}

