/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.testsuite.schema;

import java.net.URL;
import org.apache.xerces.xs.XSModel;
import org.eclipse.wst.xml.xpath2.processor.DefaultDynamicContext;
import org.eclipse.wst.xml.xpath2.processor.DefaultEvaluator;
import org.eclipse.wst.xml.xpath2.processor.DynamicContext;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.StaticError;
import org.eclipse.wst.xml.xpath2.processor.XPathParserException;
import org.eclipse.wst.xml.xpath2.processor.ast.XPath;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.XPathNode;
import org.eclipse.wst.xml.xpath2.processor.test.AbstractPsychoPathTest;

public class CatalogTest
extends AbstractPsychoPathTest {
    public void test_Catalog001() throws Exception {
        String inputFile = "/XQTSCatalog.xml";
        String xqFile = "/Queries/XQuery/Catalog/Catalog001.xq";
        String resultFile = "/ExpectedTestResults/Catalog/Catalog001.xml";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "for $x in $input-context//*:input-file[count(@variable) = 0 and ./text() != \"emptydoc\"] return string($x/../@name)";
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = "<missing-variable>" + this.buildXMLResultString(rs) + "</missing-variable>";
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        this.assertXMLEqual("XPath Result Error " + xqFile + ":", expectedResult, actual);
    }

    public void test_Catalog002() throws Exception {
        String inputFile = "/XQTSCatalog.xml";
        String xqFile = "/Queries/XQuery/Catalog/Catalog002.xq";
        String resultFile = "/ExpectedTestResults/Catalog/Catalog002.xml";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "$input-context//*:test-case[@scenario = \"standard\"][fn:count(*:output-file) = 0]/@name/string()";
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = "<standard-no-outputfile>" + this.buildXMLResultString(rs) + "</standard-no-outputfile>";
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        this.assertXMLEqual("XPath Result Error " + xqFile + ":", expectedResult, actual);
    }

    public void test_Catalog003() throws Exception {
        String inputFile = "/XQTSCatalog.xml";
        String xqFile = "/Queries/XQuery/Catalog/Catalog003.xq";
        String resultFile = "/ExpectedTestResults/Catalog/Catalog003.xml";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        DefaultDynamicContext dc = this.setupDynamicContext(schema);
        String xpath = "$input-context//*:test-case[@scenario = \"runtime-error\" or @scenario = \"parse-error\"][fn:count(*:expected-error) = 0 and fn:count(*:output-file[@compare = \"Inspect\"]) = 0]/@name/string()";
        String actual = null;
        try {
            XPath path = this.compileXPath((DynamicContext)dc, xpath);
            DefaultEvaluator eval = new DefaultEvaluator((DynamicContext)dc, this.domDoc);
            ResultSequence rs = eval.evaluate((XPathNode)path);
            actual = "<error-no-expected-error>" + this.buildXMLResultString(rs) + "</error-no-expected-error>";
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        this.assertXMLEqual("XPath Result Error " + xqFile + ":", expectedResult, actual);
    }
}

