/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jpt.utility.internal.iterators.ReadOnlyIterator;
import org.eclipse.jpt.utility.internal.model.value.AbstractCollectionValueModel;
import org.eclipse.jpt.utility.model.event.ListAddEvent;
import org.eclipse.jpt.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.utility.model.event.ListClearEvent;
import org.eclipse.jpt.utility.model.event.ListMoveEvent;
import org.eclipse.jpt.utility.model.event.ListRemoveEvent;
import org.eclipse.jpt.utility.model.event.ListReplaceEvent;
import org.eclipse.jpt.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListCollectionValueModelAdapter<E>
extends AbstractCollectionValueModel
implements CollectionValueModel<E> {
    protected final ListValueModel<? extends E> listHolder;
    protected final ListChangeListener listChangeListener;
    protected final ArrayList<E> collection;

    public ListCollectionValueModelAdapter(ListValueModel<? extends E> listHolder) {
        if (listHolder == null) {
            throw new NullPointerException();
        }
        this.listHolder = listHolder;
        this.listChangeListener = this.buildListChangeListener();
        this.collection = new ArrayList();
    }

    protected ListChangeListener buildListChangeListener() {
        return new ListChangeListener(){

            public void itemsAdded(ListAddEvent event) {
                ListCollectionValueModelAdapter.this.itemsAdded(event);
            }

            public void itemsRemoved(ListRemoveEvent event) {
                ListCollectionValueModelAdapter.this.itemsRemoved(event);
            }

            public void itemsReplaced(ListReplaceEvent event) {
                ListCollectionValueModelAdapter.this.itemsReplaced(event);
            }

            public void itemsMoved(ListMoveEvent event) {
                ListCollectionValueModelAdapter.this.itemsMoved(event);
            }

            public void listCleared(ListClearEvent event) {
                ListCollectionValueModelAdapter.this.listCleared(event);
            }

            public void listChanged(ListChangeEvent event) {
                ListCollectionValueModelAdapter.this.listChanged(event);
            }

            public String toString() {
                return "list change listener";
            }
        };
    }

    @Override
    public Iterator<E> iterator() {
        return new ReadOnlyIterator<E>(this.collection);
    }

    @Override
    public int size() {
        return this.collection.size();
    }

    @Override
    protected void engageModel() {
        this.listHolder.addListChangeListener("list values", this.listChangeListener);
        this.buildCollection();
    }

    @Override
    protected void disengageModel() {
        this.listHolder.removeListChangeListener("list values", this.listChangeListener);
        this.collection.clear();
    }

    protected void itemsAdded(ListAddEvent event) {
        this.addItemsToCollection(this.getItems(event), this.collection, "values");
    }

    protected Iterable<E> getItems(ListAddEvent event) {
        return event.getItems();
    }

    protected void itemsRemoved(ListRemoveEvent event) {
        this.removeItemsFromCollection(this.getItems(event), this.collection, "values");
    }

    protected Iterable<E> getItems(ListRemoveEvent event) {
        return event.getItems();
    }

    protected void itemsReplaced(ListReplaceEvent event) {
        this.removeItemsFromCollection(this.getOldItems(event), this.collection, "values");
        this.addItemsToCollection(this.getNewItems(event), this.collection, "values");
    }

    protected Iterable<E> getOldItems(ListReplaceEvent event) {
        return event.getOldItems();
    }

    protected Iterable<E> getNewItems(ListReplaceEvent event) {
        return event.getNewItems();
    }

    protected void itemsMoved(ListMoveEvent event) {
    }

    protected void listCleared(ListClearEvent event) {
        if (!this.collection.isEmpty()) {
            this.collection.clear();
            this.fireCollectionCleared("values");
        }
    }

    protected void listChanged(ListChangeEvent event) {
        if (this.listHolder.size() == 0) {
            if (!this.collection.isEmpty()) {
                this.clearCollection(this.collection, "values");
            }
        } else if (this.collection.isEmpty()) {
            this.buildCollection();
            this.fireItemsAdded("values", this.collection);
        } else {
            this.collection.clear();
            this.buildCollection();
            this.fireCollectionChanged("values", this.collection);
        }
    }

    protected void buildCollection() {
        int size = this.listHolder.size();
        if (size != 0) {
            this.buildCollection(size);
        }
    }

    protected void buildCollection(int size) {
        this.collection.ensureCapacity(size);
        for (E each : this.listHolder) {
            this.collection.add(each);
        }
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(this.collection);
    }
}

