/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jpt.core.internal.utility.jdt.JDTTools;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaGenerator {
    public static String LAUNCH_CONFIG_NAME = "JAXB Schema Gen Run Config";
    public static String JAXB_SCHEMA_GEN_PACKAGE_NAME = "org.eclipse.jpt.jaxb.core.schemagen";
    public static String JAXB_SCHEMA_GEN_CLASS = String.valueOf(JAXB_SCHEMA_GEN_PACKAGE_NAME) + ".Main";
    public static String ECLIPSELINK_JAXB_SCHEMA_GEN_PACKAGE_NAME = "org.eclipse.jpt.eclipselink.jaxb.core.schemagen";
    public static String ECLIPSELINK_JAXB_SCHEMA_GEN_CLASS = String.valueOf(ECLIPSELINK_JAXB_SCHEMA_GEN_PACKAGE_NAME) + ".Main";
    public static String ECLIPSELINK_JAXB_CONTEXT_FACTORY = "org.eclipse.persistence.jaxb.JAXBContextFactory";
    public static String ECLIPSELINK_JAXB_PROPERTIES_FILE_CONTENTS = "javax.xml.bind.context.factory=" + ECLIPSELINK_JAXB_CONTEXT_FACTORY;
    public static String JAXB_PROPERTIES_FILE_NAME = "jaxb.properties";
    public static String JAXB_SCHEMA_GEN_JAR = String.valueOf(JAXB_SCHEMA_GEN_PACKAGE_NAME) + "_";
    public static String ECLIPSELINK_JAXB_SCHEMA_GEN_JAR = String.valueOf(ECLIPSELINK_JAXB_SCHEMA_GEN_PACKAGE_NAME) + "_";
    public static String JAXB_GENERIC_SCHEMA_GEN_CLASS = "javax.xml.bind.JAXBContext";
    public static String JAXB_ECLIPSELINK_SCHEMA_GEN_CLASS = "org.eclipse.persistence.jaxb.JAXBContext";
    public static String PLUGINS_DIR = "plugins/";
    private IVMInstall jre;
    private ILaunchConfigurationWorkingCopy launchConfig;
    private ILaunch launch;
    private final IJavaProject javaProject;
    private final String targetSchemaName;
    private final String[] sourceClassNames;
    private String mainType;
    private boolean useMoxy;
    private final boolean isDebug = false;

    public static void generate(IJavaProject javaProject, String targetSchemaName, String[] sourceClassNames, boolean useMoxy, IProgressMonitor monitor) {
        if (javaProject == null) {
            throw new NullPointerException();
        }
        new SchemaGenerator(javaProject, targetSchemaName, sourceClassNames, useMoxy, monitor).generate();
    }

    protected SchemaGenerator(IJavaProject javaProject, String targetSchemaName, String[] sourceClassNames, boolean useMoxy, IProgressMonitor monitor) {
        this.javaProject = javaProject;
        this.targetSchemaName = targetSchemaName;
        this.sourceClassNames = sourceClassNames;
        this.useMoxy = useMoxy;
        this.mainType = this.useMoxy ? ECLIPSELINK_JAXB_SCHEMA_GEN_CLASS : JAXB_SCHEMA_GEN_CLASS;
        this.initialize();
    }

    protected void initialize() {
        try {
            this.jre = this.getProjectJRE();
            if (this.jre == null) {
                String message = "Could not identify the VM.";
                throw new RuntimeException(message);
            }
            this.launchConfig = this.buildLaunchConfiguration();
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    protected void generate() {
        if (this.useMoxy) {
            if (!this.isJaxbPropertiesFilePresent()) {
                this.generateJaxbPropertiesFile();
            } else if (!this.isJaxbContextMoxy(this.getJaxbPropertiesFile())) {
                this.useMoxy = false;
                this.mainType = JAXB_SCHEMA_GEN_CLASS;
            }
        }
        String projectLocation = this.getProject().getLocation().toString();
        this.initializeLaunchConfiguration(projectLocation);
        this.addLaunchListener();
        this.launch = this.saveAndLaunchConfig();
    }

    private IFile getJaxbPropertiesFile() {
        return this.getJaxbPropertiesFileFromPackageRoots(JDTTools.getJavaSourceFolders((IJavaProject)this.javaProject));
    }

    private IFile getJaxbPropertiesFileFromPackageRoots(Iterable<IPackageFragmentRoot> packageFragmentRoots) {
        Object[] objects = null;
        try {
            for (IPackageFragmentRoot pfr : packageFragmentRoots) {
                IJavaElement[] javaElements;
                IJavaElement[] iJavaElementArray = javaElements = pfr.getChildren();
                int n = javaElements.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaElement javaElement = iJavaElementArray[n2];
                    Object[] objectArray = objects = ((IPackageFragment)javaElement).getNonJavaResources();
                    int n3 = objects.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Object object = objectArray[n4];
                        IResource resource = (IResource)object;
                        if (resource.getName().equals(JAXB_PROPERTIES_FILE_NAME)) {
                            return (IFile)resource;
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
        }
        catch (JavaModelException jme) {
            throw new RuntimeException(jme);
        }
        return null;
    }

    private boolean isJaxbPropertiesFilePresent() {
        return this.getJaxbPropertiesFile() != null;
    }

    private boolean isJaxbContextMoxy(IFile propertyFile) {
        InputStream in = null;
        try {
            in = propertyFile.getContents();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            String line = reader.readLine();
            String propertyValue = line.substring(line.indexOf("=") + 1);
            if (propertyValue.equals(ECLIPSELINK_JAXB_CONTEXT_FACTORY)) {
                return true;
            }
        }
        catch (CoreException ce) {
            throw new RuntimeException(ce);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
        }
        return false;
    }

    private void generateJaxbPropertiesFile() {
        byte[] bytes;
        IPackageFragment packageFragment = this.findPackageFragementForSourceClassName(this.sourceClassNames[0]);
        IFolder folder = (IFolder)packageFragment.getResource();
        IFile file = folder.getFile("jaxb.properties");
        try {
            bytes = ECLIPSELINK_JAXB_PROPERTIES_FILE_CONTENTS.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        ByteArrayInputStream contents = new ByteArrayInputStream(bytes);
        try {
            file.create((InputStream)contents, 0, null);
        }
        catch (CoreException ce) {
            throw new RuntimeException(ce);
        }
    }

    private IPackageFragment findPackageFragementForSourceClassName(String sourceClassName) {
        String packageName = sourceClassName.substring(0, sourceClassName.lastIndexOf(46));
        for (IPackageFragmentRoot pfr : JDTTools.getJavaSourceFolders((IJavaProject)this.javaProject)) {
            IPackageFragment packageFragment = pfr.getPackageFragment(packageName);
            if (!packageFragment.exists()) continue;
            return packageFragment;
        }
        throw new IllegalStateException("Java package must exist for source class");
    }

    private void initializeLaunchConfiguration(String projectLocation) {
        this.specifyJRE(this.jre.getName(), this.jre.getVMInstallType().getId());
        this.specifyProject(this.getProject().getName());
        this.specifyMainType(this.mainType);
        this.specifyProgramArguments(this.targetSchemaName, this.sourceClassNames);
        this.specifyWorkingDir(projectLocation);
        String jarName = this.useMoxy ? ECLIPSELINK_JAXB_SCHEMA_GEN_JAR : JAXB_SCHEMA_GEN_JAR;
        this.specifyClasspathProperties(this.javaProject, this.buildBootstrapJarPath(jarName));
    }

    protected void postGenerate() {
        try {
            this.removeLaunchConfiguration(LAUNCH_CONFIG_NAME);
            this.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    private void specifyClasspathProperties(IJavaProject javaProject, IPath bootstrapJar) {
        ArrayList<String> classpath = new ArrayList<String>();
        try {
            classpath.add(this.getArchiveClasspathEntry(bootstrapJar).getMemento());
            classpath.add(this.getDefaultProjectClasspathEntry(javaProject).getMemento());
            classpath.add(this.getSystemLibraryClasspathEntry().getMemento());
        }
        catch (CoreException e) {
            throw new RuntimeException("An error occurs generating a memento", e);
        }
        this.launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, classpath);
        this.launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
    }

    private void specifyJRE(String jreName, String vmId) {
        this.launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, jreName);
        this.launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, vmId);
    }

    private void specifyProject(String projectName) {
        this.launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, projectName);
    }

    private void specifyMainType(String mainType) {
        this.launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, mainType);
    }

    private void specifyProgramArguments(String targetSchemaName, String[] sourceClassNames) {
        StringBuffer programArguments = new StringBuffer();
        StringBuffer sourceClassNamesArguments = this.buildClassNamesArguments(sourceClassNames);
        programArguments.append(sourceClassNamesArguments);
        programArguments.append(" -s \"");
        programArguments.append(targetSchemaName);
        programArguments.append('\"');
        this.launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, programArguments.toString());
    }

    private StringBuffer buildClassNamesArguments(String[] sourceClassNames) {
        StringBuffer classNamesArguments = new StringBuffer();
        String[] stringArray = sourceClassNames;
        int n = sourceClassNames.length;
        int n2 = 0;
        while (n2 < n) {
            String className = stringArray[n2];
            classNamesArguments.append(" -c ");
            classNamesArguments.append(className);
            ++n2;
        }
        return classNamesArguments;
    }

    private void specifyWorkingDir(String projectLocation) {
        File workingDir = new Path(projectLocation).toFile();
        this.launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, workingDir.getAbsolutePath());
    }

    private ILaunchConfigurationWorkingCopy buildLaunchConfiguration() throws CoreException {
        ILaunchConfigurationWorkingCopy launchConfig = null;
        this.removeLaunchConfiguration(LAUNCH_CONFIG_NAME);
        ILaunchManager manager = this.getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
        launchConfig = type.newInstance(null, LAUNCH_CONFIG_NAME);
        return launchConfig;
    }

    private void removeLaunchConfiguration(String launchConfigurationName) throws CoreException {
        ILaunchManager manager = this.getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
        ILaunchConfiguration[] configurations = manager.getLaunchConfigurations(type);
        int i = 0;
        while (i < configurations.length) {
            ILaunchConfiguration configuration = configurations[i];
            if (configuration.getName().equals(launchConfigurationName)) {
                configuration.delete();
                break;
            }
            ++i;
        }
    }

    private ILaunch saveAndLaunchConfig() {
        ILaunchConfiguration configuration = null;
        ILaunch result = null;
        try {
            configuration = this.launchConfig.doSave();
        }
        catch (CoreException saveException) {
            throw new RuntimeException("Could not save LaunchConfig", saveException);
        }
        try {
            result = configuration.launch("run", (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException lauchException) {
            throw new RuntimeException("An error occured during launch", lauchException);
        }
        return result;
    }

    private void addLaunchListener() {
        this.getLaunchManager().addLaunchListener((ILaunchesListener)this.buildLaunchListener());
    }

    private ILaunchesListener2 buildLaunchListener() {
        return new ILaunchesListener2(){

            public void launchesTerminated(ILaunch[] launches) {
                int i = 0;
                while (i < launches.length) {
                    ILaunch launch = launches[i];
                    if (launch.equals(SchemaGenerator.this.getLaunch())) {
                        SchemaGenerator.this.postGenerate();
                        return;
                    }
                    ++i;
                }
            }

            public void launchesAdded(ILaunch[] launches) {
            }

            public void launchesChanged(ILaunch[] launches) {
            }

            public void launchesRemoved(ILaunch[] launches) {
            }
        };
    }

    private IRuntimeClasspathEntry getSystemLibraryClasspathEntry() throws CoreException {
        Path systemLibsPath = new Path(JavaRuntime.JRE_CONTAINER);
        return JavaRuntime.newRuntimeContainerClasspathEntry((IPath)systemLibsPath, (int)1);
    }

    private IRuntimeClasspathEntry getArchiveClasspathEntry(IPath archivePath) {
        IRuntimeClasspathEntry archiveEntry = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)archivePath);
        archiveEntry.setClasspathProperty(3);
        return archiveEntry;
    }

    private IRuntimeClasspathEntry getDefaultProjectClasspathEntry(IJavaProject project) {
        IRuntimeClasspathEntry projectEntry = JavaRuntime.newDefaultProjectClasspathEntry((IJavaProject)project);
        projectEntry.setClasspathProperty(3);
        return projectEntry;
    }

    public IProject getProject() {
        return this.javaProject.getProject();
    }

    private IVMInstall getProjectJRE() throws CoreException {
        return JavaRuntime.getVMInstall((IJavaProject)this.javaProject);
    }

    protected ILaunch getLaunch() {
        return this.launch;
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    private IPath buildBootstrapJarPath(String jarName) {
        try {
            File jarInstallDir = this.getBundleParentDir("org.eclipse.jpt.jaxb.ui");
            ArrayList result = new ArrayList();
            this.findFile(jarName, jarInstallDir, result);
            if (result.isEmpty()) {
                throw new RuntimeException("Could not find: " + jarName + "#.#.#v###.jar in: " + jarInstallDir);
            }
            File ddlGenJarFile = (File)result.get(0);
            String ddlGenJarPath = ddlGenJarFile.getCanonicalPath();
            return new Path(ddlGenJarPath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void findFile(String fileName, File directory, List<? super File> list) {
        if (directory.listFiles() == null) {
            throw new RuntimeException("Could not find directory: " + directory);
        }
        File[] fileArray = directory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().startsWith(fileName)) {
                list.add(file);
            }
            if (file.isDirectory()) {
                this.findFile(fileName, file, list);
            }
            ++n2;
        }
    }

    private File getBundleParentDir(String bundleName) throws IOException {
        if (Platform.inDevelopmentMode()) {
            Location eclipseHomeLoc = Platform.getInstallLocation();
            String eclipseHome = eclipseHomeLoc.getURL().getPath();
            if (!eclipseHome.endsWith(PLUGINS_DIR)) {
                eclipseHome = String.valueOf(eclipseHome) + PLUGINS_DIR;
            }
            return new File(eclipseHome);
        }
        Bundle bundle = Platform.getBundle((String)bundleName);
        return FileLocator.getBundleFile((Bundle)bundle).getParentFile();
    }
}

