/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jpt.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.MemberAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleTypeStringExpressionConverter;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.core.utility.jdt.Type;
import org.eclipse.jpt.eclipselink.core.resource.java.EclipseLinkCustomizerAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceEclipseLinkCustomizerAnnotation
extends SourceAnnotation<Type>
implements EclipseLinkCustomizerAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("org.eclipse.persistence.annotations.Customizer");
    private static final DeclarationAnnotationElementAdapter<String> VALUE_ADAPTER = SourceEclipseLinkCustomizerAnnotation.buildValueAdapter();
    private final AnnotationElementAdapter<String> valueAdapter;
    private String value;
    private String fullyQualifiedCustomizerClassName;

    public SourceEclipseLinkCustomizerAnnotation(JavaResourcePersistentType parent, Type type) {
        super((JavaResourceNode)parent, (Member)type, DECLARATION_ANNOTATION_ADAPTER);
        this.valueAdapter = new MemberAnnotationElementAdapter((Member)type, VALUE_ADAPTER);
    }

    public String getAnnotationName() {
        return "org.eclipse.persistence.annotations.Customizer";
    }

    public void initialize(CompilationUnit astRoot) {
        this.value = this.buildValue(astRoot);
        this.fullyQualifiedCustomizerClassName = this.buildFullyQualifiedCustomizerClassName(astRoot);
    }

    public void synchronizeWith(CompilationUnit astRoot) {
        this.syncValue(this.buildValue(astRoot));
        this.syncFullyQualifiedCustomizerClassName(this.buildFullyQualifiedCustomizerClassName(astRoot));
    }

    public void toString(StringBuilder sb) {
        sb.append(this.value);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        if (this.attributeValueHasChanged(this.value, value)) {
            this.value = value;
            this.valueAdapter.setValue((Object)value);
        }
    }

    private void syncValue(String astValue) {
        String old = this.value;
        this.value = astValue;
        this.firePropertyChanged("value", old, astValue);
    }

    private String buildValue(CompilationUnit astRoot) {
        return (String)this.valueAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getValueTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(VALUE_ADAPTER, astRoot);
    }

    @Override
    public boolean customizerClassImplementsInterface(String interfaceName, CompilationUnit astRoot) {
        return this.value != null && ASTTools.typeIsSubTypeOf((Expression)this.valueAdapter.getExpression(astRoot), (String)interfaceName);
    }

    @Override
    public String getFullyQualifiedCustomizerClassName() {
        return this.fullyQualifiedCustomizerClassName;
    }

    private void syncFullyQualifiedCustomizerClassName(String name) {
        String old = this.fullyQualifiedCustomizerClassName;
        this.fullyQualifiedCustomizerClassName = name;
        this.firePropertyChanged("fullyQualifiedCustomizerClassName", old, name);
    }

    private String buildFullyQualifiedCustomizerClassName(CompilationUnit astRoot) {
        return this.value == null ? null : ASTTools.resolveFullyQualifiedName((Expression)this.valueAdapter.getExpression(astRoot));
    }

    private static DeclarationAnnotationElementAdapter<String> buildValueAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "value", false, SimpleTypeStringExpressionConverter.instance());
    }
}

