/*******************************************************************************
 * Copyright (c) 2008, 2010 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0, which accompanies this distribution
 * and is available at http://www.eclipse.org/legal/epl-v10.html.
 * 
 * Contributors:
 *     Oracle - initial API and implementation
 ******************************************************************************/
package org.eclipse.jpt.core.context.orm;

import org.eclipse.jpt.core.context.JoinColumn;
import org.eclipse.jpt.core.resource.orm.XmlJoinColumn;

/**
 * orm.xml join column
 * 
 * Provisional API: This interface is part of an interim API that is still
 * under development and expected to change significantly before reaching
 * stability. It is available at this early stage to solicit feedback from
 * pioneering adopters on the understanding that any code that uses this API
 * will almost certainly be broken (repeatedly) as the API evolves.
 * 
 * @version 2.3
 * @since 2.0
 */
public interface OrmJoinColumn
	extends JoinColumn, OrmBaseJoinColumn, OrmBaseColumn
{
	/**
	 * Initialize the join column from the specified old join column.
	 */
	void initializeFrom(JoinColumn oldJoinColumn);
	
	/**
	 * Update the join column from the specified XML.
	 * @see org.eclipse.jpt.core.JpaProject#update()
	 */
	void update(XmlJoinColumn xmlJoinColumn);

	interface Owner
		extends JoinColumn.Owner, OrmBaseJoinColumn.Owner, OrmBaseColumn.Owner
	{
		// nothing?
	}

}
