/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Vector;
import junit.framework.TestCase;
import org.eclipse.jpt.utility.internal.ClassName;
import org.eclipse.jpt.utility.internal.ReflectionTools;

public class ClassNameTests
extends TestCase {
    public ClassNameTests(String name) {
        super(name);
    }

    public void testIsArray() {
        ClassNameTests.assertFalse((boolean)ClassName.isArray((String)Integer.TYPE.getName()));
        ClassNameTests.assertTrue((boolean)ClassName.isArray((String)int[].class.getName()));
        ClassNameTests.assertTrue((boolean)ClassName.isArray((String)int[][].class.getName()));
        ClassNameTests.assertFalse((boolean)ClassName.isArray((String)String.class.getName()));
        ClassNameTests.assertTrue((boolean)ClassName.isArray((String)String[].class.getName()));
        ClassNameTests.assertTrue((boolean)ClassName.isArray((String)String[][].class.getName()));
    }

    public void testGetElementTypeName() {
        ClassNameTests.assertEquals((String)Vector.class.getName(), (String)ClassName.getElementTypeName((String)Vector.class.getName()));
        ClassNameTests.assertEquals((String)Integer.TYPE.getName(), (String)ClassName.getElementTypeName((String)Integer.TYPE.getName()));
        ClassNameTests.assertEquals((String)Void.TYPE.getName(), (String)ClassName.getElementTypeName((String)Void.TYPE.getName()));
        ClassNameTests.assertEquals((String)Vector.class.getName(), (String)ClassName.getElementTypeName((String)Vector[].class.getName()));
        ClassNameTests.assertEquals((String)Integer.TYPE.getName(), (String)ClassName.getElementTypeName((String)int[].class.getName()));
        ClassNameTests.assertEquals((String)Vector.class.getName(), (String)ClassName.getElementTypeName((String)Vector[][][].class.getName()));
        ClassNameTests.assertEquals((String)Integer.TYPE.getName(), (String)ClassName.getElementTypeName((String)int[][][].class.getName()));
    }

    public void testGetArrayDepth() {
        ClassNameTests.assertEquals((int)0, (int)ClassName.getArrayDepth((String)Vector.class.getName()));
        ClassNameTests.assertEquals((int)0, (int)ClassName.getArrayDepth((String)Integer.TYPE.getName()));
        ClassNameTests.assertEquals((int)0, (int)ClassName.getArrayDepth((String)Void.TYPE.getName()));
        ClassNameTests.assertEquals((int)1, (int)ClassName.getArrayDepth((String)Vector[].class.getName()));
        ClassNameTests.assertEquals((int)1, (int)ClassName.getArrayDepth((String)int[].class.getName()));
        ClassNameTests.assertEquals((int)3, (int)ClassName.getArrayDepth((String)Vector[][][].class.getName()));
        ClassNameTests.assertEquals((int)3, (int)ClassName.getArrayDepth((String)int[][][].class.getName()));
    }

    public void testGetComponentTypeName() {
        ClassNameTests.assertEquals(null, (String)ClassName.getComponentTypeName((String)Object.class.getName()));
        ClassNameTests.assertEquals((String)Object.class.getName(), (String)ClassName.getComponentTypeName((String)Object[].class.getName()));
        ClassNameTests.assertEquals((String)Object[].class.getName(), (String)ClassName.getComponentTypeName((String)Object[][].class.getName()));
        ClassNameTests.assertEquals(null, (String)ClassName.getComponentTypeName((String)Integer.TYPE.getName()));
        ClassNameTests.assertEquals((String)Integer.TYPE.getName(), (String)ClassName.getComponentTypeName((String)int[].class.getName()));
        ClassNameTests.assertEquals((String)int[].class.getName(), (String)ClassName.getComponentTypeName((String)int[][].class.getName()));
    }

    public void testGetSimpleName() throws Exception {
        ClassNameTests.assertEquals((String)"Object", (String)ClassName.getSimpleName((String)Object.class.getName()));
        ClassNameTests.assertEquals((String)"Object[]", (String)ClassName.getSimpleName((String)Object[].class.getName()));
        ClassNameTests.assertEquals((String)"Object[][]", (String)ClassName.getSimpleName((String)Object[][].class.getName()));
        ClassNameTests.assertEquals((String)Map.class.getSimpleName(), (String)ClassName.getSimpleName((String)Map.class.getName()));
        ClassNameTests.assertEquals((String)Map.Entry.class.getSimpleName(), (String)ClassName.getSimpleName((String)Map.Entry.class.getName()));
        ClassNameTests.assertEquals((String)"int", (String)ClassName.getSimpleName((String)Integer.TYPE.getName()));
        ClassNameTests.assertEquals((String)"int[]", (String)ClassName.getSimpleName((String)int[].class.getName()));
        ClassNameTests.assertEquals((String)"int[][]", (String)ClassName.getSimpleName((String)int[][].class.getName()));
        Object anonObject = new Object(){};
        ClassNameTests.assertEquals((String)"", (String)ClassName.getSimpleName((String)anonObject.getClass().getName()));
        class Local {
            Local() {
            }
        }
        Local localObject = new Local();
        ClassNameTests.assertEquals((String)"Local", (String)ClassName.getSimpleName((String)localObject.getClass().getName()));
    }

    public void testGetPackageName() throws Exception {
        ClassNameTests.assertEquals((String)Object.class.getPackage().getName(), (String)ClassName.getPackageName((String)Object.class.getName()));
        ClassNameTests.assertEquals((String)"", (String)ClassName.getPackageName((String)Object[].class.getName()));
        ClassNameTests.assertEquals((String)"", (String)ClassName.getPackageName((String)Object[][].class.getName()));
        ClassNameTests.assertEquals((String)Map.class.getPackage().getName(), (String)ClassName.getPackageName((String)Map.class.getName()));
        ClassNameTests.assertEquals((String)Map.Entry.class.getPackage().getName(), (String)ClassName.getPackageName((String)Map.Entry.class.getName()));
        ClassNameTests.assertEquals((String)"", (String)ClassName.getPackageName((String)Integer.TYPE.getName()));
        ClassNameTests.assertEquals((String)"", (String)ClassName.getPackageName((String)int[].class.getName()));
        ClassNameTests.assertEquals((String)"", (String)ClassName.getPackageName((String)int[][].class.getName()));
        ClassNameTests.assertEquals((String)"", (String)ClassName.getPackageName((String)Void.TYPE.getName()));
        Object anonObject = new Object(){};
        ClassNameTests.assertEquals((String)anonObject.getClass().getPackage().getName(), (String)ClassName.getPackageName((String)anonObject.getClass().getName()));
    }

    public void testIsTopLevel() throws Exception {
        ClassNameTests.assertTrue((boolean)ClassName.isTopLevel((String)Map.class.getName()));
        ClassNameTests.assertFalse((boolean)ClassName.isTopLevel((String)Map.Entry.class.getName()));
        ClassNameTests.assertFalse((boolean)ClassName.isTopLevel((String)Class.forName(String.valueOf(((Object)((Object)this)).getClass().getName()) + "$1LocalClass").getName()));
        ClassNameTests.assertFalse((boolean)ClassName.isTopLevel((String)Class.forName("java.util.Vector$1").getName()));
        Object[] array = new Map[]{};
        ClassNameTests.assertFalse((boolean)ClassName.isTopLevel((String)array.getClass().getName()));
        array = new Map.Entry[]{};
        ClassNameTests.assertFalse((boolean)ClassName.isTopLevel((String)array.getClass().getName()));
        Class<?> localClass = Class.forName(String.valueOf(((Object)((Object)this)).getClass().getName()) + "$1LocalClass");
        array = (Object[])Array.newInstance(localClass, 0);
        ClassNameTests.assertFalse((boolean)ClassName.isTopLevel((String)array.getClass().getName()));
        Class<?> anonClass = Class.forName("java.util.Vector$1");
        array = (Object[])Array.newInstance(anonClass, 0);
        ClassNameTests.assertFalse((boolean)ClassName.isTopLevel((String)array.getClass().getName()));
    }

    public void testIsMember() throws Exception {
        ClassNameTests.assertFalse((boolean)ClassName.isMember((String)Map.class.getName()));
        ClassNameTests.assertTrue((boolean)ClassName.isMember((String)Map.Entry.class.getName()));
        ClassNameTests.assertFalse((boolean)ClassName.isMember((String)Class.forName(String.valueOf(((Object)((Object)this)).getClass().getName()) + "$1LocalClass").getName()));
        ClassNameTests.assertFalse((boolean)ClassName.isMember((String)Class.forName("java.util.Vector$1").getName()));
        Object[] array = new Map[]{};
        ClassNameTests.assertFalse((boolean)ClassName.isMember((String)array.getClass().getName()));
        array = new Map.Entry[]{};
        ClassNameTests.assertFalse((boolean)ClassName.isMember((String)array.getClass().getName()));
        Class<?> localClass = Class.forName(String.valueOf(((Object)((Object)this)).getClass().getName()) + "$1LocalClass");
        array = (Object[])Array.newInstance(localClass, 0);
        ClassNameTests.assertFalse((boolean)ClassName.isMember((String)array.getClass().getName()));
        Class<?> anonClass = Class.forName("java.util.Vector$1");
        array = (Object[])Array.newInstance(anonClass, 0);
        ClassNameTests.assertFalse((boolean)ClassName.isMember((String)array.getClass().getName()));
        ClassNameTests.assertTrue((boolean)ClassName.isMember((String)"java.util.Map$a1"));
        ClassNameTests.assertTrue((boolean)ClassName.isMember((String)"java.util.Map$1aa$aaa"));
        ClassNameTests.assertTrue((boolean)ClassName.isMember((String)"java.util.Map$1$aaa"));
        ClassNameTests.assertTrue((boolean)ClassName.isMember((String)"java.util.Map$a1$aaa$bbb"));
        ClassNameTests.assertTrue((boolean)ClassName.isMember((String)"java.util.Map$1a1$aaa"));
        ClassNameTests.assertFalse((boolean)ClassName.isMember((String)"java.util.Map$1a"));
        ClassNameTests.assertTrue((boolean)ClassName.isMember((String)"java.util.Map$a12345$b12345"));
        ClassNameTests.assertFalse((boolean)ClassName.isMember((String)"java.util.Map$12345a"));
        ClassNameTests.assertFalse((boolean)ClassName.isMember((String)"java.util.Map$333"));
        ClassNameTests.assertFalse((boolean)ClassName.isMember((String)"java.util.Map3$333"));
    }

    public void testIsLocal() throws Exception {
        class LocalClass {
            LocalClass() {
            }

            void foo() {
                System.getProperty("foo");
            }
        }
        new LocalClass().foo();
        ClassNameTests.assertFalse((boolean)ClassName.isLocal((String)Map.class.getName()));
        ClassNameTests.assertFalse((boolean)ClassName.isLocal((String)Map.Entry.class.getName()));
        ClassNameTests.assertTrue((boolean)ClassName.isLocal((String)Class.forName(String.valueOf(((Object)((Object)this)).getClass().getName()) + "$1LocalClass").getName()));
        ClassNameTests.assertFalse((boolean)ClassName.isLocal((String)Class.forName("java.util.Vector$1").getName()));
        Object[] array = new Map[]{};
        ClassNameTests.assertFalse((boolean)ClassName.isLocal((String)array.getClass().getName()));
        array = new Map.Entry[]{};
        ClassNameTests.assertFalse((boolean)ClassName.isLocal((String)array.getClass().getName()));
        Class<?> localClass = Class.forName(String.valueOf(((Object)((Object)this)).getClass().getName()) + "$1LocalClass");
        array = (Object[])Array.newInstance(localClass, 0);
        ClassNameTests.assertFalse((boolean)ClassName.isLocal((String)array.getClass().getName()));
        Class<?> anonClass = Class.forName("java.util.Vector$1");
        array = (Object[])Array.newInstance(anonClass, 0);
        ClassNameTests.assertFalse((boolean)ClassName.isLocal((String)array.getClass().getName()));
        ClassNameTests.assertFalse((boolean)ClassName.isLocal((String)"java.util.Map$a1"));
        ClassNameTests.assertFalse((boolean)ClassName.isLocal((String)"java.util.Map$a1$aaa$bbb"));
        ClassNameTests.assertFalse((boolean)ClassName.isLocal((String)"java.util.Map$11$aaa"));
        ClassNameTests.assertTrue((boolean)ClassName.isLocal((String)"java.util.Map$1a"));
        ClassNameTests.assertTrue((boolean)ClassName.isLocal((String)"java.util.Map$2abc"));
        ClassNameTests.assertTrue((boolean)ClassName.isLocal((String)"java.util.Map$2abc1"));
        ClassNameTests.assertFalse((boolean)ClassName.isLocal((String)"java.util.Map$a12345$b12345"));
        ClassNameTests.assertTrue((boolean)ClassName.isLocal((String)"java.util.Map$12345$1234a"));
        ClassNameTests.assertFalse((boolean)ClassName.isLocal((String)"java.util.Map$333"));
        ClassNameTests.assertFalse((boolean)ClassName.isLocal((String)"java.util.Map3$333"));
    }

    public void testIsAnonymous() throws Exception {
        ClassNameTests.assertFalse((boolean)ClassName.isAnonymous((String)Map.class.getName()));
        ClassNameTests.assertFalse((boolean)ClassName.isAnonymous((String)Map.Entry.class.getName()));
        ClassNameTests.assertFalse((boolean)ClassName.isAnonymous((String)Class.forName(String.valueOf(((Object)((Object)this)).getClass().getName()) + "$1LocalClass").getName()));
        ClassNameTests.assertTrue((boolean)ClassName.isAnonymous((String)Class.forName("java.util.Vector$1").getName()));
        Object[] array = new Map[]{};
        ClassNameTests.assertFalse((boolean)ClassName.isAnonymous((String)array.getClass().getName()));
        array = new Map.Entry[]{};
        ClassNameTests.assertFalse((boolean)ClassName.isAnonymous((String)array.getClass().getName()));
        Class<?> localClass = Class.forName(String.valueOf(((Object)((Object)this)).getClass().getName()) + "$1LocalClass");
        array = (Object[])Array.newInstance(localClass, 0);
        ClassNameTests.assertFalse((boolean)ClassName.isAnonymous((String)array.getClass().getName()));
        Class<?> anonClass = Class.forName("java.util.Vector$1");
        array = (Object[])Array.newInstance(anonClass, 0);
        ClassNameTests.assertFalse((boolean)ClassName.isAnonymous((String)array.getClass().getName()));
        ClassNameTests.assertFalse((boolean)ClassName.isAnonymous((String)"java.util.Map$a1"));
        ClassNameTests.assertFalse((boolean)ClassName.isAnonymous((String)"java.util.Map$a1$aaa$bbb"));
        ClassNameTests.assertFalse((boolean)ClassName.isAnonymous((String)"java.util.Map$1a1$aaa"));
        ClassNameTests.assertFalse((boolean)ClassName.isAnonymous((String)"java.util.Map$1$a"));
        ClassNameTests.assertFalse((boolean)ClassName.isAnonymous((String)"java.util.Map$1a"));
        ClassNameTests.assertFalse((boolean)ClassName.isAnonymous((String)"java.util.Map$a12345$b12345"));
        ClassNameTests.assertFalse((boolean)ClassName.isAnonymous((String)"java.util.Map$12345$a1234"));
        ClassNameTests.assertTrue((boolean)ClassName.isAnonymous((String)"java.util.Map$333"));
        ClassNameTests.assertTrue((boolean)ClassName.isAnonymous((String)"java.util.Map3$333"));
    }

    public void testIsReference() throws Exception {
        ClassNameTests.assertFalse((boolean)ClassName.isReference((String)Integer.TYPE.getName()));
        ClassNameTests.assertTrue((boolean)ClassName.isReference((String)Map.class.getName()));
        ClassNameTests.assertTrue((boolean)ClassName.isReference((String)Map.Entry.class.getName()));
        ClassNameTests.assertTrue((boolean)ClassName.isReference((String)Class.forName(String.valueOf(((Object)((Object)this)).getClass().getName()) + "$1LocalClass").getName()));
        ClassNameTests.assertTrue((boolean)ClassName.isReference((String)Class.forName("java.util.Vector$1").getName()));
        Object[] array = new Map[]{};
        ClassNameTests.assertTrue((boolean)ClassName.isReference((String)array.getClass().getName()));
        array = new Map.Entry[]{};
        ClassNameTests.assertTrue((boolean)ClassName.isReference((String)array.getClass().getName()));
        Class<?> localClass = Class.forName(String.valueOf(((Object)((Object)this)).getClass().getName()) + "$1LocalClass");
        array = (Object[])Array.newInstance(localClass, 0);
        ClassNameTests.assertTrue((boolean)ClassName.isReference((String)array.getClass().getName()));
        Class<?> anonClass = Class.forName("java.util.Vector$1");
        array = (Object[])Array.newInstance(anonClass, 0);
        ClassNameTests.assertTrue((boolean)ClassName.isReference((String)array.getClass().getName()));
    }

    public void testIsPrimitive() {
        ClassNameTests.assertTrue((boolean)Void.TYPE.isPrimitive());
        ClassNameTests.assertTrue((boolean)ClassName.isPrimitive((String)Void.TYPE.getName()));
        ClassNameTests.assertTrue((boolean)ClassName.isPrimitive((String)Integer.TYPE.getName()));
        ClassNameTests.assertTrue((boolean)ClassName.isPrimitive((String)Float.TYPE.getName()));
        ClassNameTests.assertTrue((boolean)ClassName.isPrimitive((String)Boolean.TYPE.getName()));
        ClassNameTests.assertFalse((boolean)ClassName.isPrimitive((String)Number.class.getName()));
        ClassNameTests.assertFalse((boolean)ClassName.isPrimitive((String)String.class.getName()));
        ClassNameTests.assertFalse((boolean)ClassName.isPrimitive((String)Boolean.class.getName()));
        ClassNameTests.assertFalse((boolean)ClassName.isPrimitive((String)Integer.class.getName()));
    }

    public void testIsPrimitiveWrapper() {
        ClassNameTests.assertFalse((boolean)ClassName.isPrimitiveWrapper((String)Void.TYPE.getName()));
        ClassNameTests.assertFalse((boolean)ClassName.isPrimitiveWrapper((String)Integer.TYPE.getName()));
        ClassNameTests.assertFalse((boolean)ClassName.isPrimitiveWrapper((String)Float.TYPE.getName()));
        ClassNameTests.assertFalse((boolean)ClassName.isPrimitiveWrapper((String)Boolean.TYPE.getName()));
        ClassNameTests.assertFalse((boolean)ClassName.isPrimitiveWrapper((String)Field.class.getName()));
        ClassNameTests.assertFalse((boolean)ClassName.isPrimitiveWrapper((String)String.class.getName()));
        ClassNameTests.assertTrue((boolean)ClassName.isPrimitiveWrapper((String)Boolean.class.getName()));
        ClassNameTests.assertTrue((boolean)ClassName.isPrimitiveWrapper((String)Integer.class.getName()));
    }

    public void testIsVariablePrimitive() {
        ClassNameTests.assertFalse((boolean)ClassName.isVariablePrimitive((String)Void.TYPE.getName()));
        ClassNameTests.assertTrue((boolean)ClassName.isVariablePrimitive((String)Integer.TYPE.getName()));
        ClassNameTests.assertTrue((boolean)ClassName.isVariablePrimitive((String)Float.TYPE.getName()));
        ClassNameTests.assertTrue((boolean)ClassName.isVariablePrimitive((String)Boolean.TYPE.getName()));
        ClassNameTests.assertFalse((boolean)ClassName.isVariablePrimitive((String)Number.class.getName()));
        ClassNameTests.assertFalse((boolean)ClassName.isVariablePrimitive((String)String.class.getName()));
        ClassNameTests.assertFalse((boolean)ClassName.isVariablePrimitive((String)Boolean.class.getName()));
    }

    public void testIsVariablePrimitiveWrapper() {
        ClassNameTests.assertFalse((boolean)ClassName.isVariablePrimitiveWrapper((String)Void.class.getName()));
        ClassNameTests.assertTrue((boolean)ClassName.isVariablePrimitiveWrapper((String)Integer.class.getName()));
        ClassNameTests.assertTrue((boolean)ClassName.isVariablePrimitiveWrapper((String)Float.class.getName()));
        ClassNameTests.assertTrue((boolean)ClassName.isVariablePrimitiveWrapper((String)Boolean.class.getName()));
        ClassNameTests.assertFalse((boolean)ClassName.isVariablePrimitiveWrapper((String)Number.class.getName()));
        ClassNameTests.assertFalse((boolean)ClassName.isVariablePrimitiveWrapper((String)String.class.getName()));
        ClassNameTests.assertFalse((boolean)ClassName.isVariablePrimitiveWrapper((String)Object.class.getName()));
    }

    public void testGetWrapperClassName() {
        ClassNameTests.assertEquals((String)Void.class.getName(), (String)ClassName.getWrapperClassName((String)Void.TYPE.getName()));
        ClassNameTests.assertEquals((String)Integer.class.getName(), (String)ClassName.getWrapperClassName((String)Integer.TYPE.getName()));
        ClassNameTests.assertEquals((String)Float.class.getName(), (String)ClassName.getWrapperClassName((String)Float.TYPE.getName()));
        ClassNameTests.assertEquals((String)Boolean.class.getName(), (String)ClassName.getWrapperClassName((String)Boolean.TYPE.getName()));
        ClassNameTests.assertNull((Object)ClassName.getWrapperClassName((String)String.class.getName()));
    }

    public void testGetPrimitiveClassName() {
        ClassNameTests.assertEquals((String)Void.TYPE.getName(), (String)ClassName.getPrimitiveClassName((String)Void.class.getName()));
        ClassNameTests.assertEquals((String)Integer.TYPE.getName(), (String)ClassName.getPrimitiveClassName((String)Integer.class.getName()));
        ClassNameTests.assertEquals((String)Float.TYPE.getName(), (String)ClassName.getPrimitiveClassName((String)Float.class.getName()));
        ClassNameTests.assertEquals((String)Boolean.TYPE.getName(), (String)ClassName.getPrimitiveClassName((String)Boolean.class.getName()));
        ClassNameTests.assertNull((Object)ClassName.getPrimitiveClassName((String)String.class.getName()));
    }

    public void testAreAutoboxEquivalents() {
        ClassNameTests.assertTrue((boolean)ClassName.areAutoboxEquivalents((String)Integer.class.getName(), (String)Integer.class.getName()));
        ClassNameTests.assertTrue((boolean)ClassName.areAutoboxEquivalents((String)Integer.TYPE.getName(), (String)Integer.class.getName()));
        ClassNameTests.assertTrue((boolean)ClassName.areAutoboxEquivalents((String)Integer.class.getName(), (String)Integer.TYPE.getName()));
        ClassNameTests.assertFalse((boolean)ClassName.areAutoboxEquivalents((String)Integer.TYPE.getName(), (String)Boolean.class.getName()));
        ClassNameTests.assertTrue((boolean)ClassName.areAutoboxEquivalents((String)String.class.getName(), (String)String.class.getName()));
    }

    public void testForCode() {
        ClassNameTests.assertEquals((String)"byte", (String)ClassName.forCode((char)'B'));
        ClassNameTests.assertEquals((String)"char", (String)ClassName.forCode((char)'C'));
        ClassNameTests.assertEquals((String)"double", (String)ClassName.forCode((char)'D'));
        ClassNameTests.assertEquals((String)"float", (String)ClassName.forCode((char)'F'));
        ClassNameTests.assertEquals((String)"int", (String)ClassName.forCode((char)'I'));
        ClassNameTests.assertEquals((String)"long", (String)ClassName.forCode((char)'J'));
        ClassNameTests.assertEquals((String)"short", (String)ClassName.forCode((char)'S'));
        ClassNameTests.assertEquals((String)"boolean", (String)ClassName.forCode((char)'Z'));
        ClassNameTests.assertEquals((String)"void", (String)ClassName.forCode((char)'V'));
        ClassNameTests.assertNull((Object)ClassName.forCode((char)'X'));
        ClassNameTests.assertEquals((String)"byte", (String)ClassName.forCode((int)66));
        ClassNameTests.assertEquals((String)"char", (String)ClassName.forCode((int)67));
        ClassNameTests.assertEquals((String)"double", (String)ClassName.forCode((int)68));
        ClassNameTests.assertEquals((String)"float", (String)ClassName.forCode((int)70));
        ClassNameTests.assertEquals((String)"int", (String)ClassName.forCode((int)73));
        ClassNameTests.assertEquals((String)"long", (String)ClassName.forCode((int)74));
        ClassNameTests.assertEquals((String)"short", (String)ClassName.forCode((int)83));
        ClassNameTests.assertEquals((String)"boolean", (String)ClassName.forCode((int)90));
        ClassNameTests.assertEquals((String)"void", (String)ClassName.forCode((int)86));
        ClassNameTests.assertNull((Object)ClassName.forCode((int)88));
    }

    public void testGetCodeForClassName() {
        ClassNameTests.assertEquals((char)'I', (char)ClassName.getCodeForClassName((String)Integer.TYPE.getName()));
        ClassNameTests.assertEquals((char)'I', (char)ClassName.getCodeForClassName((String)"int"));
        ClassNameTests.assertEquals((char)'B', (char)ClassName.getCodeForClassName((String)Byte.TYPE.getName()));
        ClassNameTests.assertEquals((char)'B', (char)ClassName.getCodeForClassName((String)"byte"));
        ClassNameTests.assertEquals((char)'\u0000', (char)ClassName.getCodeForClassName((String)Object.class.getName()));
    }

    public void testConstructor() {
        boolean exCaught;
        block2: {
            exCaught = false;
            try {
                Object at = ReflectionTools.newInstance(ClassName.class);
                ClassNameTests.fail((String)("bogus: " + at));
            }
            catch (RuntimeException ex) {
                if (!(ex.getCause() instanceof InvocationTargetException) || !(ex.getCause().getCause() instanceof UnsupportedOperationException)) break block2;
                exCaught = true;
            }
        }
        ClassNameTests.assertTrue((boolean)exCaught);
    }
}

