/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal;

import org.eclipse.jpt.utility.Command;
import org.eclipse.jpt.utility.CommandExecutor;
import org.eclipse.jpt.utility.internal.CommandRunnable;
import org.eclipse.jpt.utility.internal.RunnableCommand;
import org.eclipse.jpt.utility.internal.ThreadLocalCommand;
import org.eclipse.jpt.utility.tests.internal.MultiThreadedTestCase;
import org.eclipse.jpt.utility.tests.internal.TestTools;

public class CommandTests
extends MultiThreadedTestCase {
    public CommandTests(String name) {
        super(name);
    }

    public void testNullCommand() {
        Command command = Command.Null.instance();
        command.execute();
    }

    public void testNullCommand_toString() {
        Command command = Command.Null.instance();
        CommandTests.assertNotNull((Object)command.toString());
    }

    public void testNullCommand_serialization() throws Exception {
        Command command1 = Command.Null.instance();
        Command command2 = TestTools.serialize(command1);
        CommandTests.assertSame((Object)command1, (Object)command2);
    }

    public void testDisabledCommand() {
        Command command = Command.Disabled.instance();
        boolean exCaught = false;
        try {
            command.execute();
            CommandTests.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        CommandTests.assertTrue((boolean)exCaught);
    }

    public void testDisabledCommand_toString() {
        Command command = Command.Disabled.instance();
        CommandTests.assertNotNull((Object)command.toString());
    }

    public void testDisabledCommand_serialization() throws Exception {
        Command command1 = Command.Disabled.instance();
        Command command2 = TestTools.serialize(command1);
        CommandTests.assertSame((Object)command1, (Object)command2);
    }

    public void testRunnableCommand() {
        SimpleTestRunnable testRunnable = new SimpleTestRunnable();
        CommandTests.assertFalse((boolean)testRunnable.ran);
        RunnableCommand command = new RunnableCommand((Runnable)testRunnable);
        command.execute();
        CommandTests.assertTrue((boolean)testRunnable.ran);
    }

    public void testCommandRunnable() {
        TestCommand testCommand = new TestCommand();
        CommandTests.assertEquals((int)0, (int)testCommand.count);
        CommandRunnable runnable = new CommandRunnable((Command)testCommand);
        runnable.run();
        CommandTests.assertEquals((int)1, (int)testCommand.count);
    }

    public void testThreadLocalCommand() throws Exception {
        ThreadLocalCommand threadLocalCommand = new ThreadLocalCommand();
        TestRunnable testRunnable1 = new TestRunnable(threadLocalCommand, 1);
        Thread thread1 = this.buildThread(testRunnable1);
        thread1.run();
        TestRunnable testRunnable2 = new TestRunnable(threadLocalCommand, 2);
        Thread thread2 = this.buildThread(testRunnable2);
        thread2.run();
        thread1.join();
        thread2.join();
        CommandTests.assertEquals((int)1, (int)testRunnable1.testCommand.count);
        CommandTests.assertEquals((int)2, (int)testRunnable2.testCommand.count);
    }

    static class SimpleTestRunnable
    implements Runnable {
        boolean ran = false;

        SimpleTestRunnable() {
        }

        public void run() {
            this.ran = true;
        }
    }

    static class TestCommand
    implements Command {
        int count = 0;

        TestCommand() {
        }

        public void execute() {
            ++this.count;
        }
    }

    static class TestCommandExecutor
    implements CommandExecutor {
        int count = 0;

        TestCommandExecutor() {
        }

        public void execute(Command command) {
            ++this.count;
            command.execute();
        }
    }

    static class TestRunnable
    implements Runnable {
        final ThreadLocalCommand threadLocalCommand;
        final int executionCount;
        final TestCommand testCommand = new TestCommand();

        TestRunnable(ThreadLocalCommand threadLocalCommand, int executionCount) {
            this.threadLocalCommand = threadLocalCommand;
            this.executionCount = executionCount;
        }

        public void run() {
            this.threadLocalCommand.set((Command)this.testCommand);
            int i = 0;
            while (i < this.executionCount) {
                this.threadLocalCommand.execute();
                ++i;
            }
        }
    }
}

